/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.util.PinyinUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.SimpleColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.admission.DirectReceptionDto;
import com.byh.outpatient.api.dto.admission.ExportVisitCountDto;
import com.byh.outpatient.api.dto.admission.OutVisitAllRecordDto;
import com.byh.outpatient.api.dto.admission.OutVisitRecordDto;
import com.byh.outpatient.api.dto.admission.OutpatientWorkloadDto;
import com.byh.outpatient.api.dto.admission.QueryAdmissionDto;
import com.byh.outpatient.api.dto.admission.QueryAdmissionPatientDto;
import com.byh.outpatient.api.dto.admission.QueryReadyVisitDto;
import com.byh.outpatient.api.dto.admission.QueryRevenueDto;
import com.byh.outpatient.api.dto.admission.QuickTreatementDto;
import com.byh.outpatient.api.dto.medicalRecord.OutpatientInfomationDto;
import com.byh.outpatient.api.dto.order.SaveOrderDto;
import com.byh.outpatient.api.dto.patient.CheckCardNoCorrectnessDto;
import com.byh.outpatient.api.dto.pay.HsRefundDto;
import com.byh.outpatient.api.dto.pay.PayRefundDto;
import com.byh.outpatient.api.enums.AdmissionSourceEnum;
import com.byh.outpatient.api.enums.AdmissionStatusEnum;
import com.byh.outpatient.api.enums.OperationTypeEnum;
import com.byh.outpatient.api.enums.OrderTypeEnum;
import com.byh.outpatient.api.enums.OutpatientDataStatusEnum;
import com.byh.outpatient.api.enums.PaymentMethodEnum;
import com.byh.outpatient.api.enums.PaymentRecordsStatusEnum;
import com.byh.outpatient.api.enums.PaymentStatusEnum;
import com.byh.outpatient.api.enums.PrescriptionStatusEnum;
import com.byh.outpatient.api.enums.ReservationStatusEnum;
import com.byh.outpatient.api.enums.SettlementMethodEnum;
import com.byh.outpatient.api.enums.SourceEnum;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.model.BaseEntity;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.hsSettlement.HsSettlementInfoEntity;
import com.byh.outpatient.api.model.order.OutOrder;
import com.byh.outpatient.api.model.order.OutOrderPayment;
import com.byh.outpatient.api.model.order.OutOrderPaymentRecord;
import com.byh.outpatient.api.model.outpatienType.OutpatientTypeEntity;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.model.prescription.OutPrescription;
import com.byh.outpatient.api.model.prescription.OutPrescriptionDrug;
import com.byh.outpatient.api.model.reservation.ReservationEntity;
import com.byh.outpatient.api.model.treatment.OutTreatmentItems;
import com.byh.outpatient.api.sysModel.request.SysDeptDto;
import com.byh.outpatient.api.sysModel.request.SysDictValueDTO;
import com.byh.outpatient.api.sysModel.request.SysDoctorDto;
import com.byh.outpatient.api.sysModel.request.SysDrugEntity;
import com.byh.outpatient.api.sysModel.respones.SysDepartmentVo;
import com.byh.outpatient.api.sysModel.respones.SysDictValueVo;
import com.byh.outpatient.api.sysModel.respones.SysDoctorIdVo;
import com.byh.outpatient.api.util.BeanUtil;
import com.byh.outpatient.api.util.DateUtils;
import com.byh.outpatient.api.util.EasyExcelUtil;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.HttpUtils;
import com.byh.outpatient.api.util.HyposensitizationUtil;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.RandomCodeUtils;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.admission.AdmissionDetailVo;
import com.byh.outpatient.api.vo.admission.AdmissionPatientVo;
import com.byh.outpatient.api.vo.admission.ExportAdmissionVo;
import com.byh.outpatient.api.vo.admission.ExportNewPatient;
import com.byh.outpatient.api.vo.admission.ExportOutpatientWorkloadVo;
import com.byh.outpatient.api.vo.admission.ExportPatientHistoryDiag;
import com.byh.outpatient.api.vo.admission.ExportRevenueVo;
import com.byh.outpatient.api.vo.admission.ExportVisitCount;
import com.byh.outpatient.api.vo.admission.ExportVisitCountVo;
import com.byh.outpatient.api.vo.admission.OutVisitAllRecordVo;
import com.byh.outpatient.api.vo.admission.OutVisitRecordVo;
import com.byh.outpatient.api.vo.admission.OutpatientWorkloadVo;
import com.byh.outpatient.api.vo.admission.QueryReadyVisitVo;
import com.byh.outpatient.api.vo.admission.QueryRevenueVo;
import com.byh.outpatient.api.vo.admission.RegFormDataVo;
import com.byh.outpatient.api.vo.medicalRecord.GetDiagCodeListVo;
import com.byh.outpatient.api.vo.patient.CheckCardNoCorrectnessVo;
import com.byh.outpatient.api.vo.prescription.GetPrescDrugListVo;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutHsSettlementInfoMapper;
import com.byh.outpatient.data.repository.OutMedicalRecordDiagnosisMapper;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentRecordMapper;
import com.byh.outpatient.data.repository.OutPrescriptionDrugMapper;
import com.byh.outpatient.data.repository.OutPrescriptionMapper;
import com.byh.outpatient.data.repository.OutTreatmentItemsMapper;
import com.byh.outpatient.data.repository.OutpatientTypeMapper;
import com.byh.outpatient.data.repository.PatientMapper;
import com.byh.outpatient.data.repository.ReservationMapper;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.controller.RocketMQProducerController;
import com.byh.outpatient.web.mvc.exception.RunDisplayException;
import com.byh.outpatient.web.mvc.utils.RedisUtil;
import com.byh.outpatient.web.rocket.RocketMQProducer;
import com.byh.outpatient.web.service.AdmissionService;
import com.byh.outpatient.web.service.OutOrderService;
import com.byh.outpatient.web.service.OutPayService;
import com.byh.outpatient.web.service.OutPrescriptionService;
import com.byh.outpatient.web.service.PatientService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.rocketmq.client.producer.SendCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class AdmissionServiceImpl
implements AdmissionService {
    private static final Logger log = LoggerFactory.getLogger(AdmissionServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(RocketMQProducerController.class);
    private static final String topic = "rocketMQ-out-doctor";
    private static final String patientTopic = "rocketMQ-out-patientTopic";
    private static final String admissionTopic = "rocketMQ-out-admissionTopic";
    private static final String patientPaymentTopic = "rocketMQ-out-patientPaymentTopic";
    private static final String prescriptionDetailTopic = "rocketMQ-out-prescriptionDetailTopic";
    private static final String treatmentItemsTopic = "rocketMQ-out-treatmentItemsTopic";
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OutHsSettlementInfoMapper hsSettlementInfoMapper;
    @Autowired
    private OutOrderPaymentMapper outOrderPaymentMapper;
    @Autowired
    private OutOrderPaymentRecordMapper outOrderPaymentRecordMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private PatientService patientService;
    @Autowired
    private OutOrderService outOrderService;
    @Autowired
    private OutOrderMapper outOrderMapper;
    @Autowired
    private OutPrescriptionService outPrescriptionService;
    @Resource
    private OutPrescriptionDrugMapper outPrescriptionDrugMapper;
    @Autowired
    private ReservationMapper reservationMapper;
    @Autowired
    private OutpatientTypeMapper outpatientTypeMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Resource
    private OutPrescriptionMapper outPrescriptionMapper;
    @Resource
    private OutTreatmentItemsMapper outTreatmentItemsMapper;
    @Resource
    private OutMedicalRecordDiagnosisMapper outMedicalRecordDiagnosisMapper;
    @Resource
    private OutHsSettlementInfoMapper outHsSettlementInfoMapper;
    @Autowired
    private OutPayService outPayService;
    public static final String WAIT_NO_PREX = "doctor_wait_no|";
    @Value(value="${remote.invokeOutArchivingFlag}")
    private boolean invokeOutArchivingFlag;

    /*
     * WARNING - void declaration
     */
    public void exportVisitCountByDiagCodes(HttpServletResponse response, ExportVisitCountDto dto) {
        String startDateStr = dto.getStartDate();
        String endDateStr = dto.getEndDate();
        List diagCodes = dto.getDiagCodes();
        Integer tenantId = dto.getTenantId();
        ArrayList dateList = new ArrayList();
        LocalDate startDate = LocalDate.parse(startDateStr);
        LocalDate endDate = LocalDate.parse(endDateStr);
        YearMonth startMonth = YearMonth.from(startDate);
        YearMonth endMonth = YearMonth.from(endDate);
        while (!startMonth.isAfter(endMonth)) {
            LocalDate monthStart = startMonth.atDay(1);
            Object monthEnd = startMonth.atEndOfMonth();
            if (startMonth.equals(YearMonth.from(startDate))) {
                monthStart = startDate;
            }
            if (startMonth.equals(YearMonth.from(endDate))) {
                monthEnd = endDate;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("startDate", monthStart.toString());
            hashMap.put("endDate", ((LocalDate)monthEnd).toString());
            dateList.add(hashMap);
            startMonth = startMonth.plusMonths(1L);
        }
        ArrayList exportList = new ArrayList();
        for (Map map : dateList) {
            Object vo22;
            String queryStartDate = (String)map.get("startDate");
            String queryEndDate = (String)map.get("endDate");
            String dateRange = queryStartDate + " \u2014 " + queryEndDate;
            List oldVisitList = this.admissionMapper.selectListByDateBefore(queryStartDate, tenantId);
            Map<String, String> oldVisitMap = oldVisitList.stream().collect(Collectors.toMap(ExportVisitCountVo::getPatientCardNo, ExportVisitCountVo::getPatientCardNo));
            List visitList = this.admissionMapper.selectListByDiagCodes(diagCodes, queryStartDate, queryEndDate, tenantId);
            HashMap<String, List> resultMap = new HashMap<String, List>();
            for (Object vo22 : visitList) {
                String matchedCode = null;
                for (String string : diagCodes) {
                    if (!StrUtil.isNotEmpty((CharSequence)vo22.getDiagName()) || !vo22.getDiagName().contains(string)) continue;
                    matchedCode = string;
                    break;
                }
                if (matchedCode == null) continue;
                resultMap.computeIfAbsent(matchedCode, k -> new ArrayList()).add(vo22);
            }
            LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
            dataMap.put("\u6708\u4efd", dateRange);
            vo22 = resultMap.entrySet().iterator();
            while (vo22.hasNext()) {
                void var26_38;
                Map.Entry entry = (Map.Entry)vo22.next();
                String firstTitle = "\u5230\u9662\u65b0\u589e\u521d\u8bca" + (String)entry.getKey() + "\u60a3\u8005\u4eba\u6570";
                Integer n = 0;
                List visitCountVoList = (List)entry.getValue();
                for (ExportVisitCountVo vo3 : visitCountVoList) {
                    Integer n2;
                    String oldPatientCardNo = oldVisitMap.get(vo3.getPatientCardNo());
                    if (!StrUtil.isEmpty((CharSequence)oldPatientCardNo)) continue;
                    void var31_46 = var26_38;
                    Integer n3 = n2 = Integer.valueOf(var26_38.intValue() + 1);
                }
                dataMap.put(firstTitle, var26_38);
            }
            exportList.add(dataMap);
        }
        try {
            Throwable throwable = null;
            try (ServletOutputStream out = response.getOutputStream();
                 ExcelWriter excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)out).registerWriteHandler((WriteHandler)new SimpleColumnWidthStyleStrategy(Integer.valueOf(40)))).registerWriteHandler((WriteHandler)this.createCellStyleStrategy())).build();){
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
                String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
                String fileName = URLEncoder.encode("\u521d\u8bca\u60a3\u8005\u4eba\u6570" + format, "UTF-8").replaceAll("\\+", "%20");
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                response.setCharacterEncoding("utf-8");
                response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
                ArrayList head = new ArrayList();
                String info = startDateStr + " \u2014 " + endDateStr + "\uff08\u521d\u8bca\u60a3\u8005\u4eba\u6570\uff09";
                Map firstRow = (Map)exportList.get(0);
                for (String key : firstRow.keySet()) {
                    ArrayList<String> headColumn = new ArrayList<String>();
                    headColumn.add(info);
                    headColumn.add(key);
                    head.add(headColumn);
                }
                WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)"\u521d\u8bca\u60a3\u8005\u4eba\u6570").head(head)).build();
                ArrayList data = new ArrayList();
                for (LinkedHashMap linkedHashMap : exportList) {
                    ArrayList rowData = new ArrayList();
                    for (String key : linkedHashMap.keySet()) {
                        rowData.add(linkedHashMap.get(key));
                    }
                    data.add(rowData);
                }
                excelWriter.write(data, writeSheet);
                out.flush();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HorizontalCellStyleStrategy createCellStyleStrategy() {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        headWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        headWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        headWriteCellStyle.setBorderRight(BorderStyle.THIN);
        headWriteCellStyle.setBorderTop(BorderStyle.THIN);
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
        headWriteCellStyle.setWriteFont(headWriteFont);
        headWriteCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
        headWriteCellStyle.setFillForegroundColor(Short.valueOf((short)40));
        headWriteCellStyle.setWrapped(Boolean.valueOf(true));
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        contentWriteCellStyle.setWrapped(Boolean.valueOf(true));
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }

    public void exportAdmissionList(HttpServletResponse response, OutVisitAllRecordDto dto) {
        Integer tenantId = dto.getTenantId();
        List exportList = this.admissionMapper.selectExportAdmission(dto);
        List cardNos = exportList.stream().map(ExportAdmissionVo::getMA20).map(s -> StrUtil.isEmpty((CharSequence)s) ? null : s.replaceAll("\\s+", "")).filter(StrUtil::isNotEmpty).collect(Collectors.toList());
        List<String> notInStatus = Arrays.asList("1", "40", "50");
        List admissionList = this.admissionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AdmissionEntity::getTenantId, (Object)tenantId)).in(AdmissionEntity::getPatientCardNo, cardNos)).notIn(AdmissionEntity::getStatus, notInStatus));
        Map<String, List<AdmissionEntity>> admissionMap = admissionList.stream().collect(Collectors.groupingBy(AdmissionEntity::getPatientCardNo));
        List outpatientNos = exportList.stream().map(ExportAdmissionVo::getMA50).distinct().collect(Collectors.toList());
        List prescDrugList = this.outPrescriptionMapper.selectPrescDrugByOutpatientNos(tenantId, outpatientNos, "11");
        Map<String, List<GetPrescDrugListVo>> prescDrugMap = prescDrugList.stream().collect(Collectors.groupingBy(GetPrescDrugListVo::getOutpatientNo));
        List diagCodeList = this.outMedicalRecordDiagnosisMapper.selectDiagListByOutpatientNos(tenantId, outpatientNos);
        Map<String, List<GetDiagCodeListVo>> diagCodeMap = diagCodeList.stream().collect(Collectors.groupingBy(GetDiagCodeListVo::getOutpatientNo));
        List setlIds = exportList.stream().map(ExportAdmissionVo::getSetlId).filter(StrUtil::isNotEmpty).distinct().collect(Collectors.toList());
        List settlementInfoList = this.outHsSettlementInfoMapper.selectListBySetlIds(tenantId, setlIds);
        Map<String, List<ExportAdmissionVo>> exportMap = exportList.stream().collect(Collectors.groupingBy(ExportAdmissionVo::getMA50));
        ArrayList<ExportAdmissionVo> realExportList = new ArrayList<ExportAdmissionVo>();
        for (Map.Entry<String, List<ExportAdmissionVo>> entry : exportMap.entrySet()) {
            String outpatientNo = entry.getKey();
            List<ExportAdmissionVo> exportAdmissionVos = entry.getValue();
            ExportAdmissionVo exportAdmissionVo = exportAdmissionVos.get(0);
            String cardNo = exportAdmissionVo.getMA20();
            List patientAdmissionList = admissionMap.getOrDefault(cardNo, new ArrayList());
            if (patientAdmissionList.isEmpty()) {
                exportAdmissionVo.setMB43C("1");
            } else {
                Date visitTime = Optional.ofNullable(exportAdmissionVo.getMB46()).orElseGet(() -> {
                    Date regTime = exportAdmissionVo.getMB41();
                    exportAdmissionVo.setMB46(regTime);
                    return regTime;
                });
                String firstFlag = patientAdmissionList.stream().map(AdmissionEntity::getVisitTime).filter(Objects::nonNull).anyMatch(allVisitTime -> allVisitTime.before(visitTime)) ? "2" : "1";
                exportAdmissionVo.setMB43C(firstFlag);
            }
            List prescDrugListVos = prescDrugMap.getOrDefault(outpatientNo, new ArrayList());
            if (prescDrugListVos.isEmpty()) {
                exportAdmissionVo.setMB54C("2");
            } else {
                exportAdmissionVo.setMB54C("1");
            }
            List diagCodeListVos = diagCodeMap.getOrDefault(outpatientNo, new ArrayList());
            if (!diagCodeListVos.isEmpty()) {
                String mainDiagCode = diagCodeListVos.stream().filter(vo -> vo.getId() != null).min(Comparator.comparing(GetDiagCodeListVo::getId)).map(GetDiagCodeListVo::getDiagCode).orElse(null);
                exportAdmissionVo.setMC01C(mainDiagCode);
                String mainDiagName = diagCodeListVos.stream().filter(vo -> vo.getId() != null).min(Comparator.comparing(GetDiagCodeListVo::getId)).map(GetDiagCodeListVo::getDiagName).orElse(null);
                exportAdmissionVo.setMC02N(mainDiagName);
                List detailDiagCodeList = diagCodeListVos.stream().filter(vo -> !mainDiagCode.equals(vo.getDiagCode())).collect(Collectors.toList());
                List detailDiagCodes = detailDiagCodeList.stream().map(GetDiagCodeListVo::getDiagCode).collect(Collectors.toList());
                block25: for (int i = 0; i < detailDiagCodes.size() && i < 10; ++i) {
                    String detailDiagCode = (String)detailDiagCodes.get(i);
                    switch (i) {
                        case 0: {
                            exportAdmissionVo.setMC52x01C(detailDiagCode);
                            continue block25;
                        }
                        case 1: {
                            exportAdmissionVo.setMC52x02C(detailDiagCode);
                            continue block25;
                        }
                        case 2: {
                            exportAdmissionVo.setMC52x03C(detailDiagCode);
                            continue block25;
                        }
                        case 3: {
                            exportAdmissionVo.setMC52x04C(detailDiagCode);
                            continue block25;
                        }
                        case 4: {
                            exportAdmissionVo.setMC52x05C(detailDiagCode);
                            continue block25;
                        }
                        case 5: {
                            exportAdmissionVo.setMC52x06C(detailDiagCode);
                            continue block25;
                        }
                        case 6: {
                            exportAdmissionVo.setMC52x07C(detailDiagCode);
                            continue block25;
                        }
                        case 7: {
                            exportAdmissionVo.setMC52x08C(detailDiagCode);
                            continue block25;
                        }
                        case 8: {
                            exportAdmissionVo.setMC52x09C(detailDiagCode);
                            continue block25;
                        }
                        case 9: {
                            exportAdmissionVo.setMC52x10C(detailDiagCode);
                        }
                    }
                }
                List detailDiagNames = detailDiagCodeList.stream().map(GetDiagCodeListVo::getDiagName).collect(Collectors.toList());
                block26: for (int i = 0; i < detailDiagNames.size() && i < 10; ++i) {
                    String detailDiagName = (String)detailDiagNames.get(i);
                    switch (i) {
                        case 0: {
                            exportAdmissionVo.setMC52x01N(detailDiagName);
                            continue block26;
                        }
                        case 1: {
                            exportAdmissionVo.setMC52x02N(detailDiagName);
                            continue block26;
                        }
                        case 2: {
                            exportAdmissionVo.setMC52x03N(detailDiagName);
                            continue block26;
                        }
                        case 3: {
                            exportAdmissionVo.setMC52x04N(detailDiagName);
                            continue block26;
                        }
                        case 4: {
                            exportAdmissionVo.setMC52x05N(detailDiagName);
                            continue block26;
                        }
                        case 5: {
                            exportAdmissionVo.setMC52x06N(detailDiagName);
                            continue block26;
                        }
                        case 6: {
                            exportAdmissionVo.setMC52x07N(detailDiagName);
                            continue block26;
                        }
                        case 7: {
                            exportAdmissionVo.setMC52x08N(detailDiagName);
                            continue block26;
                        }
                        case 8: {
                            exportAdmissionVo.setMC52x09N(detailDiagName);
                            continue block26;
                        }
                        case 9: {
                            exportAdmissionVo.setMC52x10N(detailDiagName);
                        }
                    }
                }
            }
            BigDecimal totalAmount = exportAdmissionVos.stream().map(vo -> Optional.ofNullable(vo.getTotalAmount()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
            exportAdmissionVo.setMD01(totalAmount);
            List patientSetlIds = exportAdmissionVos.stream().map(ExportAdmissionVo::getSetlId).filter(StrUtil::isNotEmpty).distinct().collect(Collectors.toList());
            BigDecimal hsTotalAmount = settlementInfoList.stream().filter(item -> patientSetlIds.contains(item.getSetl_id())).map(HsSettlementInfoEntity::getPsn_part_amt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal psnCashPayAmount = exportAdmissionVos.stream().filter(item -> StrUtil.isEmpty((CharSequence)item.getSetlId())).map(ExportAdmissionVo::getTotalAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal psnCashPayTotalAmount = hsTotalAmount.add(psnCashPayAmount);
            exportAdmissionVo.setMD09(psnCashPayTotalAmount);
            exportAdmissionVo.setMD11(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("10", "15", "62", "57"))));
            exportAdmissionVo.setMD12(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("11"))));
            exportAdmissionVo.setMD13(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("56"))));
            exportAdmissionVo.setMD14(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("58"))));
            exportAdmissionVo.setMD15(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("60"))));
            exportAdmissionVo.setMD16(BigDecimal.ZERO);
            exportAdmissionVo.setMD17(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("51"))));
            exportAdmissionVo.setMD18(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("50"))));
            exportAdmissionVo.setMD19(BigDecimal.ZERO);
            exportAdmissionVo.setMD19x01(BigDecimal.ZERO);
            exportAdmissionVo.setMD20(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("53"))));
            exportAdmissionVo.setMD20x01(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("55"))));
            exportAdmissionVo.setMD20x02(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("54"))));
            exportAdmissionVo.setMD21(BigDecimal.ZERO);
            exportAdmissionVo.setMD22(BigDecimal.ZERO);
            exportAdmissionVo.setMD23(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("20", "21"))));
            exportAdmissionVo.setMD23x01(BigDecimal.ZERO);
            exportAdmissionVo.setMD24(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("40", "41"))));
            exportAdmissionVo.setMD25(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("30", "31", "32"))));
            exportAdmissionVo.setMD26(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("61"))));
            exportAdmissionVo.setMD27(BigDecimal.ZERO);
            exportAdmissionVo.setMD28(BigDecimal.ZERO);
            exportAdmissionVo.setMD29(BigDecimal.ZERO);
            exportAdmissionVo.setMD30(BigDecimal.ZERO);
            exportAdmissionVo.setMD31(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("63"))));
            exportAdmissionVo.setMD32(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("59"))));
            exportAdmissionVo.setMD33(BigDecimal.ZERO);
            exportAdmissionVo.setMD34(this.getTotalAmountByOrderType(exportAdmissionVos, new HashSet<String>(Arrays.asList("70"))));
            realExportList.add(exportAdmissionVo);
        }
        EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)"\u95e8\uff08\u6025\uff09\u8bca\u8bca\u7597\u4fe1\u606f\u6570\u636e\u91c7\u96c6", (String)"\u95e8\uff08\u6025\uff09\u8bca\u8bca\u7597\u4fe1\u606f\u6570\u636e\u91c7\u96c6", (Object)new ExportAdmissionVo(), realExportList, null);
    }

    private BigDecimal getTotalAmountByOrderType(List<ExportAdmissionVo> exportAdmissionVos, Set<String> orderTypes) {
        BigDecimal totalAmount = exportAdmissionVos.stream().filter(vo -> orderTypes.contains(vo.getOrderType())).map(ExportAdmissionVo::getTotalAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalAmount;
    }

    @Transactional(rollbackFor={BusinessException.class})
    @Scheduled(cron="0 10 5 * * ?")
    public void timingArchivedRecord() {
        LocalDate yesterday = LocalDate.now().minusDays(1L);
        String yesterdayStr = yesterday.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        List outpatientNos = this.admissionMapper.selectArchivedList(yesterdayStr, yesterdayStr);
        this.admissionMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(BaseEntity::getUpdateId, (Object)998866)).set(BaseEntity::getUpdateName, (Object)"\u5b9a\u65f6\u5f52\u6863\u75c5\u5386")).set(BaseEntity::getUpdateTime, (Object)new Date())).set(AdmissionEntity::getStatus, (Object)AdmissionStatusEnum.ARCHIVED.getValue())).in(AdmissionEntity::getOutpatientNo, (Collection)outpatientNos));
    }

    public void exportPatientHistoryDiag(HttpServletResponse response, OutVisitAllRecordDto dto) {
        List exportList = this.admissionMapper.selectPatientHistoryDiag(dto);
        EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)"\u60a3\u8005\u5386\u53f2\u8bca\u65ad", (String)"\u60a3\u8005\u5386\u53f2\u8bca\u65ad", (Object)new ExportPatientHistoryDiag(), (List)exportList, null);
    }

    public void exportRevenue(HttpServletResponse response, QueryRevenueDto dto) {
        List<ExportRevenueVo> exportList = new ArrayList();
        String sheetName = "";
        String columnName = "";
        if ("1".equals(dto.getQueryType())) {
            exportList = this.admissionMapper.exportRevenueListByDoctor(dto);
            sheetName = "\u533b\u751f\u6536\u5165\u660e\u7ec6";
            columnName = "\u533b\u751f\u59d3\u540d";
        } else if ("2".equals(dto.getQueryType())) {
            exportList = this.admissionMapper.exportRevenueListByDept(dto);
            sheetName = "\u79d1\u5ba4\u6536\u5165\u660e\u7ec6";
            columnName = "\u79d1\u5ba4\u540d\u79f0";
        }
        int allVisitCount = 0;
        BigDecimal allTotalOutVisitAmount = BigDecimal.ZERO;
        BigDecimal allDrugAmount = BigDecimal.ZERO;
        BigDecimal allTreatmentAmount = BigDecimal.ZERO;
        BigDecimal allTotalAmount = BigDecimal.ZERO;
        for (ExportRevenueVo vo : exportList) {
            allVisitCount += vo.getVisitCount().intValue();
            allTotalOutVisitAmount = allTotalOutVisitAmount.add(vo.getOutpatVisitTotalAmount());
            allDrugAmount = allDrugAmount.add(vo.getDrugTotalAmount());
            allTreatmentAmount = allTreatmentAmount.add(vo.getTreatmentTotalAmount());
            allTotalAmount = allTotalAmount.add(vo.getTotalAmount());
        }
        ExportRevenueVo exportVo = new ExportRevenueVo();
        exportVo.setName("\u603b\u8ba1");
        exportVo.setVisitCount(Integer.valueOf(allVisitCount));
        exportVo.setOutpatVisitTotalAmount(allTotalOutVisitAmount);
        exportVo.setDrugTotalAmount(allDrugAmount);
        exportVo.setTreatmentTotalAmount(allTreatmentAmount);
        exportVo.setTotalAmount(allTotalAmount);
        exportList.add(exportVo);
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
            String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
            String fileName = URLEncoder.encode("\u6536\u5165\u62a5\u8868" + format, "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            try (ExcelWriter excelWriter = EasyExcelFactory.write((OutputStream)out).build();){
                String newHeader = dto.getStartDate() + " \u81f3 " + dto.getEndDate() + " " + sheetName;
                this.updateExcelPropertyAnnotation(ExportRevenueVo.class, "name", newHeader, true);
                this.updateExcelPropertyAnnotation(ExportRevenueVo.class, "visitCount", newHeader, true);
                this.updateExcelPropertyAnnotation(ExportRevenueVo.class, "outpatVisitTotalAmount", newHeader, true);
                this.updateExcelPropertyAnnotation(ExportRevenueVo.class, "drugTotalAmount", newHeader, true);
                this.updateExcelPropertyAnnotation(ExportRevenueVo.class, "treatmentTotalAmount", newHeader, true);
                this.updateExcelPropertyAnnotation(ExportRevenueVo.class, "totalAmount", newHeader, true);
                this.updateExcelPropertyAnnotation(ExportRevenueVo.class, "name", columnName, false);
                WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcelFactory.writerSheet((Integer)0, (String)sheetName).head(ExportRevenueVo.class)).build();
                excelWriter.write(exportList, writeSheet);
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateExcelPropertyAnnotation(Class<?> clazz, String fieldName, String newHeader, boolean updateType) throws Exception {
        Field field = clazz.getDeclaredField(fieldName);
        ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
        InvocationHandler handler = Proxy.getInvocationHandler(excelProperty);
        Field memberValuesField = handler.getClass().getDeclaredField("memberValues");
        memberValuesField.setAccessible(true);
        Map memberValues = (Map)memberValuesField.get(handler);
        String[] originalValue = (String[])memberValues.get("value");
        if (updateType) {
            originalValue[0] = newHeader;
        } else {
            originalValue[1] = newHeader;
        }
        memberValues.put("value", originalValue);
    }

    public BigDecimal getYearTotalRevenue(Integer tenantId) {
        LocalDate startDate = LocalDate.now().withDayOfYear(1);
        LocalDate endDate = LocalDate.now().withDayOfYear(LocalDate.now().lengthOfYear());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String startDateStr = startDate.format(dateTimeFormatter);
        String endDateStr = endDate.format(dateTimeFormatter);
        QueryRevenueDto dto = new QueryRevenueDto();
        dto.setStartDate(startDateStr);
        dto.setEndDate(endDateStr);
        dto.setTenantId(tenantId);
        BigDecimal totalAmount = this.admissionMapper.getYearTotalRevenue(dto);
        return totalAmount;
    }

    public List<QueryRevenueVo> selectRevenueList(QueryRevenueDto dto) {
        List list = new ArrayList();
        if ("1".equals(dto.getQueryType())) {
            list = this.admissionMapper.selectRevenueListGroupByDoctor(dto);
        } else if ("2".equals(dto.getQueryType())) {
            list = this.admissionMapper.selectselectRevenueListGroupByDept(dto);
        }
        return list;
    }

    public List<QueryReadyVisitVo> selectReadyVisitList(QueryReadyVisitDto dto) {
        return this.admissionMapper.selectReadyVisitList(dto);
    }

    public void exportOutpatientWorkload(HttpServletResponse response, OutpatientWorkloadDto dto) {
        List list = this.admissionMapper.selectOutpatientWorkload(dto);
        List exportList = BeanUtil.copyList((List)list, ExportOutpatientWorkloadVo.class);
        EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)"\u95e8\u8bca\u533b\u751f\u5de5\u4f5c\u91cf", (String)"\u95e8\u8bca\u533b\u751f\u5de5\u4f5c\u91cf", (Object)new ExportOutpatientWorkloadVo(), (List)exportList, null);
    }

    public List<OutpatientWorkloadVo> selectOutpatientWorkload(OutpatientWorkloadDto dto) {
        return this.admissionMapper.selectOutpatientWorkload(dto);
    }

    public Page<OutVisitAllRecordVo> selectAllList(OutVisitAllRecordDto dto) {
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.admissionMapper.selectAllList(page, dto);
        if (!list.isEmpty()) {
            List hisOutpatientNos = list.stream().filter(vo -> "HIS\u7cfb\u7edf".equals(vo.getDataSource())).map(OutVisitAllRecordVo::getOutpatientNo).collect(Collectors.toList());
            LambdaQueryWrapper prescQuery = Wrappers.lambdaQuery();
            prescQuery.eq(OutPrescription::getPrescriptionStatus, (Object)PrescriptionStatusEnum.STATUS_NORMAL.getValue());
            prescQuery.in(!hisOutpatientNos.isEmpty(), OutPrescription::getOutpatientNo, hisOutpatientNos);
            prescQuery.eq(hisOutpatientNos.isEmpty(), OutPrescription::getOutpatientNo, (Object)"-1");
            List prescList = this.outPrescriptionMapper.selectList((Wrapper)prescQuery);
            List prescNos = prescList.stream().map(OutPrescription::getPrescriptionNo).distinct().filter(Objects::nonNull).collect(Collectors.toList());
            LambdaQueryWrapper prescDrugQuery = Wrappers.lambdaQuery();
            prescDrugQuery.eq(OutPrescriptionDrug::getStatus, (Object)PrescriptionStatusEnum.STATUS_NORMAL.getValue());
            prescDrugQuery.in(!prescNos.isEmpty(), OutPrescriptionDrug::getPrescriptionNo, prescNos);
            prescDrugQuery.eq(prescNos.isEmpty(), OutPrescriptionDrug::getPrescriptionNo, (Object)"-1");
            List prescDrugList = this.outPrescriptionDrugMapper.selectList((Wrapper)prescDrugQuery);
            Map<String, List<OutPrescriptionDrug>> prescDrugMap = prescDrugList.stream().collect(Collectors.groupingBy(OutPrescriptionDrug::getPrescriptionNo));
            for (OutPrescription presc2 : prescList) {
                List prescDrugs = Optional.ofNullable(prescDrugMap.get(presc2.getPrescriptionNo())).orElse(new ArrayList());
                presc2.setOutPrescriptionDrugList(prescDrugs);
            }
            Map<String, List<OutPrescription>> prescMap = prescList.stream().collect(Collectors.groupingBy(OutPrescription::getOutpatientNo));
            LambdaQueryWrapper outTreatmentItemQuery = Wrappers.lambdaQuery();
            outTreatmentItemQuery.eq(OutTreatmentItems::getStatus, (Object)PrescriptionStatusEnum.STATUS_NORMAL.getValue());
            outTreatmentItemQuery.in(!hisOutpatientNos.isEmpty(), OutTreatmentItems::getOutpatientNo, hisOutpatientNos);
            outTreatmentItemQuery.eq(hisOutpatientNos.isEmpty(), OutTreatmentItems::getOutpatientNo, (Object)"-1");
            List outTreatmentItemsList = this.outTreatmentItemsMapper.selectList((Wrapper)outTreatmentItemQuery);
            Map<String, List<OutTreatmentItems>> outTreatmentItemMap = outTreatmentItemsList.stream().collect(Collectors.groupingBy(OutTreatmentItems::getOutpatientNo));
            for (OutVisitAllRecordVo vo2 : list) {
                String treatmentItenName;
                String handleOpinion = vo2.getHandleOpinion();
                StringBuilder prescDrugNameBuilder = new StringBuilder();
                StringBuilder treatmentItemBuilder = new StringBuilder();
                ((List)outTreatmentItemMap.getOrDefault(vo2.getOutpatientNo(), new ArrayList())).forEach(outTreatmentItem -> treatmentItemBuilder.append(outTreatmentItem.getName()).append("\t\t\t"));
                ((List)prescMap.getOrDefault(vo2.getOutpatientNo(), new ArrayList())).forEach(presc -> {
                    if (presc.getPrescriptionType() == 1) {
                        presc.getOutPrescriptionDrugList().forEach(prescDrug -> prescDrugNameBuilder.append(prescDrug.getDrugName()).append(" ").append("\uff08").append(prescDrug.getSpecification()).append("\uff09 ").append("\u6bcf\u6b21").append(prescDrug.getSingleDose().stripTrailingZeros().toPlainString()).append(prescDrug.getDoseUnit()).append(" ").append(prescDrug.getFrequency()).append(" ").append(prescDrug.getDrugUsage()).append(" ").append(prescDrug.getQuantity().stripTrailingZeros().toPlainString()).append(prescDrug.getQuantityUnit()).append(" ").append(prescDrug.getMedicationDays()).append("\u5929\n"));
                    } else if (presc.getPrescriptionType() == 11) {
                        presc.getOutPrescriptionDrugList().forEach(prescDrug -> prescDrugNameBuilder.append(prescDrug.getDrugName()).append("\uff08").append(prescDrug.getSpecialUsageName()).append("\uff09 ").append(prescDrug.getSingleDose().stripTrailingZeros().toPlainString()).append(prescDrug.getDoseUnit()).append(" "));
                        prescDrugNameBuilder.append("\n").append("\u5171").append(presc.getDosage()).append("\u5242 ").append("\u6bcf\u65e5").append(presc.getDailyDosage()).append("\u5242 ").append("\u6bcf\u5242" + presc.getSingleDoseUsage()).append(" ").append("\u6bcf\u65e5").append(presc.getDailyFrequency()).append("\u6b21 ").append(presc.getMedicationTime()).append("\n");
                    }
                });
                handleOpinion = StrUtil.isNotEmpty((CharSequence)handleOpinion) ? handleOpinion + "\n" : "";
                String prescDrugName = prescDrugNameBuilder.toString();
                if (StrUtil.isNotEmpty((CharSequence)prescDrugName)) {
                    prescDrugName = "Rp:\n" + prescDrugName;
                    handleOpinion = handleOpinion + prescDrugName;
                }
                if (StrUtil.isNotEmpty((CharSequence)(treatmentItenName = treatmentItemBuilder.toString()))) {
                    treatmentItenName = "\u8bca\u7597\u9879\u76ee\uff1a\n" + treatmentItenName;
                    handleOpinion = handleOpinion + treatmentItenName;
                }
                vo2.setHandleOpinion(handleOpinion);
            }
        }
        for (OutVisitAllRecordVo record : list) {
            String patientName = HyposensitizationUtil.hyposensitizationForName((String)record.getPatientName());
            String phone = HyposensitizationUtil.hyposensitizationForPhone((String)record.getPhone());
            String cardNo = HyposensitizationUtil.hyposensitizationForCardNo((String)record.getCardNo());
            record.setPatientName(patientName);
            record.setPhone(phone);
            record.setCardNo(cardNo);
        }
        page.setRecords(list);
        return page;
    }

    public void exportOutVisitCount(HttpServletResponse response, OutVisitRecordDto dto) {
        List list = this.admissionMapper.selectVisitCount(dto);
        EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)"\u95e8\u8bca\u533b\u751f\u63a5\u8bca\u6b21\u6570\u7edf\u8ba1", (String)"\u95e8\u8bca\u533b\u751f\u63a5\u8bca\u6b21\u6570\u7edf\u8ba1", (Object)new ExportVisitCount(), (List)list, null);
    }

    public void exportNewPatientInfo(HttpServletResponse response, OutVisitRecordDto dto) {
        dto.setCurrent(1);
        dto.setSize(-1);
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.admissionMapper.selectOutVisitRecordList(page, dto);
        List outpatientNos = list.stream().map(OutVisitRecordVo::getOutpatientNo).collect(Collectors.toList());
        ArrayList<ExportNewPatient> exportNewPatientList = new ArrayList<ExportNewPatient>();
        if (!outpatientNos.isEmpty()) {
            List outPrescriptionDrugList = this.outPrescriptionDrugMapper.selectListByOutpatientNos(outpatientNos);
            Map<String, List<OutPrescriptionDrug>> outPrescriptionDrugMap = outPrescriptionDrugList.stream().collect(Collectors.groupingBy(OutPrescriptionDrug::getOutpatientNo));
            for (OutVisitRecordVo vo : list) {
                List outPrescriptionDrugs = Optional.ofNullable(outPrescriptionDrugMap.get(vo.getOutpatientNo())).orElse(new ArrayList());
                if (!outPrescriptionDrugs.isEmpty()) {
                    for (OutPrescriptionDrug prescDrug : outPrescriptionDrugs) {
                        ExportNewPatient exportNewPatient = new ExportNewPatient();
                        exportNewPatient.setVisitTime(vo.getVisitTime());
                        exportNewPatient.setPatientId(vo.getPatientId());
                        exportNewPatient.setPatientName(vo.getPatientName());
                        exportNewPatient.setCardNo(vo.getCardNo());
                        exportNewPatient.setDoctorName(vo.getDoctorName());
                        exportNewPatient.setFirstVisitFlagLabel(vo.getFirstVisitFlagLabel());
                        exportNewPatient.setDiagNosis(vo.getDiagNosis());
                        exportNewPatient.setDrugName(prescDrug.getDrugName());
                        exportNewPatient.setDrugSpec(prescDrug.getSpecification());
                        exportNewPatient.setDrugNum(prescDrug.getQuantity());
                        exportNewPatientList.add(exportNewPatient);
                    }
                    continue;
                }
                ExportNewPatient exportNewPatient = new ExportNewPatient();
                exportNewPatient.setVisitTime(vo.getVisitTime());
                exportNewPatient.setPatientId(vo.getPatientId());
                exportNewPatient.setPatientName(vo.getPatientName());
                exportNewPatient.setCardNo(vo.getCardNo());
                exportNewPatient.setDoctorName(vo.getDoctorName());
                exportNewPatient.setFirstVisitFlagLabel(vo.getFirstVisitFlagLabel());
                exportNewPatient.setDiagNosis(vo.getDiagNosis());
                exportNewPatientList.add(exportNewPatient);
            }
        }
        EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)"\u65b0\u60a3\u8005\u8bc6\u522b", (String)"\u65b0\u60a3\u8005\u8bc6\u522b", (Object)new ExportNewPatient(), exportNewPatientList, null);
    }

    public Page<OutVisitRecordVo> selectOutVisitRecordList(OutVisitRecordDto dto) {
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List outVisitRecordVos = this.admissionMapper.selectOutVisitRecordList(page, dto);
        for (OutVisitRecordVo record : outVisitRecordVos) {
            String patientName = HyposensitizationUtil.hyposensitizationForName((String)record.getPatientName());
            String cardNo = HyposensitizationUtil.hyposensitizationForCardNo((String)record.getCardNo());
            String narratorName = HyposensitizationUtil.hyposensitizationForName((String)record.getNarratorName());
            record.setPatientName(patientName);
            record.setCardNo(cardNo);
            record.setNarratorName(narratorName);
        }
        page.setRecords(outVisitRecordVos);
        return page;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public ResponseData registration(QuickTreatementDto quickTreatementDto) {
        SysDoctorDto sysDoctorDto = new SysDoctorDto();
        sysDoctorDto.setId(quickTreatementDto.getDoctorId());
        ResponseData sysDoctorIdVoResponseData = this.sysServiceFeign.doctorById(sysDoctorDto);
        if (Objects.isNull(sysDoctorIdVoResponseData) || !sysDoctorIdVoResponseData.isSuccess()) {
            return ResponseData.error((String)"\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25{}", (String)JSONObject.toJSONString((Object)sysDoctorIdVoResponseData));
        }
        SysDoctorIdVo sysDoctorIdVo = (SysDoctorIdVo)sysDoctorIdVoResponseData.getData();
        SysDeptDto sysDeptDto = new SysDeptDto();
        sysDeptDto.setId(quickTreatementDto.getDeptId());
        ResponseData sysDepartmentVoResponseData = this.sysServiceFeign.deptInfoById(sysDeptDto);
        if (Objects.isNull(sysDepartmentVoResponseData) || !sysDepartmentVoResponseData.isSuccess()) {
            return ResponseData.error((String)"\u67e5\u8be2\u90e8\u95e8\u4fe1\u606f\u5931\u8d25{}", (String)JSONObject.toJSONString((Object)sysDoctorIdVoResponseData));
        }
        SysDepartmentVo sysDeptVo = (SysDepartmentVo)JSON.parseObject((String)JSON.toJSONString((Object)sysDepartmentVoResponseData.getData()), SysDepartmentVo.class);
        if (Objects.isNull(sysDeptVo)) {
            return ResponseData.error((String)"\u67e5\u8be2\u90e8\u95e8\u4fe1\u606f\u4e3a\u7a7a{}", (String)JSONObject.toJSONString((Object)sysDoctorIdVoResponseData));
        }
        quickTreatementDto.setDeptName(Objects.nonNull(sysDeptVo) ? sysDeptVo.getDepartmentName() : quickTreatementDto.getDeptName());
        quickTreatementDto.setDoctorName(Objects.nonNull(sysDoctorIdVo) ? sysDoctorIdVo.getUserName() : quickTreatementDto.getDoctorName());
        PatientEntity patientEntity = this.checkPatient(quickTreatementDto);
        if (!Objects.isNull(quickTreatementDto.getReservationId())) {
            ReservationEntity reservation = new ReservationEntity();
            reservation.setId(quickTreatementDto.getReservationId());
            reservation.setStatus(ReservationStatusEnum.REGISTRATED.getValue());
            this.reservationMapper.updateById((Object)reservation);
        }
        AdmissionEntity admission = this.buildAdmissionEntity(quickTreatementDto, patientEntity);
        admission.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
        OutpatientTypeEntity outpatientTypeEntity = this.outpatientTypeMapper.queryOutpatientTypeByType(admission.getOutpatientType(), admission.getTenantId());
        admission.setOutpatientTypeName(outpatientTypeEntity.getOutpatientTypeName());
        admission.setVisitDeptPosition(sysDoctorIdVo.getVisitDeptPosition());
        String deviceNo = quickTreatementDto.getDeviceNo();
        if (StringUtil.isNotBlank((String)deviceNo)) {
            admission.setRemark("deviceNo=" + deviceNo);
            JSONObject resultJson = null;
            String baseUrl = "https://medbox.x.yaoxz.cn/mac158";
            String url = "/his/device/getdrugbycode";
            Object map = new HashMap<String, String>();
            ((HashMap)map).put("deviceNo", deviceNo);
            try {
                String reqJson = JSONObject.toJSONString(map);
                log.info("\u8bf7\u6c42\u53d1\u836f\u673a\u5e93\u5b58\u5165\u53c2========>{}", (Object)reqJson);
                String post = HttpUtils.post((String)(baseUrl + url), (String)reqJson);
                log.info("\u8bf7\u6c42\u53d1\u836f\u673a\u5e93\u5b58\u53cd\u53c2========>{}", (Object)post);
                resultJson = JSON.parseObject((String)post);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String status = resultJson.getString("status");
            if ("200".equals(status)) {
                ArrayList<SysDrugEntity> insertDrugList = new ArrayList<SysDrugEntity>();
                JSONArray data = resultJson.getJSONArray("data");
                for (int i = 0; i < data.size(); ++i) {
                    JSONObject drugJson = data.getJSONObject(i);
                    String specifications = drugJson.getString("specs");
                    SysDrugEntity drug = new SysDrugEntity();
                    String guiID = UUIDUtils.getRandom((int)5, (boolean)true);
                    drug.setId(guiID);
                    drug.setDrugsType("2");
                    drug.setDrugType("2");
                    drug.setDrugsName(drugJson.getString("commonname"));
                    drug.setSpecifications(specifications);
                    drug.setManufacturer(drugJson.getString("factory"));
                    drug.setDeviceDrugId(drugJson.getString("productIdHis"));
                    drug.setThirdCode(drugJson.getString("productIdHis"));
                    drug.setWarehouse("2025031715504724456");
                    drug.setStatus("0");
                    drug.setDelFlag("0");
                    drug.setRetailPrice(new BigDecimal(1));
                    drug.setDrugsNamePinyinCode(PinyinUtil.getPinYin((String)drugJson.getString("commonname")));
                    drug.setTenantId(Integer.valueOf(1));
                    this.parseSpecifications(drug);
                    insertDrugList.add(drug);
                }
                this.sysServiceFeign.importDeviceDrug(insertDrugList);
            }
        }
        if (this.admissionMapper.insert((Object)admission) > 0 && outpatientTypeEntity.getRegFee().compareTo(new BigDecimal(0)) == 1) {
            SaveOrderDto saveOrderDto = new SaveOrderDto();
            saveOrderDto.setOperatorId(quickTreatementDto.getOperatorId());
            saveOrderDto.setOperatorName(quickTreatementDto.getOperatorName());
            saveOrderDto.setTenantId(quickTreatementDto.getTenantId());
            saveOrderDto.setAdmissionId(admission.getId());
            saveOrderDto.setOutpatientNo(admission.getOutpatientNo());
            saveOrderDto.setPatientId(admission.getPatientId());
            saveOrderDto.setPatientName(admission.getPatientName());
            saveOrderDto.setMedicalRecordNo(admission.getMedicalRecordNo());
            saveOrderDto.setOrderAmount(outpatientTypeEntity.getRegFee());
            saveOrderDto.setActualOtherPayment(new BigDecimal("0"));
            saveOrderDto.setRegTime(admission.getRegTime());
            saveOrderDto.setPhone(admission.getPhone());
            saveOrderDto.setPatientCardNo(admission.getPatientCardNo());
            saveOrderDto.setSource(quickTreatementDto.getSource());
            log.info("\u4fdd\u5b58\u6302\u53f7\u8ba2\u5355\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)saveOrderDto));
            this.outOrderService.saveOrder(OrderTypeEnum.REGISTERED_ORDINARY_ORDERS, saveOrderDto);
            admission.setIsPrintReg(quickTreatementDto.getIsPrintReg());
            this.redisUtil.set(admission.getOutpatientNo() + "_isPrintReg", (Object)quickTreatementDto.getIsPrintReg(), 1800L);
            try {
                String source;
                String medicalOutpatientType;
                Integer status = admission.getStatus();
                admission.setStatusName(AdmissionStatusEnum.getDesc((Integer)status));
                String medicalType = admission.getMedicalType();
                if (StringUtil.isNotBlank((String)medicalType)) {
                    switch (medicalType) {
                        case "0": {
                            admission.setMedicalTypeName("\u5426");
                            break;
                        }
                        case "1": {
                            admission.setMedicalTypeName("\u5357\u660c\u533b\u4fdd");
                        }
                    }
                }
                if (StringUtil.isNotBlank((String)(medicalOutpatientType = admission.getMedicalOutpatientType()))) {
                    switch (medicalOutpatientType) {
                        case "1": {
                            admission.setMedicalOutpatientTypeName("\u666e\u901a\u95e8\u8bca");
                            break;
                        }
                        case "2": {
                            admission.setMedicalOutpatientTypeName("\u95e8\u8bca\u6162\u7279\u75c5");
                        }
                    }
                }
                if (StringUtil.isNotBlank((String)(source = admission.getSource()))) {
                    switch (source) {
                        case "1": {
                            admission.setSourceName("\u7ebf\u4e0b");
                            break;
                        }
                        case "2": {
                            admission.setSourceName("\u7ebf\u4e0a");
                        }
                    }
                }
                ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
                ArrayList<AdmissionEntity> admissionEntityList = new ArrayList<AdmissionEntity>();
                admissionEntityList.add(admission);
                patientEntity.setAdmissionList(admissionEntityList);
                String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
                list.add(patientEntity);
                String msg = JSONObject.toJSONString(list);
                System.out.println("\u5f00\u59cb\u53d1\u9001\u95e8\u8bca\u4fe1\u606f");
                this.rocketMQProducer.asyncSendCallbackTimeoutLevel(admissionTopic, "TAG7", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ResponseData.success((Object)admission);
        }
        admission.setIsPrintReg(quickTreatementDto.getIsPrintReg());
        this.redisUtil.set(admission.getOutpatientNo() + "_isPrintReg", (Object)quickTreatementDto.getIsPrintReg(), 1800L);
        try {
            String source;
            String medicalOutpatientType;
            Integer status = admission.getStatus();
            admission.setStatusName(AdmissionStatusEnum.getDesc((Integer)status));
            String medicalType = admission.getMedicalType();
            if (StringUtil.isNotBlank((String)medicalType)) {
                switch (medicalType) {
                    case "0": {
                        admission.setMedicalTypeName("\u5426");
                        break;
                    }
                    case "1": {
                        admission.setMedicalTypeName("\u5357\u660c\u533b\u4fdd");
                    }
                }
            }
            if (StringUtil.isNotBlank((String)(medicalOutpatientType = admission.getMedicalOutpatientType()))) {
                switch (medicalOutpatientType) {
                    case "1": {
                        admission.setMedicalOutpatientTypeName("\u666e\u901a\u95e8\u8bca");
                        break;
                    }
                    case "2": {
                        admission.setMedicalOutpatientTypeName("\u95e8\u8bca\u6162\u7279\u75c5");
                    }
                }
            }
            if (StringUtil.isNotBlank((String)(source = admission.getSource()))) {
                switch (source) {
                    case "1": {
                        admission.setSourceName("\u7ebf\u4e0b");
                        break;
                    }
                    case "2": {
                        admission.setSourceName("\u7ebf\u4e0a");
                    }
                }
            }
            ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
            ArrayList<AdmissionEntity> admissionEntityList = new ArrayList<AdmissionEntity>();
            admissionEntityList.add(admission);
            patientEntity.setAdmissionList(admissionEntityList);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            list.add(patientEntity);
            String msg = JSONObject.toJSONString(list);
            System.out.println("\u5f00\u59cb\u53d1\u9001\u95e8\u8bca\u4fe1\u606f");
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(admissionTopic, "TAG7", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseData.success((Object)admission);
    }

    public void test(String deviceNo) {
        if (StringUtil.isNotBlank((String)deviceNo)) {
            JSONObject resultJson = null;
            String baseUrl = "https://medbox.x.yaoxz.cn/mac158";
            String url = "/his/device/getdrugbycode";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("deviceNo", deviceNo);
            try {
                String reqJson = JSONObject.toJSONString(map);
                log.info("\u8bf7\u6c42\u53d1\u836f\u673a\u5e93\u5b58\u5165\u53c2========>{}", (Object)reqJson);
                String post = HttpUtils.post((String)(baseUrl + url), (String)reqJson);
                log.info("\u8bf7\u6c42\u53d1\u836f\u673a\u5e93\u5b58\u53cd\u53c2========>{}", (Object)post);
                resultJson = JSON.parseObject((String)post);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String status = resultJson.getString("status");
            if ("200".equals(status)) {
                ArrayList<SysDrugEntity> insertDrugList = new ArrayList<SysDrugEntity>();
                JSONArray data = resultJson.getJSONArray("data");
                for (int i = 0; i < data.size(); ++i) {
                    JSONObject drugJson = data.getJSONObject(i);
                    String specifications = drugJson.getString("specs");
                    SysDrugEntity drug = new SysDrugEntity();
                    String guiID = UUIDUtils.getRandom((int)5, (boolean)true);
                    drug.setId(guiID);
                    drug.setDrugsType("2");
                    drug.setDrugType("2");
                    drug.setDrugsName(drugJson.getString("commonname"));
                    drug.setSpecifications(specifications);
                    drug.setManufacturer(drugJson.getString("factory"));
                    drug.setDeviceDrugId(drugJson.getString("productIdHis"));
                    drug.setThirdCode(drugJson.getString("productIdHis"));
                    drug.setWarehouse("2025031715504724456");
                    drug.setStatus("0");
                    drug.setDelFlag("0");
                    drug.setRetailPrice(new BigDecimal(1));
                    drug.setDrugsNamePinyinCode(PinyinUtil.getPinYin((String)drugJson.getString("commonname")));
                    drug.setTenantId(Integer.valueOf(1));
                    this.parseSpecifications(drug);
                    insertDrugList.add(drug);
                }
                this.sysServiceFeign.importDeviceDrug(insertDrugList);
            }
        }
    }

    public void parseSpecifications(SysDrugEntity drug) {
        SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
        sysDictValueDTO.setType("we_pack_units");
        sysDictValueDTO.setCurrent(1);
        sysDictValueDTO.setSize(9999);
        ResponseData dictRsp = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, "1");
        List wePackUnits = ((Page)dictRsp.getData()).getRecords();
        Map<String, String> unitsMap = wePackUnits.stream().collect(Collectors.toMap(SysDictValueVo::getLabel, SysDictValueVo::getValue));
        Set<String> unitsLabelSet = unitsMap.keySet();
        ArrayList<String> unitsLabelList = new ArrayList<String>();
        unitsLabelList.addAll(unitsLabelSet);
        Collections.sort(unitsLabelList, new /* Unavailable Anonymous Inner Class!! */);
        String specifications = drug.getSpecifications();
        String defaultUsage = "";
        String doseUnit = "";
        String packSmallUnitsLabel = "";
        String packLargeUnits = "";
        String s = "";
        try {
            String[] unitArr = new String[2];
            if (specifications.contains(":")) {
                unitArr = specifications.split(":");
                s = specifications.split(":")[0];
                doseUnit = s.substring(s.length() - 2, s.length());
            } else if (specifications.contains("*")) {
                unitArr = specifications.split("\\*");
                s = unitArr[0];
                doseUnit = s.substring(s.length() - 2, s.length());
            } else if (specifications.contains("x")) {
                unitArr = specifications.split("x");
                s = unitArr[0];
                doseUnit = s.substring(s.length() - 2, s.length());
            } else if (specifications.contains("\u00d7")) {
                unitArr = specifications.split("\u00d7");
                s = unitArr[0];
                doseUnit = s.substring(s.length() - 2, s.length());
            } else if (specifications.contains("/")) {
                unitArr = specifications.split("/");
                s = unitArr[0];
                doseUnit = s.substring(s.length() - 2, s.length());
            } else if (specifications.contains("[")) {
                unitArr = specifications.split("\\[");
                s = unitArr[0];
                doseUnit = s.substring(s.length() - 2, s.length());
            }
            if (!StringUtils.isBlank((CharSequence)doseUnit)) {
                String substring = doseUnit.substring(0, 1);
                if (substring.matches("-?\\d+(\\.\\d+)?") || substring.contains("*") || substring.contains("/") || substring.contains(" ")) {
                    doseUnit = doseUnit.substring(1, 2);
                }
                defaultUsage = s.replaceAll(doseUnit, "").trim();
            } else {
                s = doseUnit = specifications.replaceAll("[0-9.]", "");
                defaultUsage = specifications.replaceAll(doseUnit, "").trim();
            }
            if (specifications.contains("/")) {
                String[] split = specifications.split("/");
                packLargeUnits = split[split.length - 1];
                packSmallUnitsLabel = split[split.length - 2].length() == 1 ? split[0].substring(split[0].length() - 2, split[0].length()) : split[split.length - 2].substring(split[split.length - 2].length() - 2, split[split.length - 2].length());
                if (packSmallUnitsLabel.equals(")") || packSmallUnitsLabel.equals("\uff09") || packSmallUnitsLabel.equals(" ")) {
                    packSmallUnitsLabel = split[split.length - 2].substring(split[split.length - 2].length() - 2, split[split.length - 2].length() - 1);
                }
                if (packSmallUnitsLabel.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packSmallUnitsLabel.substring(0, 1).contains("*") || packSmallUnitsLabel.substring(0, 1).contains("/") || packSmallUnitsLabel.substring(0, 1).contains(" ")) {
                    packSmallUnitsLabel = packSmallUnitsLabel.substring(1, 2);
                }
                if (packLargeUnits.contains(" ")) {
                    packLargeUnits = packLargeUnits.substring(1, packLargeUnits.length());
                }
            } else if (specifications.contains("[")) {
                packSmallUnitsLabel = unitArr[0].substring(unitArr[0].length() - 2, unitArr[0].length());
                packLargeUnits = unitArr[0].substring(unitArr[0].length() - 2, unitArr[0].length());
                if (packSmallUnitsLabel.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packSmallUnitsLabel.substring(0, 1).contains("*") || packSmallUnitsLabel.substring(0, 1).contains("/") || packSmallUnitsLabel.substring(0, 1).contains(" ")) {
                    packSmallUnitsLabel = packSmallUnitsLabel.substring(1, 2);
                }
                if (packLargeUnits.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packLargeUnits.contains("*") || packLargeUnits.contains("/") || packLargeUnits.contains(" ")) {
                    packLargeUnits = packLargeUnits.substring(1, 2);
                }
            } else if (unitArr[0] != null) {
                packSmallUnitsLabel = unitArr[0].substring(unitArr[0].length() - 2, unitArr[0].length());
                packLargeUnits = unitArr[1].length() == 1 ? unitArr[2].substring(unitArr[2].length() - 2, unitArr[2].length()) : unitArr[1].substring(unitArr[1].length() - 2, unitArr[1].length());
                if (packSmallUnitsLabel.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packSmallUnitsLabel.substring(0, 1).contains("*") || packSmallUnitsLabel.substring(0, 1).contains("/") || packSmallUnitsLabel.substring(0, 1).contains(" ")) {
                    packSmallUnitsLabel = packSmallUnitsLabel.substring(1, 2);
                }
                if (packLargeUnits.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packLargeUnits.substring(0, 1).contains("*") || packLargeUnits.substring(0, 1).contains("/") || packLargeUnits.substring(0, 1).contains(" ")) {
                    packLargeUnits = packLargeUnits.substring(1, 2);
                }
            } else {
                packSmallUnitsLabel = specifications.replaceAll("[0-9]", "");
                packLargeUnits = specifications.replaceAll("[0-9]", "");
            }
        }
        catch (Exception e) {
            System.out.println(specifications);
            throw e;
        }
        if (!unitsLabelList.contains(doseUnit)) {
            for (String label : unitsLabelList) {
                if (!s.contains(label)) continue;
                doseUnit = label;
                break;
            }
        }
        if (!unitsLabelList.contains(packSmallUnitsLabel)) {
            if (specifications.contains("/")) {
                packSmallUnitsLabel = specifications.split("/")[0];
            }
            for (String label : unitsLabelList) {
                if (!packSmallUnitsLabel.contains(label)) continue;
                packSmallUnitsLabel = label;
                break;
            }
        }
        if (!unitsLabelList.contains(packLargeUnits)) {
            for (String label : unitsLabelList) {
                if (!packLargeUnits.contains(label)) continue;
                packLargeUnits = label;
                break;
            }
        }
        String packSpecification = "";
        packSpecification = specifications.contains("*") ? specifications.substring(specifications.indexOf(42), specifications.indexOf(42) + 4 > specifications.length() ? specifications.length() : specifications.indexOf(42) + 4) : (specifications.contains("x") ? specifications.substring(specifications.indexOf(120), specifications.indexOf(120) + 4 > specifications.length() ? specifications.length() : specifications.indexOf(120) + 4) : (specifications.contains("\u00d7") ? specifications.substring(specifications.indexOf(215), specifications.indexOf(215) + 4 > specifications.length() ? specifications.length() : specifications.indexOf(215) + 4) : (specifications.contains("/") ? specifications.substring(0, specifications.indexOf(47)) : (specifications.contains("[") ? "1" : (specifications.contains(":") ? "1" : "1")))));
        packSpecification = packSpecification.replaceAll("[^0-9]", "");
        defaultUsage = defaultUsage.replaceAll("[^0-9.]", "");
        defaultUsage = StringUtils.isNotBlank((CharSequence)defaultUsage) ? defaultUsage : "1";
        drug.setDefaultUsage(defaultUsage);
        drug.setDefaultUsageUnit(unitsMap.get(doseUnit));
        drug.setDefaultSingleDoseUnit(unitsMap.get(doseUnit));
        drug.setPackSmallUnits(unitsMap.get(packSmallUnitsLabel));
        drug.setPackSmallUnitsLabel(packSmallUnitsLabel);
        drug.setPackLargeUnits(unitsMap.get(packLargeUnits));
        drug.setPackSpecification(packSpecification);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<AdmissionPatientVo> quickTreatement(QuickTreatementDto quickTreatementDto) {
        PatientEntity patientEntities = this.checkPatient(quickTreatementDto);
        AdmissionEntity admission = this.buildAdmissionEntity(quickTreatementDto, patientEntities);
        admission.setStatus(AdmissionStatusEnum.TREATNENTED.getValue());
        admission.setVisitTime(DateUtils.getCurrentDate());
        OutpatientTypeEntity outpatientTypeEntity = this.outpatientTypeMapper.queryOutpatientTypeByType(admission.getOutpatientType(), admission.getTenantId());
        admission.setOutpatientTypeName(outpatientTypeEntity.getOutpatientTypeName());
        int insert = this.admissionMapper.insert((Object)admission);
        if (insert != 1) {
            return ResponseData.error((String)"\u63a5\u8bca\u5931\u8d25\uff01");
        }
        try {
            String source;
            String medicalOutpatientType;
            Integer status = admission.getStatus();
            admission.setStatusName(AdmissionStatusEnum.getDesc((Integer)status));
            String medicalType = admission.getMedicalType();
            if (StringUtil.isNotBlank((String)medicalType)) {
                switch (medicalType) {
                    case "0": {
                        admission.setMedicalTypeName("\u5426");
                        break;
                    }
                    case "1": {
                        admission.setMedicalTypeName("\u5357\u660c\u533b\u4fdd");
                    }
                }
            }
            if (StringUtil.isNotBlank((String)(medicalOutpatientType = admission.getMedicalOutpatientType()))) {
                switch (medicalOutpatientType) {
                    case "1": {
                        admission.setMedicalOutpatientTypeName("\u666e\u901a\u95e8\u8bca");
                        break;
                    }
                    case "2": {
                        admission.setMedicalOutpatientTypeName("\u95e8\u8bca\u6162\u7279\u75c5");
                    }
                }
            }
            if (StringUtil.isNotBlank((String)(source = admission.getSource()))) {
                switch (source) {
                    case "1": {
                        admission.setSourceName("\u7ebf\u4e0b");
                        break;
                    }
                    case "2": {
                        admission.setSourceName("\u7ebf\u4e0a");
                    }
                }
            }
            ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
            ArrayList<AdmissionEntity> admissionEntityList = new ArrayList<AdmissionEntity>();
            admissionEntityList.add(admission);
            PatientEntity patientEntity = new PatientEntity();
            patientEntity.setId(admission.getPatientId());
            patientEntity.setAdmissionList(admissionEntityList);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            list.add(patientEntity);
            String msg = JSONObject.toJSONString(list);
            System.out.println("\u5f00\u59cb\u53d1\u9001\u95e8\u8bca\u4fe1\u606f");
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(admissionTopic, "TAG7", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (outpatientTypeEntity.getRegFee().compareTo(new BigDecimal(0)) == 1) {
            SaveOrderDto saveOrderDto = new SaveOrderDto();
            saveOrderDto.setOperatorId(quickTreatementDto.getOperatorId());
            saveOrderDto.setOperatorName(quickTreatementDto.getOperatorName());
            saveOrderDto.setTenantId(quickTreatementDto.getTenantId());
            saveOrderDto.setAdmissionId(admission.getId());
            saveOrderDto.setOutpatientNo(admission.getOutpatientNo());
            saveOrderDto.setPatientId(admission.getPatientId());
            saveOrderDto.setPatientName(admission.getPatientName());
            saveOrderDto.setMedicalRecordNo(admission.getMedicalRecordNo());
            saveOrderDto.setOrderAmount(outpatientTypeEntity.getRegFee());
            saveOrderDto.setActualOtherPayment(new BigDecimal("0"));
            saveOrderDto.setRegTime(admission.getRegTime());
            saveOrderDto.setPhone(admission.getPhone());
            saveOrderDto.setPatientCardNo(admission.getPatientCardNo());
            log.info("\u4fdd\u5b58\u6302\u53f7\u8ba2\u5355\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)saveOrderDto));
            this.outOrderService.saveOrder(OrderTypeEnum.REGISTERED_ORDINARY_ORDERS, saveOrderDto);
        }
        AdmissionPatientVo quickTreatementVo = new AdmissionPatientVo();
        quickTreatementVo.setAge(patientEntities.getAge());
        quickTreatementVo.setBirthday(patientEntities.getBirthday());
        quickTreatementVo.setMedicalRecordNo(patientEntities.getMedicalRecordNo());
        quickTreatementVo.setPhone(patientEntities.getPhone());
        quickTreatementVo.setPatientId(patientEntities.getId());
        quickTreatementVo.setSex("1".equals(patientEntities.getSex()) ? "\u7537" : "\u5973");
        quickTreatementVo.setPatientName(patientEntities.getName());
        quickTreatementVo.setPatientCardNo(patientEntities.getCardNo());
        quickTreatementVo.setOutpatientType(admission.getOutpatientType());
        quickTreatementVo.setMedicalType(admission.getMedicalType());
        quickTreatementVo.setOutpatientNo(admission.getOutpatientNo());
        quickTreatementVo.setWaitNo(admission.getWaitNo());
        quickTreatementVo.setChronicDisease(patientEntities.getChronicDisease());
        quickTreatementVo.setMedicalOutpatientType(admission.getMedicalOutpatientType());
        return ResponseData.success((Object)quickTreatementVo);
    }

    public ResponseData queryTodayAdmissionPatient(QueryAdmissionPatientDto queryAdmissionPatientDto) {
        List admissionPatientVos = this.admissionMapper.queryTodayAdmissionPatient(queryAdmissionPatientDto);
        return ResponseData.success((Object)admissionPatientVos);
    }

    public ResponseData<PageResult<AdmissionPatientVo>> queryHistoryAdmissionPatient(QueryAdmissionDto queryAdmissionDto) {
        PageHelper.startPage((int)queryAdmissionDto.getCurrent(), (int)queryAdmissionDto.getSize());
        List admissionList = this.admissionMapper.queryHistoryAdmissionPatient(queryAdmissionDto);
        PageInfo pageInfo = new PageInfo(admissionList);
        PageResult pageResult = new PageResult(queryAdmissionDto.getCurrent().intValue(), queryAdmissionDto.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(admissionList);
        pageResult.setCurrent(queryAdmissionDto.getCurrent().intValue());
        pageResult.setSize(queryAdmissionDto.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> directReception(DirectReceptionDto directReceptionDto) {
        QueryWrapper queryWrapperAdmission = new QueryWrapper();
        queryWrapperAdmission.eq((Object)"outpatient_no", (Object)directReceptionDto.getOutpatientNo());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)queryWrapperAdmission);
        if (ObjectUtils.isEmpty((Object)admissionEntity)) {
            return ResponseData.error((String)"\u6302\u53f7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
        }
        if (AdmissionStatusEnum.ARCHIVED.getValue().equals(admissionEntity.getStatus())) {
            return ResponseData.success((Object)AdmissionStatusEnum.ARCHIVED.getDesc());
        }
        if (AdmissionStatusEnum.TREATNENTED.getValue().equals(admissionEntity.getStatus())) {
            return ResponseData.success((Object)"\u5df2\u7ecf\u63a5\u8bca");
        }
        if (AdmissionSourceEnum.ONLINE.getValue().equals(admissionEntity.getSource()) && !AdmissionSourceEnum.ONLINE.getValue().equals(directReceptionDto.getSource())) {
            return ResponseData.error((String)"\u6b64\u6302\u53f7\u5355\u4e3a\u7ebf\u4e0a\u5355,\u6682\u65f6\u4e0d\u80fd\u5728\u7ebf\u4e0b\u63a5\u8bca,\u8bf7\u52ff\u64cd\u4f5c!");
        }
        admissionEntity.setStatus(AdmissionStatusEnum.TREATNENTED.getValue());
        admissionEntity.setVisitTime(DateUtils.getCurrentDate());
        this.admissionMapper.updateById((Object)admissionEntity);
        if (!Objects.isNull(admissionEntity.getReservationId())) {
            ReservationEntity reservation = new ReservationEntity();
            reservation.setId(admissionEntity.getReservationId());
            reservation.setStatus(ReservationStatusEnum.TREATNENTED.getValue());
            this.reservationMapper.updateById((Object)reservation);
        }
        try {
            String source;
            String medicalOutpatientType;
            Integer status = admissionEntity.getStatus();
            admissionEntity.setStatusName(AdmissionStatusEnum.getDesc((Integer)status));
            String medicalType = admissionEntity.getMedicalType();
            if (StringUtil.isNotBlank((String)medicalType)) {
                switch (medicalType) {
                    case "0": {
                        admissionEntity.setMedicalTypeName("\u5426");
                        break;
                    }
                    case "1": {
                        admissionEntity.setMedicalTypeName("\u5357\u660c\u533b\u4fdd");
                    }
                }
            }
            if (StringUtil.isNotBlank((String)(medicalOutpatientType = admissionEntity.getMedicalOutpatientType()))) {
                switch (medicalOutpatientType) {
                    case "1": {
                        admissionEntity.setMedicalOutpatientTypeName("\u666e\u901a\u95e8\u8bca");
                        break;
                    }
                    case "2": {
                        admissionEntity.setMedicalOutpatientTypeName("\u95e8\u8bca\u6162\u7279\u75c5");
                    }
                }
            }
            if (StringUtil.isNotBlank((String)(source = admissionEntity.getSource()))) {
                switch (source) {
                    case "1": {
                        admissionEntity.setSourceName("\u7ebf\u4e0b");
                        break;
                    }
                    case "2": {
                        admissionEntity.setSourceName("\u7ebf\u4e0a");
                    }
                }
            }
            ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
            ArrayList<AdmissionEntity> admissionEntityList = new ArrayList<AdmissionEntity>();
            admissionEntityList.add(admissionEntity);
            PatientEntity patientEntity = new PatientEntity();
            patientEntity.setId(admissionEntity.getPatientId());
            patientEntity.setAdmissionList(admissionEntityList);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            list.add(patientEntity);
            String msg = JSONObject.toJSONString(list);
            System.out.println("\u5f00\u59cb\u53d1\u9001\u95e8\u8bca\u4fe1\u606f");
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(admissionTopic, "TAG7", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseData.success((Object)"\u63a5\u8bca\u5b8c\u6210");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> archiving(OutpatientInfomationDto parameter) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"outpatient_no", (Object)parameter.getOutpatientNo());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)query);
        if (admissionEntity == null) {
            return ResponseData.error((String)"\u6302\u53f7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25!");
        }
        if (AdmissionStatusEnum.ARCHIVED.getValue().equals(admissionEntity.getStatus())) {
            return ResponseData.error((String)(AdmissionStatusEnum.ARCHIVED.getDesc() + "\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        }
        if (SourceEnum.ONLINE.getValue().equals(admissionEntity.getSource()) && !SourceEnum.ONLINE.getValue().equals(parameter.getOperatorSource())) {
            return ResponseData.error((String)"\u62b1\u6b49\uff0c\u7ebf\u4e0a\u6302\u53f7\u5355\u6682\u65f6\u65e0\u6cd5\u5728\u7ebf\u4e0b\u64cd\u4f5c\uff01");
        }
        admissionEntity.setStatus(AdmissionStatusEnum.ARCHIVED.getValue());
        admissionEntity.setUpdateId(parameter.getOperatorId());
        int size = this.admissionMapper.updateById((Object)admissionEntity);
        if (size < 1) {
            throw new RunDisplayException("\u5f52\u6863\u5931\u8d25\uff01");
        }
        try {
            String source;
            String medicalOutpatientType;
            Integer status = admissionEntity.getStatus();
            admissionEntity.setStatusName(AdmissionStatusEnum.getDesc((Integer)status));
            String medicalType = admissionEntity.getMedicalType();
            if (StringUtil.isNotBlank((String)medicalType)) {
                switch (medicalType) {
                    case "0": {
                        admissionEntity.setMedicalTypeName("\u5426");
                        break;
                    }
                    case "1": {
                        admissionEntity.setMedicalTypeName("\u5357\u660c\u533b\u4fdd");
                    }
                }
            }
            if (StringUtil.isNotBlank((String)(medicalOutpatientType = admissionEntity.getMedicalOutpatientType()))) {
                switch (medicalOutpatientType) {
                    case "1": {
                        admissionEntity.setMedicalOutpatientTypeName("\u666e\u901a\u95e8\u8bca");
                        break;
                    }
                    case "2": {
                        admissionEntity.setMedicalOutpatientTypeName("\u95e8\u8bca\u6162\u7279\u75c5");
                    }
                }
            }
            if (StringUtil.isNotBlank((String)(source = admissionEntity.getSource()))) {
                switch (source) {
                    case "1": {
                        admissionEntity.setSourceName("\u7ebf\u4e0b");
                        break;
                    }
                    case "2": {
                        admissionEntity.setSourceName("\u7ebf\u4e0a");
                    }
                }
            }
            ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
            ArrayList<AdmissionEntity> admissionEntityList = new ArrayList<AdmissionEntity>();
            admissionEntityList.add(admissionEntity);
            PatientEntity patientEntity = new PatientEntity();
            patientEntity.setId(admissionEntity.getPatientId());
            patientEntity.setAdmissionList(admissionEntityList);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            list.add(patientEntity);
            String msg = JSONObject.toJSONString(list);
            System.out.println("\u5f00\u59cb\u53d1\u9001\u95e8\u8bca\u4fe1\u606f");
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(admissionTopic, "TAG7", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseData.success((Object)"\u5f52\u6863\u5b8c\u6210!");
    }

    public ResponseData<String> archivingByDate(Date nowDate) {
        return null;
    }

    public ResponseData<RegFormDataVo> regFormData(String admIdOrOutpatientNo, Integer tenantId) {
        AdmissionEntity admission = this.admissionMapper.queryAdmissionByIdOrOutpatientNo(admIdOrOutpatientNo, tenantId);
        if (Objects.isNull(admission)) {
            return ResponseData.error((String)"\u67e5\u8be2\u6302\u53f7\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
        }
        RegFormDataVo regFormDataVo = new RegFormDataVo();
        BeanUtils.copyProperties((Object)admission, (Object)regFormDataVo);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"order_no", (Object)admission.getOrderNo());
        OutOrder order = (OutOrder)this.outOrderMapper.selectOne((Wrapper)queryWrapper);
        if (!Objects.isNull(order)) {
            regFormDataVo.setRegFee(order.getOrderAmount());
            if (PaymentStatusEnum.PAYMENT_COMPLETED.getValue().equals(order.getPaymentStatus()) && !Objects.isNull(order.getPayOrderNo())) {
                QueryWrapper queryOrderWrapper = new QueryWrapper();
                ((QueryWrapper)queryOrderWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)order.getPayOrderNo());
                OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryOrderWrapper);
                regFormDataVo.setCheckerName(outOrderPayment.getCheckerName());
                regFormDataVo.setPaymentStatus(outOrderPayment.getPaymentStatus());
                regFormDataVo.setOwnPayAmt(outOrderPayment.getTotalAmount());
                BeanUtils.copyProperties((Object)outOrderPayment, (Object)regFormDataVo);
                if (SettlementMethodEnum.STATUS_MEDICARE_STTLE.getValue().equals(outOrderPayment.getSettlementMethod()) || SettlementMethodEnum.STATUS_MEDICARE_STTLE_PRVN.getValue().equals(outOrderPayment.getSettlementMethod())) {
                    HsSettlementInfoEntity hsSettlementInfoEntity = this.hsSettlementInfoMapper.queryHsSettlmentInfo(outOrderPayment.getSetlId());
                    regFormDataVo.setMedicalType(hsSettlementInfoEntity.getMed_type());
                    regFormDataVo.setBalc(hsSettlementInfoEntity.getBalc());
                    regFormDataVo.setOwnPayAmt(hsSettlementInfoEntity.getPsn_cash_pay());
                }
                regFormDataVo.setRegFeeTotal(regFormDataVo.getBalc().add(regFormDataVo.getOwnPayAmt()));
            }
        } else {
            regFormDataVo.setRegFee(new BigDecimal(0.0));
        }
        return ResponseData.success((Object)regFormDataVo);
    }

    public ResponseData<AdmissionDetailVo> queryByOutpatientNo(String outpatientNo, Integer tenantId) {
        AdmissionDetailVo admissionDetailVo = new AdmissionDetailVo();
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmissionByOutpatientNo(outpatientNo, tenantId);
        BeanUtils.copyProperties((Object)admissionEntity, (Object)admissionDetailVo);
        PatientEntity patientEntity = this.patientMapper.queryById(admissionEntity.getPatientId().intValue());
        admissionDetailVo.setPatientEntity(patientEntity);
        return ResponseData.success((Object)admissionDetailVo);
    }

    public ResponseData queryRegFee(String outpatientType, Integer tenantId) {
        OutpatientTypeEntity outpatientTypeEntity = this.outpatientTypeMapper.queryOutpatientTypeByType(outpatientType, tenantId);
        return ResponseData.success((Object)outpatientTypeEntity);
    }

    private AdmissionEntity buildAdmissionEntity(QuickTreatementDto quickTreatementDto, PatientEntity patientEntities) {
        AdmissionEntity admission = new AdmissionEntity();
        if (!"5".equals(quickTreatementDto.getSource())) {
            this.generateOupatientNoAndWaitNo(admission);
        }
        admission.setDeptId(quickTreatementDto.getDeptId());
        admission.setDeptName(quickTreatementDto.getDeptName());
        admission.setDoctorId(quickTreatementDto.getDoctorId());
        admission.setDoctorName(quickTreatementDto.getDoctorName());
        admission.setMedicalRecordNo(patientEntities.getMedicalRecordNo());
        admission.setMedicalType(quickTreatementDto.getMedicalType());
        admission.setMedicalOutpatientType(quickTreatementDto.getMedicalOutpatientType());
        admission.setOutpatientTypeName(quickTreatementDto.getOutpatientTypeName());
        admission.setPatientName(patientEntities.getName());
        admission.setPatientCardNo(patientEntities.getCardNo());
        admission.setPhone(patientEntities.getPhone());
        admission.setPatientId(patientEntities.getId());
        admission.setOutpatientType(quickTreatementDto.getOutpatientType());
        admission.setMedicalRecordNo(patientEntities.getMedicalRecordNo());
        admission.setRemark(quickTreatementDto.getRemark());
        admission.setTenantId(quickTreatementDto.getTenantId());
        admission.setSource(StringUtil.isBlank((String)quickTreatementDto.getSource()) ? AdmissionSourceEnum.OFFINE.getValue() : quickTreatementDto.getSource());
        admission.setReadyVisitCount(quickTreatementDto.getReadyVisitCount());
        if (quickTreatementDto.getOperatorId() != null && quickTreatementDto.getOperatorId() != 0) {
            admission.setCreateId(quickTreatementDto.getOperatorId());
            admission.setCreateName(quickTreatementDto.getOperatorName());
        }
        if (AdmissionSourceEnum.ONLINE.getValue().equals(quickTreatementDto.getSource())) {
            admission.setSource(AdmissionSourceEnum.ONLINE.getValue());
        } else if (AdmissionSourceEnum.PUBLIC_ACCOUNT.getValue().equals(quickTreatementDto.getSource())) {
            admission.setSource(AdmissionSourceEnum.PUBLIC_ACCOUNT.getValue());
        } else if (AdmissionSourceEnum.NET_HOSPITAL.getValue().equals(quickTreatementDto.getSource())) {
            admission.setSource(AdmissionSourceEnum.NET_HOSPITAL.getValue());
        }
        admission.setReservationId(quickTreatementDto.getReservationId());
        admission.setHospitalName(quickTreatementDto.getHospitalName());
        admission.setPatientAge(quickTreatementDto.getAge());
        admission.setPatientSex(quickTreatementDto.getSex());
        return admission;
    }

    public PatientEntity createPatient(QuickTreatementDto quickTreatementDto) {
        return this.checkPatient(quickTreatementDto);
    }

    private PatientEntity checkPatient(QuickTreatementDto quickTreatementDto) {
        CheckCardNoCorrectnessDto dto = new CheckCardNoCorrectnessDto();
        dto.setName(quickTreatementDto.getName());
        dto.setCardNo(quickTreatementDto.getCardNo());
        CheckCardNoCorrectnessVo vo = this.patientService.checkCardNoCorrectness(dto);
        if (!"01".equals(vo.getStatusCode())) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)vo.getMessage());
        }
        String phone = quickTreatementDto.getPhone();
        Integer peopleCount = this.patientMapper.selectCount((Wrapper)Wrappers.lambdaQuery().eq(PatientEntity::getPhone, (Object)(StrUtil.isNotEmpty((CharSequence)phone) ? phone : "-1")));
        if (peopleCount > 5 && !"5".equals(quickTreatementDto.getSource())) {
            String errorInfo = String.format("\u8be5\u624b\u673a\u53f7\u7801\uff1a\u3010" + phone + "\u3011 \u7ed1\u5b9a\u4eba\u6570\u8d85\u4e0a\u9650\uff0c\u8bf7\u66f4\u6362\u624b\u673a\u53f7\u7801\u91cd\u65b0\u6302\u53f7!", new Object[0]);
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)errorInfo);
        }
        PatientEntity patientEntity = this.patientMapper.queryPatientByCardNoAndTenantId(quickTreatementDto.getCardNo(), quickTreatementDto.getTenantId());
        PatientEntity entity = new PatientEntity();
        if (!Objects.isNull(patientEntity)) {
            if (!quickTreatementDto.getName().equals(patientEntity.getName())) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u60a3\u8005\u59d3\u540d\u548c\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u5339\u914d\uff01");
            }
            patientEntity.setTenantId(quickTreatementDto.getTenantId());
            patientEntity.setName(quickTreatementDto.getName());
            patientEntity.setPhone(quickTreatementDto.getPhone());
            patientEntity.setSex(quickTreatementDto.getSex());
            patientEntity.setCardType(quickTreatementDto.getCardType());
            patientEntity.setCardNo(quickTreatementDto.getCardNo());
            patientEntity.setAge(quickTreatementDto.getAge());
            patientEntity.setRemark(quickTreatementDto.getPatientRemark());
            patientEntity.setBirthday(quickTreatementDto.getBirthday());
            patientEntity.setCardSn(quickTreatementDto.getCardSn());
            patientEntity.setSocialCardNo(quickTreatementDto.getSocialCardNo());
            patientEntity.setSocialCardInfo(quickTreatementDto.getSocialCardInfo());
            patientEntity.setChronicDiseaseCode(quickTreatementDto.getChronicDiseaseCode());
            patientEntity.setChronicDisease(quickTreatementDto.getChronicDisease());
            patientEntity.setUpdateTime(new Date());
            this.patientMapper.updateById((Object)patientEntity);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            ArrayList<PatientEntity> westernMedicinePrescriptionsVos1 = new ArrayList<PatientEntity>();
            westernMedicinePrescriptionsVos1.add(patientEntity);
            String msg = JSONObject.toJSONString(westernMedicinePrescriptionsVos1);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(patientTopic, "TAG3", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
            return patientEntity;
        }
        entity.setTenantId(quickTreatementDto.getTenantId());
        entity.setName(quickTreatementDto.getName());
        entity.setPhone(quickTreatementDto.getPhone());
        entity.setSex(quickTreatementDto.getSex());
        entity.setCardType(quickTreatementDto.getCardType());
        entity.setCardNo(quickTreatementDto.getCardNo());
        entity.setAge(quickTreatementDto.getAge());
        entity.setRemark(quickTreatementDto.getPatientRemark());
        entity.setBirthday(quickTreatementDto.getBirthday());
        entity.setCardSn(quickTreatementDto.getCardSn());
        entity.setSocialCardNo(quickTreatementDto.getSocialCardNo());
        entity.setSocialCardInfo(quickTreatementDto.getSocialCardInfo());
        entity.setChronicDiseaseCode(quickTreatementDto.getChronicDiseaseCode());
        entity.setChronicDisease(quickTreatementDto.getChronicDisease());
        entity.setSource(quickTreatementDto.getSource());
        this.patientService.insert(entity);
        entity.setCreateTime(new Date());
        String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
        ArrayList<PatientEntity> westernMedicinePrescriptionsVos1 = new ArrayList<PatientEntity>();
        westernMedicinePrescriptionsVos1.add(entity);
        String msg = JSONObject.toJSONString(westernMedicinePrescriptionsVos1);
        this.rocketMQProducer.asyncSendCallbackTimeoutLevel(patientTopic, "TAG3", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        return entity;
    }

    private AdmissionEntity generateOupatientNoAndWaitNo(AdmissionEntity admission) {
        admission.setOutpatientNo(RandomCodeUtils.getOutPatientNo());
        Object waitNoObj = this.redisUtil.get(WAIT_NO_PREX + DateUtils.getCurrentDate((String)"yyyy-MM-dd") + "|" + admission.getDoctorId());
        if (Objects.isNull(waitNoObj)) {
            waitNoObj = 0;
            this.redisUtil.set(WAIT_NO_PREX + DateUtils.getCurrentDate((String)"yyyy-MM-dd") + "|" + admission.getDoctorId(), (Object)0, 86400L);
        }
        Integer waitNo = Integer.parseInt(waitNoObj.toString()) + 1;
        admission.setWaitNo(waitNo);
        this.redisUtil.set(WAIT_NO_PREX + DateUtils.getCurrentDate((String)"yyyy-MM-dd") + "|" + admission.getDoctorId(), (Object)waitNo, 86400L);
        return admission;
    }

    public ResponseData deleteById(int id) {
        if (this.admissionMapper.deleteById((Serializable)Integer.valueOf(id)) > 0) {
            return ResponseData.success();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("order_no", id);
        this.outOrderMapper.deleteByMap(map);
        return ResponseData.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
    }

    public ResponseData updateById(AdmissionEntity admission) {
        AdmissionEntity orderAdm = (AdmissionEntity)this.admissionMapper.selectById((Serializable)admission.getId());
        if (AdmissionSourceEnum.ONLINE.getValue().equals(orderAdm.getSource()) && !AdmissionSourceEnum.ONLINE.getValue().equals(admission.getOperatorSource())) {
            return ResponseData.error((String)"\u6b64\u6302\u53f7\u5355\u4e3a\u7ebf\u4e0a\u5355\uff0c\u6682\u65f6\u65e0\u6cd5\u5728\u7ebf\u4e0b\u64cd\u4f5c\uff01");
        }
        OutpatientTypeEntity outpatientTypeEntity = this.outpatientTypeMapper.queryOutpatientTypeByType(admission.getOutpatientType(), admission.getTenantId());
        if (0 == outpatientTypeEntity.getRegFee().compareTo(BigDecimal.ZERO)) {
            admission.setCancelTime(DateUtils.getCurrentDate());
        } else if (AdmissionStatusEnum.DOCTOR_CANCEL.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.PATIENT_CANCEL.getValue().equals(admission.getStatus())) {
            QueryWrapper outOrderPaymentRecordQueryWrapper = new QueryWrapper();
            outOrderPaymentRecordQueryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentRecordQueryWrapper.eq((Object)"operation_type", (Object)OperationTypeEnum.PAYMENT_REFUND.getValue());
            outOrderPaymentRecordQueryWrapper.eq((Object)"order_no", (Object)orderAdm.getOrderNo());
            OutOrderPaymentRecord outOrderPaymentRecord = (OutOrderPaymentRecord)this.outOrderPaymentRecordMapper.selectOne((Wrapper)outOrderPaymentRecordQueryWrapper);
            String orderNo = orderAdm.getOrderNo();
            if (Objects.isNull(outOrderPaymentRecord) && StringUtil.isNotBlank((String)orderNo)) {
                return ResponseData.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u5148\u9000\u6b3e\uff01");
            }
            admission.setCancelTime(DateUtils.getCurrentDate());
            admission.setStatus(AdmissionStatusEnum.RETIRMENT.getValue());
        }
        if (this.admissionMapper.updateById((Object)admission) > 0) {
            try {
                String source;
                String medicalOutpatientType;
                AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getId, (Object)admission.getId()));
                admissionEntity.setCancelTime(admission.getCancelTime());
                admissionEntity.setStatus(admission.getStatus());
                admissionEntity.setUpdateId(admission.getUpdateId());
                admissionEntity.setUpdateName(admission.getUpdateName());
                Integer status = admissionEntity.getStatus();
                admissionEntity.setStatusName(AdmissionStatusEnum.getDesc((Integer)status));
                String medicalType = admissionEntity.getMedicalType();
                if (StringUtil.isNotBlank((String)medicalType)) {
                    switch (medicalType) {
                        case "0": {
                            admissionEntity.setMedicalTypeName("\u5426");
                            break;
                        }
                        case "1": {
                            admissionEntity.setMedicalTypeName("\u5357\u660c\u533b\u4fdd");
                        }
                    }
                }
                if (StringUtil.isNotBlank((String)(medicalOutpatientType = admissionEntity.getMedicalOutpatientType()))) {
                    switch (medicalOutpatientType) {
                        case "1": {
                            admissionEntity.setMedicalOutpatientTypeName("\u666e\u901a\u95e8\u8bca");
                            break;
                        }
                        case "2": {
                            admissionEntity.setMedicalOutpatientTypeName("\u95e8\u8bca\u6162\u7279\u75c5");
                        }
                    }
                }
                if (StringUtil.isNotBlank((String)(source = admissionEntity.getSource()))) {
                    switch (source) {
                        case "1": {
                            admissionEntity.setSourceName("\u7ebf\u4e0b");
                            break;
                        }
                        case "2": {
                            admissionEntity.setSourceName("\u7ebf\u4e0a");
                        }
                    }
                }
                ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
                ArrayList<AdmissionEntity> admissionEntityList = new ArrayList<AdmissionEntity>();
                admissionEntityList.add(admissionEntity);
                PatientEntity patientEntity = new PatientEntity();
                patientEntity.setId(admissionEntity.getPatientId());
                patientEntity.setAdmissionList(admissionEntityList);
                String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
                list.add(patientEntity);
                String msg = JSONObject.toJSONString(list);
                System.out.println("\u5f00\u59cb\u53d1\u9001\u95e8\u8bca\u4fe1\u606f");
                this.rocketMQProducer.asyncSendCallbackTimeoutLevel(admissionTopic, "TAG7", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
    }

    public ResponseData<AdmissionDetailVo> queryById(int id) {
        AdmissionDetailVo admissionDetailVo = new AdmissionDetailVo();
        AdmissionEntity admission = (AdmissionEntity)this.admissionMapper.selectById((Serializable)Integer.valueOf(id));
        BeanUtils.copyProperties((Object)admission, (Object)admissionDetailVo);
        PatientEntity patientEntity = this.patientMapper.queryById(admission.getPatientId().intValue());
        admissionDetailVo.setPatientEntity(patientEntity);
        return ResponseData.success((Object)admissionDetailVo);
    }

    public ResponseData<PageResult<AdmissionPatientVo>> queryAdmission(QueryAdmissionDto queryAdmissionDto) {
        PageHelper.startPage((int)queryAdmissionDto.getCurrent(), (int)queryAdmissionDto.getSize());
        List admissionPatientVos = this.admissionMapper.queryAdmission(queryAdmissionDto);
        PageInfo pageInfo = new PageInfo(admissionPatientVos);
        PageResult pageResult = new PageResult(queryAdmissionDto.getCurrent().intValue(), queryAdmissionDto.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(admissionPatientVos);
        pageResult.setCurrent(queryAdmissionDto.getCurrent().intValue());
        pageResult.setSize(queryAdmissionDto.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public AdmissionEntity queryAdmissionByOutpatient(AdmissionEntity param) {
        AdmissionEntity entity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AdmissionEntity::getOutpatientNo, (Object)param.getOutpatientNo())).eq(AdmissionEntity::getTenantId, (Object)param.getTenantId()));
        return entity;
    }

    @Transactional
    public Integer cancelRegist(AdmissionEntity admission) {
        AdmissionEntity orderAdm = (AdmissionEntity)this.admissionMapper.selectById((Serializable)admission.getId());
        if (AdmissionSourceEnum.ONLINE.getValue().equals(orderAdm.getSource()) && !AdmissionSourceEnum.ONLINE.getValue().equals(admission.getOperatorSource())) {
            throw new BusinessException("\u6b64\u6302\u53f7\u5355\u4e3a\u7ebf\u4e0a\u5355\uff0c\u6682\u65f6\u65e0\u6cd5\u5728\u7ebf\u4e0b\u64cd\u4f5c\uff01");
        }
        OutOrder order = new OutOrder();
        order.setOrderNo(orderAdm.getOrderNo());
        order.setStatus(OutpatientDataStatusEnum.DELETE.getValue());
        int orderUpdateRows = this.outOrderMapper.updateByOrderNo(order);
        if (orderUpdateRows == 0) {
            throw new BusinessException("\u53d6\u6d88\u767b\u8bb0\u5931\u8d25");
        }
        int admissionUpdateRows = this.admissionMapper.deleteById((Serializable)admission.getId());
        if (admissionUpdateRows == 0) {
            throw new BusinessException("\u53d6\u6d88\u767b\u8bb0\u5931\u8d25");
        }
        return 1;
    }

    @Transactional
    public Integer cancelRegistration(AdmissionEntity admission) {
        AdmissionEntity orderAdm = (AdmissionEntity)this.admissionMapper.selectById((Serializable)admission.getId());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)orderAdm.getOrderNo());
        queryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)queryWrapper);
        if (PaymentStatusEnum.PAYMENT_PENDING.getValue().equals(outOrder.getPaymentStatus())) {
            OutOrder order = new OutOrder();
            order.setOrderNo(orderAdm.getOrderNo());
            order.setStatus(OutpatientDataStatusEnum.DELETE.getValue());
            int orderUpdateRows = this.outOrderMapper.updateByOrderNo(order);
            if (orderUpdateRows == 0) {
                throw new BusinessException("\u53d6\u6d88\u767b\u8bb0\u5931\u8d25");
            }
            int t = this.admissionMapper.deleteById((Serializable)admission.getId());
            if (t == 0) {
                throw new BusinessException("\u53d6\u6d88\u767b\u8bb0\u5931\u8d25");
            }
            if (admission.getReservationId() != null) {
                this.reservationMapper.deleteById(admission.getReservationId());
            }
        } else if (PaymentStatusEnum.PAYMENT_COMPLETED.getValue().equals(outOrder.getPaymentStatus())) {
            if (!AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(orderAdm.getStatus())) {
                throw new BusinessException("\u5df2\u5c31\u8bca,\u9000\u53f7\u5931\u8d25\uff01");
            }
            LambdaQueryWrapper outOrderPaymentLambdaQueryWrapper = Wrappers.lambdaQuery();
            outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getPayOrderNo, (Object)outOrder.getPayOrderNo());
            outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getPaymentStatus, (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
            OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)outOrderPaymentLambdaQueryWrapper);
            if (PaymentMethodEnum.PAY_WECHAT.getValue().equals(outOrderPayment.getPaymentMethod())) {
                PayRefundDto payRefundDto = new PayRefundDto();
                payRefundDto.setTenantId(Integer.valueOf(1));
                payRefundDto.setPayOrderNo(outOrderPayment.getPayOrderNo());
                payRefundDto.setRefundableAmount(outOrder.getActualPayment());
                payRefundDto.setRefundAmount(outOrder.getActualPayment());
                payRefundDto.setRefundMethod(Integer.valueOf(1));
                payRefundDto.setReasonForRefund("\u7ebf\u4e0a\u9000\u53f7");
                payRefundDto.setSource("1");
                payRefundDto.setOperatorSource("1");
                ArrayList<String> orderNoList = new ArrayList<String>();
                orderNoList.add(outOrder.getOrderNo());
                payRefundDto.setOrderNoList(orderNoList);
                ResponseData responseData = this.outPayService.firstPayRefund(payRefundDto);
                logger.info("\u81ea\u8d39\u7ebf\u4e0a\u9000\u53f7\uff1a{}", (Object)responseData);
            } else if (PaymentMethodEnum.PAY_MEDICAL_INSURANCE.getValue().equals(outOrderPayment.getPaymentMethod())) {
                HsRefundDto hsRefundDto = new HsRefundDto();
                hsRefundDto.setPayOrderNo(outOrderPayment.getPayOrderNo());
                hsRefundDto.setTenantId(Integer.valueOf(1));
                hsRefundDto.setOpterType("1");
                hsRefundDto.setOpter("76");
                hsRefundDto.setOpterName("ZHJY");
                hsRefundDto.setSign_no("99999");
                ResponseData responseData = this.outPayService.hsRefund(hsRefundDto);
                logger.info("\u533b\u4fdd\u7ebf\u4e0a\u9000\u53f7\uff1a{}", (Object)responseData);
                if (responseData.isSuccess()) {
                    this.refundHy(outOrderPayment);
                } else {
                    throw new BusinessException("\u533b\u4fdd\u9000\u53f7\u5931\u8d25\uff01");
                }
            }
            AdmissionEntity ae = new AdmissionEntity();
            ae.setId(admission.getId());
            ae.setStatus(AdmissionStatusEnum.RETIRMENT.getValue());
            this.admissionMapper.updateById((Object)ae);
            if (admission.getReservationId() != null) {
                ReservationEntity reservation = new ReservationEntity();
                reservation.setId(admission.getReservationId());
                reservation.setStatus(ReservationStatusEnum.CANCEL.getValue());
                this.reservationMapper.updateById((Object)reservation);
            }
        }
        return 1;
    }

    public void refundHy(OutOrderPayment outOrderPayment) {
        QueryWrapper outOrderQueryWrapper = new QueryWrapper();
        outOrderQueryWrapper.eq((Object)"outpatient_no", (Object)outOrderPayment.getOutpatientNo());
        outOrderQueryWrapper.eq((Object)"pay_order_no", (Object)outOrderPayment.getPayOrderNo());
        List orderList = this.outOrderMapper.selectList((Wrapper)outOrderQueryWrapper);
        String source = "";
        if (!orderList.isEmpty()) {
            source = ((OutOrder)orderList.get(0)).getSource();
        }
        if (!StringUtils.isEmpty((CharSequence)source) && source.equalsIgnoreCase("3") && outOrderPayment.getRefundAmount() != null && outOrderPayment.getRefundAmount().compareTo(BigDecimal.ZERO) > 0) {
            String REFUND_URL = "https://ihos.chinachdu.com/zhjy/NCZK/api/v1/refund/outpatientRefundForHis";
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("orderNo", (Object)outOrderPayment.getPayOrderNo());
            jsonObject.put("payChannel", (Object)"WECHAT");
            jsonObject.put("refundFee", (Object)outOrderPayment.getRefundAmount());
            jsonObject.put("refundSerialNo", (Object)outOrderPayment.getPaymentTransactionNo());
            jsonObject.put("transType", (Object)"2");
            logger.info("\u4e92\u533b\u9000\u8d39\u53c2\u65702--:{}", (Object)jsonObject.toJSONString());
            String refundResponse = HttpRequest.post((String)"https://ihos.chinachdu.com/zhjy/NCZK/api/v1/refund/outpatientRefundForHis").contentType("application/json").body(jsonObject.toJSONString()).execute().body();
            JSONObject refundResJson = JSONObject.parseObject((String)refundResponse);
            logger.info("\u4e92\u533b\u9000\u8d39\u8fd4\u56de2--:{}", (Object)refundResJson.toJSONString());
            if (!refundResJson.getString("code").equals("200")) {
                throw new RunDisplayException(refundResJson.getString("message"));
            }
            OutOrderPayment outOrderPayment1 = new OutOrderPayment();
            outOrderPayment1.setRefundCheckerId(Integer.valueOf(76));
            outOrderPayment1.setRefundCheckerName("ZHJY");
            this.outOrderPaymentMapper.updateById((Object)outOrderPayment1);
        }
    }

    public AdmissionEntity queryAdmissionByOutpatientNo(String outpatientNo, Integer tenantId) {
        return this.admissionMapper.queryAdmissionByOutpatientNo(outpatientNo, tenantId);
    }

    public AdmissionEntity queryAdmissionByPrescriptionNo(String prescriptionNo) {
        return this.admissionMapper.queryAdmissionByPrescriptionNo(prescriptionNo);
    }

    public ResponseData updateOutAdmission(JSONObject jsonObject) {
        QueryWrapper queryWrapperAdmission = new QueryWrapper();
        queryWrapperAdmission.eq((Object)"outpatient_no", (Object)jsonObject.getString("outpatientNo"));
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)queryWrapperAdmission);
        if (ObjectUtils.isEmpty((Object)admissionEntity)) {
            return ResponseData.error((String)"\u6302\u53f7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
        }
        if (AdmissionStatusEnum.ARCHIVED.getValue().equals(admissionEntity.getStatus())) {
            return ResponseData.success((Object)AdmissionStatusEnum.ARCHIVED.getDesc());
        }
        if (AdmissionStatusEnum.TREATNENTED.getValue().equals(admissionEntity.getStatus())) {
            return ResponseData.success((Object)"\u5df2\u7ecf\u63a5\u8bca");
        }
        admissionEntity.setStatus(AdmissionStatusEnum.TREATNENTED.getValue());
        admissionEntity.setVisitTime(DateUtils.getCurrentDate());
        this.admissionMapper.updateById((Object)admissionEntity);
        return ResponseData.success();
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

