/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.enums.OrderTypeEnum;
import com.byh.outpatient.api.enums.OutpatientDataStatusEnum;
import com.byh.outpatient.api.enums.PaymentMethodEnum;
import com.byh.outpatient.api.enums.PaymentRecordsStatusEnum;
import com.byh.outpatient.api.enums.PaymentStatusEnum;
import com.byh.outpatient.api.enums.SettlementMethodEnum;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.hsModel.request.GetSettlementInfoRequest;
import com.byh.outpatient.api.hsModel.respones.HsBaseResponse;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.hsSettlement.HsSettlementInfoEntity;
import com.byh.outpatient.api.model.order.OutOrder;
import com.byh.outpatient.api.model.order.OutOrderPayment;
import com.byh.outpatient.api.model.prescription.OutPrescriptionDrug;
import com.byh.outpatient.api.model.treatment.OutTreatmentDetails;
import com.byh.outpatient.api.sysModel.invoice.InvoiceConfigDetailVo;
import com.byh.outpatient.api.sysModel.invoice.InvoiceConfigVo;
import com.byh.outpatient.api.sysModel.invoice.SysInvoiceApplyForEntity;
import com.byh.outpatient.api.sysModel.invoice.SysInvoiceConfigDetailEntity;
import com.byh.outpatient.api.sysModel.invoice.SysInvoiceConfigDto;
import com.byh.outpatient.api.sysModel.invoice.SysInvoiceConfirmDetailsEntity;
import com.byh.outpatient.api.sysModel.invoice.SysInvoiceDto;
import com.byh.outpatient.api.sysModel.request.SysDictValueDTO;
import com.byh.outpatient.api.sysModel.respones.SysDictValueVo;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutHsSettlementInfoMapper;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.data.repository.OutPrescriptionDrugMapper;
import com.byh.outpatient.data.repository.OutTreatmentDetailsMapper;
import com.byh.outpatient.web.feign.HsServiceFeign;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.config.NodeConfig;
import com.byh.outpatient.web.service.OutInvoiceService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutInvoiceServiceImpl
implements OutInvoiceService {
    @Resource
    private OutOrderPaymentMapper outOrderPaymentMapper;
    @Resource
    private AdmissionMapper admissionMapper;
    @Resource
    private OutOrderMapper outOrderMapper;
    @Resource
    private OutPrescriptionDrugMapper outPrescriptionDrugMapper;
    @Resource
    private OutTreatmentDetailsMapper outTreatmentDetailsMapper;
    @Resource
    private OutHsSettlementInfoMapper outHsSettlementInfoMapper;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private HsServiceFeign hsServiceFeign;
    private Logger logger = LoggerFactory.getLogger(OutInvoiceServiceImpl.class);
    private ExecutorService executor = Executors.newCachedThreadPool();
    @Autowired
    private NodeConfig nodeConfig;

    @Transactional(rollbackFor={BusinessException.class})
    public boolean outInvoicing(String payOrderNo, String signNo, String invoiceRemark, Integer tenantId) {
        Number quantity;
        if (StrUtil.isEmpty((CharSequence)payOrderNo)) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u5355\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        SysInvoiceConfigDto dto = new SysInvoiceConfigDto();
        LambdaQueryWrapper outOrderPaymentLambdaQueryWrapper = Wrappers.lambdaQuery();
        outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getPayOrderNo, (Object)payOrderNo);
        outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getPaymentStatus, (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)outOrderPaymentLambdaQueryWrapper);
        if (outOrderPayment == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u652f\u4ed8\u5355\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)outOrderPayment.getOutpatientNo())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u95e8\u8bca\u53f7\u4e3a\u7a7a\uff01");
        }
        if (outOrderPayment.getPaymentTime() == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u652f\u4ed8\u65f6\u95f4\u4e3a\u7a7a\uff01");
        }
        if (outOrderPayment.getPaymentMethod() == null || StrUtil.isEmpty((CharSequence)outOrderPayment.getPaymentMethod().toString())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u652f\u4ed8\u65b9\u5f0f\u4e3a\u7a7a\uff01");
        }
        String remark = "";
        String paymentMethod = PaymentMethodEnum.getEnum((Integer)outOrderPayment.getPaymentMethod()).getDesc();
        if (SettlementMethodEnum.STATUS_MEDICARE_STTLE.getValue().equals(outOrderPayment.getSettlementMethod()) || SettlementMethodEnum.STATUS_MEDICARE_STTLE_PRVN.getValue().equals(outOrderPayment.getSettlementMethod()) || SettlementMethodEnum.STATUS_MEDICARE_STTLE_PRVN_OTHER.getValue().equals(outOrderPayment.getSettlementMethod()) || SettlementMethodEnum.STATUS_MEDICARE_STTLE_OUT_PRVN_OTHER.getValue().equals(outOrderPayment.getSettlementMethod())) {
            String cvlservPay;
            String hifesPay;
            String hifmiPay;
            String acctMulaidPay;
            String balc;
            String cashPayamt;
            String acctPay;
            String hifpPay;
            HsSettlementInfoEntity hsSettlementInfoEntity;
            if (StrUtil.isEmpty((CharSequence)outOrderPayment.getSetlId())) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u533b\u4fdd\u7ed3\u7b97ID\u4e3a\u7a7a\uff01");
            }
            if ((hsSettlementInfoEntity = this.outHsSettlementInfoMapper.queryHsSettlmentInfo(outOrderPayment.getSetlId())) == null) {
                if (StrUtil.isEmpty((CharSequence)outOrderPayment.getPsnNo())) {
                    ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u60a3\u8005\u533b\u4fdd\u7f16\u53f7\u4e3a\u7a7a\uff01");
                }
                if (StrUtil.isEmpty((CharSequence)outOrderPayment.getSetlId())) {
                    ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u533b\u4fdd\u7ed3\u7b97\u7f16\u53f7\u4e3a\u7a7a\uff01");
                }
                if (StrUtil.isEmpty((CharSequence)outOrderPayment.getMdtrtId())) {
                    ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u533b\u4fdd\u767b\u8bb0\u7f16\u53f7\u4e3a\u7a7a\uff01");
                }
                GetSettlementInfoRequest getSettlementInfoRequest = new GetSettlementInfoRequest();
                getSettlementInfoRequest.setPsn_no(outOrderPayment.getPsnNo());
                getSettlementInfoRequest.setSetl_id(outOrderPayment.getSetlId());
                getSettlementInfoRequest.setMdtrt_id(outOrderPayment.getMdtrtId());
                getSettlementInfoRequest.setSign_no(signNo);
                getSettlementInfoRequest.setTenantId(tenantId);
                ResponseData hsBaseResponseResponseData = this.hsServiceFeign.settlementInfo(getSettlementInfoRequest);
                if (!Objects.isNull(hsBaseResponseResponseData) && hsBaseResponseResponseData.isSuccess() && !Objects.isNull(hsBaseResponseResponseData.getData())) {
                    JSONObject jsonObject = (JSONObject)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput();
                    Object object = jsonObject.get((Object)"setlinfo");
                    LinkedHashMap linkedHashMap = (LinkedHashMap)object;
                    hifpPay = linkedHashMap.get("hifp_pay") == null ? "0" : linkedHashMap.get("hifp_pay").toString();
                    acctPay = linkedHashMap.get("acct_pay") == null ? "0" : linkedHashMap.get("acct_pay").toString();
                    cashPayamt = linkedHashMap.get("cash_payamt") == null ? "0" : linkedHashMap.get("cash_payamt").toString();
                    balc = linkedHashMap.get("balc") == null ? "0" : linkedHashMap.get("balc").toString();
                    acctMulaidPay = linkedHashMap.get("acct_mulaid_pay") == null ? "0" : linkedHashMap.get("acct_mulaid_pay").toString();
                    hifmiPay = linkedHashMap.get("hifmi_pay") == null ? "0" : linkedHashMap.get("hifmi_pay").toString();
                    hifesPay = linkedHashMap.get("hifes_pay") == null ? "0" : linkedHashMap.get("hifes_pay").toString();
                    cvlservPay = linkedHashMap.get("cvlserv_flag") == null ? "0" : linkedHashMap.get("cvlserv_flag").toString();
                    remark = "\u7edf\u7b79\u652f\u4ed8\uff1a" + hifpPay + " \u8d26\u6237\u652f\u4ed8\uff1a" + acctPay + " \u4e2a\u4eba\u81ea\u4ed8\uff1a" + cashPayamt + " \u8d26\u6237\u4f59\u989d\uff1a" + balc + " \u652f\u4ed8\u65b9\u5f0f\uff1a" + paymentMethod + " \u5171\u6d4e\uff1a" + acctMulaidPay + " \u5927\u75c5\u4fdd\u9669\uff1a" + hifmiPay + " \u533b\u7597\u6551\u52a9\uff1a" + hifesPay + " \u516c\u52a1\u5458\u8865\u52a9\uff1a" + cvlservPay;
                } else {
                    ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u533b\u4fdd\u7ed3\u7b97\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
                }
            } else {
                hifpPay = hsSettlementInfoEntity.getHifp_pay() == null ? "0" : hsSettlementInfoEntity.getHifp_pay().stripTrailingZeros().toPlainString();
                acctPay = hsSettlementInfoEntity.getAcct_pay() == null ? "0" : hsSettlementInfoEntity.getAcct_pay().stripTrailingZeros().toPlainString();
                cashPayamt = hsSettlementInfoEntity.getPsn_cash_pay() == null ? "0" : hsSettlementInfoEntity.getPsn_cash_pay().stripTrailingZeros().toPlainString();
                balc = hsSettlementInfoEntity.getBalc() == null ? "0" : hsSettlementInfoEntity.getBalc().stripTrailingZeros().toPlainString();
                acctMulaidPay = hsSettlementInfoEntity.getAcct_mulaid_pay() == null ? "0" : hsSettlementInfoEntity.getAcct_mulaid_pay().stripTrailingZeros().toPlainString();
                hifmiPay = hsSettlementInfoEntity.getHifmi_pay() == null ? "0" : hsSettlementInfoEntity.getHifmi_pay().stripTrailingZeros().toPlainString();
                hifesPay = hsSettlementInfoEntity.getMaf_pay() == null ? "0" : hsSettlementInfoEntity.getMaf_pay().stripTrailingZeros().toPlainString();
                cvlservPay = hsSettlementInfoEntity.getCvlserv_pay() == null ? "0" : hsSettlementInfoEntity.getCvlserv_pay().stripTrailingZeros().toPlainString();
                remark = "\u7edf\u7b79\u652f\u4ed8\uff1a" + hifpPay + " \u8d26\u6237\u652f\u4ed8\uff1a" + acctPay + " \u4e2a\u4eba\u81ea\u4ed8\uff1a" + cashPayamt + " \u8d26\u6237\u4f59\u989d\uff1a" + balc + " \u652f\u4ed8\u65b9\u5f0f\uff1a" + paymentMethod + " \u5171\u6d4e\uff1a" + acctMulaidPay + " \u5927\u75c5\u4fdd\u9669\uff1a" + hifmiPay + " \u533b\u7597\u6551\u52a9\uff1a" + hifesPay + " \u516c\u52a1\u5458\u8865\u52a9\uff1a" + cvlservPay;
            }
        } else {
            remark = "\u7edf\u7b79\u652f\u4ed8\uff1a0 \u8d26\u6237\u652f\u4ed8\uff1a0 \u4e2a\u4eba\u81ea\u4ed8\uff1a0 \u8d26\u6237\u4f59\u989d\uff1a0 \u652f\u4ed8\u65b9\u5f0f\uff1a" + paymentMethod + " \u5171\u6d4e\uff1a0 \u5927\u75c5\u4fdd\u9669\uff1a0 \u533b\u7597\u6551\u52a9\uff1a0 \u516c\u52a1\u5458\u8865\u52a9\uff1a0";
        }
        if (StrUtil.isNotEmpty((CharSequence)invoiceRemark)) {
            remark = invoiceRemark + "\n" + remark;
        }
        dto.setRemark(remark);
        dto.setOrderNo(outOrderPayment.getPayOrderNo());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String invoiceDate = dateFormat.format(outOrderPayment.getPaymentTime());
        dto.setInvoiceDate(invoiceDate);
        LambdaQueryWrapper admissionEntityLambdaQueryWrapper = Wrappers.lambdaQuery();
        admissionEntityLambdaQueryWrapper.eq(AdmissionEntity::getOutpatientNo, (Object)outOrderPayment.getOutpatientNo());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admissionEntityLambdaQueryWrapper);
        if (admissionEntity == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u95e8\u8bca\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6302\u53f7\u4fe1\u606f\uff01");
        }
        if (admissionEntity.getDeptId() == null || StrUtil.isEmpty((CharSequence)admissionEntity.getDeptId().toString())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6302\u53f7\u4fe1\u606f\u8868\u5185\u7684\u79d1\u5ba4\u7f16\u53f7\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)admissionEntity.getPatientName())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6302\u53f7\u4fe1\u606f\u8868\u5185\u7684\u60a3\u8005\u59d3\u540d\u4e3a\u7a7a\uff01");
        }
        dto.setPatientName(admissionEntity.getPatientName());
        dto.setPatientCardNo(admissionEntity.getPatientCardNo());
        dto.setDepartmentId(admissionEntity.getDeptId().toString());
        dto.setBuyerPhone(admissionEntity.getPhone());
        LambdaQueryWrapper outOrderLambdaQueryWrapper = Wrappers.lambdaQuery();
        outOrderLambdaQueryWrapper.eq(OutOrder::getPayOrderNo, (Object)payOrderNo);
        outOrderLambdaQueryWrapper.eq(OutOrder::getStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        outOrderLambdaQueryWrapper.eq(OutOrder::getPaymentStatus, (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        List orderList = this.outOrderMapper.selectList((Wrapper)outOrderLambdaQueryWrapper);
        if (orderList == null || orderList.size() == 0) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u652f\u4ed8\u5355\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        HashSet<String> prescNos = new HashSet<String>();
        HashSet<String> treatmentNos = new HashSet<String>();
        ArrayList<SysInvoiceConfigDetailEntity> invoiceDetailList = new ArrayList<SysInvoiceConfigDetailEntity>();
        for (OutOrder outOrder : orderList) {
            BigDecimal totalAmount;
            if (OrderTypeEnum.PRESCRIPTION_WESTERN_MEDICINE_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_TRADITIONAL_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_CHINESE_PATENT_DRUG_ORDERS.getValue().equals(outOrder.getOrderType())) {
                prescNos.add(outOrder.getPrescriptionNo());
                continue;
            }
            if (OrderTypeEnum.REGISTERED_INSPECTION_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_INSPECT_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_TREATMENT_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_OPERATION_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_ANAESTHESIA_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_NURSING_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_DIET_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_OXYGEN_THERAPY_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_MATERIAL_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_PATROL_VEHICLE_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_MATERIAL_PROJECTS_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_SERVICER_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_BLOOD_TRANSFUSION_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_OTHER_PROJECTS_ORDERS.getValue().equals(outOrder.getOrderType())) {
                treatmentNos.add(outOrder.getPrescriptionNo());
                continue;
            }
            if (!OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getValue().equals(outOrder.getOrderType()) || (totalAmount = outOrder.getTotalAmount()) == null || totalAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            SysInvoiceConfigDetailEntity entity = new SysInvoiceConfigDetailEntity();
            entity.setGoodsName(admissionEntity.getOutpatientTypeName());
            entity.setNum("1");
            entity.setPrice(outOrder.getActualPayment() == null ? "0" : outOrder.getActualPayment().toString());
            entity.setUnit("\u4eba\u6b21");
            invoiceDetailList.add(entity);
        }
        if (!prescNos.isEmpty()) {
            LambdaQueryWrapper outPrescriptionDrugLambdaQueryWrapper = Wrappers.lambdaQuery();
            outPrescriptionDrugLambdaQueryWrapper.in(OutPrescriptionDrug::getPrescriptionNo, prescNos);
            outPrescriptionDrugLambdaQueryWrapper.eq(OutPrescriptionDrug::getStatus, (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            List prescriptionDrugList = this.outPrescriptionDrugMapper.selectList((Wrapper)outPrescriptionDrugLambdaQueryWrapper);
            Object unitMap = new HashMap();
            if (prescriptionDrugList != null && !prescriptionDrugList.isEmpty()) {
                unitMap = this.getUnitDictValues("we_pack_units", tenantId);
            }
            if (prescriptionDrugList != null && !prescriptionDrugList.isEmpty()) {
                for (OutPrescriptionDrug prescDrug : prescriptionDrugList) {
                    BigDecimal totalDrugAmount = prescDrug.getTotalDrugAmount();
                    if (totalDrugAmount == null || totalDrugAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    quantity = prescDrug.getQuantity();
                    BigDecimal drugPriceAmount = prescDrug.getDrugPriceAmount();
                    String quantityUnitCode = prescDrug.getQuantityUnitCode();
                    SysInvoiceConfigDetailEntity detailEntity = new SysInvoiceConfigDetailEntity();
                    detailEntity.setGoodsName(prescDrug.getDrugName());
                    detailEntity.setNum(quantity == null ? "0" : ((BigDecimal)quantity).toString());
                    detailEntity.setPrice(drugPriceAmount == null ? "0" : drugPriceAmount.toString());
                    String quantityUnitLabel = unitMap.get(quantityUnitCode) == null ? "" : (String)unitMap.get(quantityUnitCode);
                    detailEntity.setUnit(quantityUnitLabel);
                    invoiceDetailList.add(detailEntity);
                }
            }
        }
        if (!treatmentNos.isEmpty()) {
            LambdaQueryWrapper outTreatmentDetailsLambdaQueryWrapper = Wrappers.lambdaQuery();
            outTreatmentDetailsLambdaQueryWrapper.in(OutTreatmentDetails::getOutTreatmentId, treatmentNos);
            List treatmentDetailsList = this.outTreatmentDetailsMapper.selectList((Wrapper)outTreatmentDetailsLambdaQueryWrapper);
            for (OutTreatmentDetails detail : treatmentDetailsList) {
                BigDecimal totalAmount = detail.getTotalAmount();
                if (totalAmount == null || totalAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal unitPriceAmount = detail.getUnitPriceAmount();
                quantity = detail.getQuantity();
                SysInvoiceConfigDetailEntity detailEntity = new SysInvoiceConfigDetailEntity();
                detailEntity.setGoodsName(detail.getTreatmentName());
                detailEntity.setNum(quantity == null ? "0" : ((Integer)quantity).toString());
                detailEntity.setPrice(unitPriceAmount == null ? "0" : unitPriceAmount.toString());
                invoiceDetailList.add(detailEntity);
            }
        }
        dto.setInvoiceDetail(invoiceDetailList);
        JSONObject jsonObject = this.sysServiceFeign.invoicing(dto);
        String code = jsonObject.getString("code");
        if ("E0000".equals(code)) {
            Object resultObject = jsonObject.get((Object)"result");
            LinkedHashMap map = (LinkedHashMap)resultObject;
            String serialNum = map.get("invoiceSerialNum").toString();
            for (OutOrder outOrder : orderList) {
                outOrder.setInvoiceNo(serialNum);
                outOrder.setInvoiceTime(outOrderPayment.getPaymentTime());
                outOrder.setInvoiceStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
                this.outOrderMapper.updateById((Object)outOrder);
            }
        } else {
            String failReson = jsonObject.getString("describe");
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)failReson);
        }
        return true;
    }

    private Map<String, String> getUnitDictValues(String type, Integer tenantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        SysDictValueDTO dictValueDTO = new SysDictValueDTO();
        dictValueDTO.setType(type);
        dictValueDTO.setCurrent(1);
        dictValueDTO.setSize(-1);
        ResponseData sysDictValueVoResponseData = this.sysServiceFeign.sysDictValueById(dictValueDTO, String.valueOf(tenantId));
        List dictValueVoList = ((Page)sysDictValueVoResponseData.getData()).getRecords();
        for (SysDictValueVo vo : dictValueVoList) {
            map.put(vo.getValue(), vo.getLabel());
        }
        return map;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public boolean cancel(String payOrderNo, Integer tenantId) {
        SysInvoiceApplyForEntity entity = new SysInvoiceApplyForEntity();
        entity.setTenantId(tenantId);
        if (StrUtil.isEmpty((CharSequence)payOrderNo)) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u5355\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper outOrderLambdaQueryWrapper = Wrappers.lambdaQuery();
        outOrderLambdaQueryWrapper.eq(OutOrder::getPayOrderNo, (Object)payOrderNo);
        outOrderLambdaQueryWrapper.eq(OutOrder::getStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        outOrderLambdaQueryWrapper.eq(OutOrder::getPaymentStatus, (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        outOrderLambdaQueryWrapper.eq(OutOrder::getInvoiceStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        List orderList = this.outOrderMapper.selectList((Wrapper)outOrderLambdaQueryWrapper);
        if (orderList == null || orderList.size() == 0) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u652f\u4ed8\u5355\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        HashSet<String> prescNos = new HashSet<String>();
        HashSet<String> treatmentNos = new HashSet<String>();
        ArrayList<SysInvoiceConfirmDetailsEntity> detailsEntityList = new ArrayList<SysInvoiceConfirmDetailsEntity>();
        for (OutOrder outOrder : orderList) {
            if (OrderTypeEnum.PRESCRIPTION_WESTERN_MEDICINE_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_TRADITIONAL_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_CHINESE_PATENT_DRUG_ORDERS.getValue().equals(outOrder.getOrderType())) {
                prescNos.add(outOrder.getPrescriptionNo());
                continue;
            }
            if (OrderTypeEnum.REGISTERED_INSPECTION_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_INSPECT_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_TREATMENT_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_OPERATION_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_ANAESTHESIA_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_NURSING_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_DIET_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_OXYGEN_THERAPY_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_MATERIAL_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_PATROL_VEHICLE_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_OTHER_PROJECTS_ORDERS.getValue().equals(outOrder.getOrderType())) {
                treatmentNos.add(outOrder.getPrescriptionNo());
                continue;
            }
            if (!OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getValue().equals(outOrder.getOrderType())) continue;
            LambdaQueryWrapper outOrderPaymentLambdaQueryWrapper = Wrappers.lambdaQuery();
            outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getPayOrderNo, (Object)payOrderNo);
            outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getPaymentStatus, (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
            OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)outOrderPaymentLambdaQueryWrapper);
            if (outOrderPayment == null) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u652f\u4ed8\u5355\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f\uff01");
            }
            if (StrUtil.isEmpty((CharSequence)outOrderPayment.getOutpatientNo())) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u95e8\u8bca\u53f7\u4e3a\u7a7a\uff01");
            }
            LambdaQueryWrapper admissionEntityLambdaQueryWrapper = Wrappers.lambdaQuery();
            admissionEntityLambdaQueryWrapper.eq(AdmissionEntity::getOutpatientNo, (Object)outOrderPayment.getOutpatientNo());
            AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admissionEntityLambdaQueryWrapper);
            if (admissionEntity == null) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u95e8\u8bca\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6302\u53f7\u4fe1\u606f\uff01");
            }
            SysInvoiceConfirmDetailsEntity detailsEntity = new SysInvoiceConfirmDetailsEntity();
            detailsEntity.setGoodsName(admissionEntity.getOutpatientTypeName());
            detailsEntity.setUnit("\u4eba\u6b21");
            detailsEntity.setTaxExcludedPrice(outOrder.getActualPayment() == null ? "0" : outOrder.getActualPayment().toString());
            detailsEntity.setNum("1");
            detailsEntity.setTaxExcludedAmount(outOrder.getActualPayment() == null ? "0" : outOrder.getActualPayment().toString());
            detailsEntityList.add(detailsEntity);
        }
        entity.setSerialNo(((OutOrder)orderList.get(0)).getInvoiceNo());
        if (prescNos.size() > 0) {
            LambdaQueryWrapper outPrescriptionDrugLambdaQueryWrapper = Wrappers.lambdaQuery();
            outPrescriptionDrugLambdaQueryWrapper.in(OutPrescriptionDrug::getPrescriptionNo, prescNos);
            outPrescriptionDrugLambdaQueryWrapper.eq(OutPrescriptionDrug::getStatus, (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            List prescriptionDrugList = this.outPrescriptionDrugMapper.selectList((Wrapper)outPrescriptionDrugLambdaQueryWrapper);
            Object unitMap = new HashMap();
            if (prescriptionDrugList != null && prescriptionDrugList.size() > 0) {
                unitMap = this.getUnitDictValues("we_pack_units", tenantId);
            }
            for (OutPrescriptionDrug prescDrug : prescriptionDrugList) {
                SysInvoiceConfirmDetailsEntity detailsEntity = new SysInvoiceConfirmDetailsEntity();
                detailsEntity.setGoodsName(prescDrug.getDrugName());
                detailsEntity.setSpecType(prescDrug.getSpecification());
                String quantityUnitLabel = unitMap.get(prescDrug.getQuantityUnitCode()) == null ? "" : (String)unitMap.get(prescDrug.getQuantityUnitCode());
                detailsEntity.setUnit(quantityUnitLabel);
                detailsEntity.setNum(prescDrug.getQuantity() == null ? "0" : prescDrug.getQuantity().toString());
                detailsEntity.setTaxExcludedPrice(prescDrug.getDrugPriceAmount() == null ? "0" : prescDrug.getDrugPriceAmount().toString());
                detailsEntity.setTaxExcludedAmount(prescDrug.getTotalDrugAmount() == null ? "0" : prescDrug.getTotalDrugAmount().toString());
                detailsEntityList.add(detailsEntity);
            }
        }
        if (treatmentNos.size() > 0) {
            LambdaQueryWrapper outTreatmentDetailsLambdaQueryWrapper = Wrappers.lambdaQuery();
            outTreatmentDetailsLambdaQueryWrapper.in(OutTreatmentDetails::getOutTreatmentId, treatmentNos);
            List treatmentDetailsList = this.outTreatmentDetailsMapper.selectList((Wrapper)outTreatmentDetailsLambdaQueryWrapper);
            for (OutTreatmentDetails details : treatmentDetailsList) {
                SysInvoiceConfirmDetailsEntity detailsEntity = new SysInvoiceConfirmDetailsEntity();
                detailsEntity.setGoodsName(details.getTreatmentName());
                detailsEntity.setNum(details.getQuantity() == null ? "0" : details.getQuantity().toString());
                detailsEntity.setTaxExcludedPrice(details.getUnitPriceAmount() == null ? "0" : details.getUnitPriceAmount().toString());
                detailsEntity.setTaxExcludedAmount(details.getTotalAmount() == null ? "0" : details.getTotalAmount().toString());
                detailsEntityList.add(detailsEntity);
            }
        }
        entity.setDetail(detailsEntityList);
        JSONObject jsonObject = this.sysServiceFeign.cancel(entity);
        String code = jsonObject.getString("code");
        if ("E0000".equals(code)) {
            for (OutOrder outOrder : orderList) {
                outOrder.setInvoiceStatus(PaymentRecordsStatusEnum.STATUS_VOID.getValue());
                this.outOrderMapper.updateById((Object)outOrder);
            }
        } else {
            String failReson = jsonObject.getString("describe");
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)failReson);
        }
        return true;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public boolean cancel2(String payOrderNo, Integer tenantId) {
        SysInvoiceApplyForEntity entity = new SysInvoiceApplyForEntity();
        entity.setTenantId(tenantId);
        if (StrUtil.isEmpty((CharSequence)payOrderNo)) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u5355\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper outOrderLambdaQueryWrapper = Wrappers.lambdaQuery();
        outOrderLambdaQueryWrapper.eq(OutOrder::getPayOrderNo, (Object)payOrderNo);
        outOrderLambdaQueryWrapper.eq(OutOrder::getStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        outOrderLambdaQueryWrapper.eq(OutOrder::getPaymentStatus, (Object)PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
        outOrderLambdaQueryWrapper.eq(OutOrder::getInvoiceStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        List orderList = this.outOrderMapper.selectList((Wrapper)outOrderLambdaQueryWrapper);
        if (orderList == null || orderList.size() == 0) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u652f\u4ed8\u5355\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        HashSet<String> prescNos = new HashSet<String>();
        HashSet<String> treatmentNos = new HashSet<String>();
        ArrayList<SysInvoiceConfirmDetailsEntity> detailsEntityList = new ArrayList<SysInvoiceConfirmDetailsEntity>();
        for (OutOrder outOrder : orderList) {
            if (OrderTypeEnum.PRESCRIPTION_WESTERN_MEDICINE_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_TRADITIONAL_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_CHINESE_PATENT_DRUG_ORDERS.getValue().equals(outOrder.getOrderType())) {
                prescNos.add(outOrder.getPrescriptionNo());
                continue;
            }
            if (OrderTypeEnum.REGISTERED_INSPECTION_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_INSPECT_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_TREATMENT_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_OPERATION_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_ANAESTHESIA_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_NURSING_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_DIET_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_OXYGEN_THERAPY_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_MATERIAL_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_PATROL_VEHICLE_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_OTHER_PROJECTS_ORDERS.getValue().equals(outOrder.getOrderType())) {
                treatmentNos.add(outOrder.getPrescriptionNo());
                continue;
            }
            if (!OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getValue().equals(outOrder.getOrderType())) continue;
            LambdaQueryWrapper outOrderPaymentLambdaQueryWrapper = Wrappers.lambdaQuery();
            outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getPayOrderNo, (Object)payOrderNo);
            outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getPaymentStatus, (Object)PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)outOrderPaymentLambdaQueryWrapper);
            if (outOrderPayment == null) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u652f\u4ed8\u5355\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f\uff01");
            }
            if (StrUtil.isEmpty((CharSequence)outOrderPayment.getOutpatientNo())) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u95e8\u8bca\u53f7\u4e3a\u7a7a\uff01");
            }
            LambdaQueryWrapper admissionEntityLambdaQueryWrapper = Wrappers.lambdaQuery();
            admissionEntityLambdaQueryWrapper.eq(AdmissionEntity::getOutpatientNo, (Object)outOrderPayment.getOutpatientNo());
            AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admissionEntityLambdaQueryWrapper);
            if (admissionEntity == null) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u95e8\u8bca\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6302\u53f7\u4fe1\u606f\uff01");
            }
            SysInvoiceConfirmDetailsEntity detailsEntity = new SysInvoiceConfirmDetailsEntity();
            detailsEntity.setGoodsName(admissionEntity.getOutpatientTypeName());
            detailsEntity.setUnit("\u4eba\u6b21");
            detailsEntity.setTaxExcludedPrice(outOrder.getActualPayment() == null ? "0" : outOrder.getActualPayment().toString());
            detailsEntity.setNum("1");
            detailsEntity.setTaxExcludedAmount(outOrder.getActualPayment() == null ? "0" : outOrder.getActualPayment().toString());
            detailsEntityList.add(detailsEntity);
        }
        entity.setSerialNo(((OutOrder)orderList.get(0)).getInvoiceNo());
        if (prescNos.size() > 0) {
            LambdaQueryWrapper outPrescriptionDrugLambdaQueryWrapper = Wrappers.lambdaQuery();
            outPrescriptionDrugLambdaQueryWrapper.in(OutPrescriptionDrug::getPrescriptionNo, prescNos);
            outPrescriptionDrugLambdaQueryWrapper.eq(OutPrescriptionDrug::getStatus, (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            List prescriptionDrugList = this.outPrescriptionDrugMapper.selectList((Wrapper)outPrescriptionDrugLambdaQueryWrapper);
            Object unitMap = new HashMap();
            if (prescriptionDrugList != null && prescriptionDrugList.size() > 0) {
                unitMap = this.getUnitDictValues("we_pack_units", tenantId);
            }
            for (OutPrescriptionDrug prescDrug : prescriptionDrugList) {
                SysInvoiceConfirmDetailsEntity detailsEntity = new SysInvoiceConfirmDetailsEntity();
                detailsEntity.setGoodsName(prescDrug.getDrugName());
                detailsEntity.setSpecType(prescDrug.getSpecification());
                String quantityUnitLabel = unitMap.get(prescDrug.getQuantityUnitCode()) == null ? "" : (String)unitMap.get(prescDrug.getQuantityUnitCode());
                detailsEntity.setUnit(quantityUnitLabel);
                detailsEntity.setNum(prescDrug.getQuantity() == null ? "0" : prescDrug.getQuantity().toString());
                detailsEntity.setTaxExcludedPrice(prescDrug.getDrugPriceAmount() == null ? "0" : prescDrug.getDrugPriceAmount().toString());
                detailsEntity.setTaxExcludedAmount(prescDrug.getTotalDrugAmount() == null ? "0" : prescDrug.getTotalDrugAmount().toString());
                detailsEntityList.add(detailsEntity);
            }
        }
        if (treatmentNos.size() > 0) {
            LambdaQueryWrapper outTreatmentDetailsLambdaQueryWrapper = Wrappers.lambdaQuery();
            outTreatmentDetailsLambdaQueryWrapper.in(OutTreatmentDetails::getOutTreatmentId, treatmentNos);
            List treatmentDetailsList = this.outTreatmentDetailsMapper.selectList((Wrapper)outTreatmentDetailsLambdaQueryWrapper);
            for (OutTreatmentDetails details : treatmentDetailsList) {
                SysInvoiceConfirmDetailsEntity detailsEntity = new SysInvoiceConfirmDetailsEntity();
                detailsEntity.setGoodsName(details.getTreatmentName());
                detailsEntity.setNum(details.getQuantity() == null ? "0" : details.getQuantity().toString());
                detailsEntity.setTaxExcludedPrice(details.getUnitPriceAmount() == null ? "0" : details.getUnitPriceAmount().toString());
                detailsEntity.setTaxExcludedAmount(details.getTotalAmount() == null ? "0" : details.getTotalAmount().toString());
                detailsEntityList.add(detailsEntity);
            }
        }
        entity.setDetail(detailsEntityList);
        JSONObject jsonObject = this.sysServiceFeign.cancel(entity);
        String code = jsonObject.getString("code");
        if ("E0000".equals(code)) {
            for (OutOrder outOrder : orderList) {
                outOrder.setInvoiceStatus(PaymentRecordsStatusEnum.STATUS_VOID.getValue());
                this.outOrderMapper.updateById((Object)outOrder);
            }
        } else {
            String failReson = jsonObject.getString("describe");
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)failReson);
        }
        return true;
    }

    public boolean batchCancel(String payOrderNo, List<String> orderNoList) {
        List outOrderList;
        ArrayList list = new ArrayList();
        if (orderNoList != null && orderNoList != null) {
            QueryWrapper queryrOrder = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)queryrOrder.in((Object)"order_no", orderNoList)).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
            outOrderList = this.outOrderMapper.selectList((Wrapper)queryrOrder);
            list.addAll(outOrderList);
        }
        if (StringUtil.isNotBlank((String)payOrderNo)) {
            QueryWrapper queryOrderWrapper = new QueryWrapper();
            ((QueryWrapper)queryOrderWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"pay_order_no", (Object)payOrderNo);
            outOrderList = this.outOrderMapper.selectList((Wrapper)queryOrderWrapper);
            list.addAll(outOrderList);
        }
        for (OutOrder outOrder : list) {
            String payOrderNo1 = outOrder.getPayOrderNo();
            Integer tenantId1 = outOrder.getTenantId();
            Integer invoiceStatus = outOrder.getInvoiceStatus();
            if (invoiceStatus != 1) continue;
            for (int i = 0; i < 2; ++i) {
                this.cancel2(payOrderNo1, tenantId1);
            }
        }
        return true;
    }

    public ResponseData createInvoiceParams(String payOrderNo, Integer tenantId, String signNo) {
        Number quantity;
        if (StrUtil.isEmpty((CharSequence)payOrderNo)) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u5355\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        InvoiceConfigVo dto = new InvoiceConfigVo();
        LambdaQueryWrapper outOrderPaymentLambdaQueryWrapper = Wrappers.lambdaQuery();
        outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getPayOrderNo, (Object)payOrderNo);
        outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        outOrderPaymentLambdaQueryWrapper.eq(OutOrderPayment::getPaymentStatus, (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)outOrderPaymentLambdaQueryWrapper);
        if (outOrderPayment == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u652f\u4ed8\u5355\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)outOrderPayment.getOutpatientNo())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u95e8\u8bca\u53f7\u4e3a\u7a7a\uff01");
        }
        if (outOrderPayment.getPaymentTime() == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u652f\u4ed8\u65f6\u95f4\u4e3a\u7a7a\uff01");
        }
        if (outOrderPayment.getPaymentMethod() == null || StrUtil.isEmpty((CharSequence)outOrderPayment.getPaymentMethod().toString())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u652f\u4ed8\u65b9\u5f0f\u4e3a\u7a7a\uff01");
        }
        String remark = "";
        String paymentMethod = PaymentMethodEnum.getEnum((Integer)outOrderPayment.getPaymentMethod()).getDesc();
        if (SettlementMethodEnum.STATUS_MEDICARE_STTLE.getValue().equals(outOrderPayment.getSettlementMethod()) || SettlementMethodEnum.STATUS_MEDICARE_STTLE_PRVN.getValue().equals(outOrderPayment.getSettlementMethod()) || SettlementMethodEnum.STATUS_MEDICARE_STTLE_PRVN_OTHER.getValue().equals(outOrderPayment.getSettlementMethod()) || SettlementMethodEnum.STATUS_MEDICARE_STTLE_OUT_PRVN_OTHER.getValue().equals(outOrderPayment.getSettlementMethod())) {
            String cvlservPay;
            String hifesPay;
            String hifmiPay;
            String acctMulaidPay;
            String balc;
            String cashPayamt;
            String acctPay;
            String hifpPay;
            HsSettlementInfoEntity hsSettlementInfoEntity;
            if (StrUtil.isEmpty((CharSequence)outOrderPayment.getSetlId())) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u533b\u4fdd\u7ed3\u7b97ID\u4e3a\u7a7a\uff01");
            }
            if ((hsSettlementInfoEntity = this.outHsSettlementInfoMapper.queryHsSettlmentInfo(outOrderPayment.getSetlId())) == null) {
                if (StrUtil.isEmpty((CharSequence)outOrderPayment.getPsnNo())) {
                    ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u60a3\u8005\u533b\u4fdd\u7f16\u53f7\u4e3a\u7a7a\uff01");
                }
                if (StrUtil.isEmpty((CharSequence)outOrderPayment.getSetlId())) {
                    ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u533b\u4fdd\u7ed3\u7b97\u7f16\u53f7\u4e3a\u7a7a\uff01");
                }
                if (StrUtil.isEmpty((CharSequence)outOrderPayment.getMdtrtId())) {
                    ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8868\u5185\u7684\u533b\u4fdd\u767b\u8bb0\u7f16\u53f7\u4e3a\u7a7a\uff01");
                }
                GetSettlementInfoRequest getSettlementInfoRequest = new GetSettlementInfoRequest();
                getSettlementInfoRequest.setPsn_no(outOrderPayment.getPsnNo());
                getSettlementInfoRequest.setSetl_id(outOrderPayment.getSetlId());
                getSettlementInfoRequest.setMdtrt_id(outOrderPayment.getMdtrtId());
                getSettlementInfoRequest.setSign_no(signNo);
                getSettlementInfoRequest.setTenantId(tenantId);
                ResponseData hsBaseResponseResponseData = this.hsServiceFeign.settlementInfo(getSettlementInfoRequest);
                if (!Objects.isNull(hsBaseResponseResponseData) && hsBaseResponseResponseData.isSuccess() && !Objects.isNull(hsBaseResponseResponseData.getData())) {
                    JSONObject jsonObject = (JSONObject)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput();
                    Object object = jsonObject.get((Object)"setlinfo");
                    LinkedHashMap linkedHashMap = (LinkedHashMap)object;
                    hifpPay = linkedHashMap.get("hifp_pay") == null ? "0" : linkedHashMap.get("hifp_pay").toString();
                    acctPay = linkedHashMap.get("acct_pay") == null ? "0" : linkedHashMap.get("acct_pay").toString();
                    cashPayamt = linkedHashMap.get("cash_payamt") == null ? "0" : linkedHashMap.get("cash_payamt").toString();
                    balc = linkedHashMap.get("balc") == null ? "0" : linkedHashMap.get("balc").toString();
                    acctMulaidPay = linkedHashMap.get("acct_mulaid_pay") == null ? "0" : linkedHashMap.get("acct_mulaid_pay").toString();
                    hifmiPay = linkedHashMap.get("hifmi_pay") == null ? "0" : linkedHashMap.get("hifmi_pay").toString();
                    hifesPay = linkedHashMap.get("hifes_pay") == null ? "0" : linkedHashMap.get("hifes_pay").toString();
                    cvlservPay = linkedHashMap.get("cvlserv_flag") == null ? "0" : linkedHashMap.get("cvlserv_flag").toString();
                    remark = "\u7edf\u7b79\u652f\u4ed8\uff1a" + hifpPay + " \u8d26\u6237\u652f\u4ed8\uff1a" + acctPay + " \u4e2a\u4eba\u81ea\u4ed8\uff1a" + cashPayamt + " \u8d26\u6237\u4f59\u989d\uff1a" + balc + " \u652f\u4ed8\u65b9\u5f0f\uff1a" + paymentMethod + " \u5171\u6d4e\uff1a" + acctMulaidPay + " \u5927\u75c5\u4fdd\u9669\uff1a" + hifmiPay + " \u533b\u7597\u6551\u52a9\uff1a" + hifesPay + " \u516c\u52a1\u5458\u8865\u52a9\uff1a" + cvlservPay;
                } else {
                    ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u533b\u4fdd\u7ed3\u7b97\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
                }
            } else {
                hifpPay = hsSettlementInfoEntity.getHifp_pay() == null ? "0" : hsSettlementInfoEntity.getHifp_pay().stripTrailingZeros().toPlainString();
                acctPay = hsSettlementInfoEntity.getAcct_pay() == null ? "0" : hsSettlementInfoEntity.getAcct_pay().stripTrailingZeros().toPlainString();
                cashPayamt = hsSettlementInfoEntity.getPsn_cash_pay() == null ? "0" : hsSettlementInfoEntity.getPsn_cash_pay().stripTrailingZeros().toPlainString();
                balc = hsSettlementInfoEntity.getBalc() == null ? "0" : hsSettlementInfoEntity.getBalc().stripTrailingZeros().toPlainString();
                acctMulaidPay = hsSettlementInfoEntity.getAcct_mulaid_pay() == null ? "0" : hsSettlementInfoEntity.getAcct_mulaid_pay().stripTrailingZeros().toPlainString();
                hifmiPay = hsSettlementInfoEntity.getHifmi_pay() == null ? "0" : hsSettlementInfoEntity.getHifmi_pay().stripTrailingZeros().toPlainString();
                hifesPay = hsSettlementInfoEntity.getMaf_pay() == null ? "0" : hsSettlementInfoEntity.getMaf_pay().stripTrailingZeros().toPlainString();
                cvlservPay = hsSettlementInfoEntity.getCvlserv_pay() == null ? "0" : hsSettlementInfoEntity.getCvlserv_pay().stripTrailingZeros().toPlainString();
                remark = "\u7edf\u7b79\u652f\u4ed8\uff1a" + hifpPay + " \u8d26\u6237\u652f\u4ed8\uff1a" + acctPay + " \u4e2a\u4eba\u81ea\u4ed8\uff1a" + cashPayamt + " \u8d26\u6237\u4f59\u989d\uff1a" + balc + " \u652f\u4ed8\u65b9\u5f0f\uff1a" + paymentMethod + " \u5171\u6d4e\uff1a" + acctMulaidPay + " \u5927\u75c5\u4fdd\u9669\uff1a" + hifmiPay + " \u533b\u7597\u6551\u52a9\uff1a" + hifesPay + " \u516c\u52a1\u5458\u8865\u52a9\uff1a" + cvlservPay;
            }
        } else {
            remark = "\u7edf\u7b79\u652f\u4ed8\uff1a0 \u8d26\u6237\u652f\u4ed8\uff1a0 \u4e2a\u4eba\u81ea\u4ed8\uff1a0 \u8d26\u6237\u4f59\u989d\uff1a0 \u652f\u4ed8\u65b9\u5f0f\uff1a" + paymentMethod + " \u5171\u6d4e\uff1a0 \u5927\u75c5\u4fdd\u9669\uff1a0 \u533b\u7597\u6551\u52a9\uff1a0 \u516c\u52a1\u5458\u8865\u52a9\uff1a0";
        }
        dto.setRemark(remark);
        dto.setOrderNo(outOrderPayment.getPayOrderNo());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String invoiceDate = dateFormat.format(outOrderPayment.getPaymentTime());
        dto.setInvoiceDate(invoiceDate);
        LambdaQueryWrapper admissionEntityLambdaQueryWrapper = Wrappers.lambdaQuery();
        admissionEntityLambdaQueryWrapper.eq(AdmissionEntity::getOutpatientNo, (Object)outOrderPayment.getOutpatientNo());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admissionEntityLambdaQueryWrapper);
        if (admissionEntity == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u95e8\u8bca\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6302\u53f7\u4fe1\u606f\uff01");
        }
        if (admissionEntity.getDeptId() == null || StrUtil.isEmpty((CharSequence)admissionEntity.getDeptId().toString())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6302\u53f7\u4fe1\u606f\u8868\u5185\u7684\u79d1\u5ba4\u7f16\u53f7\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)admissionEntity.getPatientName())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6302\u53f7\u4fe1\u606f\u8868\u5185\u7684\u60a3\u8005\u59d3\u540d\u4e3a\u7a7a\uff01");
        }
        dto.setBuyerName(admissionEntity.getPatientName());
        dto.setBuyerTaxNum(admissionEntity.getPatientCardNo());
        dto.setDepartmentId(admissionEntity.getDeptId().toString());
        dto.setBuyerPhone(admissionEntity.getPhone());
        LambdaQueryWrapper outOrderLambdaQueryWrapper = Wrappers.lambdaQuery();
        outOrderLambdaQueryWrapper.eq(OutOrder::getPayOrderNo, (Object)payOrderNo);
        outOrderLambdaQueryWrapper.eq(OutOrder::getStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        outOrderLambdaQueryWrapper.eq(OutOrder::getPaymentStatus, (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        List orderList = this.outOrderMapper.selectList((Wrapper)outOrderLambdaQueryWrapper);
        if (orderList == null || orderList.size() == 0) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u652f\u4ed8\u5355\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        HashSet<String> prescNos = new HashSet<String>();
        HashSet<String> treatmentNos = new HashSet<String>();
        ArrayList<InvoiceConfigDetailVo> invoiceDetailList = new ArrayList<InvoiceConfigDetailVo>();
        for (OutOrder outOrder : orderList) {
            BigDecimal totalAmount;
            if (OrderTypeEnum.PRESCRIPTION_WESTERN_MEDICINE_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_TRADITIONAL_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_CHINESE_PATENT_DRUG_ORDERS.getValue().equals(outOrder.getOrderType())) {
                prescNos.add(outOrder.getPrescriptionNo());
                continue;
            }
            if (OrderTypeEnum.REGISTERED_INSPECTION_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_INSPECT_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_TREATMENT_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_OPERATION_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_ANAESTHESIA_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_NURSING_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_DIET_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_OXYGEN_THERAPY_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_MATERIAL_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_PATROL_VEHICLE_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_MATERIAL_PROJECTS_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_SERVICER_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_BLOOD_TRANSFUSION_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_OTHER_PROJECTS_ORDERS.getValue().equals(outOrder.getOrderType())) {
                treatmentNos.add(outOrder.getPrescriptionNo());
                continue;
            }
            if (!OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getValue().equals(outOrder.getOrderType()) || (totalAmount = outOrder.getTotalAmount()) == null || totalAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            InvoiceConfigDetailVo entity = new InvoiceConfigDetailVo();
            entity.setGoodsName(admissionEntity.getOutpatientTypeName());
            entity.setNum("1");
            entity.setPrice(outOrder.getActualPayment() == null ? "0" : outOrder.getActualPayment().toString());
            entity.setUnit("\u4eba\u6b21");
            invoiceDetailList.add(entity);
        }
        if (!prescNos.isEmpty()) {
            LambdaQueryWrapper outPrescriptionDrugLambdaQueryWrapper = Wrappers.lambdaQuery();
            outPrescriptionDrugLambdaQueryWrapper.in(OutPrescriptionDrug::getPrescriptionNo, prescNos);
            outPrescriptionDrugLambdaQueryWrapper.eq(OutPrescriptionDrug::getStatus, (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            List prescriptionDrugList = this.outPrescriptionDrugMapper.selectList((Wrapper)outPrescriptionDrugLambdaQueryWrapper);
            Map unitMap = new HashMap();
            if (prescriptionDrugList != null && !prescriptionDrugList.isEmpty()) {
                unitMap = this.getUnitDictValues("we_pack_units", tenantId);
            }
            if (prescriptionDrugList != null && !prescriptionDrugList.isEmpty()) {
                for (OutPrescriptionDrug prescDrug : prescriptionDrugList) {
                    BigDecimal totalDrugAmount = prescDrug.getTotalDrugAmount();
                    if (totalDrugAmount == null || totalDrugAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    quantity = prescDrug.getQuantity();
                    BigDecimal drugPriceAmount = prescDrug.getDrugPriceAmount();
                    String quantityUnitCode = prescDrug.getQuantityUnitCode();
                    InvoiceConfigDetailVo detailEntity = new InvoiceConfigDetailVo();
                    detailEntity.setGoodsName(prescDrug.getDrugName());
                    detailEntity.setNum(quantity == null ? "0" : ((BigDecimal)quantity).toString());
                    detailEntity.setPrice(drugPriceAmount == null ? "0" : drugPriceAmount.toString());
                    detailEntity.setSpecType(prescDrug.getSpecification());
                    String quantityUnitLabel = unitMap.get(quantityUnitCode) == null ? "" : (String)unitMap.get(quantityUnitCode);
                    detailEntity.setUnit(quantityUnitLabel);
                    invoiceDetailList.add(detailEntity);
                }
            }
        }
        if (!treatmentNos.isEmpty()) {
            LambdaQueryWrapper outTreatmentDetailsLambdaQueryWrapper = Wrappers.lambdaQuery();
            outTreatmentDetailsLambdaQueryWrapper.in(OutTreatmentDetails::getOutTreatmentId, treatmentNos);
            List treatmentDetailsList = this.outTreatmentDetailsMapper.selectList((Wrapper)outTreatmentDetailsLambdaQueryWrapper);
            for (OutTreatmentDetails detail : treatmentDetailsList) {
                BigDecimal totalAmount = detail.getTotalAmount();
                if (totalAmount == null || totalAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal unitPriceAmount = detail.getUnitPriceAmount();
                quantity = detail.getQuantity();
                InvoiceConfigDetailVo detailEntity = new InvoiceConfigDetailVo();
                detailEntity.setGoodsName(detail.getTreatmentName());
                detailEntity.setNum(quantity == null ? "0" : ((Integer)quantity).toString());
                detailEntity.setPrice(unitPriceAmount == null ? "0" : unitPriceAmount.toString());
                invoiceDetailList.add(detailEntity);
            }
        }
        dto.setInvoiceDetail(invoiceDetailList);
        return ResponseData.success((Object)dto);
    }

    @Transactional
    public ResponseData updateInvoice(SysInvoiceDto dto) {
        JSONObject jsonObject;
        String flag = dto.getFlag();
        if (!"1".equals(flag) && !(jsonObject = this.sysServiceFeign.addInvoice(dto)).getString("code").equalsIgnoreCase("200")) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u65b0\u589e\u53d1\u7968\u4fe1\u606f\u5931\u8d25!");
        }
        LambdaQueryWrapper outOrderLambdaQueryWrapper = Wrappers.lambdaQuery();
        outOrderLambdaQueryWrapper.eq(OutOrder::getPayOrderNo, (Object)dto.getOrderNo());
        outOrderLambdaQueryWrapper.eq(OutOrder::getStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        outOrderLambdaQueryWrapper.eq(OutOrder::getPaymentStatus, (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        List orderList = this.outOrderMapper.selectList((Wrapper)outOrderLambdaQueryWrapper);
        if (orderList == null || orderList.size() == 0) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u652f\u4ed8\u5355\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        for (OutOrder outOrder : orderList) {
            if ("1".equals(flag)) {
                outOrder.setInvoiceStatus(PaymentRecordsStatusEnum.STATUS_GOING.getValue());
            } else {
                outOrder.setInvoiceNo(dto.getSerialNo());
                outOrder.setInvoiceTime(new Date(Long.parseLong(dto.getInvoiceDate())));
                outOrder.setInvoiceStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            }
            this.outOrderMapper.updateById((Object)outOrder);
        }
        return ResponseData.success((Object)dto);
    }
}

