/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.byh.outpatient.api.dto.medicalRecord.PerformSkinTestDto;
import com.byh.outpatient.api.dto.medicalRecord.QuerySkinTestDto;
import com.byh.outpatient.api.enums.OutpatientDataStatusEnum;
import com.byh.outpatient.api.model.prescription.OutPrescriptionDrug;
import com.byh.outpatient.api.model.prescription.OutSkinRecords;
import com.byh.outpatient.api.sysModel.request.SysEasyEntity;
import com.byh.outpatient.api.sysModel.respones.SysUserVo;
import com.byh.outpatient.api.util.HyposensitizationUtil;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.vo.prescription.QuerySkinTestListVo;
import com.byh.outpatient.data.repository.OutPrescriptionDrugMapper;
import com.byh.outpatient.data.repository.OutSkinRecordsMapper;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.service.OutSkinRecordsMapperService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutSkinRecordsMapperServiceImpl
implements OutSkinRecordsMapperService {
    @Autowired
    private OutSkinRecordsMapper outSkinRecordsMapper;
    @Autowired
    private OutPrescriptionDrugMapper outPrescriptionDrugMapper;
    @Autowired
    private SysServiceFeign sysServiceFeign;

    public ResponseData<PageResult<QuerySkinTestListVo>> querySkinTestList(QuerySkinTestDto parameter) {
        if (parameter.getCurrent() == null || parameter.getSize() == null) {
            return ResponseData.error((String)"\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtil.isEmpty((String)parameter.getStartTime()) && !StringUtil.isEmpty((String)parameter.getEndTime())) {
            parameter.setStartTime(parameter.getStartTime() + " 00:00:00");
            parameter.setEndTime(parameter.getEndTime() + " 23:59:59");
        }
        PageHelper.startPage((int)parameter.getCurrent(), (int)parameter.getSize());
        List querySkinTestListVos = this.outSkinRecordsMapper.querySkinTestList(parameter);
        for (QuerySkinTestListVo record : querySkinTestListVos) {
            String patientName = HyposensitizationUtil.hyposensitizationForName((String)record.getPatientName());
            record.setPatientName(patientName);
        }
        PageInfo pageInfo = new PageInfo(querySkinTestListVos);
        PageResult pageResult = new PageResult(parameter.getCurrent().intValue(), parameter.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(querySkinTestListVos);
        pageResult.setCurrent(parameter.getCurrent().intValue());
        pageResult.setSize(parameter.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData<String> performSkinTest(PerformSkinTestDto parameter) {
        if (null == parameter.getSkinTestStatus() || null == parameter.getVerifierID()) {
            return ResponseData.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)parameter.getVerifierPassword())) {
            return ResponseData.error((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OutPrescriptionDrug outPrescriptionDrug = (OutPrescriptionDrug)this.outPrescriptionDrugMapper.selectById((Serializable)parameter.getId());
        if (outPrescriptionDrug == null) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u8bb0\u5f55\uff01");
        }
        SysEasyEntity entity = new SysEasyEntity();
        entity.setId(String.valueOf(parameter.getVerifierID()));
        ResponseData info = this.sysServiceFeign.getInfo(entity);
        if (Objects.isNull(info) || !info.isSuccess() || info.getData() == null) {
            return ResponseData.error((String)"\u67e5\u8be2\u4fe1\u606f\u5931\u8d25{}", (String)JSONObject.toJSONString((Object)parameter.getVerifierID()));
        }
        SysUserVo infoData = (SysUserVo)info.getData();
        if (!infoData.getPassword().equals(parameter.getVerifierPassword())) {
            return ResponseData.error((String)"\u5bc6\u7801\u9519\u8bef");
        }
        outPrescriptionDrug.setIsSkinTest(Integer.valueOf(3));
        outPrescriptionDrug.setSkinTestResult(parameter.getSkinTestStatus() == 1 ? "\u9634\u6027" : "\u9633\u6027");
        this.outPrescriptionDrugMapper.updateById((Object)outPrescriptionDrug);
        OutSkinRecords outSkinRecords = new OutSkinRecords();
        outSkinRecords.setTenantId(parameter.getTenantId());
        outSkinRecords.setPrescriptionDrugId(outPrescriptionDrug.getId());
        outSkinRecords.setDrugNo(outPrescriptionDrug.getDrugNo());
        outSkinRecords.setDrugName(outPrescriptionDrug.getDrugName());
        outSkinRecords.setSkinTestResult(parameter.getSkinTestStatus() == 1 ? "\u9634\u6027" : "\u9633\u6027");
        outSkinRecords.setSkinTestStatus(parameter.getSkinTestStatus());
        outSkinRecords.setStatus(OutpatientDataStatusEnum.NORMAL.getValue());
        outSkinRecords.setSkinRemark(parameter.getRemarks());
        outSkinRecords.setOperatorId(parameter.getOperatorId());
        outSkinRecords.setOperatorName(parameter.getOperatorName());
        outSkinRecords.setVerifierId(parameter.getVerifierID());
        outSkinRecords.setVerifierName(infoData.getUserName());
        outSkinRecords.setUpdateTime(new Date());
        this.outSkinRecordsMapper.insert((Object)outSkinRecords);
        return ResponseData.success((Object)"\u64cd\u4f5c\u5b8c\u6210\uff01");
    }
}

