/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.history.OutpatientHistoryDto;
import com.byh.outpatient.api.excel.PatientImportVo;
import com.byh.outpatient.api.excel.PatientListener;
import com.byh.outpatient.api.excel.history.HistoryImportVo;
import com.byh.outpatient.api.excel.history.HistoryListener;
import com.byh.outpatient.api.model.history.OutpatientHistoryEntity;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.sdkModel.OrdSeeDoctorRecordEntity;
import com.byh.outpatient.api.util.BeanUtil;
import com.byh.outpatient.api.util.EasyExcelUtil;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutpatientHistoryService;
import com.byh.outpatient.web.service.PatientService;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/outHistory"})
public class OutpatientHistoryController {
    private static final Logger logger = LoggerFactory.getLogger(OutpatientHistoryController.class);
    private final OutpatientHistoryService outpatientHistoryService;
    private final CommonRequest commonRequest;
    @Autowired
    private PatientService patientService;

    @ApiOperation(value="\u5206\u9875", httpMethod="GET", notes="\u5206\u9875")
    @GetMapping(value={"/pageList"})
    public ResponseData pageList(Page page, OutpatientHistoryDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.outpatientHistoryService.pageList(page, dto));
    }

    @PostMapping(value={"/timing/insertRecord"})
    @ApiOperation(value="\u5b9a\u65f6\u67e5\u8be2\u5934\u4e00\u5929\u665a\u4e0a\u7684\u5c31\u8bca\u8bb0\u5f55\uff0c\u63d2\u5165\u4e4b\u4e91HIS\u6570\u636e\u5e93\uff08\u6bcf\u5929\u51cc\u66681\u70b9\u8c03\u7528\uff09")
    public ResponseData timingInsertRecords(@RequestBody List<OrdSeeDoctorRecordEntity> list) {
        this.outpatientHistoryService.timingInsertRecord(list);
        return ResponseData.success();
    }

    @PostMapping(value={"/importExcel"})
    @Transactional(rollbackFor={Exception.class})
    @ApiOperation(value="\u7528\u6237\u5bfc\u5165Excel", httpMethod="POST", notes="\u7528\u6237\u5bfc\u5165Excel")
    public ResponseData importExcel(@RequestPart(value="file") MultipartFile file) throws IOException {
        List list = EasyExcelUtil.importExcel((MultipartFile)file, (Object)new HistoryImportVo(), (Object)new HistoryListener());
        List outpatientHistoryEntities = BeanUtil.copyList((List)list, OutpatientHistoryEntity.class);
        boolean b = this.outpatientHistoryService.saveBatch((Collection)outpatientHistoryEntities);
        return ResponseData.success((Object)b);
    }

    @PostMapping(value={"/importPatientExcel"})
    @Transactional(rollbackFor={Exception.class})
    @ApiOperation(value="\u5bfc\u5165\u60a3\u8005\u6863\u6848", httpMethod="POST", notes="\u5bfc\u5165\u60a3\u8005\u6863\u6848")
    public ResponseData importPatientExcel(@RequestPart(value="file") MultipartFile file) throws IOException {
        Integer tenant = this.commonRequest.getTenant();
        List importVos = EasyExcelUtil.importExcel((MultipartFile)file, (Object)new PatientImportVo(), (Object)new PatientListener());
        List patientList = BeanUtil.copyList((List)importVos, PatientEntity.class);
        patientList.forEach(item -> item.setTenantId(tenant));
        return this.patientService.insertImport(patientList);
    }

    public OutpatientHistoryController(OutpatientHistoryService outpatientHistoryService, CommonRequest commonRequest) {
        this.outpatientHistoryService = outpatientHistoryService;
        this.commonRequest = commonRequest;
    }
}

