/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.SimpleColumnWidthStyleStrategy;
import com.alibaba.excel.write.style.row.SimpleRowHeightStyleStrategy;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.dto.DoctorInfo;
import com.byh.outpatient.api.dto.QueryScheduleRecordDto;
import com.byh.outpatient.api.dto.ScheduleDetail;
import com.byh.outpatient.api.dto.admission.QueryReadyVisitDto;
import com.byh.outpatient.api.dto.schdule.ExportRecordDto;
import com.byh.outpatient.api.dto.schdule.ImportRecordDto;
import com.byh.outpatient.api.dto.schdule.SchduleTimeRangeDto;
import com.byh.outpatient.api.dto.schdule.ScheduleRecordDto;
import com.byh.outpatient.api.dto.schedule.DateTimeDto;
import com.byh.outpatient.api.dto.schedule.QueryRecordDto;
import com.byh.outpatient.api.dto.schedule.RegRecordDto;
import com.byh.outpatient.api.enums.DoctorOutpatientTypeEnum;
import com.byh.outpatient.api.enums.OutRegTypeEnum;
import com.byh.outpatient.api.enums.ScheduleStatusEnum;
import com.byh.outpatient.api.enums.ScheduleTimeRangeEnum;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.model.BaseEntity;
import com.byh.outpatient.api.model.doctorRegFee.OutDoctorRegfeeEntity;
import com.byh.outpatient.api.model.outpatienType.OutpatientTypeEntity;
import com.byh.outpatient.api.model.reservation.ReservationEntity;
import com.byh.outpatient.api.model.schedule.ScheduleRecordDetailEntity;
import com.byh.outpatient.api.model.schedule.ScheduleRecordEntity;
import com.byh.outpatient.api.util.DateUtils;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.PaginationHelper;
import com.byh.outpatient.api.util.RandomCodeUtils;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.admission.QueryReadyVisitVo;
import com.byh.outpatient.api.vo.schedule.DateScheduleRecordVo;
import com.byh.outpatient.api.vo.schedule.DeptVo;
import com.byh.outpatient.api.vo.schedule.DoctorTypeVo;
import com.byh.outpatient.api.vo.schedule.DoctorVo;
import com.byh.outpatient.api.vo.schedule.OutpatientTypeVo;
import com.byh.outpatient.api.vo.schedule.QueryRecordVo;
import com.byh.outpatient.api.vo.schedule.QueryScheduleRecordVo;
import com.byh.outpatient.api.vo.schedule.RegRecordVo;
import com.byh.outpatient.api.vo.schedule.ScheduleRecordVo;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutDoctorRegFeeMapper;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.data.repository.OutpatientTypeMapper;
import com.byh.outpatient.data.repository.ReservationMapper;
import com.byh.outpatient.data.repository.ScheduleRecordDetailMapper;
import com.byh.outpatient.data.repository.ScheduleRecordMapper;
import com.byh.outpatient.web.service.OutpatientTypeService;
import com.byh.outpatient.web.service.ScheduleService;
import com.byh.outpatient.web.service.impl.ScheduleServiceImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Resource
    private ScheduleRecordMapper scheduleRecordMapper;
    @Resource
    private ScheduleRecordDetailMapper scheduleRecordDetailMapper;
    @Resource
    private OutpatientTypeService outpatientTypeService;
    @Resource
    private ReservationMapper reservationMapper;
    @Resource
    private OutDoctorRegFeeMapper outDoctorRegFeeMapper;
    @Resource
    private OutpatientTypeMapper outpatientTypeMapper;
    @Resource
    private AdmissionMapper admissionMapper;
    @Resource
    private OutOrderMapper outOrderMapper;

    public void downLoadRecord(HttpServletResponse response, ExportRecordDto dto) {
        Integer tenantId = dto.getTenantId();
        String startDate = dto.getStartDate();
        String endDate = dto.getEndDate();
        List scheduleRecordList = this.scheduleRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().between(ScheduleRecordEntity::getScheduleDate, (Object)startDate, (Object)endDate)).ne(ScheduleRecordEntity::getStatus, (Object)"0")).orderByAsc(ScheduleRecordEntity::getScheduleDate));
        if (!scheduleRecordList.isEmpty()) {
            Iterator iterator;
            Map scheduleRecordMap = scheduleRecordList.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getScheduleDate, LinkedHashMap::new, Collectors.groupingBy(ScheduleRecordEntity::getDoctorId, LinkedHashMap::new, Collectors.collectingAndThen(Collectors.toList(), list -> (ScheduleRecordEntity)list.get(0)))));
            List doctorIds = scheduleRecordList.stream().map(ScheduleRecordEntity::getDoctorId).distinct().collect(Collectors.toList());
            List doctorList = this.scheduleRecordMapper.selectDoctorListByDoctorIds(doctorIds, "2");
            Map<String, List<DoctorVo>> doctorMap = doctorList.stream().collect(Collectors.groupingBy(vo -> {
                String position = vo.getDoctorPosition();
                return StrUtil.isEmpty((CharSequence)position) ? "\u79bb\u804c" : position;
            }));
            ArrayList dataList = new ArrayList();
            Integer count = 0;
            for (Map.Entry<String, List<DoctorVo>> entry : doctorMap.entrySet()) {
                Object vo222;
                if (count > 0) {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    map.put("\u7c7b\u578b", null);
                    map.put("\u7f16\u53f7", null);
                    map.put("\u59d3\u540d", null);
                    for (Map.Entry entries : scheduleRecordMap.entrySet()) {
                        String dateStr = (String)entries.getKey();
                        map.put(dateStr, null);
                    }
                    dataList.add(map);
                }
                List<DoctorVo> doctorVos = entry.getValue();
                for (Object vo222 : doctorVos) {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    map.put("\u7c7b\u578b", StrUtil.isEmpty((CharSequence)vo222.getDoctorPosition()) ? "\u79bb\u804c" : vo222.getDoctorPosition());
                    map.put("\u7f16\u53f7", vo222.getDoctorId());
                    map.put("\u59d3\u540d", vo222.getDoctorName());
                    for (Map.Entry entries : scheduleRecordMap.entrySet()) {
                        String dateStr = (String)entries.getKey();
                        Map recordMap2 = (Map)entries.getValue();
                        ScheduleRecordEntity scheduleRecordEntity = (ScheduleRecordEntity)recordMap2.get(vo222.getDoctorId());
                        if (scheduleRecordEntity != null) {
                            String scheduleTimeRange = scheduleRecordEntity.getScheduleTimeRange();
                            String scheduleTimeRangeLabel = Optional.ofNullable(ScheduleTimeRangeEnum.getEnumLabel((String)scheduleTimeRange)).map(ScheduleTimeRangeEnum::getLabel).orElse("\u7f16\u7801\u5f02\u5e38");
                            map.put(dateStr, scheduleTimeRangeLabel);
                            continue;
                        }
                        map.put(dateStr, "\u4e00");
                    }
                    dataList.add(map);
                }
                iterator = count;
                count = count + 1;
                vo222 = count;
            }
            SimpleRowHeightStyleStrategy rowHeightStyleStrategy = new SimpleRowHeightStyleStrategy(Short.valueOf((short)30), Short.valueOf((short)20));
            SimpleColumnWidthStyleStrategy simpleColumnWidthStyleStrategy = new SimpleColumnWidthStyleStrategy(Integer.valueOf(26));
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                iterator = null;
                try {
                    try (ExcelWriter excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)bos).registerWriteHandler((WriteHandler)simpleColumnWidthStyleStrategy)).registerWriteHandler((WriteHandler)rowHeightStyleStrategy)).registerWriteHandler((WriteHandler)this.createCellStyleStrategy())).build();){
                        ArrayList head = new ArrayList();
                        if (!dataList.isEmpty()) {
                            String headInfo = dto.getStartDate() + " \u81f3 " + dto.getEndDate() + " \u533b\u751f\u6392\u73ed\u4fe1\u606f";
                            Integer headCount = 0;
                            Map firstRow = (Map)dataList.get(0);
                            for (String key : firstRow.keySet()) {
                                ArrayList<String> headColumn = new ArrayList<String>();
                                headColumn.add(headInfo);
                                String headStr = "";
                                if (headCount == 0) {
                                    headStr = "\u5907\u6ce8";
                                    Integer n = headCount;
                                    Integer n2 = headCount = Integer.valueOf(headCount + 1);
                                } else {
                                    headStr = "\u4e0a\u5348\uff0808:00-12:00\uff09\u3001\u4e0b\u5348\uff0814:00-17:30\uff09\u3001\u884c\uff0808:00-17:30 \uff5c 12:00-14:00\u4f11\u606f\uff09\u3001\u884c\u4e2d\uff0809:30-17:30 \uff5c 11:30-12:00\u4f11\u606f\uff09\u3001\u4e2d\u73ed\uff0809:30-14:00\uff09\u3001\u884c\u65e9\uff0808:00-16:00 \uff5c 11:30-12:00\u4f11\u606f\uff09\u3001\u4e00\uff08\u4f11\u606f\uff09\u3001\u5907\u73ed\uff08\u533b\u751f\u4eba\u6570\u4e0d\u591f\uff0c\u5907\u7528\uff09";
                                }
                                headColumn.add(headStr);
                                String weekStr = Optional.ofNullable(scheduleRecordMap.get(key)).flatMap(recordMap -> recordMap.values().stream().findFirst()).map(ScheduleRecordEntity::getWeek).orElse(null);
                                if (StrUtil.isNotEmpty((CharSequence)weekStr)) {
                                    String keyValue = key;
                                    key = weekStr;
                                    weekStr = keyValue;
                                    headColumn.add(weekStr);
                                }
                                headColumn.add(key);
                                head.add(headColumn);
                            }
                        }
                        WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)"\u533b\u751f\u6392\u73ed\u4fe1\u606f").head(head)).build();
                        ArrayList data = new ArrayList();
                        for (LinkedHashMap linkedHashMap : dataList) {
                            ArrayList rowData = new ArrayList();
                            for (String key : linkedHashMap.keySet()) {
                                rowData.add(linkedHashMap.get(key));
                            }
                            data.add(rowData);
                        }
                        excelWriter.write(data, writeSheet);
                        excelWriter.finish();
                    }
                    var18_21 = null;
                    try (XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new ByteArrayInputStream(bos.toByteArray()));){
                        String excelName = dto.getStartDate() + " \u81f3 " + dto.getEndDate() + " \u533b\u751f\u6392\u73ed\u4fe1\u606f";
                        String fileName = URLEncoder.encode(excelName, "UTF-8").replaceAll("\\+", "%20");
                        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                        response.setCharacterEncoding("utf-8");
                        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
                        workbook.write((OutputStream)response.getOutputStream());
                    }
                    catch (Throwable throwable) {
                        var18_21 = throwable;
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    iterator = throwable;
                    throw throwable;
                }
                finally {
                    if (bos != null) {
                        if (iterator != null) {
                            try {
                                bos.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)((Object)iterator)).addSuppressed(throwable);
                            }
                        } else {
                            bos.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
            }
        }
    }

    public List<RegRecordVo> selectListByHis(RegRecordDto dto) {
        Integer tenantId = dto.getTenantId();
        DateTimeDto dateTimeDto = this.getDateTime();
        String todayStr = dateTimeDto.getSearchDate();
        String nowStr = dateTimeDto.getSearchTime();
        dto.setSearchDate(todayStr);
        dto.setSearchTime(nowStr);
        List list = this.scheduleRecordMapper.selectListByHis(dto);
        if (!list.isEmpty()) {
            List doctorIds = list.stream().map(RegRecordVo::getDoctorId).distinct().collect(Collectors.toList());
            DoctorTypeVo typeVo = this.getRegFeeAndTypeList(tenantId, doctorIds, todayStr);
            Map regFeeMap = typeVo.getRegFeeMap();
            Map typeMap = typeVo.getTypeMap();
            Map admissionMap = typeVo.getAdmissionMap();
            for (RegRecordVo vo : list) {
                List regFeeList = regFeeMap.getOrDefault(vo.getDoctorId(), new ArrayList());
                ArrayList<OutpatientTypeVo> typeList = new ArrayList<OutpatientTypeVo>();
                Integer readyVisitCount = admissionMap.getOrDefault(vo.getDoctorId(), 0);
                vo.setReadyVisitCount(readyVisitCount);
                for (OutDoctorRegfeeEntity regFee : regFeeList) {
                    String outpatientTypeName;
                    OutpatientTypeEntity typeEntity = (OutpatientTypeEntity)typeMap.get(regFee.getOutpatientTypeId());
                    if (typeEntity == null) continue;
                    OutpatientTypeVo outpatientTypeVo = new OutpatientTypeVo();
                    BigDecimal doctorRegFee = typeEntity.getRegFee();
                    outpatientTypeVo.setRegFee(doctorRegFee);
                    outpatientTypeVo.setOutpatientType(typeEntity.getOutpatientType());
                    if (DoctorOutpatientTypeEnum.FIRST_TUMOR.getValue().equals(regFee.getVisitFlag())) {
                        outpatientTypeName = DoctorOutpatientTypeEnum.FIRST_TUMOR.getLabel() + typeEntity.getOutpatientTypeName() + "\uff08 " + doctorRegFee.stripTrailingZeros().toPlainString() + " \u5143\uff09";
                        outpatientTypeVo.setOutpatientTypeName(outpatientTypeName);
                        typeList.add(outpatientTypeVo);
                        continue;
                    }
                    if (DoctorOutpatientTypeEnum.FIRST_CHRONIC.getValue().equals(regFee.getVisitFlag())) {
                        outpatientTypeName = DoctorOutpatientTypeEnum.FIRST_CHRONIC.getLabel() + typeEntity.getOutpatientTypeName() + "\uff08 " + doctorRegFee.stripTrailingZeros().toPlainString() + " \u5143\uff09";
                        outpatientTypeVo.setOutpatientTypeName(outpatientTypeName);
                        typeList.add(outpatientTypeVo);
                        continue;
                    }
                    if (!DoctorOutpatientTypeEnum.REPEAT_FLAG.getValue().equals(regFee.getVisitFlag())) continue;
                    outpatientTypeName = "\uff08" + DoctorOutpatientTypeEnum.REPEAT_FLAG.getLabel() + "\uff09" + typeEntity.getOutpatientTypeName() + "\uff08 " + doctorRegFee.stripTrailingZeros().toPlainString() + " \u5143\uff09";
                    outpatientTypeVo.setOutpatientTypeName(outpatientTypeName);
                    typeList.add(outpatientTypeVo);
                }
                vo.setTypeList(typeList);
            }
        }
        return list;
    }

    private DateTimeDto getDateTime() {
        DateTimeDto dateTimeDto = new DateTimeDto();
        LocalDate today = LocalDate.now();
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String todayStr = today.format(dateFormatter);
        dateTimeDto.setSearchDate(todayStr);
        LocalTime now = LocalTime.now();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
        String nowStr = now.format(timeFormatter);
        dateTimeDto.setSearchTime(nowStr);
        return dateTimeDto;
    }

    private DoctorTypeVo getRegFeeAndTypeList(Integer tenantId, List<Integer> doctorIds, String todayStr) {
        DoctorTypeVo typeVo = new DoctorTypeVo();
        LambdaQueryWrapper doctorRegFeeWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(tenantId != null, OutDoctorRegfeeEntity::getTenantId, (Object)tenantId)).in(OutDoctorRegfeeEntity::getDoctorId, doctorIds);
        List doctorRegFeeList = this.outDoctorRegFeeMapper.selectList((Wrapper)doctorRegFeeWrapper);
        Map<Integer, List<OutDoctorRegfeeEntity>> regFeeMap = doctorRegFeeList.stream().collect(Collectors.groupingBy(OutDoctorRegfeeEntity::getDoctorId));
        typeVo.setRegFeeMap(regFeeMap);
        List outpatientTypeIds = doctorRegFeeList.stream().map(OutDoctorRegfeeEntity::getOutpatientTypeId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper outpatientTypeWrpper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(tenantId != null, OutpatientTypeEntity::getTenantId, (Object)tenantId)).eq(OutpatientTypeEntity::getStatus, (Object)"1")).in(BaseEntity::getId, outpatientTypeIds);
        List typeList = this.outpatientTypeMapper.selectList((Wrapper)outpatientTypeWrpper);
        Map typeMap = typeList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        typeVo.setTypeMap(typeMap);
        QueryReadyVisitDto dto = new QueryReadyVisitDto();
        dto.setTenantId(tenantId);
        dto.setStartDate(todayStr);
        dto.setEndDate(todayStr);
        dto.setDoctorIds(doctorIds);
        List readyVisitVos = this.admissionMapper.selectReadyVisitList(dto);
        Map<Integer, Integer> admissionMap = readyVisitVos.stream().collect(Collectors.toMap(QueryReadyVisitVo::getDoctorId, QueryReadyVisitVo::getReadyVisitCount));
        typeVo.setAdmissionMap(admissionMap);
        return typeVo;
    }

    public List<QueryRecordVo> selectListBySelf(QueryRecordDto dto) {
        Integer tenantId = dto.getTenantId();
        DateTimeDto dateTimeDto = this.getDateTime();
        String todayStr = dateTimeDto.getSearchDate();
        String nowStr = dateTimeDto.getSearchTime();
        dto.setSearchDate(todayStr);
        dto.setSearchTime(nowStr);
        List list = this.scheduleRecordMapper.selectListBySelf(dto);
        if (!list.isEmpty()) {
            List doctorIds = list.stream().map(QueryRecordVo::getDoctorId).distinct().collect(Collectors.toList());
            DoctorTypeVo doctorTypeVo = this.getRegFeeAndTypeList(tenantId, doctorIds, todayStr);
            Map regFeeMap = doctorTypeVo.getRegFeeMap();
            Map typeMap = doctorTypeVo.getTypeMap();
            Map admissionMap = doctorTypeVo.getAdmissionMap();
            for (QueryRecordVo vo : list) {
                List feeList = regFeeMap.getOrDefault(vo.getDoctorId(), new ArrayList());
                Integer readyVisitCount = admissionMap.getOrDefault(vo.getDoctorId(), 0);
                vo.setReadyVisitCount(readyVisitCount);
                for (OutDoctorRegfeeEntity fee : feeList) {
                    OutpatientTypeEntity typeEntity = (OutpatientTypeEntity)typeMap.get(fee.getOutpatientTypeId());
                    if (typeEntity == null) continue;
                    String outpatientTypeCode = typeEntity.getOutpatientType();
                    String outpatientTypeName = typeEntity.getOutpatientTypeName();
                    String regTypeCode = typeEntity.getRegType();
                    String regTypeName = OutRegTypeEnum.getEnumLabel((String)regTypeCode);
                    BigDecimal regFee = typeEntity.getRegFee();
                    if (DoctorOutpatientTypeEnum.FIRST_TUMOR.getValue().equals(fee.getVisitFlag())) {
                        vo.setFirstTumorTypeCode(outpatientTypeCode);
                        vo.setFirstTumorTypeName(outpatientTypeName);
                        vo.setFirstTumorRegTypeCode(regTypeCode);
                        vo.setFirstTumorRegTypeName(regTypeName);
                        vo.setFirstTumorFee(regFee);
                        continue;
                    }
                    if (DoctorOutpatientTypeEnum.FIRST_CHRONIC.getValue().equals(fee.getVisitFlag())) {
                        vo.setFirstChronicTypeCode(outpatientTypeCode);
                        vo.setFirstChronicTypeName(outpatientTypeName);
                        vo.setFirstChronicRegTypeCode(regTypeCode);
                        vo.setFirstChronicRegTypeName(regTypeName);
                        vo.setFirstChronicFee(regFee);
                        continue;
                    }
                    if (!DoctorOutpatientTypeEnum.REPEAT_FLAG.getValue().equals(fee.getVisitFlag())) continue;
                    vo.setRepeatTypeCode(outpatientTypeCode);
                    vo.setRepeatTypeName(outpatientTypeName);
                    vo.setRepeatRegTypeCode(regTypeCode);
                    vo.setRepeatRegTypeName(regTypeName);
                    vo.setRepeatFee(regFee);
                }
            }
        }
        return list;
    }

    public List<QueryRecordVo> selectListByHy(QueryRecordDto dto) {
        Integer tenantId = dto.getTenantId();
        List list = this.scheduleRecordMapper.selectListBySelf(dto);
        if (!list.isEmpty()) {
            List doctorIds = list.stream().map(QueryRecordVo::getDoctorId).distinct().collect(Collectors.toList());
            DoctorTypeVo doctorTypeVo = this.getRegFeeAndTypeList(tenantId, doctorIds, dto.getSearchDate());
            Map regFeeMap = doctorTypeVo.getRegFeeMap();
            Map typeMap = doctorTypeVo.getTypeMap();
            Map admissionMap = doctorTypeVo.getAdmissionMap();
            for (QueryRecordVo vo : list) {
                List feeList = regFeeMap.getOrDefault(vo.getDoctorId(), new ArrayList());
                Integer readyVisitCount = admissionMap.getOrDefault(vo.getDoctorId(), 0);
                vo.setReadyVisitCount(readyVisitCount);
                for (OutDoctorRegfeeEntity fee : feeList) {
                    OutpatientTypeEntity typeEntity = (OutpatientTypeEntity)typeMap.get(fee.getOutpatientTypeId());
                    if (typeEntity == null) continue;
                    String outpatientTypeCode = typeEntity.getOutpatientType();
                    String outpatientTypeName = typeEntity.getOutpatientTypeName();
                    String regTypeCode = typeEntity.getRegType();
                    String regTypeName = OutRegTypeEnum.getEnumLabel((String)regTypeCode);
                    BigDecimal regFee = typeEntity.getRegFee();
                    if (DoctorOutpatientTypeEnum.FIRST_TUMOR.getValue().equals(fee.getVisitFlag())) {
                        vo.setFirstTumorTypeCode(outpatientTypeCode);
                        vo.setFirstTumorTypeName(outpatientTypeName);
                        vo.setFirstTumorRegTypeCode(regTypeCode);
                        vo.setFirstTumorRegTypeName(regTypeName);
                        vo.setFirstTumorFee(regFee);
                        continue;
                    }
                    if (DoctorOutpatientTypeEnum.FIRST_CHRONIC.getValue().equals(fee.getVisitFlag())) {
                        vo.setFirstChronicTypeCode(outpatientTypeCode);
                        vo.setFirstChronicTypeName(outpatientTypeName);
                        vo.setFirstChronicRegTypeCode(regTypeCode);
                        vo.setFirstChronicRegTypeName(regTypeName);
                        vo.setFirstChronicFee(regFee);
                        continue;
                    }
                    if (!DoctorOutpatientTypeEnum.REPEAT_FLAG.getValue().equals(fee.getVisitFlag())) continue;
                    vo.setRepeatTypeCode(outpatientTypeCode);
                    vo.setRepeatTypeName(outpatientTypeName);
                    vo.setRepeatRegTypeCode(regTypeCode);
                    vo.setRepeatRegTypeName(regTypeName);
                    vo.setRepeatFee(regFee);
                }
            }
        }
        return list;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void delete(ScheduleRecordEntity entity) {
        if (entity.getId() == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5220\u9664\u6392\u73ed\u4fe1\u606f\u65f6\uff0c\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getId, (Object)entity.getId());
        ScheduleRecordEntity scheduleRecord = (ScheduleRecordEntity)this.scheduleRecordMapper.selectOne((Wrapper)queryWrapper);
        this.scheduleRecordMapper.delete((Wrapper)queryWrapper);
        this.scheduleRecordDetailMapper.deleteByScheduleCodes(Collections.singletonList(scheduleRecord.getScheduleCode()), scheduleRecord.getTenantId(), scheduleRecord.getStatus());
    }

    public void exportRecordTemplate(HttpServletResponse response, ExportRecordDto dto) {
        Integer tenantId = dto.getTenantId();
        List deptList = this.scheduleRecordMapper.selectDeptListByType("0", tenantId);
        if (!deptList.isEmpty()) {
            Iterator iterator;
            String startDate = dto.getStartDate();
            String endDate = dto.getEndDate();
            LinkedHashMap<String, String> dateMap = new LinkedHashMap<String, String>();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate start = LocalDate.parse(startDate, formatter);
            LocalDate end = LocalDate.parse(endDate, formatter);
            while (!start.isAfter(end)) {
                DayOfWeek dayOfWeek = start.getDayOfWeek();
                String dateStr = start.format(formatter);
                dateMap.put(dateStr, this.convertDayOfWeekToChinese(dayOfWeek));
                start = start.plusDays(1L);
            }
            List deptIds = deptList.stream().map(DeptVo::getId).collect(Collectors.toList());
            List doctorList = this.scheduleRecordMapper.selectDoctorListByDeptIds(deptIds, "2", tenantId);
            Map doctorMap = doctorList.stream().collect(Collectors.groupingBy(DoctorVo::getDoctorPosition, LinkedHashMap::new, Collectors.toList()));
            ArrayList dataList = new ArrayList();
            Integer count = 0;
            for (Map.Entry entry : doctorMap.entrySet()) {
                Object vo22;
                if (count > 0) {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    map.put("\u7c7b\u578b", null);
                    map.put("\u7f16\u53f7", null);
                    map.put("\u59d3\u540d", null);
                    for (Map.Entry entries : dateMap.entrySet()) {
                        String dateStr = (String)entries.getKey();
                        map.put(dateStr, null);
                    }
                    dataList.add(map);
                }
                List doctorVos = (List)entry.getValue();
                for (Object vo22 : doctorVos) {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    map.put("\u7c7b\u578b", vo22.getDoctorPosition());
                    map.put("\u7f16\u53f7", vo22.getDoctorId());
                    map.put("\u59d3\u540d", vo22.getDoctorName());
                    for (Map.Entry entries : dateMap.entrySet()) {
                        String dateStr = (String)entries.getKey();
                        map.put(dateStr, "\u4e00");
                    }
                    dataList.add(map);
                }
                iterator = count;
                count = count + 1;
                vo22 = count;
            }
            SimpleRowHeightStyleStrategy rowHeightStyleStrategy = new SimpleRowHeightStyleStrategy(Short.valueOf((short)30), Short.valueOf((short)20));
            SimpleColumnWidthStyleStrategy simpleColumnWidthStyleStrategy = new SimpleColumnWidthStyleStrategy(Integer.valueOf(26));
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                iterator = null;
                try {
                    try (ExcelWriter excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)bos).registerWriteHandler((WriteHandler)simpleColumnWidthStyleStrategy)).registerWriteHandler((WriteHandler)rowHeightStyleStrategy)).registerWriteHandler((WriteHandler)this.createCellStyleStrategy())).build();){
                        ArrayList<Object> head = new ArrayList<Object>();
                        if (!dataList.isEmpty()) {
                            String headInfo = dto.getStartDate() + " \u81f3 " + dto.getEndDate() + " \u533b\u751f\u6392\u73ed\u4fe1\u606f";
                            Integer headCount = 0;
                            Map firstRow = (Map)dataList.get(0);
                            for (String key : firstRow.keySet()) {
                                ArrayList headColumn = new ArrayList();
                                headColumn.add(headInfo);
                                String headStr = "";
                                if (headCount == 0) {
                                    headStr = "\u5907\u6ce8";
                                    Integer n = headCount;
                                    Integer n2 = headCount = Integer.valueOf(headCount + 1);
                                } else {
                                    headStr = "\u4e0a\u5348\uff0808:00-12:00\uff09\u3001\u4e0b\u5348\uff0814:00-17:30\uff09\u3001\u884c\uff0808:00-17:30 \uff5c 12:00-14:00\u4f11\u606f\uff09\u3001\u884c\u4e2d\uff0809:30-17:30 \uff5c 11:30-12:00\u4f11\u606f\uff09\u3001\u4e2d\u73ed\uff0809:30-14:00\uff09\u3001\u884c\u65e9\uff0808:00-16:00 \uff5c 11:30-12:00\u4f11\u606f\uff09\u3001\u4e00\uff08\u4f11\u606f\uff09\u3001\u5907\u73ed\uff08\u533b\u751f\u4eba\u6570\u4e0d\u591f\uff0c\u5907\u7528\uff09";
                                }
                                headColumn.add(headStr);
                                String weekStr = (String)dateMap.get(key);
                                if (StrUtil.isNotEmpty((CharSequence)weekStr)) {
                                    String keyValue = key;
                                    key = weekStr;
                                    weekStr = keyValue;
                                    headColumn.add(weekStr);
                                }
                                headColumn.add(key);
                                head.add(headColumn);
                            }
                        }
                        WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)"\u533b\u751f\u6392\u73ed\u4fe1\u606f").head(head)).build();
                        ArrayList data = new ArrayList();
                        for (LinkedHashMap linkedHashMap : dataList) {
                            ArrayList rowData = new ArrayList();
                            for (String key : linkedHashMap.keySet()) {
                                rowData.add(linkedHashMap.get(key));
                            }
                            data.add(rowData);
                        }
                        excelWriter.write(data, writeSheet);
                        excelWriter.finish();
                    }
                    var21_24 = null;
                    try (XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new ByteArrayInputStream(bos.toByteArray()));){
                        Sheet sheet = workbook.getSheetAt(0);
                        String[] allowedValues = new String[]{"\u4e0a\u5348", "\u4e0b\u5348", "\u884c", "\u884c\u4e2d", "\u884c\u65e9", "\u4e00", "\u5907\u73ed"};
                        DataValidationHelper helper = sheet.getDataValidationHelper();
                        DataValidationConstraint constraint = helper.createExplicitListConstraint(allowedValues);
                        CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(4, dataList.size() + 3, 3, dateMap.size() + 2);
                        DataValidation dataValidation = helper.createValidation(constraint, cellRangeAddressList);
                        sheet.addValidationData(dataValidation);
                        String excelName = dto.getStartDate() + " \u81f3 " + dto.getEndDate() + " \u533b\u751f\u6392\u73ed\u4fe1\u606f";
                        String fileName = URLEncoder.encode(excelName, "UTF-8").replaceAll("\\+", "%20");
                        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                        response.setCharacterEncoding("utf-8");
                        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
                        workbook.write((OutputStream)response.getOutputStream());
                    }
                    catch (Throwable throwable) {
                        var21_24 = throwable;
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    iterator = throwable;
                    throw throwable;
                }
                finally {
                    if (bos != null) {
                        if (iterator != null) {
                            try {
                                bos.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)((Object)iterator)).addSuppressed(throwable);
                            }
                        } else {
                            bos.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
            }
        }
    }

    private HorizontalCellStyleStrategy createCellStyleStrategy() {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        headWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        headWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        headWriteCellStyle.setBorderRight(BorderStyle.THIN);
        headWriteCellStyle.setBorderTop(BorderStyle.THIN);
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
        headWriteCellStyle.setWriteFont(headWriteFont);
        headWriteCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
        headWriteCellStyle.setFillForegroundColor(Short.valueOf((short)40));
        headWriteCellStyle.setWrapped(Boolean.valueOf(true));
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        contentWriteCellStyle.setWrapped(Boolean.valueOf(true));
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }

    private String convertDayOfWeekToChinese(DayOfWeek dayOfWeek) {
        switch (1.$SwitchMap$java$time$DayOfWeek[dayOfWeek.ordinal()]) {
            case 1: {
                return "\u5468\u4e00";
            }
            case 2: {
                return "\u5468\u4e8c";
            }
            case 3: {
                return "\u5468\u4e09";
            }
            case 4: {
                return "\u5468\u56db";
            }
            case 5: {
                return "\u5468\u4e94";
            }
            case 6: {
                return "\u5468\u516d";
            }
            case 7: {
                return "\u5468\u65e5";
            }
        }
        return "";
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void importRecord(MultipartFile file, Integer tenantId, Integer operatorId, String operatorName) {
        try {
            Object weekValue;
            InputStream inputStream = file.getInputStream();
            XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
            XSSFSheet sheet = workbook.getSheetAt(0);
            List deptList = this.scheduleRecordMapper.selectDeptListByType("0", tenantId);
            List deptIds = deptList.stream().map(DeptVo::getId).collect(Collectors.toList());
            List doctorList = this.scheduleRecordMapper.selectDoctorListByDeptIds(deptIds, "1", tenantId);
            Map doctorMap = doctorList.stream().collect(Collectors.toMap(DoctorVo::getDoctorId, Function.identity()));
            Map<Integer, String> deptMap = deptList.stream().collect(Collectors.toMap(DeptVo::getId, DeptVo::getDepartmentName));
            Integer count = 0;
            Integer dateCount = 0;
            LinkedHashMap<String, String> dateMap = new LinkedHashMap<String, String>();
            XSSFRow dateRow = sheet.getRow(2);
            XSSFRow weekRow = sheet.getRow(3);
            Integer cellCount = dateRow.getPhysicalNumberOfCells();
            for (int i = 0; i < cellCount; ++i) {
                if (dateCount <= 2) {
                    Integer n = dateCount;
                    Integer n2 = dateCount = Integer.valueOf(dateCount + 1);
                    continue;
                }
                Cell dateCell = dateRow.getCell(i);
                Iterator weekCell = weekRow.getCell(i);
                String dateValue = this.getCellValue(dateCell);
                weekValue = this.getCellValue((Cell)weekCell);
                dateMap.put(dateValue, (String)weekValue);
            }
            ArrayList<ImportRecordDto> importList = new ArrayList<ImportRecordDto>();
            ArrayList<String> errorNameList = new ArrayList<String>();
            for (Row row : sheet) {
                if (count <= 3) {
                    weekValue = count;
                    Integer n = count = Integer.valueOf(count + 1);
                    continue;
                }
                String doctorName = row.getCell(2).getStringCellValue();
                if (StrUtil.isEmpty((CharSequence)doctorName)) continue;
                ImportRecordDto importDto = new ImportRecordDto();
                LinkedHashMap<String, String> recordMap = new LinkedHashMap<String, String>();
                Integer targetIndex = 0;
                Integer cellNum = row.getPhysicalNumberOfCells();
                block4: for (int i = 0; i < cellNum; ++i) {
                    if (i == 0) {
                        String typeName = row.getCell(i).getStringCellValue();
                        importDto.setTypeName(typeName);
                        continue;
                    }
                    if (i == 1) {
                        Integer doctorId = (int)row.getCell(i).getNumericCellValue();
                        DoctorVo doctorVo = (DoctorVo)doctorMap.get(doctorId);
                        if (doctorVo == null) {
                            errorNameList.add(doctorName);
                        }
                        importDto.setDoctorId(doctorId);
                        continue;
                    }
                    if (i == 2) {
                        importDto.setDoctorName(doctorName);
                        continue;
                    }
                    Integer currentIndex = 0;
                    for (Map.Entry entry : dateMap.entrySet()) {
                        Object weekStr;
                        Object dateStr;
                        if (currentIndex == targetIndex) {
                            dateStr = (String)entry.getKey();
                            weekStr = (String)entry.getValue();
                            String recordInfo = row.getCell(i).getStringCellValue();
                            if (!"\u4e00".equals(recordInfo) && !"\u5907\u73ed".equals(recordInfo)) {
                                recordMap.put((String)dateStr + "|" + (String)weekStr, recordInfo);
                            }
                            Integer n = targetIndex;
                            targetIndex = targetIndex + 1;
                            Integer n3 = targetIndex;
                            continue block4;
                        }
                        dateStr = currentIndex;
                        currentIndex = currentIndex + 1;
                        weekStr = currentIndex;
                    }
                }
                if (recordMap.isEmpty()) continue;
                importDto.setRecordMap(recordMap);
                importList.add(importDto);
            }
            if (!errorNameList.isEmpty()) {
                String errorInfo = String.join((CharSequence)"\u3001", errorNameList);
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)(errorInfo + "\uff0c\u8fd9\u4e9b\u533b\u751f\u4e0d\u5b58\u5728\uff01\u8bf7\u4ed4\u7ec6\u6838\u5bf9\uff01"));
            }
            if (importList.isEmpty()) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6392\u73ed\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            String startDateStr = ((String)dateMap.keySet().iterator().next()).toString();
            String endDateStr = (String)new ArrayList(dateMap.keySet()).get(dateMap.size() - 1);
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(tenantId != null, ScheduleRecordEntity::getTenantId, (Object)tenantId)).eq(ScheduleRecordEntity::getStatus, (Object)ScheduleStatusEnum.NORMAL.getValue())).eq(BaseEntity::getRemark, (Object)"Excel\u6392\u73ed\u5bfc\u5165")).between(ScheduleRecordEntity::getScheduleDate, (Object)startDateStr, (Object)endDateStr);
            List oldList = this.scheduleRecordMapper.selectList((Wrapper)queryWrapper);
            if (!oldList.isEmpty()) {
                List scheduleCodes = oldList.stream().map(ScheduleRecordEntity::getScheduleCode).distinct().collect(Collectors.toList());
                LambdaQueryWrapper deleteWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(tenantId != null, ScheduleRecordEntity::getTenantId, (Object)tenantId)).eq(ScheduleRecordEntity::getStatus, (Object)ScheduleStatusEnum.NORMAL.getValue())).in(ScheduleRecordEntity::getScheduleCode, scheduleCodes);
                this.scheduleRecordMapper.delete((Wrapper)deleteWrapper);
                this.scheduleRecordDetailMapper.deleteByScheduleCodes(scheduleCodes, tenantId, ScheduleStatusEnum.NORMAL.getValue());
            }
            ArrayList<ScheduleRecordEntity> list = new ArrayList<ScheduleRecordEntity>();
            ArrayList<ScheduleRecordDetailEntity> detailList = new ArrayList<ScheduleRecordDetailEntity>();
            ArrayList<ScheduleRecordEntity> dbList = new ArrayList<ScheduleRecordEntity>();
            for (ImportRecordDto recordDto : importList) {
                Integer doctorId = recordDto.getDoctorId();
                String doctorName = recordDto.getDoctorName();
                DoctorVo doctorVo = (DoctorVo)doctorMap.get(doctorId);
                Integer deptId = doctorVo.getDeptId();
                String doctorTitle = doctorVo.getDoctorTitle();
                String deptName = deptMap.get(deptId);
                for (Map.Entry entry : recordDto.getRecordMap().entrySet()) {
                    boolean dbFlag = false;
                    String key = (String)entry.getKey();
                    String dateStr = key.substring(0, key.indexOf("|"));
                    String weekStr = key.substring(key.indexOf("|") + 1);
                    String timeRangeStr = (String)entry.getValue();
                    ScheduleTimeRangeEnum scheduleTimeRangeEnum = ScheduleTimeRangeEnum.getTimeRangeList((String)timeRangeStr);
                    String timeRangeValue = scheduleTimeRangeEnum.getValue();
                    List rangeList = scheduleTimeRangeEnum.getTimeRanges();
                    String startTime = ((ScheduleTimeRangeEnum.TimeRange)rangeList.get(0)).getStartTime();
                    String endTime = ((ScheduleTimeRangeEnum.TimeRange)rangeList.get(rangeList.size() - 1)).getEndTime();
                    ScheduleRecordEntity record = new ScheduleRecordEntity();
                    record.setCreateId(operatorId);
                    record.setCreateName(operatorName);
                    record.setTenantId(tenantId);
                    record.setRemark("Excel\u6392\u73ed\u5bfc\u5165");
                    record.setStatus(ScheduleStatusEnum.NORMAL.getValue());
                    String scheduleCode = dateStr + "|" + deptId + "|" + doctorId + "|T" + timeRangeValue + "|" + RandomCodeUtils.sixRandom();
                    record.setScheduleCode(scheduleCode);
                    record.setScheduleType("1");
                    record.setScheduleRange("1");
                    record.setDoctorId(doctorId);
                    record.setDoctorName(doctorName);
                    record.setDoctorTitle(doctorTitle);
                    record.setDeptId(deptId);
                    record.setDeptName(deptName);
                    record.setOutpatientType("1");
                    record.setRegType("1");
                    record.setScheduleDate(dateStr);
                    record.setWeek(weekStr);
                    record.setScheduleTimeRange(timeRangeValue);
                    record.setStartTime(startTime);
                    record.setEndTime(endTime);
                    record.setRegTotal(Integer.valueOf(999));
                    record.setAvaliable(Integer.valueOf(999));
                    ScheduleRecordEntity dbEntity = new ScheduleRecordEntity();
                    dbEntity.setTenantId(tenantId);
                    dbEntity.setDoctorId(doctorId);
                    dbEntity.setDeptId(deptId);
                    dbEntity.setScheduleDate(dateStr);
                    dbEntity.setStatus(ScheduleStatusEnum.NORMAL.getValue());
                    Integer dbCount = this.scheduleRecordMapper.checkSchedule(dbEntity);
                    if (dbCount > 0) {
                        dbFlag = true;
                        dbList.add(record);
                    }
                    if (dbFlag) continue;
                    list.add(record);
                    for (ScheduleTimeRangeEnum.TimeRange timeRange : rangeList) {
                        ScheduleRecordDetailEntity detailRecord = new ScheduleRecordDetailEntity();
                        detailRecord.setTenantId(tenantId);
                        detailRecord.setRemark("Excel\u6392\u73ed\u5bfc\u5165");
                        detailRecord.setStatus(ScheduleStatusEnum.NORMAL.getValue());
                        detailRecord.setScheduleCode(scheduleCode);
                        detailRecord.setScheduleDate(dateStr);
                        detailRecord.setScheduleTimeRange(timeRangeValue);
                        detailRecord.setStartTime(timeRange.getStartTime());
                        detailRecord.setEndTime(timeRange.getEndTime());
                        detailRecord.setTotal(Integer.valueOf(999));
                        detailRecord.setAvaliable(Integer.valueOf(999));
                        detailRecord.setStartNo(Integer.valueOf(1));
                        detailRecord.setEndNo(Integer.valueOf(999));
                        detailList.add(detailRecord);
                    }
                }
            }
            if (!dbList.isEmpty()) {
                String errorInfo = "\u4ee5\u4e0b\u533b\u751f\u5b58\u5728\u91cd\u590d\u6392\u73ed\uff1a";
                String detailErrorInfo = "";
                for (int i = 0; i < dbList.size(); ++i) {
                    String deptName = ((ScheduleRecordEntity)dbList.get(i)).getDeptName();
                    String doctorName = ((ScheduleRecordEntity)dbList.get(i)).getDoctorName();
                    String scheduleDate = ((ScheduleRecordEntity)dbList.get(i)).getScheduleDate();
                    detailErrorInfo = detailErrorInfo + (i + 1) + "\u3001" + deptName + " \u4e0b\u7684 " + doctorName + " \u5728 " + scheduleDate + " \u5b58\u5728\u91cd\u590d\u6392\u73ed\uff01";
                }
                errorInfo = errorInfo + detailErrorInfo;
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorInfo);
            }
            this.scheduleRecordMapper.insertBatch(list);
            this.scheduleRecordDetailMapper.insertBatch(detailList);
        }
        catch (Exception e) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
            this.logger.info(e.getMessage());
        }
    }

    private String getCellValue(Cell cell) {
        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
            case 1: {
                return cell.getStringCellValue();
            }
            case 2: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue().toString();
                }
                return String.valueOf(cell.getNumericCellValue());
            }
            case 3: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 4: {
                return cell.getCellFormula();
            }
            case 5: {
                return "";
            }
        }
        return "\u672a\u77e5\u7c7b\u578b";
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void insertRecord(List<ScheduleRecordDto> scheduleRecordDtoList, Integer tenantId, Integer operatorId, String operatorName) {
        ArrayList<ScheduleRecordEntity> list = new ArrayList<ScheduleRecordEntity>();
        ArrayList<ScheduleRecordDetailEntity> detailList = new ArrayList<ScheduleRecordDetailEntity>();
        for (ScheduleRecordDto dto : scheduleRecordDtoList) {
            List doctorInfos = dto.getDoctorInfos();
            for (DoctorInfo doctorInfo : doctorInfos) {
                List schduleTimeRangeDtoList = dto.getSchduleTimeRangeDtoList();
                for (SchduleTimeRangeDto schduleTimeRangeDto : schduleTimeRangeDtoList) {
                    ScheduleRecordEntity scheduleRecord = new ScheduleRecordEntity();
                    BeanUtils.copyProperties((Object)doctorInfo, (Object)scheduleRecord);
                    BeanUtils.copyProperties((Object)dto, (Object)scheduleRecord);
                    String scheduleCode = dto.getScheduleDate() + "|" + doctorInfo.getDeptId() + "|" + doctorInfo.getDoctorId() + "|T" + schduleTimeRangeDto.getScheduleTimeRange() + "|" + RandomCodeUtils.sixRandom();
                    scheduleRecord.setScheduleCode(scheduleCode);
                    scheduleRecord.setScheduleDate(dto.getScheduleDate());
                    scheduleRecord.setRegTotal(schduleTimeRangeDto.getRegTotal());
                    scheduleRecord.setAvaliable(schduleTimeRangeDto.getRegTotal());
                    scheduleRecord.setScheduleTimeRange(schduleTimeRangeDto.getScheduleTimeRange());
                    scheduleRecord.setStartTime(schduleTimeRangeDto.getStartTime());
                    scheduleRecord.setEndTime(schduleTimeRangeDto.getEndTime());
                    scheduleRecord.setScheduleInterval(schduleTimeRangeDto.getScheduleInterval());
                    scheduleRecord.setStatus(ScheduleStatusEnum.NORMAL.getValue());
                    scheduleRecord.setTenantId(tenantId);
                    scheduleRecord.setCreateId(operatorId);
                    scheduleRecord.setCreateName(operatorName);
                    Integer dbCount = this.scheduleRecordMapper.checkSchedule(scheduleRecord);
                    if (dbCount > 0) {
                        String errorInfo = scheduleRecord.getDeptName() + " \u4e0b\u7684 " + scheduleRecord.getDoctorName() + " \u5728 " + scheduleRecord.getScheduleDate() + " \u5b58\u5728\u91cd\u590d\u6392\u73ed\uff01";
                        ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorInfo);
                    }
                    list.add(scheduleRecord);
                    List scheduleDetails = schduleTimeRangeDto.getScheduleDetails();
                    for (ScheduleDetail detail : scheduleDetails) {
                        Integer totalNum = detail.getTotal();
                        ScheduleRecordDetailEntity detailEntity = new ScheduleRecordDetailEntity();
                        BeanUtils.copyProperties((Object)detail, (Object)detailEntity);
                        detailEntity.setTenantId(tenantId);
                        detailEntity.setAvaliable(totalNum);
                        detailEntity.setStartNo(Integer.valueOf(0));
                        detailEntity.setEndNo(totalNum);
                        detailEntity.setTenantId(tenantId);
                        detailEntity.setScheduleCode(scheduleCode);
                        detailEntity.setScheduleTimeRange(detail.getScheduleTimeRange());
                        detailEntity.setScheduleDate(dto.getScheduleDate());
                        detailEntity.setStatus(ScheduleStatusEnum.NORMAL.getValue());
                        detailList.add(detailEntity);
                    }
                }
            }
        }
        if (!list.isEmpty()) {
            this.scheduleRecordMapper.insertBatch(list);
            this.scheduleRecordDetailMapper.insertBatch(detailList);
        }
    }

    public ResponseData<PageResult<QueryScheduleRecordVo>> queryRecord(QueryScheduleRecordDto queryScheduleRecordDto) {
        if (Objects.isNull(queryScheduleRecordDto.getScheduleDate())) {
            queryScheduleRecordDto.setScheduleDate(DateUtils.getCurrentDate((String)"yyyy-MM-dd"));
        }
        List scheduleRecordList = this.scheduleRecordMapper.queryRecord(queryScheduleRecordDto);
        HashMap results = new HashMap();
        Map<Integer, Map<Integer, List<ScheduleRecordEntity>>> collect = scheduleRecordList.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getDoctorId, Collectors.groupingBy(ScheduleRecordEntity::getDeptId)));
        collect.forEach((key, value) -> value.forEach((key2, value2) -> results.put(new ScheduleRecordEntity(key, key2), value2)));
        ArrayList queryScheduleRecordList = new ArrayList();
        Set scheduleRecordEntities = results.keySet();
        scheduleRecordEntities.stream().forEach(scheduleRecordEntity -> {
            QueryScheduleRecordVo queryScheduleRecordVo = new QueryScheduleRecordVo();
            queryScheduleRecordVo.setDeptId(scheduleRecordEntity.getDeptId());
            queryScheduleRecordVo.setDoctorId(scheduleRecordEntity.getDoctorId());
            ArrayList scheduleRecordVos = new ArrayList();
            ((List)results.get(scheduleRecordEntity)).stream().forEach(scheduleRecord -> {
                ScheduleRecordVo scheduleRecordVo = new ScheduleRecordVo();
                BeanUtils.copyProperties((Object)scheduleRecord, (Object)scheduleRecordVo);
                queryScheduleRecordVo.setDeptName(scheduleRecord.getDeptName());
                queryScheduleRecordVo.setDoctorName(scheduleRecord.getDoctorName());
                queryScheduleRecordVo.setOutpatientType(scheduleRecord.getOutpatientType());
                ResponseData outpatientTypeEntityResponseData = this.outpatientTypeService.queryOutpatientTypeByType(scheduleRecord.getOutpatientType(), scheduleRecord.getTenantId());
                queryScheduleRecordVo.setOutpatientTypeName(((OutpatientTypeEntity)outpatientTypeEntityResponseData.getData()).getOutpatientTypeName());
                scheduleRecordVo.setRegTotal(scheduleRecord.getRegTotal());
                scheduleRecordVo.setAvaliable(scheduleRecord.getAvaliable());
                queryScheduleRecordVo.setDoctorTitle(scheduleRecord.getDoctorTitle());
                scheduleRecordVos.add(scheduleRecordVo);
            });
            Map<String, List<ScheduleRecordVo>> collectMap = scheduleRecordVos.stream().collect(Collectors.groupingBy(e -> e.getScheduleDate().toString()));
            Set<String> keys = collectMap.keySet();
            ArrayList<DateScheduleRecordVo> dateScheduleRecordVos = new ArrayList<DateScheduleRecordVo>();
            if (!Objects.isNull(queryScheduleRecordDto.getScheduleEndDate())) {
                Long aLong = DateUtils.computedDiffDays((Date)DateUtils.stringToSimpleDate((String)queryScheduleRecordDto.getScheduleDate()), (Date)DateUtils.stringToSimpleDate((String)queryScheduleRecordDto.getScheduleEndDate()));
                int i = 0;
                while ((long)i <= aLong) {
                    DateScheduleRecordVo dateScheduleRecordVo = new DateScheduleRecordVo();
                    String afterDay = DateUtils.getMoveDays((String)queryScheduleRecordDto.getScheduleDate(), (int)i, (int)1);
                    dateScheduleRecordVo.setScheduleDate(afterDay);
                    dateScheduleRecordVo.setScheduleRecordVos(collectMap.get(afterDay));
                    dateScheduleRecordVos.add(dateScheduleRecordVo);
                    ++i;
                }
            } else {
                keys.stream().forEach(key -> {
                    DateScheduleRecordVo dateScheduleRecordVo = new DateScheduleRecordVo();
                    dateScheduleRecordVo.setScheduleDate(key);
                    dateScheduleRecordVo.setScheduleRecordVos((List)collectMap.get(key));
                    dateScheduleRecordVos.add(dateScheduleRecordVo);
                });
            }
            queryScheduleRecordVo.setScheduleRecordVos(dateScheduleRecordVos);
            queryScheduleRecordList.add(queryScheduleRecordVo);
        });
        PaginationHelper paginationHelper = new PaginationHelper(queryScheduleRecordList, queryScheduleRecordDto.getSize().intValue());
        List pageList = paginationHelper.getPage(queryScheduleRecordDto.getCurrent().intValue());
        int totalPages = paginationHelper.getTotalPages();
        PageResult pageResult = new PageResult(queryScheduleRecordDto.getCurrent().intValue(), queryScheduleRecordDto.getSize().intValue());
        pageResult.setTotal(queryScheduleRecordList.size());
        pageResult.setPages(totalPages);
        pageResult.setRecords(pageList);
        pageResult.setCurrent(queryScheduleRecordDto.getCurrent().intValue());
        pageResult.setSize(queryScheduleRecordDto.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData<List<ScheduleRecordDetailEntity>> queryRecordDetail(String scheduleCode, Integer reservationId) {
        List scheduleRecordDetailEntityList = this.scheduleRecordDetailMapper.selectByscheduleCode(scheduleCode);
        if (!Objects.isNull(reservationId)) {
            ReservationEntity reservation = (ReservationEntity)this.reservationMapper.selectById((Serializable)reservationId);
            ScheduleRecordDetailEntity scheduleRecordDetailEntity = (ScheduleRecordDetailEntity)this.scheduleRecordDetailMapper.selectById((Serializable)reservation.getScheduleRecordDetailId());
            scheduleRecordDetailEntityList.add(scheduleRecordDetailEntity);
        }
        return ResponseData.success((Object)scheduleRecordDetailEntityList);
    }

    public ResponseData updateDetailStatus(Integer detailId, String status) {
        ScheduleRecordDetailEntity scheduleRecordDetailEntity = new ScheduleRecordDetailEntity();
        scheduleRecordDetailEntity.setId(detailId);
        scheduleRecordDetailEntity.setStatus(status);
        if (this.scheduleRecordDetailMapper.updateById((Object)scheduleRecordDetailEntity) > 0) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u66f4\u65b0\u72b6\u6001\u5931\u8d25\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData updateRecordStatus(Integer detailId, String status) {
        try {
            ScheduleRecordEntity scheduleRecordEntity = (ScheduleRecordEntity)this.scheduleRecordMapper.selectById((Serializable)detailId);
            if (null == scheduleRecordEntity) {
                return ResponseData.error((String)"\u6392\u73ed\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            if ("0".equals(status)) {
                // empty if block
            }
            this.scheduleRecordDetailMapper.updateStatusByscheduleCode(scheduleRecordEntity.getScheduleCode(), status);
            scheduleRecordEntity.setStatus(status);
            this.scheduleRecordMapper.updateById((Object)scheduleRecordEntity);
        }
        catch (Exception e) {
            log.info("\u4fee\u6539\u6392\u73ed\u72b6\u6001\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return ResponseData.error((String)"\u4fee\u6539\u6392\u73ed\u72b6\u6001\u5931\u8d25");
        }
        if ("3".equals(status)) {
            // empty if block
        }
        return ResponseData.success();
    }

    public ResponseData<List<QueryScheduleRecordVo>> queryRecordByDeptDoctorId(QueryScheduleRecordDto queryScheduleRecordDto) {
        if (Objects.isNull(queryScheduleRecordDto.getScheduleDate())) {
            queryScheduleRecordDto.setScheduleDate(DateUtils.getCurrentDate((String)"yyyy-MM-dd"));
        }
        queryScheduleRecordDto.setStatus("1");
        List scheduleRecordList = this.scheduleRecordMapper.queryRecord(queryScheduleRecordDto);
        HashMap results = new HashMap();
        Map<Integer, Map<String, List<ScheduleRecordEntity>>> collect = scheduleRecordList.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getDoctorId, Collectors.groupingBy(ScheduleRecordEntity::getOutpatientType)));
        collect.forEach((doctorId, value) -> value.forEach((outpatientType, value2) -> results.put(new ScheduleRecordEntity(doctorId, outpatientType), value2)));
        ArrayList queryScheduleRecordList = new ArrayList();
        Set scheduleRecordEntities = results.keySet();
        scheduleRecordEntities.stream().forEach(scheduleRecordEntity -> {
            QueryScheduleRecordVo queryScheduleRecordVo = new QueryScheduleRecordVo();
            queryScheduleRecordVo.setDeptId(scheduleRecordEntity.getDeptId());
            queryScheduleRecordVo.setDoctorId(scheduleRecordEntity.getDoctorId());
            ArrayList scheduleRecordVos = new ArrayList();
            ((List)results.get(scheduleRecordEntity)).stream().forEach(scheduleRecord -> {
                ScheduleRecordVo scheduleRecordVo = new ScheduleRecordVo();
                BeanUtils.copyProperties((Object)scheduleRecord, (Object)scheduleRecordVo);
                queryScheduleRecordVo.setDoctorName(scheduleRecord.getDoctorName());
                queryScheduleRecordVo.setOutpatientType(scheduleRecord.getOutpatientType());
                ResponseData outpatientTypeEntityResponseData = this.outpatientTypeService.queryOutpatientTypeByType(scheduleRecord.getOutpatientType(), scheduleRecord.getTenantId());
                queryScheduleRecordVo.setOutpatientTypeName(((OutpatientTypeEntity)outpatientTypeEntityResponseData.getData()).getOutpatientTypeName());
                scheduleRecordVo.setRegTotal(scheduleRecord.getRegTotal());
                scheduleRecordVo.setAvaliable(scheduleRecord.getAvaliable());
                scheduleRecordVos.add(scheduleRecordVo);
            });
            Map<String, List<ScheduleRecordVo>> collectMap = scheduleRecordVos.stream().collect(Collectors.groupingBy(e -> e.getScheduleDate()));
            Set<String> keys = collectMap.keySet();
            ArrayList<DateScheduleRecordVo> dateScheduleRecordVos = new ArrayList<DateScheduleRecordVo>();
            if (!Objects.isNull(queryScheduleRecordDto.getScheduleEndDate())) {
                Long aLong = DateUtils.computedDiffDays((Date)DateUtils.stringToSimpleDate((String)queryScheduleRecordDto.getScheduleDate()), (Date)DateUtils.stringToSimpleDate((String)queryScheduleRecordDto.getScheduleEndDate()));
                int i = 0;
                while ((long)i <= aLong) {
                    DateScheduleRecordVo dateScheduleRecordVo = new DateScheduleRecordVo();
                    String afterDay = DateUtils.getMoveDays((String)queryScheduleRecordDto.getScheduleDate(), (int)i, (int)1);
                    dateScheduleRecordVo.setScheduleDate(afterDay);
                    dateScheduleRecordVo.setScheduleRecordVos(collectMap.get(afterDay));
                    dateScheduleRecordVos.add(dateScheduleRecordVo);
                    ++i;
                }
            } else {
                keys.stream().forEach(key -> {
                    DateScheduleRecordVo dateScheduleRecordVo = new DateScheduleRecordVo();
                    dateScheduleRecordVo.setScheduleDate(key);
                    dateScheduleRecordVo.setScheduleRecordVos((List)collectMap.get(key));
                    dateScheduleRecordVos.add(dateScheduleRecordVo);
                });
            }
            queryScheduleRecordVo.setScheduleRecordVos(dateScheduleRecordVos);
            queryScheduleRecordList.add(queryScheduleRecordVo);
        });
        return ResponseData.success(queryScheduleRecordList);
    }
}

