/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.dto.zyyky.GetSampleDataLastDto;
import com.byh.outpatient.api.enums.HwCollectionUnitEnum;
import com.byh.outpatient.api.enums.HwFieldNameEnum;
import com.byh.outpatient.api.enums.HwSportExecFlagEnum;
import com.byh.outpatient.api.enums.HwStatusDataEnum;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.model.HwSportInfoEntity;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.vo.hsSettlement.DictValueVo;
import com.byh.outpatient.api.vo.hwSportInfo.HwDetailVo;
import com.byh.outpatient.api.vo.hwSportInfo.HwInfoVo;
import com.byh.outpatient.data.repository.HwSportInfoMapper;
import com.byh.outpatient.data.repository.OutHsSettlementInfoMapper;
import com.byh.outpatient.data.repository.PatientMapper;
import com.byh.outpatient.web.service.HwSportInfoService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HwSportInfoServiceImpl
implements HwSportInfoService {
    private static final Logger log = LoggerFactory.getLogger(HwSportInfoServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(HwSportInfoServiceImpl.class);
    @Resource
    private HwSportInfoMapper hwSportInfoMapper;
    @Resource
    private OutHsSettlementInfoMapper outHsSettlementInfoMapper;
    @Resource
    private PatientMapper patientMapper;
    @Value(value="${zhongyou.baseUrl}")
    private String baseUrl;

    @Transactional(rollbackFor={BusinessException.class})
    public List<HwSportInfoEntity> getSampleDataDetailByDate(GetSampleDataLastDto dto) {
        Integer tenantId = dto.getTenantId();
        String openUserId = dto.getOpenUserId();
        String startTime = dto.getStartDate() + " 00:00:00";
        String endTime = dto.getEndDate() + " 23:59:59";
        String dataTypeName = dto.getDataType();
        List<HwSportInfoEntity> hwSportInfoList = new ArrayList();
        PatientEntity patient = this.getPatientInfo(tenantId, openUserId);
        if (patient == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u8be5\u7528\u6237\u5e76\u672a\u5b8c\u6210\u8d26\u53f7\u7ed1\u5b9a\uff01");
        }
        String patientName = patient.getName();
        String patientCardNo = patient.getCardNo();
        hwSportInfoList = this.hwSportInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(HwSportInfoEntity::getTenantId, (Object)tenantId)).eq(HwSportInfoEntity::getOpenUserId, (Object)openUserId)).eq(HwSportInfoEntity::getDataTypeName, (Object)dataTypeName)).le(HwSportInfoEntity::getStartTime, (Object)endTime)).ge(HwSportInfoEntity::getEndTime, (Object)startTime));
        List<String> dictTypes = Arrays.asList("before_measure_activities", "grade", "measure_type", "measurement_anomaly_flag", "sleep_state", "on_off_bed_state", "measure_time");
        Map dictTypeMap = this.getDictTypeMap(dictTypes, tenantId);
        if (hwSportInfoList.isEmpty()) {
            String url = this.baseUrl + "/zyyky/getSampleDataDetailByDate";
            HashMap<String, String> requestMap = new HashMap<String, String>();
            requestMap.put("openUserId", openUserId);
            requestMap.put("startDay", startTime);
            requestMap.put("endDay", endTime);
            requestMap.put("dataType", dataTypeName);
            String resutStr = this.getRequestResult(requestMap, url);
            List hwInfoVoList = this.getHwInfoList(resutStr);
            hwSportInfoList = this.getHwSportInfoList(hwInfoVoList, tenantId, patientName, patientCardNo, openUserId, dictTypeMap);
            this.hwSportInfoMapper.insertList(hwSportInfoList);
            return hwSportInfoList;
        }
        for (HwSportInfoEntity hwSportInfo : hwSportInfoList) {
            String execStatus = hwSportInfo.getExecStatus();
            String execFlag = hwSportInfo.getFlag();
            String fieldName = hwSportInfo.getFieldName();
            String fieldNameLabel = Optional.ofNullable(HwFieldNameEnum.getEnumLabel((String)fieldName)).map(HwFieldNameEnum::getLabel).orElse("\u672a\u77e5");
            hwSportInfo.setFieldNameLabel(fieldNameLabel);
            if (!StrUtil.isNotEmpty((CharSequence)execStatus)) continue;
            String stringValueLabel = "";
            if (HwSportExecFlagEnum.DATA_COLLECTION_STATUS.getValue().equals(execFlag)) {
                stringValueLabel = this.getExecStatusLabel(hwSportInfo.getFieldName(), hwSportInfo.getExecStatus(), dictTypeMap);
            } else if (HwSportExecFlagEnum.DATA_COLLECTION_STATUS_INTEGER.getValue().equals(execFlag)) {
                stringValueLabel = this.getIntegerValueLabel(hwSportInfo.getFieldName(), Integer.valueOf(hwSportInfo.getExecStatus()), dictTypeMap);
            }
            hwSportInfo.setExecStatusLabel(stringValueLabel);
        }
        return hwSportInfoList;
    }

    public Map<String, List<HwSportInfoEntity>> getSampleDataLast(GetSampleDataLastDto dto) {
        LinkedHashMap<String, List<HwSportInfoEntity>> map = new LinkedHashMap<String, List<HwSportInfoEntity>>();
        String openUserId = dto.getOpenUserId();
        Integer tenantId = dto.getTenantId();
        if (StrUtil.isEmpty((CharSequence)openUserId)) {
            return map;
        }
        PatientEntity patient = this.getPatientInfo(tenantId, openUserId);
        if (patient == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u8be5\u7528\u6237\u5e76\u672a\u5b8c\u6210\u8d26\u53f7\u7ed1\u5b9a\uff01");
        }
        String patientName = patient.getName();
        String patientCardNo = patient.getCardNo();
        List<String> dictTypes = Arrays.asList("before_measure_activities", "hw_sport_data_type", "grade", "measure_type", "measurement_anomaly_flag", "sleep_state", "on_off_bed_state", "measure_time");
        Map dictTypeMap = this.getDictTypeMap(dictTypes, tenantId);
        List dataTypes = dto.getDataTypes();
        if (dataTypes == null || dataTypes.isEmpty()) {
            List hwSportDataTypeDictList = this.getDictValueVoByType(dictTypeMap, "hw_sport_data_type");
            HashSet<String> excludeTypes = new HashSet<String>();
            excludeTypes.add("com.huawei.continuous.sleep.fragment");
            excludeTypes.add("com.huawei.continuous.steps.delta");
            excludeTypes.add("com.huawei.continuous.distance.delta");
            excludeTypes.add("com.huawei.continuous.calories.burnt");
            dataTypes = hwSportDataTypeDictList.stream().map(DictValueVo::getValue).filter(value -> !excludeTypes.contains(value)).collect(Collectors.toList());
        }
        String url = this.baseUrl + "/zyyky/getSampleDataLast";
        LinkedHashMap<String, Object> requestMap = new LinkedHashMap<String, Object>();
        requestMap.put("openUserId", openUserId);
        requestMap.put("dataTypes", dataTypes);
        String resultStr = this.getRequestResult(requestMap, url);
        List hwInfoVoList = this.getHwInfoList(resultStr);
        List hwSportInfoList = this.getHwSportInfoList(hwInfoVoList, tenantId, patientName, patientCardNo, openUserId, dictTypeMap);
        return hwSportInfoList.stream().collect(Collectors.groupingBy(HwSportInfoEntity::getDataTypeName));
    }

    private List<HwSportInfoEntity> getHwSportInfoList(List<HwInfoVo> hwInfoVoList, Integer tenantId, String patientName, String patientCardNo, String openUserId, Map<String, List<DictValueVo>> dictTypeMap) {
        ArrayList<HwSportInfoEntity> hwSportInfoList = new ArrayList<HwSportInfoEntity>();
        for (HwInfoVo hwInfoVo : hwInfoVoList) {
            Date responseStartTime = this.getDateTime(hwInfoVo.getStartTime());
            Date responseEndTime = this.getDateTime(hwInfoVo.getEndTime());
            String originalDataCollectorId = hwInfoVo.getOriginalDataCollectorId();
            String dataTypeName = hwInfoVo.getDataTypeName();
            List detailList = hwInfoVo.getValue();
            for (HwDetailVo detail : detailList) {
                HwSportInfoEntity hwSportInfo = new HwSportInfoEntity();
                String fieldName = detail.getFieldName();
                BigDecimal floatValue = detail.getFloatValue();
                String stringValue = detail.getStringValue();
                Integer integerValue = detail.getIntegerValue();
                String fieldNameLabel = Optional.ofNullable(HwFieldNameEnum.getEnumLabel((String)fieldName)).map(HwFieldNameEnum::getLabel).orElse("\u672a\u77e5");
                hwSportInfo.setFieldNameLabel(fieldNameLabel);
                if (StrUtil.isNotEmpty((CharSequence)stringValue)) {
                    String stringValueLabel = this.getExecStatusLabel(fieldName, stringValue, dictTypeMap);
                    hwSportInfo.setFlag(HwSportExecFlagEnum.DATA_COLLECTION_STATUS.getValue());
                    hwSportInfo.setExecStatus(stringValue);
                    hwSportInfo.setExecStatusLabel(stringValueLabel);
                } else if (integerValue != null) {
                    String label = Optional.ofNullable(HwStatusDataEnum.getEnumLabel((String)fieldName)).map(HwStatusDataEnum::getLabel).orElse(null);
                    if (StrUtil.isNotEmpty((CharSequence)label)) {
                        String integerValueLabel = this.getIntegerValueLabel(fieldName, integerValue, dictTypeMap);
                        hwSportInfo.setFlag(HwSportExecFlagEnum.DATA_COLLECTION_STATUS_INTEGER.getValue());
                        hwSportInfo.setExecStatus(String.valueOf(integerValue));
                        hwSportInfo.setExecStatusLabel(integerValueLabel);
                    } else {
                        hwSportInfo.setFloatValue(BigDecimal.valueOf(integerValue.intValue()));
                    }
                } else {
                    hwSportInfo.setFlag(HwSportExecFlagEnum.DATA_COLLECTION.getValue());
                    hwSportInfo.setFloatValue(floatValue);
                    String unit = Optional.ofNullable(HwCollectionUnitEnum.getEnumLabel((String)fieldName)).map(HwCollectionUnitEnum::getLabel).orElse(null);
                    hwSportInfo.setUnit(unit);
                }
                hwSportInfo.setTenantId(tenantId);
                hwSportInfo.setPatientName(patientName);
                hwSportInfo.setPatientCardNo(patientCardNo);
                hwSportInfo.setOpenUserId(openUserId);
                hwSportInfo.setOriginalDataCollectorId(originalDataCollectorId);
                hwSportInfo.setDataTypeName(dataTypeName);
                hwSportInfo.setStartTime(responseStartTime);
                hwSportInfo.setEndTime(responseEndTime);
                hwSportInfo.setFieldName(fieldName);
                hwSportInfoList.add(hwSportInfo);
            }
        }
        return hwSportInfoList;
    }

    private String getRequestResult(Map<String, Object> requestMap, String url) {
        String resultStr = "";
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String json = objectMapper.writeValueAsString(requestMap);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpPost httpPost = new HttpPost(url);
                httpPost.setHeader("Content-Type", "application/json");
                httpPost.setHeader("tenant-id", "1");
                httpPost.setHeader("Authorization", "Bearer test1");
                httpPost.setEntity((HttpEntity)new StringEntity(json));
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    resultStr = EntityUtils.toString((HttpEntity)entity);
                    this.checkResultStr(resultStr);
                }
            }
            catch (Exception e) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
            }
        }
        catch (Exception e) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
        }
        return resultStr;
    }

    private Map<String, List<DictValueVo>> getDictTypeMap(List<String> dictTypes, Integer tenantId) {
        List dictValueVoList = this.outHsSettlementInfoMapper.selectDictListByTypes(dictTypes, tenantId);
        return dictValueVoList.stream().collect(Collectors.groupingBy(DictValueVo::getType));
    }

    private PatientEntity getPatientInfo(Integer tenantId, String openUserId) {
        return (PatientEntity)this.patientMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PatientEntity::getTenantId, (Object)tenantId)).eq(PatientEntity::getOpenUserId, (Object)openUserId));
    }

    private String getIntegerValueLabel(String fieldName, Integer integerValue, Map<String, List<DictValueVo>> dictTypeMap) {
        String integerValueLabel = "";
        List fieldNameDictList = this.getDictValueVoByType(dictTypeMap, fieldName);
        Map<String, String> dictValueMap = fieldNameDictList.stream().collect(Collectors.toMap(DictValueVo::getValue, DictValueVo::getLabel));
        integerValueLabel = dictValueMap.getOrDefault(String.valueOf(integerValue), "\u672a\u77e5");
        return integerValueLabel;
    }

    private String getExecStatusLabel(String fieldName, String execStatus, Map<String, List<DictValueVo>> dictTypeMap) {
        String execStatusLabel = "";
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            List execStatusList = (List)objectMapper.readValue(execStatus, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, String.class));
            List fieldNameDictList = this.getDictValueVoByType(dictTypeMap, fieldName);
            Map<String, String> dictValueMap = fieldNameDictList.stream().collect(Collectors.toMap(DictValueVo::getValue, DictValueVo::getLabel));
            execStatusLabel = execStatusList.stream().map(dictValueMap::get).filter(Objects::nonNull).collect(Collectors.joining("\u3001"));
            return execStatusLabel;
        }
        catch (Exception e) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
            return execStatusLabel;
        }
    }

    private Date getDateTime(String time) {
        long nanoTimestamp = Long.parseLong(time);
        long milliTimestamp = nanoTimestamp / 1000000L;
        Date date = new Date(milliTimestamp);
        return date;
    }

    private List<DictValueVo> getDictValueVoByType(Map<String, List<DictValueVo>> dictTypeMap, String type) {
        return dictTypeMap.getOrDefault(type, new ArrayList());
    }

    private List<HwInfoVo> getHwInfoList(String result) {
        List<Object> hwInfoVoList = new ArrayList<HwInfoVo>();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode resultNode = objectMapper.readTree(result);
            Object samplePointsNode = null;
            JsonNode dataNode = resultNode.path("data");
            hwInfoVoList = (List)objectMapper.readValue(dataNode.toString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
        }
        return hwInfoVoList;
    }

    private void checkResultStr(String result) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode resultNode = objectMapper.readTree(result);
            String resultCode = resultNode.path("code").asText();
            if (!"0".equals(resultCode)) {
                String errorInfo = resultNode.path("msg").asText();
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorInfo);
            }
        }
        catch (Exception e) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
        }
    }
}

