/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.bot;

import cn.hutool.http.HttpException;
import java.io.IOException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class BotApiAuthorization {
    private static Logger logger = LoggerFactory.getLogger(BotApiAuthorization.class);

    public static String genCDSSAuthorization(String ak, String sk, String urlPath, String content) {
        String canonicalRequest = "POST\n" + urlPath + "\ncontent-md5:" + BotApiAuthorization.md5((String)content);
        DateTimeFormatter utcFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
        String canonicalTimestamp = utcFormatter.print((ReadableInstant)DateTime.now((DateTimeZone)DateTimeZone.UTC));
        StringBuilder authStringPrefixBuilder = new StringBuilder("cdss-auth-v1/").append(ak).append("/").append(canonicalTimestamp).append("/300");
        String signingKey = BotApiAuthorization.hmacSHA256((String)sk, (String)authStringPrefixBuilder.toString());
        String signature = BotApiAuthorization.hmacSHA256((String)signingKey, (String)canonicalRequest);
        return authStringPrefixBuilder.append("/").append(signature).toString();
    }

    private static String hmacSHA256(String key, String data) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
            mac.init(secretKey);
            return Hex.encodeHexString((byte[])mac.doFinal(data.getBytes("UTF-8")));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String md5(String data) {
        try {
            return DigestUtils.md5Hex((byte[])data.getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sendPost(String urlParam, String ak, String sk, String urlPath, String content) throws HttpException, IOException {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(15000);
        PostMethod postMethod = new PostMethod(urlParam);
        postMethod.getParams().setParameter("http.socket.timeout", (Object)60000);
        httpClient.getParams().setContentCharset("UTF-8");
        String authorization = BotApiAuthorization.genCDSSAuthorization((String)ak, (String)sk, (String)urlPath, (String)content);
        postMethod.addRequestHeader("Content-Type", "application/json; charset=utf-8");
        postMethod.addRequestHeader("Authorization", authorization);
        StringRequestEntity se = new StringRequestEntity(content, "application/json", "UTF-8");
        postMethod.setRequestEntity((RequestEntity)se);
        httpClient.executeMethod((HttpMethod)postMethod);
        String result = postMethod.getResponseBodyAsString();
        postMethod.releaseConnection();
        return result;
    }

    public static String sendGet(String urlParam) throws HttpException, IOException {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(15000);
        GetMethod getMethod = new GetMethod(urlParam);
        getMethod.getParams().setParameter("http.socket.timeout", (Object)60000);
        getMethod.addRequestHeader("Content-Type", "application/json");
        int statusCode = httpClient.executeMethod((HttpMethod)getMethod);
        if (statusCode != 200) {
            logger.info("Method failed: " + getMethod.getStatusLine());
        }
        byte[] responseBody = getMethod.getResponseBody();
        String result = new String(responseBody);
        return result;
    }
}

