/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.call;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.byh.sdk.entity.call.back.CallBackStatus;
import com.byh.sdk.entity.call.back.CallBackTicket;
import com.byh.sdk.service.MakeCallBackService;
import com.byh.sdk.util.ResponseData;
import io.swagger.annotations.ApiOperation;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/callBack"})
public class CallBackController {
    private static final Logger log = LoggerFactory.getLogger(CallBackController.class);
    @Autowired
    private MakeCallBackService makeCallBackService;

    @ApiOperation(value="\u70b9\u5bf9\u70b9\u547c\u53eb\u72b6\u6001\u4fe1\u4ee4\u63a8\u9001")
    @PostMapping(value={"/callStatus"})
    @DS(value="mysql3")
    public ResponseData callStatus(@RequestBody CallBackStatus callBackStatus) {
        String jsonString = JSONObject.toJSONString((Object)callBackStatus);
        log.info("jsonString---" + jsonString);
        return this.makeCallBackService.callStatus(callBackStatus);
    }

    @ApiOperation(value="\u70b9\u5bf9\u70b9\u547c\u53eb\u8bdd\u5355\u63a8\u9001")
    @PostMapping(value={"/callTicket"})
    @DS(value="mysql3")
    public ResponseData callTicket(@RequestBody CallBackTicket callBackTicket) {
        String recordUrl = callBackTicket.getEntry().getRecordUrl();
        String callSid = callBackTicket.getCallSid();
        if (!StringUtils.isBlank((CharSequence)recordUrl)) {
            CompletableFuture.runAsync(() -> this.updateUrl(recordUrl, callSid)).exceptionally(ex -> {
                ex.getCause().printStackTrace();
                return null;
            });
        }
        return this.makeCallBackService.callTicket(callBackTicket);
    }

    @DS(value="mysql3")
    private void updateUrl(String url, String callSid) {
        this.makeCallBackService.updateUrl(url, callSid);
    }
}

