/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.icbc;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Base64;
import javax.crypto.Cipher;

/*
 * Exception performing whole class analysis ignored.
 */
public class RSAExample {
    public static void main(String[] args) throws Exception {
        String plainText = "Hello, World!";
        KeyPair keyPair = RSAExample.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        byte[] encryptedBytes = RSAExample.encrypt((String)plainText, (PublicKey)publicKey);
        String encryptedText = Base64.getEncoder().encodeToString(encryptedBytes);
        System.out.println("Encrypted Text: " + encryptedText);
        byte[] decryptedBytes = RSAExample.decrypt((byte[])encryptedBytes, (PrivateKey)privateKey);
        String decryptedText = new String(decryptedBytes);
        System.out.println("Decrypted Text: " + decryptedText);
        byte[] signatureBytes = RSAExample.sign((String)plainText, (PrivateKey)privateKey);
        String signatureText = Base64.getEncoder().encodeToString(signatureBytes);
        System.out.println("Signature: " + signatureText);
        boolean isVerified = RSAExample.verify((String)plainText, (byte[])signatureBytes, (PublicKey)publicKey);
        System.out.println("Signature Verified: " + isVerified);
    }

    public static KeyPair generateKeyPair() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        return keyPairGenerator.generateKeyPair();
    }

    public static byte[] encrypt(String plainText, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        return cipher.doFinal(plainText.getBytes());
    }

    public static byte[] decrypt(byte[] encryptedBytes, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        return cipher.doFinal(encryptedBytes);
    }

    public static byte[] sign(String plainText, PrivateKey privateKey) throws Exception {
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(privateKey);
        signature.update(plainText.getBytes());
        return signature.sign();
    }

    public static boolean verify(String plainText, byte[] signatureBytes, PublicKey publicKey) throws Exception {
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initVerify(publicKey);
        signature.update(plainText.getBytes());
        return signature.verify(signatureBytes);
    }
}

