/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.byh.sdk.entity.appoint.AdmissionDetailVo;
import com.byh.sdk.entity.appoint.AppPointRequestDTO;
import com.byh.sdk.entity.appoint.ArchivingRequestDTO;
import com.byh.sdk.entity.appoint.HisDeptAndDocCodeVo;
import com.byh.sdk.entity.appoint.MakeAnAppointmentRequestVO;
import com.byh.sdk.entity.appoint.OutpatientTypeVo;
import com.byh.sdk.entity.appoint.SysDepartmentVo;
import com.byh.sdk.entity.appoint.SysDeptDto;
import com.byh.sdk.entity.appoint.SysDoctorIdVo;
import com.byh.sdk.entity.base.FrontRequest;
import com.byh.sdk.entity.base.FrontResponse;
import com.byh.sdk.entity.doctor.SysDoctorDto;
import com.byh.sdk.enums.SourceEnum;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.service.AppointService;
import com.byh.sdk.util.DateUtils;
import com.byh.sdk.util.DobUtils;
import com.byh.sdk.util.ResponseData;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppointServiceImpl
implements AppointService {
    private static final Logger log = LoggerFactory.getLogger(AppointServiceImpl.class);
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Value(value="${remote.outpatientType}")
    private String OUTPATIENT_TYPE;
    @Value(value="${remote.outpatientTypeName}")
    private String OUTPATIENT_TYPE_NAME;

    public FrontResponse<MakeAnAppointmentRequestVO> registration(FrontRequest<AppPointRequestDTO> param) {
        log.info("\u95e8\u8bca\u5feb\u901f\u6302\u53f7\u5165\u53c2:{}", (Object)JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            AppPointRequestDTO body = (AppPointRequestDTO)param.getBody();
            String cardNo = body.getCardNo();
            body.setBirthday(DobUtils.format((String)cardNo.substring(6, 14)));
            body.setAge(Integer.valueOf(DobUtils.countAge((String)cardNo)));
            body.setOutpatientType(this.OUTPATIENT_TYPE);
            body.setOutpatientTypeName(this.OUTPATIENT_TYPE_NAME);
            body.setSource(SourceEnum.ONLINE.getValue());
            ResponseData responseData = this.outpatientServiceFeign.registration(body, tenantId, param.getOperatorId(), param.getOperatorName());
            if (responseData == null || !responseData.isSuccess()) {
                log.info("\u95e8\u8bca\u6302\u53f7\u767b\u8bb0\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)body), (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u6302\u53f7\u767b\u8bb0\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            MakeAnAppointmentRequestVO makeAnAppointmentRequestVO = (MakeAnAppointmentRequestVO)JSON.parseObject((String)JSON.toJSONString((Object)responseData.getData()), MakeAnAppointmentRequestVO.class);
            return FrontResponse.success((String)transactionId, (Object)makeAnAppointmentRequestVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u95e8\u8bca\u6302\u53f7\u767b\u8bb0\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u95e8\u8bca\u6302\u53f7\u767b\u8bb0\u5f02\u5e38");
        }
    }

    public FrontResponse<String> archiving(FrontRequest<ArchivingRequestDTO> param) {
        log.info("\u95e8\u8bca\u5f52\u6863\u5165\u53c2:{}", (Object)JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            ArchivingRequestDTO body = (ArchivingRequestDTO)param.getBody();
            body.setOperatorSource(SourceEnum.ONLINE.getValue());
            ResponseData responseData = this.outpatientServiceFeign.archiving(body, tenantId, param.getOperatorId(), param.getOperatorName());
            if (responseData == null || !responseData.isSuccess()) {
                log.info("\u95e8\u8bca\u5f52\u6863\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)body), (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u95e8\u8bca\u5f52\u6863\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            return FrontResponse.success((String)transactionId, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u95e8\u8bca\u5f52\u6863\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u95e8\u8bca\u5f52\u6863\u5f02\u5e38");
        }
    }

    public FrontResponse<String> updateById(FrontRequest<AppPointRequestDTO> param) {
        log.info("\u66f4\u65b0\u6302\u53f7\u767b\u8bb0\u5165\u53c2:{}", (Object)JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            AppPointRequestDTO body = (AppPointRequestDTO)param.getBody();
            ResponseData admissionResponseData = this.outpatientServiceFeign.queryByOutpatientNo(body.getOutpatientNo(), tenantId);
            if (admissionResponseData == null || !admissionResponseData.isSuccess()) {
                log.info("\u95e8\u8bca\u66f4\u65b0\u6302\u53f7\u67e5\u8be2\u6302\u53f7\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)body), (Object)JSON.toJSONString((Object)admissionResponseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)admissionResponseData.getMsg());
            }
            AdmissionDetailVo admissionDetailVo = (AdmissionDetailVo)JSON.parseObject((String)JSON.toJSONString((Object)admissionResponseData.getData()), AdmissionDetailVo.class);
            if (Objects.isNull(admissionDetailVo)) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"\u672a\u83b7\u53d6\u5230\u6302\u53f7\u4fe1\u606f");
            }
            admissionDetailVo.setStatus(body.getStatus());
            admissionDetailVo.setSource(SourceEnum.ONLINE.getValue());
            admissionDetailVo.setOperatorSource(SourceEnum.ONLINE.getValue());
            admissionDetailVo.setRegTime(DateUtils.getCurrentDate((String)"yyyy-MM-dd HH:mm:ss"));
            ResponseData responseData = this.outpatientServiceFeign.updateById(admissionDetailVo, tenantId, param.getOperatorId(), param.getOperatorName());
            if (responseData == null || !responseData.isSuccess()) {
                log.info("\u95e8\u8bca\u66f4\u65b0\u6302\u53f7\u767b\u8bb0\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)body), (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)responseData.getMsg());
            }
            return FrontResponse.success((String)transactionId, (Object)admissionDetailVo.getOutpatientNo());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u95e8\u8bca\u66f4\u65b0\u6302\u53f7\u767b\u8bb0\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u95e8\u8bca\u66f4\u65b0\u6302\u53f7\u767b\u8bb0\u5f02\u5e38");
        }
    }

    public FrontResponse checkDocAndDeptAndRegFeeInfo(FrontRequest<HisDeptAndDocCodeVo> param) {
        log.info("====\u67e5\u8be2\u6302\u53f7\u7c7b\u578b\u533b\u751f\u90e8\u95e8\u4fe1\u606f\u68c0\u9a8c\u5165\u53c2===={}", (Object)JSON.toJSONString(param));
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error(null, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            HisDeptAndDocCodeVo body = (HisDeptAndDocCodeVo)param.getBody();
            ResponseData responseData = this.outpatientServiceFeign.queryRegFee(this.OUTPATIENT_TYPE, tenantId);
            if (responseData == null || !responseData.isSuccess()) {
                log.info("\u95e8\u8bca\u6302\u53f7\u7c7b\u578b\u67e5\u8be2\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)this.OUTPATIENT_TYPE, (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error(null, (String)"0", (String)responseData.getMsg());
            }
            if (Objects.isNull(responseData.getData())) {
                return FrontResponse.error(null, (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u95e8\u8bca\u6302\u53f7\u7c7b\u578b");
            }
            SysDoctorDto sysDoctorDto = new SysDoctorDto();
            sysDoctorDto.setId(Integer.valueOf(body.getDoctorCode()));
            ResponseData sysDoctorIdVoResponseData = this.sysServiceFeign.doctorById(sysDoctorDto);
            if (Objects.isNull(sysDoctorIdVoResponseData) || !sysDoctorIdVoResponseData.isSuccess()) {
                log.info("\u95e8\u8bca\u533b\u751f\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)sysDoctorDto, (Object)JSON.toJSONString((Object)sysDoctorIdVoResponseData));
                return FrontResponse.error(null, (String)"0", (String)sysDoctorIdVoResponseData.getMsg());
            }
            SysDoctorIdVo sysDoctorIdVo = (SysDoctorIdVo)sysDoctorIdVoResponseData.getData();
            if (Objects.isNull(sysDoctorIdVo) || !Objects.equals(sysDoctorIdVo.getUserName(), body.getDoctorName())) {
                return FrontResponse.error(null, (String)"0", (String)"\u533b\u751f\u4fe1\u606f\u5bf9\u7167\u6709\u8bef");
            }
            SysDeptDto sysDeptDto = new SysDeptDto();
            sysDeptDto.setId(Integer.valueOf(body.getDeptCode()));
            ResponseData sysDepartmentVoResponseData = this.sysServiceFeign.deptInfoById(sysDeptDto);
            if (Objects.isNull(sysDepartmentVoResponseData) || !sysDepartmentVoResponseData.isSuccess()) {
                log.info("\u95e8\u8bca\u79d1\u5ba4\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)sysDeptDto, (Object)JSON.toJSONString((Object)sysDepartmentVoResponseData));
                return FrontResponse.error(null, (String)"0", (String)sysDepartmentVoResponseData.getMsg());
            }
            SysDepartmentVo departmentVo = (SysDepartmentVo)sysDepartmentVoResponseData.getData();
            if (Objects.isNull(departmentVo) || !Objects.equals(departmentVo.getDepartmentName(), body.getDeptName())) {
                return FrontResponse.error(null, (String)"0", (String)"\u79d1\u5ba4\u4fe1\u606f\u5bf9\u7167\u6709\u8bef");
            }
            OutpatientTypeVo outpatientTypeVo = (OutpatientTypeVo)JSON.parseObject((String)JSON.toJSONString((Object)responseData.getData()), OutpatientTypeVo.class);
            return FrontResponse.success(null, (Object)outpatientTypeVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u95e8\u8bca\u6302\u53f7\u7c7b\u578b\u67e5\u8be2\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error(null, (String)"0", (String)"\u95e8\u8bca\u6302\u53f7\u7c7b\u578b\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public FrontResponse queryDoctor(FrontRequest<SysDoctorDto> param) {
        log.info("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5165\u53c2{}", (Object)JSON.toJSONString(param));
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error(null, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SysDoctorDto sysDoctorDto = (SysDoctorDto)param.getBody();
            ResponseData sysDoctorIdVoResponseData = this.sysServiceFeign.doctorById(sysDoctorDto);
            if (Objects.isNull(sysDoctorIdVoResponseData) || !sysDoctorIdVoResponseData.isSuccess()) {
                log.info("\u95e8\u8bca\u533b\u751f\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)sysDoctorDto, (Object)JSON.toJSONString((Object)sysDoctorIdVoResponseData));
                return FrontResponse.error(null, (String)"0", (String)sysDoctorIdVoResponseData.getMsg());
            }
            SysDoctorIdVo sysDoctorIdVo = (SysDoctorIdVo)sysDoctorIdVoResponseData.getData();
            if (Objects.isNull(sysDoctorIdVo) || !Objects.equals(sysDoctorIdVo.getUserName(), sysDoctorDto.getName())) {
                return FrontResponse.error(null, (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u533b\u751f\u767b\u8bb0\u4fe1\u606f");
            }
            SysDoctorIdVo sysDoctorIdVo1 = (SysDoctorIdVo)JSON.parseObject((String)JSON.toJSONString((Object)sysDoctorIdVoResponseData.getData()), SysDoctorIdVo.class);
            return FrontResponse.success(null, (Object)sysDoctorIdVo1);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u95e8\u8bca\u533b\u751f\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error(null, (String)"0", (String)"\u67e5\u8be2\u533b\u751f\u767b\u8bb0\u4fe1\u606f\u5f02\u5e38");
        }
    }
}

