/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.entity.DispensingDetails;
import com.byh.sdk.entity.DispensingInfo;
import com.byh.sdk.entity.admission.AdmissionEntity;
import com.byh.sdk.entity.ve.OutPrescription;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.mapper.OutPrescriptionMapper;
import com.byh.sdk.service.DispensingService;
import com.byh.sdk.util.HttpUtils;
import com.byh.sdk.util.ResponseData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DispensingServiceImpl
implements DispensingService {
    private static Logger log = LoggerFactory.getLogger(DispensingServiceImpl.class);
    public final String baseUrl = "https://medbox.x.yaoxz.cn/mac158";
    public final String url = "/his/product/presc";
    @Resource
    private OutPrescriptionMapper outPrescriptionMapper;
    @Resource
    private OutpatientServiceFeign outServiceFeign;

    public ResponseData presc(OutPrescription prescription) {
        log.info("=======>\u5c55\u5385\u53d1\u836f\u673a\u63a5\u6536\u5230\u7684deviceNo{}", (Object)prescription.getDeviceNo());
        log.info("=======>\u5c55\u5385\u53d1\u836f\u673a\u63a5\u6536\u5230\u7684phone{}", (Object)prescription.getPhone());
        log.info("=======>\u5c55\u5385\u53d1\u836f\u673a\u63a5\u6536\u5230\u7684prescriptionNo{}", (Object)prescription.getPrescriptionNo());
        if (StringUtils.isBlank((CharSequence)prescription.getPrescriptionNo())) {
            return ResponseData.error((String)"\u5904\u65b9\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DispensingInfo info = this.outPrescriptionMapper.queryDispensing(prescription);
        if (StringUtils.isBlank((CharSequence)prescription.getDeviceNo())) {
            AdmissionEntity data;
            String remark;
            info.setDeviceNo("42088100200104");
            ResponseData admissionEntityResponseData = this.outServiceFeign.queryAdmissionByPrescriptionNo(prescription.getPrescriptionNo());
            if ("200".equals(admissionEntityResponseData.getCode()) && StringUtils.isNotBlank((CharSequence)(remark = (data = (AdmissionEntity)admissionEntityResponseData.getData()).getRemark())) && remark.contains("deviceNo=")) {
                String deviceNo = remark.replaceAll("deviceNo=", "");
                info.setDeviceNo(deviceNo);
            }
        } else {
            info.setDeviceNo(prescription.getDeviceNo());
        }
        info.setCurrent("1");
        ArrayList<DispensingDetails> details = new ArrayList<DispensingDetails>();
        JSONObject resultJson = null;
        String inventoryUrl = "/his/device/getdrugbycode";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("deviceNo", info.getDeviceNo());
        try {
            String reqJson = JSONObject.toJSONString(map);
            log.info("\u8bf7\u6c42\u53d1\u836f\u673a\u5e93\u5b58\u5165\u53c2========>{}", (Object)reqJson);
            String post = HttpUtils.post((String)("https://medbox.x.yaoxz.cn/mac158" + inventoryUrl), (String)reqJson);
            log.info("\u8bf7\u6c42\u53d1\u836f\u673a\u5e93\u5b58\u53cd\u53c2========>{}", (Object)post);
            resultJson = JSON.parseObject((String)post);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String rspStatus = resultJson.getString("status");
        HashMap<String, Integer> drugMap = new HashMap<String, Integer>();
        if ("200".equals(rspStatus)) {
            JSONArray data = resultJson.getJSONArray("data");
            for (int i = 0; i < data.size(); ++i) {
                JSONObject drugJson = data.getJSONObject(i);
                drugMap.put(drugJson.getString("commonname"), drugJson.getInteger("quantity"));
            }
        }
        Set drugNames = drugMap.keySet();
        String emptyDrug = "";
        String insufficientDrug = "";
        for (DispensingDetails detail : info.getDetails()) {
            String commonname = detail.getCommonname();
            Integer quantity = detail.getQuantity();
            if (!drugNames.contains(commonname)) {
                if (emptyDrug.equals("")) {
                    emptyDrug = emptyDrug + commonname;
                    continue;
                }
                emptyDrug = emptyDrug + "," + commonname;
                continue;
            }
            Integer deviceQuantity = (Integer)drugMap.get(commonname);
            int i = deviceQuantity - quantity;
            if (i < 0) {
                insufficientDrug = insufficientDrug + "\r\n\u5904\u65b9\u836f\u54c1" + commonname + "\u6570\u91cf\u4e3a\uff1a" + quantity + "\uff0c\u5927\u4e8e\u53d1\u836f\u673a\u5e93\u5b58\u6570\u91cf\uff1a" + deviceQuantity + ";";
                continue;
            }
            details.add(detail);
        }
        if (StringUtils.isNotBlank((CharSequence)emptyDrug) || StringUtils.isNotBlank((CharSequence)insufficientDrug)) {
            return ResponseData.error((String)("\u8be5\u53d1\u836f\u673a\u4e0d\u6ee1\u8db3\u53d1\u836f\u6761\u4ef6{\u836f\u54c1 " + emptyDrug + " \u8be5\u53d1\u836f\u673a\u4e2d\u4e0d\u5b58\u5728\uff01\r\n" + insufficientDrug + "}"));
        }
        info.setDetails(details);
        String respStr = "";
        try {
            String jsonString = JSON.toJSONString((Object)info);
            log.info("=======>\u5c55\u5385\u53d1\u836f\u673a\u8bf7\u6c42\u53c2\u6570{}", (Object)jsonString);
            respStr = HttpUtils.doPost((String)"https://medbox.x.yaoxz.cn/mac158/his/product/presc", (String)jsonString, (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u5c55\u5385\u53d1\u836f\u673a\u8fd4\u56de\u7684\u7ed3\u679c{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject jsonObject = JSON.parseObject((String)respStr);
        String status = jsonObject.get((Object)"status") + "";
        String message = jsonObject.get((Object)"message") + "";
        if ("200".equals(status)) {
            return ResponseData.success((Object)message);
        }
        return ResponseData.error((String)message);
    }
}

