/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.entity.drug.DrugPharmacyStorageDto;
import com.byh.sdk.entity.drug.SysDrugPharmacyStorageVo;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.service.DrugPharmacyStorageService;
import com.byh.sdk.service.GeoCodingService;
import com.byh.sdk.util.JsonUtils;
import com.byh.sdk.util.ResponseData;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DrugPharmacyStorageServiceImpl
implements DrugPharmacyStorageService {
    private static final Logger log = LoggerFactory.getLogger(DrugPharmacyStorageServiceImpl.class);
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private GeoCodingService geoCodingService;

    public ResponseData sysDrugStorageSelect(DrugPharmacyStorageDto dto) {
        dto.setSize(-1);
        return this.sysServiceFeign.withoutSelectPage(dto);
    }

    public ResponseData sysDrugStorageSelectByAddr(DrugPharmacyStorageDto dto) {
        DrugPharmacyStorageDto d = new DrugPharmacyStorageDto();
        d.setSize(-1);
        ResponseData response = this.sysServiceFeign.withoutSelectPage(d);
        List list = JsonUtils.create((Object)response.getData()).getObjectValue("records").getArrayValue().getList();
        ArrayList<Object> storageList = new ArrayList<Object>();
        for (JSONObject jsonObject : list) {
            storageList.add(JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject), SysDrugPharmacyStorageVo.class));
        }
        List onlineList = storageList.stream().filter(n -> "1".equals(n.getOnLine())).collect(Collectors.toList());
        List ftList = storageList.stream().filter(n -> "2024042515142937970".equals(n.getId())).collect(Collectors.toList());
        List xList = storageList.stream().filter(n -> "202401290919222322".equals(n.getId())).collect(Collectors.toList());
        if (!"".equals(dto.getLongitude()) && !"".equals(dto.getLatitude())) {
            JSONObject address = this.geoCodingService.getAddress(dto.getLongitude(), dto.getLatitude());
            JSONObject json = JsonUtils.create((Object)address).getObjectValue("result").getObjectValue("addressComponent").toJsonObject().getJson();
            String province = String.valueOf(json.get((Object)"province"));
            String city = String.valueOf(json.get((Object)"city"));
            String district = String.valueOf(json.get((Object)"district"));
            dto.setAddrIdent(province + "-" + city + "-" + district);
            String addrIdent = province + "-" + city + "-" + district;
            List addrIdentList = onlineList.stream().filter(n -> n.getAddrIdent().equals(addrIdent)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(addrIdentList)) {
                ftList.addAll(xList);
                return ResponseData.success(ftList);
            }
            addrIdentList.addAll(ftList);
            List collect = addrIdentList.stream().distinct().collect(Collectors.toList());
            return ResponseData.success(collect);
        }
        ftList.addAll(xList);
        return ResponseData.success(ftList);
    }
}

