/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.entity.bot.ContentEntity;
import com.byh.sdk.entity.bot.MessageBeanEntity;
import com.byh.sdk.entity.bot.MessageEntity;
import com.byh.sdk.service.Intelligent01BotService;
import com.byh.sdk.util.bot.MedicalRecordBotUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class Intelligent01BotServiceImpl
implements Intelligent01BotService {
    private static final Logger log = LoggerFactory.getLogger(Intelligent01BotServiceImpl.class);
    @Value(value="${bot.url}")
    private String url;
    @Value(value="${bot.ak}")
    private String ak;
    @Value(value="${bot.sk}")
    private String sk;

    public String chat(List<ContentEntity> contents) throws IOException {
        String inputLine;
        long timeStamp = System.currentTimeMillis();
        MessageBeanEntity messageBean = new MessageBeanEntity();
        messageBean.setModel("third-common-v1-faq");
        messageBean.setStream(true);
        MessageEntity message = new MessageEntity();
        ArrayList<MessageEntity> messageList = new ArrayList<MessageEntity>();
        message.setRole("user");
        message.setCreated(timeStamp);
        message.setVersion("api-v2");
        message.setContent(contents);
        messageList.add(message);
        messageBean.setMessages(messageList);
        String messageJson = JSONObject.toJSONString((Object)messageBean);
        log.info("\u8bf7\u6c42\u53c2\u6570:{} ", (Object)messageJson);
        messageJson = MedicalRecordBotUtils.string2Unicode((String)messageJson);
        String md5 = "";
        try {
            md5 = MedicalRecordBotUtils.getMd5((String)messageJson);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Cannot get content md5");
            System.exit(0);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        String trimester = sdf.format(new Date());
        String authStringPrefix = "ihcloud/" + this.ak + "/" + trimester + "/300";
        String signingKey = "";
        try {
            signingKey = MedicalRecordBotUtils.hmacSha256((String)this.sk, (String)authStringPrefix);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Cannot get content md5");
            System.exit(0);
        }
        URL obj = new URL(this.url);
        String canonicalRequest = String.join((CharSequence)"\n", "POST", obj.getPath(), "content-md5:" + md5);
        String signature = "";
        try {
            signature = MedicalRecordBotUtils.hmacSha256((String)signingKey, (String)canonicalRequest);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("gen signature failed");
            System.exit(0);
        }
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("X-IHU-Authorization-V2", authStringPrefix + "/" + signature);
        con.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        wr.writeBytes(messageJson);
        wr.flush();
        wr.close();
        int responseCode = con.getResponseCode();
        System.out.println("Response Code : " + responseCode);
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        log.info("\u7075\u533bchat\u8c03\u7528\u8fd4\u56de\u7ed3\u679c:{}", (Object)response.toString());
        return response.toString();
    }
}

