/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.entity.bot.BotResult;
import com.byh.sdk.entity.bot.Content01Vo;
import com.byh.sdk.entity.bot.ContentEntity;
import com.byh.sdk.entity.bot.MedicalRecordResponse;
import com.byh.sdk.entity.bot.MedicalRecordVo;
import com.byh.sdk.entity.bot.MessageBeanEntity;
import com.byh.sdk.entity.bot.MessageEntity;
import com.byh.sdk.service.AnsMsgHandlerService;
import com.byh.sdk.service.MedicalRecordBotService;
import com.byh.sdk.service.WeChatCustomerService;
import com.byh.sdk.util.ResponseData;
import com.byh.sdk.util.bot.MedicalRecordBotUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MedicalRecordBotServiceImpl
implements MedicalRecordBotService {
    private static final Logger log = LoggerFactory.getLogger(MedicalRecordBotServiceImpl.class);
    @Value(value="${bot.url}")
    private String botUrl;
    @Value(value="${bot.ak}")
    private String botAk;
    @Value(value="${bot.sk}")
    private String botSk;
    @Autowired
    private AnsMsgHandlerService ansMsgHandlerService;
    @Autowired
    private WeChatCustomerService weChatCustomerService;

    public ResponseData generateMedicalRecords(List<ContentEntity> contentEntityList) {
        log.info("url:{},ak:{},sk:{}", new Object[]{this.botUrl, this.botAk, this.botSk});
        try {
            String inputLine;
            MessageBeanEntity messageBean = new MessageBeanEntity();
            messageBean.setModel("third-common-v2-emrGenerate");
            messageBean.setStream(true);
            MessageEntity message = new MessageEntity();
            ArrayList<MessageEntity> messageList = new ArrayList<MessageEntity>();
            message.setRole("user");
            message.setCreated(System.currentTimeMillis() / 1000L);
            message.setVersion("api-v2");
            List<ContentEntity> contentsList = contentEntityList;
            message.setContent(contentsList);
            messageList.add(message);
            messageBean.setMessages(messageList);
            String messageJson = JSONObject.toJSONString((Object)messageBean);
            log.info("url:{},ak:{},sk:{}", new Object[]{this.botUrl, this.botAk, this.botSk});
            log.info("\u8bf7\u6c42\u53c2\u6570:{}", (Object)messageJson);
            messageJson = MedicalRecordBotUtils.string2Unicode((String)messageJson);
            String md5 = MedicalRecordBotUtils.getMd5((String)messageJson);
            SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
            String trimester = sdf.format(new Date());
            String authStringPrefix = "ihcloud/" + this.botAk + "/" + trimester + "/300";
            String signingKey = MedicalRecordBotUtils.hmacSha256((String)this.botSk, (String)authStringPrefix);
            URL obj = new URL(this.botUrl);
            String canonicalRequest = String.join((CharSequence)"\n", "POST", obj.getPath(), "content-md5:" + md5);
            String signature = MedicalRecordBotUtils.hmacSha256((String)signingKey, (String)canonicalRequest);
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setUseCaches(false);
            con.setRequestProperty("X-IHU-Authorization-V2", authStringPrefix + "/" + signature);
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(messageJson);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            log.info("Response Code \u8fd4\u56de\u72b6\u6001\u7801+: " + responseCode);
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            log.info("\u54cd\u5e94\u8fd4\u56de:{}", (Object)response.toString());
            Content01Vo response1 = this.weChatCustomerService.get01Response(response.toString());
            String content = response1.getContent();
            MedicalRecordVo medicalRecordVo = this.buildStreamMedicalResponseVo(content);
            return ResponseData.success((Object)medicalRecordVo);
        }
        catch (Exception e) {
            log.info("\u751f\u6210\u7535\u5b50\u75c5\u5386\u5f02\u5e38:{}", (Object)e.getMessage());
            return ResponseData.error((String)e.getMessage());
        }
    }

    private MedicalRecordVo buildStreamMedicalResponseVo(String content) {
        MedicalRecordVo medicalRecordVo = new MedicalRecordVo();
        String[] key = new String[]{"\u4e3b\u8bc9", "\u4f53\u683c\u68c0\u67e5", "\u65e2\u5f80\u53f2", "\u73b0\u75c5\u53f2", "\u8bca\u65ad", "\u8bca\u7597\u610f\u89c1", "\u8f85\u52a9\u68c0\u67e5", "\u8fc7\u654f\u53f2"};
        List<String> keys = Arrays.asList(key);
        try {
            content = content.replace('\uff1a', ':');
            System.out.println("111\uff1a" + content.contains("\n"));
            if (content.contains("\n\n")) {
                String[] split;
                log.info("\n\n\u5904\u7406:");
                block22: for (String s : split = content.split("\n\n+")) {
                    String detailKey;
                    String[] detail = s.split(":");
                    if (detail.length < 2 || !keys.contains(detailKey = detail[0].trim())) continue;
                    String detailContent = detail[1].trim();
                    switch (detailKey) {
                        case "\u4e3b\u8bc9": {
                            medicalRecordVo.setChiefComplaint(detailContent);
                            continue block22;
                        }
                        case "\u4f53\u683c\u68c0\u67e5": {
                            medicalRecordVo.setPhysicalExam(detailContent);
                            continue block22;
                        }
                        case "\u65e2\u5f80\u53f2": {
                            medicalRecordVo.setMedicalHistory(detailContent);
                            continue block22;
                        }
                        case "\u73b0\u75c5\u53f2": {
                            medicalRecordVo.setPresentMedicalHistory(detailContent);
                            continue block22;
                        }
                        case "\u8bca\u65ad": {
                            medicalRecordVo.setDiagnosisValue(detailContent);
                            continue block22;
                        }
                        case "\u8bca\u7597\u610f\u89c1": {
                            medicalRecordVo.setHandleOpinion(detailContent);
                            continue block22;
                        }
                        case "\u8f85\u52a9\u68c0\u67e5": {
                            medicalRecordVo.setAuxiliaryInspection(detailContent);
                            continue block22;
                        }
                        case "\u8fc7\u654f\u53f2": {
                            medicalRecordVo.setAllergyHistoryText(detailContent);
                            continue block22;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.info("\u7075\u533b\u7535\u5b50\u75c5\u5386\u6570\u636e\u89e3\u6790\u5f02\u5e38:content:{},message:{}", (Object)content, (Object)e.getMessage());
        }
        return medicalRecordVo;
    }

    private MedicalRecordVo buildMedicalResponseVo(MedicalRecordResponse medicalRecordResponse) {
        String emr;
        MessageEntity messageEntity;
        List content;
        BotResult botResult;
        List messages;
        List result = medicalRecordResponse.getResult();
        if (!CollectionUtils.isEmpty((Collection)result) && !CollectionUtils.isEmpty((Collection)(messages = (botResult = (BotResult)result.get(0)).getMessages())) && !CollectionUtils.isEmpty((Collection)(content = (messageEntity = (MessageEntity)messages.get(0)).getContent())) && Strings.isNotEmpty((CharSequence)(emr = ((ContentEntity)content.get(0)).getEmr()))) {
            MedicalRecordVo medicalRecordVo = new MedicalRecordVo();
            JSONObject jsonObject = JSONObject.parseObject((String)emr);
            String chiefComplaint = Objects.nonNull(jsonObject.get((Object)"\u4e3b\u8bc9")) ? jsonObject.get((Object)"\u4e3b\u8bc9").toString() : "";
            String physicalExam = Objects.nonNull(jsonObject.get((Object)"\u4f53\u683c\u68c0\u67e5")) ? jsonObject.get((Object)"\u4f53\u683c\u68c0\u67e5").toString() : "";
            String medicalHistory = Objects.nonNull(jsonObject.get((Object)"\u65e2\u5f80\u53f2")) ? jsonObject.get((Object)"\u65e2\u5f80\u53f2").toString() : "";
            String presentMedicalHistory = Objects.nonNull(jsonObject.get((Object)"\u73b0\u75c5\u53f2")) ? jsonObject.get((Object)"\u73b0\u75c5\u53f2").toString() : "";
            String diagnosisValue = Objects.nonNull(jsonObject.get((Object)"\u8bca\u65ad")) ? jsonObject.get((Object)"\u8bca\u65ad").toString() : "";
            String handleOpinion = Objects.nonNull(jsonObject.get((Object)"\u8bca\u7597\u610f\u89c1")) ? jsonObject.get((Object)"\u8bca\u7597\u610f\u89c1").toString() : "";
            String auxiliaryInspection = Objects.nonNull(jsonObject.get((Object)"\u8f85\u52a9\u68c0\u67e5")) ? jsonObject.get((Object)"\u8f85\u52a9\u68c0\u67e5").toString() : "";
            String allergyHistoryText = Objects.nonNull(jsonObject.get((Object)"\u8fc7\u654f\u53f2")) ? jsonObject.get((Object)"\u8fc7\u654f\u53f2").toString() : "";
            medicalRecordVo.setChiefComplaint(chiefComplaint);
            medicalRecordVo.setPhysicalExam(physicalExam);
            medicalRecordVo.setMedicalHistory(medicalHistory);
            medicalRecordVo.setPresentMedicalHistory(presentMedicalHistory);
            medicalRecordVo.setDiagnosisValue(diagnosisValue);
            medicalRecordVo.setHandleOpinion(handleOpinion);
            medicalRecordVo.setAuxiliaryInspection(auxiliaryInspection);
            medicalRecordVo.setAllergyHistoryText(allergyHistoryText);
            return medicalRecordVo;
        }
        return null;
    }

    public String readStream(InputStream is) throws IOException {
        String line = "";
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                String s = this.ansMsgHandlerService.actMsg(is, line);
                if ("event:message".equals(s) || !StrUtil.isNotEmpty((CharSequence)s) || !StrUtil.isNotEmpty((CharSequence)line)) continue;
                return line;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("\u5173\u95ed\u6570\u636e\u6d41\uff01");
        }
        return line;
    }
}

