/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sdk.entity.HttpLogEntity;
import com.byh.sdk.entity.base.FrontRequest;
import com.byh.sdk.entity.base.FrontResponse;
import com.byh.sdk.entity.drug.CheckObtainDrugDto;
import com.byh.sdk.entity.drug.OutPrescriptionDto;
import com.byh.sdk.entity.drug.RationDrugUseVo;
import com.byh.sdk.entity.drug.SysDrugNumberRelationEntity;
import com.byh.sdk.entity.drug.SysEasyEntity;
import com.byh.sdk.entity.prescription.CheckPrescriptionDTO;
import com.byh.sdk.entity.prescription.SavePrescriptionDto;
import com.byh.sdk.entity.ve.OutPrescription;
import com.byh.sdk.entity.ve.OutPrescriptionDrug;
import com.byh.sdk.enums.SourceEnum;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.mapper.HttpLogMapper;
import com.byh.sdk.mapper.OutPrescriptionMapper;
import com.byh.sdk.mapper.SysDrugNumberRelationMapper;
import com.byh.sdk.service.PrescriptionService;
import com.byh.sdk.util.ExceptionUtils;
import com.byh.sdk.util.RedisUtil;
import com.byh.sdk.util.ResponseData;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PrescriptionServiceImpl
implements PrescriptionService {
    private static final Logger log = LoggerFactory.getLogger(PrescriptionServiceImpl.class);
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private RedisUtil redisUtil;
    @Qualifier(value="outPrescriptionMapper")
    @Autowired
    private OutPrescriptionMapper outPrescriptionMapper;
    @Autowired
    private SysDrugNumberRelationMapper sysDrugNumberRelationMapper;
    @Autowired
    private HttpLogMapper httpLogMapper;

    public FrontResponse savePrescription(FrontRequest<SavePrescriptionDto> param) {
        log.info("\u5904\u65b9\u4fdd\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SavePrescriptionDto body = (SavePrescriptionDto)param.getBody();
            if (this.redisUtil.hasKey("save_" + body.getMainId())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8bf7\u52ff\u91cd\u590d\u4fdd\u5b58");
            }
            this.redisUtil.set("save_" + body.getMainId(), (Object)body.getMainId(), 3600L);
            body.setSource(SourceEnum.ONLINE.getValue());
            body.setOperatorSource(SourceEnum.ONLINE.getValue());
            ResponseData responseData = this.outpatientServiceFeign.savePrescription(body, tenantId, param.getOperatorId(), param.getOperatorName());
            if (responseData == null || !responseData.isSuccess()) {
                log.error("\u5904\u65b9\u4fdd\u5b58\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)body), (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u5904\u65b9\u4fdd\u5b58\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            return FrontResponse.success((String)transactionId, (Object)responseData.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u5904\u65b9\u64cd\u4f5c\u5f02\u5e38:{}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u5904\u65b9\u64cd\u4f5c\u5f02\u5e38");
        }
    }

    public FrontResponse checkPrescription(FrontRequest<CheckPrescriptionDTO> param) {
        log.info("\u6821\u9a8c\u5904\u65b9\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            CheckPrescriptionDTO prescriptionDTO = (CheckPrescriptionDTO)param.getBody();
            prescriptionDTO.setSource(SourceEnum.ONLINE.getValue());
            ResponseData responseData = this.outpatientServiceFeign.checkPrescription(prescriptionDTO, tenantId, param.getOperatorId(), param.getOperatorName());
            log.info("\u6821\u9a8c\u5904\u65b9\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString(param), (Object)JSON.toJSONString((Object)responseData));
            if (responseData == null) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"\u68c0\u9a8c\u5904\u65b9\u8fd4\u56de\u5f02\u5e38");
            }
            if (!ResponseData.ResponseEnum.SUCCESS.getCode().equals(responseData.getCode())) {
                try {
                    RationDrugUseVo rationDrugUseVo = (RationDrugUseVo)JSON.parseObject((String)JSON.toJSONString((Object)responseData.getData()), RationDrugUseVo.class);
                    return new FrontResponse(transactionId, "-1", responseData.getMsg(), (Object)rationDrugUseVo);
                }
                catch (Exception e) {
                    return FrontResponse.error((String)transactionId, (String)"0", (String)responseData.getMsg());
                }
            }
            return FrontResponse.success((String)transactionId, (Object)responseData.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6821\u9a8c\u5904\u65b9\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)e.getMessage());
        }
    }

    public FrontResponse deletePrescriptionsByNo(FrontRequest<OutPrescriptionDto> param) {
        log.info("\u5220\u9664\u5904\u65b9\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            OutPrescriptionDto outPrescriptionDto = (OutPrescriptionDto)param.getBody();
            outPrescriptionDto.setOperatorSource(SourceEnum.IHOS_ONLINE.getValue());
            ResponseData responseData = this.outpatientServiceFeign.deletePrescriptionsByNo(outPrescriptionDto, tenantId, param.getOperatorId(), param.getOperatorName());
            log.info("\u5220\u9664\u5904\u65b9\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString(param), (Object)JSON.toJSONString((Object)responseData));
            if (responseData == null) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"\u5220\u9664\u5904\u65b9\u8fd4\u56de\u5f02\u5e38");
            }
            if (!ResponseData.ResponseEnum.SUCCESS.getCode().equals(responseData.getCode())) {
                try {
                    RationDrugUseVo rationDrugUseVo = (RationDrugUseVo)JSON.parseObject((String)JSON.toJSONString((Object)responseData.getData()), RationDrugUseVo.class);
                    return new FrontResponse(transactionId, "-1", responseData.getMsg(), (Object)rationDrugUseVo);
                }
                catch (Exception e) {
                    return FrontResponse.error((String)transactionId, (String)"0", (String)responseData.getMsg());
                }
            }
            return FrontResponse.success((String)transactionId, (Object)responseData.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u5220\u9664\u5904\u65b9\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)e.getMessage());
        }
    }

    public FrontResponse deletePrescriptionsByMainId(FrontRequest<OutPrescriptionDto> param) {
        log.info("\u5220\u9664\u5904\u65b9\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            OutPrescriptionDto outPrescriptionDto = (OutPrescriptionDto)param.getBody();
            outPrescriptionDto.setOperatorSource(SourceEnum.IHOS_ONLINE.getValue());
            ResponseData responseData = this.outpatientServiceFeign.deletePrescriptionsByMainId(outPrescriptionDto, tenantId, param.getOperatorId(), param.getOperatorName());
            log.info("\u5220\u9664\u5904\u65b9\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString(param), (Object)JSON.toJSONString((Object)responseData));
            if (responseData == null) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"\u5220\u9664\u5904\u65b9\u8fd4\u56de\u5f02\u5e38");
            }
            if (!ResponseData.ResponseEnum.SUCCESS.getCode().equals(responseData.getCode())) {
                try {
                    RationDrugUseVo rationDrugUseVo = (RationDrugUseVo)JSON.parseObject((String)JSON.toJSONString((Object)responseData.getData()), RationDrugUseVo.class);
                    return new FrontResponse(transactionId, "-1", responseData.getMsg(), (Object)rationDrugUseVo);
                }
                catch (Exception e) {
                    return FrontResponse.error((String)transactionId, (String)"0", (String)responseData.getMsg());
                }
            }
            return FrontResponse.success((String)transactionId, (Object)responseData.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u5220\u9664\u5904\u65b9\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)e.getMessage());
        }
    }

    public FrontResponse checkObtainDrug(FrontRequest<CheckObtainDrugDto> param) {
        log.info("\u6821\u9a8c\u5904\u65b9\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        ResponseData responseData = this.outpatientServiceFeign.checkObtainDrug((CheckObtainDrugDto)param.getBody(), param.getTenantId(), param.getOperatorId(), param.getOperatorName());
        log.info("\u6821\u9a8c\u5904\u65b9\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)responseData));
        if (responseData.isSuccess()) {
            return FrontResponse.success((String)param.getTransactionId(), (Object)responseData.getData());
        }
        return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)String.valueOf(responseData.getMsg()));
    }

    public List<OutPrescription> selectByNo(String outpatientNo) {
        List outPrescriptions = this.outPrescriptionMapper.selectOneByOutPatientNo(outpatientNo);
        for (OutPrescription m : outPrescriptions) {
            List list = this.outPrescriptionMapper.selectDrugList(m.getPrescriptionNo());
            for (OutPrescriptionDrug n : list) {
                SysDrugNumberRelationEntity relationEntity = this.sysDrugNumberRelationMapper.selectRelation(n.getThirdCode(), n.getTenantId());
                n.setQuantity(n.getQuantity().divide(new BigDecimal(relationEntity.getNumber())));
                n.setQuantityUnit("\u4ef6");
                n.setUseText("\u5171" + n.getMedicationDays() + "\u5929\uff1b\u6bcf\u6b21" + n.getSingleDose() + n.getDoseUnit() + "\uff1b" + n.getDrugUsage() + "\uff1b" + n.getFrequency());
            }
            m.setOutPrescriptionDrugList(list);
        }
        return outPrescriptions;
    }

    public ResponseData uploadHs(SysEasyEntity entity) {
        ResponseData responseData = this.sysServiceFeign.goodSale(entity);
        ExceptionUtils.createException((Logger)log, (!"200".equals(responseData.getCode()) ? 1 : 0) != 0, (String)responseData.getCode(), (String)responseData.getMsg());
        HttpLogEntity httpLogEntity = new HttpLogEntity();
        httpLogEntity.setParam(JSONObject.toJSONString((Object)entity));
        httpLogEntity.setResult(JSONObject.toJSONString((Object)responseData));
        this.httpLogMapper.insert((Object)httpLogEntity);
        return responseData;
    }

    public ResponseData uploadHsAgain(SysEasyEntity entity) {
        ResponseData responseData = this.sysServiceFeign.goodSaleAgain(entity);
        ExceptionUtils.createException((Logger)log, (!"200".equals(responseData.getCode()) ? 1 : 0) != 0, (String)responseData.getCode(), (String)responseData.getMsg());
        return responseData;
    }

    public ResponseData selectUploadBak(SysEasyEntity entity) {
        Page page = new Page((long)entity.getCurrent(), (long)entity.getSize());
        IPage list = this.outPrescriptionMapper.selectUploadBak(page, entity);
        return ResponseData.success((Object)list);
    }

    public ResponseData updateExamineStatus(OutPrescription parameter) {
        log.info("\u6821\u9a8c\u5904\u65b9\u5ba1\u6838\u72b6\u6001\u5165\u53c2", (Object)JSON.toJSONString((Object)parameter));
        ResponseData responseData = this.outpatientServiceFeign.updateExamineStatus(parameter);
        log.info("\u6821\u9a8c\u5904\u65b9\u5ba1\u6838\u72b6\u6001\u51fa\u53c2", (Object)JSON.toJSONString((Object)responseData));
        return responseData;
    }
}

