/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.byh.sdk.entity.PurchaseOrderBatchDetailEntity;
import com.byh.sdk.entity.PurchaseOrderEntity;
import com.byh.sdk.mapper.PurchaseOrderBatchDetailMapper;
import com.byh.sdk.service.PurchaseOrderBatchDetailService;
import com.byh.sdk.util.ExceptionUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.cxf.BusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseOrderBatchDetailServiceImpl
implements PurchaseOrderBatchDetailService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseOrderBatchDetailServiceImpl.class);
    @Resource
    private PurchaseOrderBatchDetailMapper purchaseOrderBatchDetailMapper;

    @Transactional(rollbackFor={BusException.class})
    public void purchaseOrderBatchDetailSaveBatch(List<PurchaseOrderBatchDetailEntity> list) {
        Map<String, List<PurchaseOrderBatchDetailEntity>> map = list.stream().collect(Collectors.groupingBy(PurchaseOrderBatchDetailEntity::getOrderid));
        for (Map.Entry<String, List<PurchaseOrderBatchDetailEntity>> entry : map.entrySet()) {
            String orderid = entry.getKey();
            if (orderid.indexOf("-") <= 0) continue;
            PurchaseOrderEntity entity = this.purchaseOrderBatchDetailMapper.purchaseOrderSelect(orderid = orderid.substring(0, orderid.indexOf("-")));
            if (Objects.nonNull(entity)) {
                int b = this.purchaseOrderBatchDetailMapper.updatePurchaseOrderBackFlag(orderid);
                ExceptionUtils.createException((Logger)log, (boolean)"1".equals(entity.getBackFlag()), (String)"500", (String)("\u3010orderId\uff1a" + orderid + "\u3011\u4e0d\u53ef\u91cd\u590d\u63a8\u9001"));
                ExceptionUtils.createException((Logger)log, (int)b, (String)("\u3010orderId\uff1a" + orderid + "\u3011\u7684\u91c7\u8d2d\u5355\u66f4\u65b0\u63a5\u53d7\u53c2\u6570\u72b6\u6001\u62a5\u9519\u3002"));
                for (PurchaseOrderBatchDetailEntity e : entry.getValue()) {
                    e.setOrderid(orderid);
                }
                int a = this.purchaseOrderBatchDetailMapper.purchaseOrderBatchDetailSaveBatch(entry.getValue());
                ExceptionUtils.createException((Logger)log, (int)a, (String)"500", (String)"\u6279\u91cf\u6570\u636e\u63d2\u5165\u5f02\u5e38");
                continue;
            }
            log.error("\u8ba2\u5355\u53f7\uff1a\u3010{}\u3011\u4e0d\u5728\u4e8epurchase_order\u8868\u4e2d\u3002\u672a\u6267\u884c\u63d2\u5165\u64cd\u4f5c\u3002", (Object)orderid);
        }
    }

    public void purchaseOrderBatchDetailSave(PurchaseOrderBatchDetailEntity entity) {
        int a = this.purchaseOrderBatchDetailMapper.purchaseOrderBatchDetailSave(entity);
    }

    public List<PurchaseOrderBatchDetailEntity> purchaseOrderBatchDetailSelect(PurchaseOrderBatchDetailEntity entity) {
        List list = this.purchaseOrderBatchDetailMapper.purchaseOrderBatchDetailSelect(entity);
        return list;
    }

    public void purchaseOrderBatchDetailUpdate(PurchaseOrderBatchDetailEntity entity) {
        int a = this.purchaseOrderBatchDetailMapper.purchaseOrderBatchDetailUpdate(entity);
    }

    public void purchaseOrderBatchDetailDelete(PurchaseOrderBatchDetailEntity entity) {
        int a = this.purchaseOrderBatchDetailMapper.purchaseOrderBatchDetailDelete(entity);
    }
}

