/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.bot;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.controller.bot.BotApiAuthorization;
import com.byh.sdk.entity.bot.cdss.outRecords.Whole;
import com.byh.sdk.entity.bot.knowledgeBase.KnowledgeBaseEntity;
import com.byh.sdk.util.ResponseData;
import com.byh.sdk.util.exception.BusinessException;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cdss"})
public class CDSSController {
    private static Logger logger = LoggerFactory.getLogger(CDSSController.class);
    private static final String urlPath = "/cdss/standard/api/v2";
    @Value(value="${bot-cdss.ak}")
    private String ak;
    @Value(value="${bot-cdss.sk}")
    private String sk;
    @Value(value="${bot-cdss.url}")
    private String urlDev;

    @PostMapping(value={"/getCDSSDiagnosePortrait"})
    @ApiOperation(value="\u7591\u4f3c\u8bca\u65ad\u63a8\u8350API")
    public ResponseData getCDSSDiagnosePortrait(@RequestBody Whole whole) throws NoSuchAlgorithmException, IOException {
        whole.setMethod("cdss-diagnose-portrait");
        String content = JSON.toJSONString((Object)whole);
        String url = this.urlDev + urlPath;
        String s = BotApiAuthorization.sendPost((String)url, (String)this.ak, (String)this.sk, (String)urlPath, (String)content);
        JSONObject jSONObject = JSONObject.parseObject((String)s);
        return ResponseData.success((Object)jSONObject);
    }

    @PostMapping(value={"/getCDSSDetailDiagnose"})
    @ApiOperation(value="\u7591\u4f3c\u8bca\u65ad\u63a8\u8350\u7406\u7531\u8be6\u60c5API")
    public ResponseData getCDSSDetailDiagnose(@RequestBody Whole whole) throws NoSuchAlgorithmException, IOException {
        whole.setMethod("cdss-detail-diagnose");
        String content = JSON.toJSONString((Object)whole);
        String url = this.urlDev + urlPath;
        String s = BotApiAuthorization.sendPost((String)url, (String)this.ak, (String)this.sk, (String)urlPath, (String)content);
        JSONObject jSONObject = JSONObject.parseObject((String)s);
        return ResponseData.success((Object)jSONObject);
    }

    @PostMapping(value={"/getCDSSDdx"})
    @ApiOperation(value="\u9274\u522b\u8bca\u65ad\u63a8\u8350API")
    public ResponseData getCDSSDdx(@RequestBody Whole whole) throws NoSuchAlgorithmException, IOException {
        whole.setMethod("cdss-ddx");
        String content = JSON.toJSONString((Object)whole);
        String url = this.urlDev + urlPath;
        String s = BotApiAuthorization.sendPost((String)url, (String)this.ak, (String)this.sk, (String)urlPath, (String)content);
        JSONObject jSONObject = JSONObject.parseObject((String)s);
        return ResponseData.success((Object)jSONObject);
    }

    @PostMapping(value={"/getCDSSTreatPlatform"})
    @ApiOperation(value="\u897f\u533b\u6cbb\u7597\u65b9\u6848\u63a8\u8350API")
    public ResponseData getCDSSTreatPlatform(@RequestBody Whole whole) throws NoSuchAlgorithmException, IOException {
        whole.setMethod("cdss-treat-platform");
        String content = JSON.toJSONString((Object)whole);
        String url = this.urlDev + urlPath;
        String s = BotApiAuthorization.sendPost((String)url, (String)this.ak, (String)this.sk, (String)urlPath, (String)content);
        JSONObject jSONObject = JSONObject.parseObject((String)s);
        return ResponseData.success((Object)jSONObject);
    }

    @PostMapping(value={"/getCDSSTcm"})
    @ApiOperation(value="\u4e2d\u533b\u6cbb\u7597\u65b9\u6848\u63a8\u8350API")
    public ResponseData getCDSSTcm(@RequestBody Whole whole) throws NoSuchAlgorithmException, IOException {
        whole.setMethod("cdss-tcm");
        String content = JSON.toJSONString((Object)whole);
        String url = this.urlDev + urlPath;
        String s = BotApiAuthorization.sendPost((String)url, (String)this.ak, (String)this.sk, (String)urlPath, (String)content);
        JSONObject jSONObject = JSONObject.parseObject((String)s);
        return ResponseData.success((Object)jSONObject);
    }

    @PostMapping(value={"/getCDSSKbDetailNew"})
    @ApiOperation(value="\u77e5\u8bc6\u5e93\u8be6\u60c5API")
    public ResponseData getCDSSKbDetailNew(@RequestBody KnowledgeBaseEntity entity) throws NoSuchAlgorithmException, IOException {
        entity.setMethod("cdss-kb-detail-new");
        String content = JSON.toJSONString((Object)entity);
        String url = this.urlDev + urlPath;
        String s = BotApiAuthorization.sendPost((String)url, (String)this.ak, (String)this.sk, (String)urlPath, (String)content);
        JSONObject jSONObject = JSONObject.parseObject((String)s);
        return ResponseData.success((Object)jSONObject);
    }

    @PostMapping(value={"/getCDSSKbSearch"})
    @ApiOperation(value="\u68c0\u7d22\u77e5\u8bc6\u5e93 ")
    public ResponseData getCDSSKbSearch(@RequestBody KnowledgeBaseEntity entity) throws NoSuchAlgorithmException, IOException {
        String query = entity.getQuery();
        if (StrUtil.isEmpty((CharSequence)query)) {
            throw new BusinessException("\u641c\u7d22\u6761\u4ef6 \u4e0d\u80fd\u4e3a\u7a7a\uff01\uff5bquery\uff5d==" + query);
        }
        entity.setMethod("cdss-kb-search");
        String content = JSON.toJSONString((Object)entity);
        String url = this.urlDev + urlPath;
        String s = BotApiAuthorization.sendPost((String)url, (String)this.ak, (String)this.sk, (String)urlPath, (String)content);
        JSONObject jSONObject = JSONObject.parseObject((String)s);
        return ResponseData.success((Object)jSONObject);
    }
}

