/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.video;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.byh.sdk.entity.im.InterrogationVideoRedisDto;
import com.byh.sdk.entity.im.OutInterrogationVideoDto;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.util.ResponseData;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/outInterrogationVideo"})
public class OutInterrogationVideoController {
    private static final Logger log = LoggerFactory.getLogger(OutInterrogationVideoController.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;

    @ApiOperation(value="redis\u7f13\u5b58")
    @PostMapping(value={"/redisVideo"})
    public ResponseData getDeptInfo(@RequestBody InterrogationVideoRedisDto dto) {
        this.redisTemplate.opsForValue().set((Object)("video:VIDEO_" + dto.getRoomId()), (Object)dto.getOutpatientNo(), 600L, TimeUnit.SECONDS);
        return ResponseData.success();
    }

    @ApiOperation(value="\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u89c6\u9891\u5217\u8868", httpMethod="POST", notes="\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u89c6\u9891\u5217\u8868")
    @PostMapping(value={"/queryVideoList"})
    public ResponseData queryVideoList(@RequestBody OutInterrogationVideoDto dto) {
        return this.outpatientServiceFeign.queryVideoList(dto, Integer.valueOf(1));
    }

    @PostMapping(value={"/notify"})
    public ResponseData notify(@RequestHeader(value="Sign") String sign, @RequestHeader(value="SdkAppId") String sdkAppId, @RequestBody String body) {
        log.info("\u95ee\u8bca\u89c6\u9891\u56de\u8c03\u53c2\u6570----body\u8bf7\u6c42\u4f53\uff1a{},\u7b7e\u540dsign:{},\u8d26\u53f7sdkAppId:{}", new Object[]{body, sign, sdkAppId});
        JSONObject returnJson = new JSONObject();
        returnJson.putOpt("code", (Object)"0");
        try {
            String sign1 = OutInterrogationVideoController.getResultSign((String)"123456", (String)body);
            log.info("getResultSign:{}", (Object)sign1);
            if (!sign1.equals(sign)) {
                log.info("\u95ee\u8bca\u89c6\u9891\u7b7e\u540d\u6821\u9a8c\u5931\u8d25!");
                return ResponseData.success((Object)returnJson);
            }
            JSONObject jsonObject = JSONUtil.parseObj((String)body);
            String EventType2 = jsonObject.getStr((Object)"EventType");
            HashSet<String> eventTypes = new HashSet<String>(Arrays.asList("312", "311", "310"));
            if (!eventTypes.contains(EventType2)) {
                return ResponseData.success((Object)returnJson);
            }
            String EventInfo = jsonObject.getStr((Object)"EventInfo");
            if (!StringUtils.isEmpty((CharSequence)EventInfo)) {
                JSONObject eventInfoJson = JSONUtil.parseObj((String)EventInfo);
                String RoomId = eventInfoJson.getStr((Object)"RoomId");
                String taskId = eventInfoJson.getStr((Object)"TaskId");
                String outpatientNo = Objects.requireNonNull(this.redisTemplate.opsForValue().get((Object)("video:VIDEO_" + RoomId))).toString();
                if (StringUtils.isEmpty((CharSequence)outpatientNo)) {
                    return ResponseData.success((Object)returnJson);
                }
                JSONObject PayloadJson = JSONUtil.parseObj((String)eventInfoJson.getStr((Object)"Payload"));
                String status = PayloadJson.getStr((Object)"Status");
                JSONObject TencentVodJson = JSONUtil.parseObj((String)PayloadJson.getStr((Object)"TencentVod"));
                String userId = TencentVodJson.getStr((Object)"UserId");
                String fileId = TencentVodJson.getStr((Object)"FileId");
                String videoUrl = TencentVodJson.getStr((Object)"VideoUrl");
                OutInterrogationVideoDto outInterrogationVideoDto = new OutInterrogationVideoDto();
                outInterrogationVideoDto.setOutpatientNo(outpatientNo);
                outInterrogationVideoDto.setTaskId(taskId);
                outInterrogationVideoDto.setVideoStatus(status);
                outInterrogationVideoDto.setFileId(fileId);
                outInterrogationVideoDto.setVideoUrl(videoUrl);
                outInterrogationVideoDto.setVideoType("0");
                log.info("\u95ee\u8bca\u89c6\u9891\u65b0\u589e\u53c2\u6570,{}", (Object)JSONUtil.toJsonStr((Object)outInterrogationVideoDto));
                CompletableFuture.runAsync(() -> this.outpatientServiceFeign.addOutInterrogationVideo(outInterrogationVideoDto, Integer.valueOf(1)));
                return ResponseData.success((Object)returnJson);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ResponseData.success((Object)returnJson);
    }

    public static String getResultSign(String key, String body) throws Exception {
        Mac hmacSha256 = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(), "HmacSHA256");
        hmacSha256.init(secret_key);
        return Base64.getEncoder().encodeToString(hmacSha256.doFinal(body.getBytes()));
    }
}

