/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.webservice.manage;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.entity.appoint.AdmissionDetailVo;
import com.byh.sdk.entity.diagnostic.Out_DiagnosisDto;
import com.byh.sdk.entity.diagnostic.OutpatientInfomationDto;
import com.byh.sdk.entity.diagnostic.QueryOutpatientMedicalRecordsVo;
import com.byh.sdk.entity.drug.OutPrescriptionDto;
import com.byh.sdk.entity.drug.SysDrugPharmacySimpleDto;
import com.byh.sdk.entity.drug.SysDrugPharmacySimpleVo;
import com.byh.sdk.entity.order.OutOrder;
import com.byh.sdk.entity.order.QueryOrderDto;
import com.byh.sdk.entity.prescription.QueryPrescriptionsVo;
import com.byh.sdk.entity.respones.WesternMedicineDrugsVo;
import com.byh.sdk.entity.zkSelfMachine.BaseReturnVo;
import com.byh.sdk.entity.zkSelfMachine.ConsisBasicDrugsvw;
import com.byh.sdk.entity.zkSelfMachine.ConsisPrescDetlvm;
import com.byh.sdk.entity.zkSelfMachine.ConsisPrescMstvw;
import com.byh.sdk.entity.zkSelfMachine.DrugDictReqVo;
import com.byh.sdk.entity.zkSelfMachine.InventoryResVo;
import com.byh.sdk.entity.zkSelfMachine.PrescriptionBusinessReqVo;
import com.byh.sdk.entity.zkSelfMachine.ZkBusinessResVo;
import com.byh.sdk.enums.SourceEnum;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.util.IdCardUtil;
import com.byh.sdk.util.RedisUtil;
import com.byh.sdk.util.ResponseData;
import com.byh.sdk.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.jws.WebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@WebService
@Service
public class CloudMedicalManage {
    private static final Logger log = LoggerFactory.getLogger(CloudMedicalManage.class);
    @Value(value="${warehouse.selfmachine}")
    private String selfmachineWarehouse;
    @Value(value="${warehouse.tenantId}")
    private Integer tenantId;
    @Value(value="${warehouse.userId}")
    private Integer userId;
    @Value(value="${warehouse.userName}")
    private String userName;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;

    public ResponseData<DrugDictReqVo> addDrugDict(String xml) {
        try {
            DrugDictReqVo drugDictReqVo = new DrugDictReqVo();
            ArrayList consisBasicDrugsvw = new ArrayList();
            SysDrugPharmacySimpleDto sysDrugPharmacySimpleDto = new SysDrugPharmacySimpleDto();
            sysDrugPharmacySimpleDto.setWarehouse(this.selfmachineWarehouse);
            sysDrugPharmacySimpleDto.setIsPlus("off");
            log.info("\u67e5\u8be2\u836f\u623f\u836f\u54c1\u4fe1\u606f\u5165\u53c2" + JSONObject.toJSONString((Object)sysDrugPharmacySimpleDto));
            HttpResponse response = ((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)"http://192.168.0.121:8898/sys-service/sysDrug/pharmacyOut/sdkSearch").header("User-Agent", "Apifox/1.0.0 (https://apifox.com)")).header("Content-Type", "application/json")).header("Accept", "*/*")).body(JSONObject.toJSONString((Object)sysDrugPharmacySimpleDto)).contentType("application/json").execute();
            String responseBody = response.body();
            ResponseData responseData = (ResponseData)JSONObject.parseObject((String)responseBody, ResponseData.class);
            if (responseData == null || !responseData.isSuccess()) {
                log.info("\u67e5\u8be2\u836f\u623f\u836f\u54c1\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)sysDrugPharmacySimpleDto, (Object)JSON.toJSONString((Object)responseData));
                return ResponseData.error((String)"inventoryResVo");
            }
            List drugItems = JSON.parseArray((String)JSON.toJSONString((Object)responseData.getData()), SysDrugPharmacySimpleVo.class);
            drugItems.stream().forEach(drug -> {
                String drugDetial = JSONObject.toJSONString((Object)drug);
                drugDetial.replaceAll("<", "&lt;");
                drugDetial.replaceAll(">", "&gt;");
                drugDetial.replaceAll("&", "&amp;");
                drug = (SysDrugPharmacySimpleVo)JSONObject.parseObject((String)drugDetial, SysDrugPharmacySimpleVo.class);
                ConsisBasicDrugsvw basicDrugsvw = new ConsisBasicDrugsvw();
                basicDrugsvw.setDrugCode(String.valueOf(drug.getInternalCode()));
                basicDrugsvw.setDrugName(drug.getDrugsName());
                basicDrugsvw.setTradeName(drug.getDrugsName());
                basicDrugsvw.setDrugSpec(drug.getSpecifications());
                basicDrugsvw.setEnglishName("");
                basicDrugsvw.setPinyin(drug.getPinyin());
                String sorttype1 = "\u897f\u836f/\u4e2d\u6210\u836f";
                basicDrugsvw.setSorttype1(sorttype1);
                basicDrugsvw.setSorttype2(drug.getDosageForm());
                basicDrugsvw.setDrugSpec(drug.getSpecifications());
                basicDrugsvw.setMinSpecs(drug.getPackSmallUnitsLabel());
                basicDrugsvw.setMaxUnit(drug.getPackLargeUnits());
                basicDrugsvw.setUnit(drug.getUnit());
                basicDrugsvw.setDosage(drug.getDefaultSingleDose());
                basicDrugsvw.setDosageUnit(drug.getDefaultUsageUnit());
                basicDrugsvw.setPrice1(String.valueOf(drug.getRetailPrice()));
                basicDrugsvw.setConvertion1("");
                basicDrugsvw.setConbertion2("");
                basicDrugsvw.setFirmId("1");
                basicDrugsvw.setFirmName(drug.getManufacturer());
                basicDrugsvw.setPassno(drug.getMedicalInsuranceCode());
                basicDrugsvw.setBarCode("");
                basicDrugsvw.setStorageCondition("");
                basicDrugsvw.setStorageType("0");
                basicDrugsvw.setAlloWind("Y");
                consisBasicDrugsvw.add(basicDrugsvw);
            });
            drugDictReqVo.setOpsSystem("HIS");
            drugDictReqVo.setOpWinid("");
            drugDictReqVo.setOpType("101");
            drugDictReqVo.setOpIp("");
            drugDictReqVo.setOpManno("130188");
            drugDictReqVo.setOpManName("HIS");
            drugDictReqVo.setConsisBasicDrugsvw(consisBasicDrugsvw);
            return ResponseData.success((Object)drugDictReqVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.error((String)"inventoryResVo");
        }
    }

    public ResponseData<ZkBusinessResVo> queryPrecription(String xml) {
        ResponseData medicalRespose;
        ZkBusinessResVo zkBusinessResVo = new ZkBusinessResVo();
        PrescriptionBusinessReqVo prescriptionBusinessReqVo = (PrescriptionBusinessReqVo)XmlUtil.convertToJavaBean((String)xml, PrescriptionBusinessReqVo.class);
        OutpatientInfomationDto outpatientInfomationDto = new OutpatientInfomationDto();
        outpatientInfomationDto.setPrescriptionNo(prescriptionBusinessReqVo.getPatientCard());
        ResponseData responseData = this.outpatientServiceFeign.queryPrescriptionsByNo(outpatientInfomationDto, this.tenantId, this.userId, this.userName);
        if (!responseData.isSuccess()) {
            return ResponseData.error((String)"");
        }
        zkBusinessResVo.setOpIp("");
        zkBusinessResVo.setOpManName("");
        zkBusinessResVo.setOpType("");
        zkBusinessResVo.setOpWinid("");
        ArrayList<ConsisPrescMstvw> prescList = new ArrayList<ConsisPrescMstvw>();
        ConsisPrescMstvw consisPrescMstvw = new ConsisPrescMstvw();
        String presJson = JSONObject.toJSONString((Object)responseData.getData());
        presJson.replaceAll("<", "&lt;");
        presJson.replaceAll(">", "&gt;");
        presJson.replaceAll("&", "&amp;");
        QueryPrescriptionsVo queryPrescriptionsVo = (QueryPrescriptionsVo)JSONObject.parseObject((String)presJson, QueryPrescriptionsVo.class);
        QueryOrderDto queryOrderDto = new QueryOrderDto();
        queryOrderDto.setOutpatientNo(queryPrescriptionsVo.getOutpatientNo());
        queryOrderDto.setPrescriptionNo(queryPrescriptionsVo.getPrescriptionNo());
        queryOrderDto.setTenantId(this.tenantId);
        ResponseData orderResponse = this.outpatientServiceFeign.queryOrderByPresNoAndOutNo(queryOrderDto, this.tenantId);
        if (orderResponse == null || !orderResponse.isSuccess()) {
            log.info("\u8ba2\u5355\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)orderResponse));
            return ResponseData.error((String)"\u8ba2\u5355\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        List orderData = JSON.parseArray((String)JSON.toJSONString((Object)orderResponse.getData()), OutOrder.class);
        if (Objects.isNull(orderData) || orderData.isEmpty()) {
            return ResponseData.error((String)"\u8ba2\u5355\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        OutOrder outOrder = (OutOrder)orderData.get(0);
        if (10 == outOrder.getPaymentStatus() && 10 != outOrder.getDeliveryStatus()) {
            return ResponseData.error((String)"\u8ba2\u5355\u672a\u652f\u4ed8\u5b8c");
        }
        ResponseData admissionResponse = this.outpatientServiceFeign.queryByOutpatientNo(queryPrescriptionsVo.getOutpatientNo(), this.tenantId);
        if (admissionResponse.isSuccess()) {
            String admPresJson = JSONObject.toJSONString((Object)admissionResponse.getData());
            admPresJson.replaceAll("<", "&lt;");
            admPresJson.replaceAll(">", "&gt;");
            admPresJson.replaceAll("&", "&amp;");
            AdmissionDetailVo admissionDetailVo = (AdmissionDetailVo)JSONObject.parseObject((String)admPresJson, AdmissionDetailVo.class);
            consisPrescMstvw.setPatientId(String.valueOf(admissionDetailVo.getPatientId()));
            consisPrescMstvw.setPatinetName(admissionDetailVo.getPatientName());
            consisPrescMstvw.setDateOfBirth(IdCardUtil.getBirthByIdCard((String)admissionDetailVo.getPatientCardNo()));
            consisPrescMstvw.setSex(IdCardUtil.getGenderByIdCard((String)admissionDetailVo.getPatientCardNo()).equals("M") ? "\u7537" : "\u5973");
        }
        if ((medicalRespose = this.outpatientServiceFeign.queryOutpatientMedicalRecords(outpatientInfomationDto, this.tenantId, this.userId, this.userName)).isSuccess()) {
            String medPresJson = JSONObject.toJSONString((Object)medicalRespose.getData());
            medPresJson.replaceAll("<", "&lt;");
            medPresJson.replaceAll(">", "&gt;");
            medPresJson.replaceAll("&", "&amp;");
            QueryOutpatientMedicalRecordsVo queryOutpatientInfomationVo = (QueryOutpatientMedicalRecordsVo)JSONObject.parseObject((String)medPresJson, QueryOutpatientMedicalRecordsVo.class);
            List diagnosis = queryOutpatientInfomationVo.getDiagnosis();
            String rcptInfo = "";
            for (Out_DiagnosisDto diagno : diagnosis) {
                rcptInfo = rcptInfo + diagno.getDiagnosis() + ",";
            }
            consisPrescMstvw.setRcptInfo(rcptInfo);
        }
        consisPrescMstvw.setPrescDate(String.valueOf(queryPrescriptionsVo.getIssueTime()));
        consisPrescMstvw.setPrescNo(queryPrescriptionsVo.getPrescriptionNo());
        consisPrescMstvw.setDispensary(prescriptionBusinessReqVo.getDispensary());
        consisPrescMstvw.setInvoiceNo(queryPrescriptionsVo.getPrescriptionNo());
        consisPrescMstvw.setPatientType("00");
        consisPrescMstvw.setPrescIdentity("");
        consisPrescMstvw.setChargeType("");
        consisPrescMstvw.setPrescAttr("\u5904\u65b9");
        consisPrescMstvw.setPrescInfo("");
        consisPrescMstvw.setRcptRemark(String.valueOf(queryPrescriptionsVo.getDeliveryStatus()));
        consisPrescMstvw.setRepetition(String.valueOf(queryPrescriptionsVo.getTotalDrugQuantity()));
        consisPrescMstvw.setCosts(queryPrescriptionsVo.getTotalPrescriptionAmount().toString());
        consisPrescMstvw.setPayments(queryPrescriptionsVo.getTotalPrescriptionAmount().toString());
        consisPrescMstvw.setOrderedBy(String.valueOf(queryPrescriptionsVo.getPrescribingDepartmentId()));
        consisPrescMstvw.setOrderedByName(queryPrescriptionsVo.getPrescribingDepartmentName());
        consisPrescMstvw.setPrescribedBy(queryPrescriptionsVo.getPrescribingDoctorName());
        consisPrescMstvw.setEnteredBY(queryPrescriptionsVo.getPrescribingDoctorName());
        consisPrescMstvw.setDispensePri("1");
        ArrayList<ConsisPrescDetlvm> prescDetail = new ArrayList<ConsisPrescDetlvm>();
        List drugList = queryPrescriptionsVo.getDrugList();
        for (int i = 0; i < drugList.size(); ++i) {
            WesternMedicineDrugsVo drugDetail = (WesternMedicineDrugsVo)drugList.get(i);
            ConsisPrescDetlvm drug = new ConsisPrescDetlvm();
            drug.setPrescNo(queryPrescriptionsVo.getPrescriptionNo());
            drug.setItemNo(String.valueOf(i));
            drug.setAdviceCode(queryPrescriptionsVo.getPrescriptionNo());
            drug.setDrugCode(String.valueOf(drugDetail.getInternalCode()));
            drug.setDrugSpec(drugDetail.getSpecification());
            drug.setDrugName(drugDetail.getDrugName());
            drug.setFirmId("1");
            drug.setFirmName(drugDetail.getManufacturer());
            drug.setPackageSpec(drugDetail.getSpecification());
            drug.setPackageUnits(drugDetail.getQuantityUnit());
            drug.setQuantity(String.valueOf(drugDetail.getQuantity()));
            drug.setUnit(drugDetail.getDoseUnit());
            drug.setCosts(String.valueOf(drugDetail.getTotalDrugAmount()));
            drug.setPayments(String.valueOf(drugDetail.getTotalDrugAmount()));
            drug.setDosage(String.valueOf(drugDetail.getSingleDose()));
            drug.setDosageUnits(drugDetail.getDoseUnit());
            drug.setAdministration("");
            drug.setFrequency("");
            drug.setAdditionusage(drugDetail.getSpecialNotes());
            drug.setRcptRemark(drugDetail.getSpecialNotes());
            prescDetail.add(drug);
        }
        consisPrescMstvw.setConsisPrescDetlvm(prescDetail);
        prescList.add(consisPrescMstvw);
        zkBusinessResVo.setConsisPrescMstvw(prescList);
        zkBusinessResVo.setOpsSystem("HIS");
        zkBusinessResVo.setOpWinid("");
        zkBusinessResVo.setOpType("201");
        zkBusinessResVo.setOpIp("");
        zkBusinessResVo.setOpManno("130188");
        zkBusinessResVo.setOpManName("HIS");
        return ResponseData.success((Object)zkBusinessResVo);
    }

    public ResponseData<BaseReturnVo> dispensary(String xml) {
        try {
            BaseReturnVo dispensaryResVo = new BaseReturnVo();
            ZkBusinessResVo zkBusinessResVo = (ZkBusinessResVo)XmlUtil.convertToJavaBean((String)xml, ZkBusinessResVo.class);
            ConsisPrescMstvw consisPrescMstvw = (ConsisPrescMstvw)zkBusinessResVo.getConsisPrescMstvw().get(0);
            String adviceCode = ((ConsisPrescDetlvm)consisPrescMstvw.getConsisPrescDetlvm().get(0)).getAdviceCode();
            OutPrescriptionDto outPrescriptionDto = new OutPrescriptionDto();
            outPrescriptionDto.setOperatorSource(SourceEnum.OFFLINE.getValue());
            outPrescriptionDto.setPrescriptionNo(adviceCode);
            ResponseData responseData = this.outpatientServiceFeign.dispenseMedicine(outPrescriptionDto, this.tenantId, this.userId, this.userName);
            if (!responseData.isSuccess()) {
                ResponseData.error((String)"dispensaryResVo");
            }
            return ResponseData.success((Object)dispensaryResVo);
        }
        catch (Exception e) {
            log.info("=======\u6263\u9664\u5e93\u5b58\u9519\u8bef\uff01=========");
            return ResponseData.error((String)"dispensaryResVo");
        }
    }

    public ResponseData<InventoryResVo> queryDrugInventory(String xml) {
        try {
            InventoryResVo inventoryResVo = new InventoryResVo();
            ArrayList drugQty = new ArrayList();
            inventoryResVo.setRetcode("1");
            inventoryResVo.setHisConsisStorageChkqtyvm(drugQty);
            return ResponseData.success((Object)inventoryResVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.error((String)"inventoryResVo");
        }
    }
}

