/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import cn.hutool.json.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sdk.config.minio.MinioUtil;
import com.byh.sdk.entity.call.back.CallBackStatus;
import com.byh.sdk.entity.call.back.CallBackTicket;
import com.byh.sdk.entity.call.back.CallBackTicketEntry;
import com.byh.sdk.mapper.call.CallStatusMapper;
import com.byh.sdk.mapper.call.CallTicketMapper;
import com.byh.sdk.service.MakeCallBackService;
import com.byh.sdk.util.ResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DS(value="mysql3")
public class MakeCallBackServiceImpl
extends ServiceImpl<CallTicketMapper, CallBackTicket>
implements MakeCallBackService {
    @Autowired
    private CallStatusMapper callStatusMapper;
    @Autowired
    private CallTicketMapper callTicketMapper;
    @Autowired
    private MinioUtil minioUtil;

    public ResponseData callStatus(CallBackStatus callBackStatus) {
        this.callStatusMapper.saveCallBackStatus(callBackStatus);
        return ResponseData.success();
    }

    public ResponseData callTicket(CallBackTicket callBackTicket) {
        this.callTicketMapper.saveCallBackTicket(callBackTicket);
        return ResponseData.success();
    }

    public void updateUrl(String recordUrl, String callSid) {
        JSONObject jsonObject = this.minioUtil.upload(recordUrl);
        CallBackTicket callBackTicket = new CallBackTicket();
        callBackTicket.setCallSid(callSid);
        CallBackTicketEntry callBackTicketEntry = new CallBackTicketEntry();
        callBackTicketEntry.setDataCenterRecordUrl(jsonObject.getStr((Object)"url"));
        callBackTicket.setEntry(callBackTicketEntry);
        this.callTicketMapper.updateCallBackTicket(callBackTicket);
    }
}

