/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.entity.base.FrontRequest;
import com.byh.sdk.entity.base.FrontResponse;
import com.byh.sdk.entity.order.FeeBillCreationDto;
import com.byh.sdk.entity.order.FeeBillCreationVo;
import com.byh.sdk.entity.order.HsPayDto;
import com.byh.sdk.entity.order.HsPreparePayDto;
import com.byh.sdk.entity.order.HsRefundDto;
import com.byh.sdk.entity.order.OnlineHsPayDto;
import com.byh.sdk.entity.order.OnlineHsRefundDto;
import com.byh.sdk.entity.order.OutOrder;
import com.byh.sdk.entity.order.OutOrderPaymentRecord;
import com.byh.sdk.entity.order.PayDto;
import com.byh.sdk.entity.order.PayRefundDto;
import com.byh.sdk.entity.order.PayRefundVo;
import com.byh.sdk.entity.order.PayVo;
import com.byh.sdk.entity.order.QueryOrderDto;
import com.byh.sdk.enums.SourceEnum;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.service.OrderService;
import com.byh.sdk.util.ResponseData;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrderServiceImpl
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;

    public FrontResponse createCharge(FrontRequest<FeeBillCreationDto> param) {
        log.info("\u9884\u652f\u4ed8\u5165\u53c2:{}", (Object)JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            FeeBillCreationDto body = (FeeBillCreationDto)param.getBody();
            QueryOrderDto queryOrderDto = new QueryOrderDto();
            queryOrderDto.setTenantId(tenantId);
            queryOrderDto.setOutpatientNo(body.getOutpatientNo());
            queryOrderDto.setMainId(body.getMainId());
            queryOrderDto.setOrderType(body.getOrderType());
            ResponseData orderResponse = this.outpatientServiceFeign.queryOrderByMainIdAndOutNo(queryOrderDto, tenantId);
            if (orderResponse == null || !orderResponse.isSuccess()) {
                log.info("\u8ba2\u5355\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)body), (Object)JSON.toJSONString((Object)orderResponse));
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)orderResponse.getMsg());
            }
            List orderData = JSON.parseArray((String)JSON.toJSONString((Object)orderResponse.getData()), OutOrder.class);
            if (CollectionUtils.isEmpty((Collection)orderData)) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u672a\u627e\u5230\u8ba2\u5355\u4fe1\u606f");
            }
            List orderNoList = orderData.stream().map(x -> x.getOrderNo()).collect(Collectors.toList());
            body.setOrderNoList(orderNoList);
            body.setPayOrderName("\u5357\u660c\u4f17\u5eb7\u533b\u9662\u6709\u9650\u516c\u53f8");
            body.setSource(SourceEnum.ONLINE.getValue());
            body.setOperatorSource(SourceEnum.ONLINE.getValue());
            ResponseData orderChargeResponseData = this.outpatientServiceFeign.orderCharge(body, tenantId, param.getOperatorId(), param.getOperatorName());
            if (orderChargeResponseData == null || !orderChargeResponseData.isSuccess()) {
                log.info("\u8ba2\u5355\u9884\u652f\u4ed8\u521b\u5efa\u5931\u8d25\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)body), (Object)JSON.toJSONString((Object)orderChargeResponseData));
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)orderChargeResponseData.getMsg());
            }
            FeeBillCreationVo creationVo = (FeeBillCreationVo)JSON.parseObject((String)JSON.toJSONString((Object)orderChargeResponseData.getData()), FeeBillCreationVo.class);
            return FrontResponse.success((String)param.getTransactionId(), (Object)creationVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u9884\u652f\u4ed8\u64cd\u4f5c\u5f02\u5e38:{}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u9884\u652f\u4ed8\u64cd\u4f5c\u5f02\u5e38");
        }
    }

    public FrontResponse payment(FrontRequest<PayDto> param) {
        log.info("\u8ba2\u5355\u652f\u4ed8\u5165\u53c2:{}", (Object)JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            PayDto body = (PayDto)param.getBody();
            body.setSource(SourceEnum.ONLINE.getValue());
            body.setTenantId(tenantId);
            body.setOperatorSource(SourceEnum.ONLINE.getValue());
            ResponseData orderResponse = this.outpatientServiceFeign.payment(body, tenantId, param.getOperatorId(), param.getOperatorName());
            if (orderResponse == null || !orderResponse.isSuccess()) {
                log.info("\u8ba2\u5355\u652f\u4ed8\u5931\u8d25\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)body), (Object)JSON.toJSONString((Object)orderResponse));
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)orderResponse.getMsg());
            }
            PayVo payVo = (PayVo)JSON.parseObject((String)JSON.toJSONString((Object)orderResponse.getData()), PayVo.class);
            return FrontResponse.success((String)param.getTransactionId(), (Object)payVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8ba2\u5355\u652f\u4ed8\u64cd\u4f5c\u5f02\u5e38:{}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u8ba2\u5355\u652f\u4ed8\u64cd\u4f5c\u5f02\u5e38");
        }
    }

    public FrontResponse refund(FrontRequest<PayRefundDto> param) {
        log.info("\u8ba2\u5355\u9000\u6b3e\u5165\u53c2:{}", (Object)JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            PayRefundDto body = (PayRefundDto)param.getBody();
            body.setTenantId(tenantId);
            String transactionNumber = body.getTransactionNumber();
            ResponseData orderDataResponse = this.outpatientServiceFeign.queryOrderByNumber(transactionNumber, tenantId, param.getOperatorId(), param.getOperatorName());
            if (orderDataResponse == null || !orderDataResponse.isSuccess()) {
                log.info("\u9000\u6b3e\u8ba2\u5355\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)transactionNumber, (Object)JSON.toJSONString((Object)orderDataResponse));
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u9000\u6b3e\u8ba2\u5355\u67e5\u8be2\u5931\u8d25!");
            }
            if (Objects.isNull(orderDataResponse.getData())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u8ba2\u5355\u4fe1\u606f!");
            }
            List data = JSON.parseArray((String)JSON.toJSONString((Object)orderDataResponse.getData()), OutOrderPaymentRecord.class);
            List orderNoList = data.stream().map(x -> x.getOrderNo()).collect(Collectors.toList());
            body.setOrderNoList(orderNoList);
            body.setPayOrderNo(((OutOrderPaymentRecord)data.get(0)).getPayOrderNo());
            body.setRefundMethod(Integer.valueOf(1));
            body.setSource(SourceEnum.ONLINE.getValue());
            body.setOperatorSource(SourceEnum.ONLINE.getValue());
            ResponseData orderResponse = this.outpatientServiceFeign.refund(body, tenantId, param.getOperatorId(), param.getOperatorName());
            if (orderResponse == null || !orderResponse.isSuccess()) {
                log.info("\u8ba2\u5355\u9000\u6b3e\u5931\u8d25\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)body), (Object)JSON.toJSONString((Object)orderResponse));
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)orderResponse.getMsg());
            }
            PayRefundVo payRefundVo = (PayRefundVo)JSON.parseObject((String)JSON.toJSONString((Object)orderResponse.getData()), PayRefundVo.class);
            return FrontResponse.success((String)param.getTransactionId(), (Object)payRefundVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8ba2\u5355\u9000\u6b3e\u64cd\u4f5c\u5f02\u5e38:{}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u8ba2\u5355\u9000\u6b3e\u64cd\u4f5c\u5f02\u5e38");
        }
    }

    public FrontResponse hsPayment(FrontRequest<OnlineHsPayDto> param) {
        log.info("\u533b\u4fdd\u8ba2\u5355\u652f\u4ed8\u5165\u53c2:{}", (Object)JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            OnlineHsPayDto body = (OnlineHsPayDto)param.getBody();
            body.setTenantId(tenantId);
            body.setOperatorSource(SourceEnum.ONLINE.getValue());
            ResponseData orderResponse = this.outpatientServiceFeign.hsPayment(body, tenantId, param.getOperatorId(), param.getOperatorName());
            if (orderResponse == null || !orderResponse.isSuccess()) {
                log.info("\u533b\u4fdd\u8ba2\u5355\u652f\u4ed8\u5931\u8d25\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)body), (Object)JSON.toJSONString((Object)orderResponse));
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)orderResponse.getMsg());
            }
            Object data = orderResponse.getData();
            return FrontResponse.success((String)param.getTransactionId(), (Object)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8ba2\u5355\u652f\u4ed8\u64cd\u4f5c\u5f02\u5e38:{}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u8ba2\u5355\u652f\u4ed8\u64cd\u4f5c\u5f02\u5e38");
        }
    }

    public FrontResponse hsRefund(FrontRequest<OnlineHsRefundDto> param) {
        log.info("\u533b\u4fdd\u8ba2\u5355\u9000\u6b3e\u5165\u53c2:{}", (Object)JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            OnlineHsRefundDto body = (OnlineHsRefundDto)param.getBody();
            body.setTenantId(tenantId);
            String transactionNumber = body.getTransactionNumber();
            ResponseData orderDataResponse = this.outpatientServiceFeign.queryOrderByNumber(transactionNumber, tenantId, param.getOperatorId(), param.getOperatorName());
            if (orderDataResponse == null || !orderDataResponse.isSuccess()) {
                log.info("\u9000\u6b3e\u8ba2\u5355\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)transactionNumber, (Object)JSON.toJSONString((Object)orderDataResponse));
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u9000\u6b3e\u8ba2\u5355\u67e5\u8be2\u5931\u8d25!");
            }
            if (Objects.isNull(orderDataResponse.getData())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u8ba2\u5355\u4fe1\u606f!");
            }
            List data = JSON.parseArray((String)JSON.toJSONString((Object)orderDataResponse.getData()), OutOrderPaymentRecord.class);
            String payOrderNo = ((OutOrderPaymentRecord)data.get(0)).getPayOrderNo();
            body.setPayOrderNo(payOrderNo);
            body.setOperatorSource(SourceEnum.ONLINE.getValue());
            ResponseData orderResponse = this.outpatientServiceFeign.hsRefund(body, tenantId, param.getOperatorId(), param.getOperatorName());
            if (orderResponse == null || !orderResponse.isSuccess()) {
                log.error("\u533b\u4fdd\u8ba2\u5355\u9000\u6b3e\u5931\u8d25\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)body), (Object)JSON.toJSONString((Object)orderResponse));
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)orderResponse.getMsg());
            }
            PayRefundVo payRefundVo = (PayRefundVo)JSON.parseObject((String)JSON.toJSONString((Object)orderResponse.getData()), PayRefundVo.class);
            return FrontResponse.success((String)param.getTransactionId(), (Object)payRefundVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u533b\u4fdd\u8ba2\u5355\u9000\u6b3e\u64cd\u4f5c\u5f02\u5e38:{}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u533b\u4fdd\u8ba2\u5355\u9000\u6b3e\u64cd\u4f5c\u5f02\u5e38");
        }
    }

    public FrontResponse<Object> ihosHsPreparePay(FrontRequest<HsPreparePayDto> param) {
        HsPreparePayDto hsPreparePayDto = (HsPreparePayDto)param.getBody();
        hsPreparePayDto.setPayOrderName("\u5357\u660c\u4f17\u5eb7\u533b\u9662\u6709\u9650\u516c\u53f8");
        hsPreparePayDto.setAcctUsedFlag("1");
        hsPreparePayDto.setPsnSetlway("01");
        hsPreparePayDto.setMdtrtCertType("01");
        hsPreparePayDto.setPsnCertType("01");
        hsPreparePayDto.setMdtrtCertNo(hsPreparePayDto.getCardNo());
        if ("369900".equals(hsPreparePayDto.getInsuplcAdmdvs())) {
            hsPreparePayDto.setSettlementMethod(Integer.valueOf(4));
        } else {
            hsPreparePayDto.setSettlementMethod(Integer.valueOf(3));
        }
        hsPreparePayDto.setOperatorSource("3");
        log.info("\u533b\u4fdd\u9884\u7ed3\u7b97\u5165\u53c2\uff1a" + JSON.toJSONString((Object)hsPreparePayDto));
        ResponseData responseData = this.outpatientServiceFeign.ihosHsPreparePayment(hsPreparePayDto, param.getTenantId(), param.getOperatorId(), param.getOperatorName());
        if (!responseData.isSuccess()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)responseData.getMsg());
        }
        log.info("\u533b\u4fdd\u9884\u7ed3\u7b97\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)responseData));
        return FrontResponse.success((String)param.getTransactionId(), (Object)responseData.getData());
    }

    public FrontResponse<String> ihosHsPayment(FrontRequest<HsPayDto> param) {
        HsPayDto hsPayDto = (HsPayDto)param.getBody();
        hsPayDto.setPaymentMethod(Integer.valueOf(11));
        hsPayDto.setOperatorSource("3");
        ResponseData stringResponseData = this.outpatientServiceFeign.hsPayment(hsPayDto, param.getTenantId(), param.getOperatorId(), param.getOperatorName());
        log.info("\u533b\u4fdd\u7ed3\u7b97\u8fd4\u56de" + JSONObject.toJSONString((Object)stringResponseData));
        if (!stringResponseData.isSuccess() || Objects.isNull(stringResponseData.getData())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u7ed3\u7b97\u5931\u8d25\uff01");
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)stringResponseData.getData());
    }

    public FrontResponse ihosHsRefund(FrontRequest<HsRefundDto> param) {
        HsRefundDto body = (HsRefundDto)param.getBody();
        body.setOperatorSource(SourceEnum.IHOS_ONLINE.getValue());
        ResponseData orderResponse = this.outpatientServiceFeign.ihosHsRefund(body, param.getTenantId(), param.getOperatorId(), param.getOperatorName());
        if (!orderResponse.isSuccess()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)orderResponse.getMsg());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)orderResponse.getData());
    }
}

