/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sdk.entity.ve.AdmissionEntity;
import com.byh.sdk.entity.ve.OutMedicalRecord;
import com.byh.sdk.entity.ve.OutVeHsSettlementInfoEntity;
import com.byh.sdk.entity.ve.VeVisitInfoDto;
import com.byh.sdk.mapper.OutAdmissionMapper;
import com.byh.sdk.mapper.OutMedicalRecordDiagnosisMapper;
import com.byh.sdk.mapper.OutMedicalRecordMapper;
import com.byh.sdk.mapper.OutPrescriptionDrugMapper;
import com.byh.sdk.mapper.OutPrescriptionMapper;
import com.byh.sdk.mapper.OutVeHsSettlementInfoMapper;
import com.byh.sdk.service.OutVeHsSettlementInfoService;
import com.byh.sdk.util.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutVeHsSettlementInfoServiceImpl
extends ServiceImpl<OutVeHsSettlementInfoMapper, OutVeHsSettlementInfoEntity>
implements OutVeHsSettlementInfoService {
    private Logger logger = LoggerFactory.getLogger(OutVeHsSettlementInfoServiceImpl.class);
    @Resource
    private OutVeHsSettlementInfoMapper outVeHsSettlementInfoMapper;
    @Resource
    private OutAdmissionMapper outAdmissionMapper;
    @Resource
    private OutMedicalRecordMapper outMedicalRecordMapper;
    @Resource
    private OutMedicalRecordDiagnosisMapper outMedicalRecordDiagnosisMapper;
    @Resource
    private OutPrescriptionMapper outPrescriptionMapper;
    @Resource
    private OutPrescriptionDrugMapper outPrescriptionDrugMapper;

    @Transactional(rollbackFor={BusinessException.class})
    public void insertHsInfo(VeVisitInfoDto dto) {
        Integer createId = 999;
        String createName = "\u5fae\u533b\u6570\u636e";
        Integer tenantId = 999;
        AdmissionEntity admission = dto.getAdmission();
        if (admission != null) {
            OutVeHsSettlementInfoEntity hsSettlementInfo;
            admission.setCreateId(createId);
            admission.setCreateName(createName);
            admission.setTenantId(tenantId);
            this.outAdmissionMapper.insert((Object)admission);
            String outpatientNo = admission.getOutpatientNo();
            String medicalRecordNo = admission.getMedicalRecordNo();
            OutMedicalRecord medicalRecord = dto.getOutMedicalRecord();
            if (medicalRecord != null) {
                medicalRecord.setCreateId(createId);
                medicalRecord.setCreateName(createName);
                medicalRecord.setTenantId(tenantId);
                medicalRecord.setOutpatientNo(outpatientNo);
                medicalRecord.setMedicalRecordNo(medicalRecordNo);
                medicalRecord.setType(Integer.valueOf(1));
                this.outMedicalRecordMapper.insert((Object)medicalRecord);
                if (medicalRecord.getDiagList() != null && !medicalRecord.getDiagList().isEmpty()) {
                    medicalRecord.getDiagList().forEach(vo -> {
                        vo.setTenantId(tenantId);
                        vo.setOutpatientNo(outpatientNo);
                    });
                    this.outMedicalRecordDiagnosisMapper.insertList(medicalRecord.getDiagList());
                }
            }
            List prescList = dto.getPrescList();
            ArrayList prescDrugList = new ArrayList();
            prescList.forEach(vo -> {
                String prescNo = vo.getPrescriptionNo();
                vo.setPrintCount(Integer.valueOf(0));
                vo.setTenantId(tenantId);
                vo.setOutpatientNo(outpatientNo);
                vo.setMedicalRecordNo(medicalRecordNo);
                vo.setAdditionalNotes(createName);
                vo.getOutPrescriptionDrugList().forEach(ele -> {
                    ele.setCreateId(createId);
                    ele.setTenantId(tenantId);
                    ele.setPharmacyName(createName);
                    ele.setPrescriptionNo(prescNo);
                    prescDrugList.add(ele);
                });
            });
            if (prescList != null && !prescList.isEmpty()) {
                this.outPrescriptionMapper.insertList(prescList);
                if (!prescDrugList.isEmpty()) {
                    this.outPrescriptionDrugMapper.insertList(prescDrugList);
                }
            }
            if ((hsSettlementInfo = dto.getOutVeHsSettlementInfo()) != null) {
                hsSettlementInfo.setTenantId(tenantId);
                this.outVeHsSettlementInfoMapper.insert((Object)hsSettlementInfo);
            }
        }
    }
}

