/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sdk.entity.system.GetDrugStoreDto;
import com.byh.sdk.entity.system.GetItemListVo;
import com.byh.sdk.entity.system.GetPharmacyListDto;
import com.byh.sdk.entity.system.SysDrugDirectionEntity;
import com.byh.sdk.entity.system.SysDrugInfoVo;
import com.byh.sdk.entity.system.SysDrugPharmacyVo;
import com.byh.sdk.entity.system.SysDrugStoreInOutInfoVo;
import com.byh.sdk.mapper.sys.SysDrugDirectionMapper;
import com.byh.sdk.service.SysDrugDirectionService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysDrugDirectionServiceImpl
extends ServiceImpl<SysDrugDirectionMapper, SysDrugDirectionEntity>
implements SysDrugDirectionService {
    private Logger logger = LoggerFactory.getLogger(SysDrugDirectionServiceImpl.class);
    @Resource
    private SysDrugDirectionMapper sysDrugDirectionMapper;

    public List<SysDrugStoreInOutInfoVo> selectDrugStoreList(GetDrugStoreDto dto) {
        return this.sysDrugDirectionMapper.selectDrugStoreList(dto);
    }

    public GetItemListVo selectVideoItemList() {
        List outpatientVisitTypeVoList = this.sysDrugDirectionMapper.selectOutpatientVisitList();
        List centralizedMiningDrugVoList = this.sysDrugDirectionMapper.selectCentralizedMiningDrugList();
        List centralizedMiningThreeInDrugVoList = this.sysDrugDirectionMapper.selectCentralizedMiningThreeInDrugList();
        List drugInfoVoList = this.sysDrugDirectionMapper.selectDrugInfoList();
        List treatmentItemVoList = this.sysDrugDirectionMapper.selectTreatmentList();
        GetItemListVo getItemListVo = new GetItemListVo();
        getItemListVo.setOutpatientVisitTypeVoList(outpatientVisitTypeVoList);
        getItemListVo.setCentralizedMiningDrugVoList(centralizedMiningDrugVoList);
        getItemListVo.setCentralizedMiningThreeInDrugVoList(centralizedMiningThreeInDrugVoList);
        getItemListVo.setDrugInfoVoList(drugInfoVoList);
        getItemListVo.setTreatmentItemVoList(treatmentItemVoList);
        return getItemListVo;
    }

    public List<SysDrugPharmacyVo> getDrugPharmacyList(GetPharmacyListDto dto) {
        String startTime = dto.getStartTime();
        String endTime = dto.getEndTime();
        List list = this.sysDrugDirectionMapper.getDrugPharmacyList(startTime, endTime);
        List drugIds = list.stream().filter(vo -> StrUtil.isEmpty((CharSequence)vo.getThirdCode())).map(SysDrugPharmacyVo::getDrugsId).collect(Collectors.toList());
        List drugInfoList = this.sysDrugDirectionMapper.selectDrugList(drugIds);
        Map<String, String> drugInfoMap = drugInfoList.stream().filter(vo -> vo.getThirdCode() != null).collect(Collectors.toMap(SysDrugInfoVo::getDrugId, SysDrugInfoVo::getThirdCode));
        list.forEach(vo -> {
            if (StrUtil.isEmpty((CharSequence)vo.getThirdCode())) {
                vo.setThirdCode((String)drugInfoMap.get(vo.getDrugsId()));
            }
        });
        return list;
    }
}

