/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sdk.entity.OutGroupHistoryMsgEntity;
import com.byh.sdk.mapper.OutGroupHistoryMsgMapper;
import com.byh.sdk.service.IMGenerateService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class HistoryTask {
    private static final Logger log = LoggerFactory.getLogger(HistoryTask.class);
    @Autowired
    private IMGenerateService imGenerateService;
    @Autowired
    private OutGroupHistoryMsgMapper groupHistoryMsgMapper;

    @Scheduled(cron="0 30 2 * * ?")
    @DS(value="mysql3")
    public void pullingHistoryTask() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String timeStr = format.format(new Date());
        List outGroupHistoryMsgEntities = this.groupHistoryMsgMapper.selectList((Wrapper)Wrappers.lambdaQuery());
        log.info("\u5f00\u59cb\u62c9\u53d6\u7fa4\u7ec4\u6d88\u606f\uff0c\u62c9\u53d6\u65f6\u95f4========{}\uff0c\u62c9\u53d6\u7fa4\u7ec4\u4e2a\u6570========={}", (Object)timeStr, (Object)outGroupHistoryMsgEntities.size());
        for (OutGroupHistoryMsgEntity outGroupHistoryMsgEntity : outGroupHistoryMsgEntities) {
            String history = outGroupHistoryMsgEntity.getHistory();
            JSONArray jsonArray = JSONArray.parseArray((String)history);
            String lastMsgSeq = outGroupHistoryMsgEntity.getLastMsgSeq();
            JSONArray arr = this.pullingHistory(null, Integer.valueOf(Integer.parseInt(lastMsgSeq)), outGroupHistoryMsgEntity.getGroupId());
            if (arr.size() == 0) continue;
            jsonArray.addAll((Collection)arr);
            jsonArray = this.deduplicateByMsgSeq(jsonArray).getJSONArray(0);
            jsonArray.sort((a, b) -> ((JSONObject)a).getInteger("MsgSeq") - ((JSONObject)b).getInteger("MsgSeq"));
            outGroupHistoryMsgEntity.setLastMsgSeq(jsonArray.getJSONObject(jsonArray.size() - 1).getString("MsgSeq"));
            outGroupHistoryMsgEntity.setHistory(jsonArray.toString());
            outGroupHistoryMsgEntity.setUpdateTime(timeStr);
            this.groupHistoryMsgMapper.update((Object)outGroupHistoryMsgEntity, (Wrapper)Wrappers.lambdaUpdate().eq(OutGroupHistoryMsgEntity::getGroupId, (Object)outGroupHistoryMsgEntity.getGroupId()));
        }
        log.info("\u62c9\u53d6\u7ed3\u675f\uff01");
    }

    public JSONArray deduplicateByMsgSeq(JSONArray originalArray) {
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
        HashSet<String> msgSeqSet = new HashSet<String>();
        if (originalArray == null || originalArray.isEmpty()) {
            return new JSONArray();
        }
        for (Object obj : originalArray) {
            JSONObject jsonObject;
            Object msgSeqObj;
            if (!(obj instanceof JSONObject) || (msgSeqObj = (jsonObject = (JSONObject)obj).get((Object)"MsgSeq")) == null) continue;
            String msgSeq = msgSeqObj.toString();
            if (!msgSeqSet.contains(msgSeq) && !jsonObject.containsKey((Object)"$ref")) {
                System.out.println("Adding MsgSeq: " + msgSeq);
                resultList.add(jsonObject);
                msgSeqSet.add(msgSeq);
                continue;
            }
            System.out.println("Skipping duplicate MsgSeq: " + msgSeq);
        }
        return new JSONArray(Collections.singletonList(resultList));
    }

    private JSONArray pullingHistory(JSONArray arr, Integer lastSeq, String groupId) {
        JSONObject param = new JSONObject();
        param.put("GroupId", (Object)groupId);
        param.put("ReqMsgNumber", (Object)20);
        if (arr == null) {
            arr = this.imGenerateService.getGroupMsgHistory(param).getJSONArray("RspMsgList");
            int c = 0;
            for (int i = 0; i < arr.size(); ++i) {
                Integer msgSeq = arr.getJSONObject(i).getInteger("MsgSeq");
                if (msgSeq <= lastSeq) {
                    arr.remove(i);
                    --i;
                    ++c;
                }
                if (c == arr.size()) break;
            }
            if (arr.size() == 0) {
                return arr;
            }
        }
        JSONObject jsonObject = arr.getJSONObject(0);
        int msgSeq = jsonObject.getInteger("MsgSeq") + 1;
        param.put("ReqMsgSeq", (Object)msgSeq);
        JSONObject groupMsgHistory = this.imGenerateService.getGroupMsgHistory(param);
        JSONArray rspMsgList = groupMsgHistory.getJSONArray("RspMsgList");
        for (int i = 0; i < rspMsgList.size(); ++i) {
            JSONObject json = rspMsgList.getJSONObject(i);
            msgSeq = json.getInteger("MsgSeq");
            if (lastSeq >= msgSeq) continue;
            arr.add((Object)jsonObject);
        }
        Integer minSeq = rspMsgList.getJSONObject(rspMsgList.size() - 1).getInteger("MsgSeq");
        if (minSeq > lastSeq + 1) {
            this.pullingHistory(arr, lastSeq, groupId);
        }
        return arr;
    }
}

