/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.util;

import com.byh.sdk.util.SendMailUtils;
import com.byh.sdk.util.exception.BusinessException;
import javax.mail.internet.MimeMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class SendMailUtils {
    private String htmlPrefix = "<html><body>";
    private String htmlsuffix = "</body></html>";
    @Autowired
    private JavaMailSender javaMailSender;

    public void sendSimpleEmail(EmailEntity entity) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(entity.getFrom());
        message.setTo(entity.getTo());
        message.setSentDate(entity.getSentDate());
        message.setSubject(entity.getSubject());
        message.setText(entity.getText());
        try {
            this.javaMailSender.send(message);
        }
        catch (MailException e) {
            e.printStackTrace();
            throw new BusinessException("500", "\u7b80\u6613\u90ae\u4ef6\u53d1\u9001\u5931\u8d25");
        }
    }

    public void sendHtmlEmail(EmailEntity entity) {
        MimeMessage message = this.javaMailSender.createMimeMessage();
        try {
            MimeMessageHelper mime = new MimeMessageHelper(message, true);
            mime.setTo(entity.getTo());
            mime.setFrom(entity.getFrom());
            mime.setSubject(entity.getSubject());
            mime.setText(this.htmlPrefix + entity.getText() + this.htmlsuffix, true);
            this.javaMailSender.send(message);
        }
        catch (Exception e) {
            throw new BusinessException("500", "\u53d1\u9001html\u90ae\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38");
        }
    }
}

