/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.util.bot;

import cn.hutool.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class MedicalRecordBotUtils {
    public static String getMd5(String data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(data.getBytes(StandardCharsets.UTF_8));
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String string2Unicode(String str) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return null;
        }
        char[] bytes = str.toCharArray();
        StringBuffer unicode = new StringBuffer();
        for (char c : bytes) {
            if (c >= '\u0000' && c <= '\u007f') {
                unicode.append(c);
                continue;
            }
            String hexString = Integer.toHexString(c);
            unicode.append("\\u");
            if (hexString.length() < 4) {
                unicode.append("0000".substring(hexString.length(), 4));
            }
            unicode.append(hexString);
        }
        return unicode.toString();
    }

    public static String hmacSha256(String secret, String message) throws NoSuchAlgorithmException {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(secret.getBytes(), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKeySpec);
            byte[] rawHmac = mac.doFinal(message.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (byte b : rawHmac) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate HMAC-SHA256", e);
        }
    }

    public static InputStream getSseInputStream(String urlPath) throws IOException {
        URL url = new URL(urlPath);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod("GET");
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setUseCaches(false);
        urlConnection.setRequestProperty("Connection", "Keep-Alive");
        urlConnection.setRequestProperty("Charset", "UTF-8");
        urlConnection.setReadTimeout(60000);
        urlConnection.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        InputStream inputStream = urlConnection.getInputStream();
        BufferedInputStream is = new BufferedInputStream(inputStream);
        return is;
    }
}

