/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.config.es;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ElasticsearchUtils {
    private final Logger logger = LoggerFactory.getLogger(ElasticsearchUtils.class);
    @Resource
    RestHighLevelClient restHighLevelClient;
    private static TransportClient client;

    public Boolean createIndex(String index) throws IOException {
        if (this.isIndexExist(index)) {
            this.logger.error("Index is  exits!");
            return false;
        }
        CreateIndexRequest request = new CreateIndexRequest(index);
        CreateIndexResponse response = this.restHighLevelClient.indices().create(request, RequestOptions.DEFAULT);
        return response.isAcknowledged();
    }

    public boolean isIndexExist(String index) throws IOException {
        GetIndexRequest request = new GetIndexRequest(new String[]{index});
        return this.restHighLevelClient.indices().exists(request, RequestOptions.DEFAULT);
    }

    public boolean deleteIndex(String index) throws IOException {
        if (!this.isIndexExist(index)) {
            this.logger.error("Index is not exits!");
            return false;
        }
        DeleteIndexRequest request = new DeleteIndexRequest(index);
        AcknowledgedResponse delete = this.restHighLevelClient.indices().delete(request, RequestOptions.DEFAULT);
        return delete.isAcknowledged();
    }

    private <T> String getId(T entry) {
        try {
            Field field = entry.getClass().getDeclaredField("id");
            if (null == field || null == field.get(entry)) {
                return IdWorker.getIdStr();
            }
            field.setAccessible(true);
            return field.get(entry).toString();
        }
        catch (Exception e) {
            return IdWorker.getIdStr();
        }
    }

    public <T> int save(String index, T entry) throws Exception {
        if (null == index) {
            throw new Exception("\u7d22\u5f15\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        IndexRequest indexRequest = new IndexRequest(index);
        String id = this.getId(entry);
        String source = JSON.toJSONString(entry);
        indexRequest.id(id).source(source, XContentType.JSON);
        IndexResponse indexResponse = this.restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
        return indexResponse.status().getStatus();
    }

    public <T> int saveBatch(String index, List<T> entryList) throws Exception {
        if (null == index) {
            throw new Exception("The index is null!");
        }
        BulkRequest request = new BulkRequest();
        for (T entry : entryList) {
            String id = this.getId(entry);
            request.add(new IndexRequest(index).id(id).source(JSON.toJSONString(entry), XContentType.JSON));
        }
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
        BulkResponse bulkResponse = this.restHighLevelClient.bulk(request, RequestOptions.DEFAULT);
        return bulkResponse.status().getStatus();
    }

    public <T> int update(String index, T entry) throws Exception {
        if (null == index) {
            throw new Exception("The index is null!");
        }
        Field field = entry.getClass().getDeclaredField("id");
        if (null == field) {
            throw new Exception(" The class is not exist id!");
        }
        field.setAccessible(true);
        String id = field.get(entry).toString();
        UpdateRequest updateRequest = new UpdateRequest(index, id);
        updateRequest.doc(JSON.toJSONString(entry), XContentType.JSON);
        UpdateResponse updateResponse = this.restHighLevelClient.update(updateRequest, RequestOptions.DEFAULT);
        return updateResponse.status().getStatus();
    }

    public int deleteById(String index, String id) throws Exception {
        if (null == index) {
            throw new Exception("The index is null!");
        }
        DeleteRequest deleteRequest = new DeleteRequest(index, id);
        DeleteResponse deleteResponse = this.restHighLevelClient.delete(deleteRequest, RequestOptions.DEFAULT);
        return deleteResponse.status().getStatus();
    }

    public long deleteByQuery(List<String> indexList, QueryBuilder queryBuilder) throws Exception {
        DeleteByQueryRequest deleteRequest = new DeleteByQueryRequest();
        if (CollectionUtils.isNotEmpty(indexList)) {
            deleteRequest.indices(indexList.toArray(new String[indexList.size()]));
        }
        deleteRequest.setQuery(queryBuilder);
        BulkByScrollResponse response = this.restHighLevelClient.deleteByQuery(deleteRequest, RequestOptions.DEFAULT);
        return response.getStatus().getDeleted();
    }

    public SearchResponse getEsInfo() throws Exception {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.source(searchSourceBuilder);
        return this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public <T> List<T> getList(List<String> indexList, QueryBuilder queryBuilder) throws Exception {
        SearchHit[] searchHits;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        SearchRequest searchRequest = null == indexList ? new SearchRequest() : new SearchRequest(indexList.toArray(new String[0]));
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = searchResponse.getHits();
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (SearchHit searchHit : searchHits = hits.getHits()) {
            resultList.add(JSON.parseObject((String)searchHit.getSourceAsString(), (Class)((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0])));
        }
        return resultList;
    }

    public static List<Map<String, Object>> searchListData(String index, String type, QueryBuilder query, Integer size, String fields, String sortField, String highlightField) {
        SearchRequestBuilder searchRequestBuilder = client.prepareSearch(new String[]{index});
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            searchRequestBuilder.setTypes(type.split(","));
        }
        if (StringUtils.isNotEmpty((CharSequence)highlightField)) {
            HighlightBuilder highlightBuilder = new HighlightBuilder();
            highlightBuilder.field(highlightField);
            searchRequestBuilder.highlighter(highlightBuilder);
        }
        searchRequestBuilder.setQuery(query);
        if (StringUtils.isNotEmpty((CharSequence)fields)) {
            searchRequestBuilder.setFetchSource(fields.split(","), null);
        }
        searchRequestBuilder.setFetchSource(true);
        if (StringUtils.isNotEmpty((CharSequence)sortField)) {
            searchRequestBuilder.addSort(sortField, SortOrder.DESC);
        }
        if (size != null && size > 0) {
            searchRequestBuilder.setSize(size.intValue());
        }
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
        long totalHits = searchResponse.getHits().getTotalHits().value;
        long length = searchResponse.getHits().getHits().length;
        if (searchResponse.status().getStatus() == 200) {
            return ElasticsearchUtils.setSearchResponse((SearchResponse)searchResponse, (String)highlightField);
        }
        return null;
    }

    private static List<Map<String, Object>> setSearchResponse(SearchResponse searchResponse, String highlightField) {
        ArrayList<Map<String, Object>> sourceList = new ArrayList<Map<String, Object>>();
        StringBuffer stringBuffer = new StringBuffer();
        for (SearchHit searchHit : searchResponse.getHits().getHits()) {
            searchHit.getSourceAsMap().put("id", searchHit.getId());
            if (StringUtils.isNotEmpty((CharSequence)highlightField)) {
                System.out.println("\u904d\u5386 \u9ad8\u4eae\u7ed3\u679c\u96c6\uff0c\u8986\u76d6 \u6b63\u5e38\u7ed3\u679c\u96c6" + searchHit.getSourceAsMap());
                Text[] text = ((HighlightField)searchHit.getHighlightFields().get(highlightField)).getFragments();
                if (text != null) {
                    for (Text str : text) {
                        stringBuffer.append(str.string());
                    }
                    searchHit.getSourceAsMap().put(highlightField, stringBuffer.toString());
                }
            }
            sourceList.add(searchHit.getSourceAsMap());
        }
        return sourceList;
    }
}

