/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.model.SysMedicalRecordTemplateEntity;
import com.byh.sys.api.model.UpdateMedicalRecordsTemplate;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.QuerySysMedicalRecordsTemplateVo;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysMedicalRecordTemplateService;
import com.github.pagehelper.PageInfo;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SysMedicalRecordTemplateController {
    @Autowired
    private SysMedicalRecordTemplateService sysMedicalRecordTemplateService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/sys/medical/record/template/save"})
    public ResponseData sysMedicalRecordTemplateSave(@RequestBody @Valid UpdateMedicalRecordsTemplate entity) {
        Integer tenant = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        String userName = this.commonRequest.getUserName();
        entity.setCreateName(userName);
        entity.setTenantId(tenant);
        entity.setCreateId(userId);
        this.sysMedicalRecordTemplateService.sysMedicalRecordTemplateSave(entity);
        return ResponseData.success().save();
    }

    @RequestMapping(value={"/sys/medical/record/template/select"})
    public ResponseData sysMedicalRecordTemplateSelect(SysMedicalRecordTemplateEntity entity, Page page) {
        Integer tenant = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        String userName = this.commonRequest.getUserName();
        entity.setCreateId(userId);
        entity.setCreateName(userName);
        entity.setTenantId(tenant);
        entity.setRoleId(this.commonRequest.getUserInfo().getRoleId());
        entity.setUserId(this.commonRequest.getUserId());
        PageInfo list = this.sysMedicalRecordTemplateService.sysMedicalRecordTemplateSelect(entity, page);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/sys/medical/record/template/selectOne"})
    public ResponseData sysMedicalRecordTemplateSelectOne(@RequestBody @Valid SysMedicalRecordTemplateEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        entity.setTenantId(tenant);
        QuerySysMedicalRecordsTemplateVo querySysMedicalRecordsTemplateVo = this.sysMedicalRecordTemplateService.sysMedicalRecordTemplateSelectOne(entity);
        return ResponseData.success((Object)querySysMedicalRecordsTemplateVo);
    }

    @RequestMapping(value={"/sys/medical/record/template/update"})
    public ResponseData sysMedicalRecordTemplateUpdate(@RequestBody @Valid UpdateMedicalRecordsTemplate entity) {
        Integer tenant = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        String userName = this.commonRequest.getUserName();
        entity.setUpdateName(userName);
        entity.setTenantId(tenant);
        entity.setUpdateId(userId);
        this.sysMedicalRecordTemplateService.sysMedicalRecordTemplateUpdate(entity);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/sys/medical/record/template/delete"})
    public ResponseData sysMedicalRecordTemplateDelete(@RequestBody @Valid SysMedicalRecordTemplateEntity entity) {
        this.sysMedicalRecordTemplateService.sysMedicalRecordTemplateDelete(entity);
        return ResponseData.success().delete();
    }
}

