/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.SysDrugDto;
import com.byh.sys.api.dto.drug.SysDrugInDto;
import com.byh.sys.api.excel.listener.DrugListener;
import com.byh.sys.api.excel.listener.DrugVo;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysParamEntity;
import com.byh.sys.api.model.drug.SysDrugClassificationMiddleEntity;
import com.byh.sys.api.model.drug.SysDrugCustomEntity;
import com.byh.sys.api.model.drug.SysDrugDualEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.StringUtils;
import com.byh.sys.api.vo.SysParamVo;
import com.byh.sys.api.vo.drug.ExportDrug;
import com.byh.sys.api.vo.drug.ExportDrugNew;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDictService;
import com.byh.sys.web.service.SysDrugClassificationMiddleService;
import com.byh.sys.web.service.SysDrugCustomService;
import com.byh.sys.web.service.SysDrugDualService;
import com.byh.sys.web.service.SysDrugService;
import com.byh.sys.web.service.SysParamService;
import enums.ConstantsEnums;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/drug"})
public class SysDrugController {
    private static final Logger log = LoggerFactory.getLogger(SysDrugController.class);
    private static Logger logger = LoggerFactory.getLogger(SysDrugController.class);
    private final SysDrugService sysDrugService;
    private final SysDrugDualService sysDrugDualService;
    private final SysDrugCustomService sysDrugCustomService;
    private final CommonRequest commonRequest;
    private final SysDrugClassificationMiddleService drugClassificationMiddleService;
    @Autowired
    private SysParamService paramService;
    @Autowired
    private SysDrugMapper sysDrugMapper;
    private final SysDictService sysDictService;

    @ApiOperation(value="\u5bfc\u5165Excel\u66f4\u65b0\u836f\u54c1\u79cd\u7c7b")
    @PostMapping(value={"/importAndUpdateSpecies"})
    public ResponseData importAndUpdateSpecies(@RequestPart(value="file") MultipartFile file) throws Exception {
        this.sysDrugService.importAndUpdateSpecies(file, this.commonRequest.getTenant());
        return ResponseData.success((Object)"\u5bfc\u5165Excel\u66f4\u65b0\u836f\u54c1\u79cd\u7c7b\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5bfc\u5165\u836f\u54c1\u56fe\u7247")
    @PostMapping(value={"/importDrugImg"})
    public ResponseData importDrugImg(@RequestPart(value="file") MultipartFile file) throws Exception {
        this.sysDrugService.importDrugImg(file, this.commonRequest.getTenant());
        return ResponseData.success((Object)"\u5bfc\u5165\u836f\u54c1\u56fe\u7247\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5bfc\u5165\u5904\u65b9\u6d41\u8f6c\u836f\u54c1")
    @PostMapping(value={"/importDualDrug"})
    public ResponseData importDualDrug(@RequestPart(value="file") MultipartFile file) throws Exception {
        this.sysDrugService.importDualDrug(file, this.commonRequest.getTenant());
        return ResponseData.success((Object)"\u5bfc\u5165\u836f\u54c1\u56fe\u7247\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5bfc\u5165\u6025\u901f\u5f00\u65b9\u836f\u54c1")
    @PostMapping(value={"/importRapidDrug"})
    public ResponseData importRapidDrug(@RequestPart(value="file") MultipartFile file) throws Exception {
        this.sysDrugService.importRapidDrug(file, this.commonRequest.getTenant());
        return ResponseData.success((Object)"\u5bfc\u5165\u6025\u901f\u5f00\u65b9\u836f\u54c1\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5bfc\u5165\u6025\u901f\u5f00\u65b9\u836f\u54c1")
    @PostMapping(value={"/importRapidDrug2"})
    public ResponseData importRapidDrug2(@RequestPart(value="file") MultipartFile file) {
        try {
            this.sysDrugService.importRapidDrug2(file, this.commonRequest.getTenant());
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
        return ResponseData.success((Object)"\u5bfc\u5165\u6025\u901f\u5f00\u65b9\u836f\u54c1\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6279\u91cf\u63d2\u5165\u836f\u54c1\u5e76\u5173\u8054\u836f\u623f")
    @PostMapping(value={"/importDeviceDrug"})
    public ResponseData importDeviceDrug(@RequestBody List<SysDrugEntity> insertDrugList) throws Exception {
        this.sysDrugService.importDeviceDrug(insertDrugList);
        return ResponseData.success((Object)"\u6279\u91cf\u63d2\u5165\u836f\u54c1\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u62f7\u8d1d\u5176\u4ed6\u836f\u623f\u836f\u54c1\u81f3\u5904\u65b9\u6d41\u8f6c\u836f\u623f")
    @GetMapping(value={"/copyDrugToDual"})
    public ResponseData copyDrugToDual(String warehouse) throws Exception {
        if (StringUtils.isBlank((String)warehouse)) {
            return ResponseData.error((String)"\u836f\u623fid\u4e3a\u7a7a\uff01");
        }
        this.sysDrugService.copyDrugToDual(warehouse);
        return ResponseData.success((Object)"\u62f7\u8d1d\u836f\u54c1\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5220\u9664\u5904\u65b9\u6d41\u8f6c\u91cd\u590d\u7684\u836f\u54c1\u4ee5\u53ca\u5173\u8054\u7684\u836f\u623f")
    @GetMapping(value={"/delSimpleByDual"})
    public ResponseData delSimpleByDual() throws Exception {
        this.sysDrugService.delSimpleByDual();
        return ResponseData.success((Object)"\u53bb\u9664\u91cd\u590d\u836f\u54c1\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5bfc\u5165\u66f4\u65b0\u5904\u65b9\u6d41\u8f6c\u836f\u54c1")
    @PostMapping(value={"/importUpdateDualDrug"})
    public ResponseData importUpdateDualDrug(@RequestPart(value="file") MultipartFile file) throws Exception {
        this.sysDrugService.importUpdateDualDrug(file, this.commonRequest.getTenant());
        return ResponseData.success((Object)"\u5bfc\u5165\u836f\u54c1\u56fe\u7247\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5c06\u540c\u5584\u5802\u7684\u836f\u54c1\u8fdb\u884c\u836f\u623f\u5bfc\u5165\u64cd\u4f5c")
    @PostMapping(value={"/drugInventory"})
    @UserOptLogger(operation="\u836f\u54c1\u7ba1\u7406")
    public ResponseData drugInventory(@RequestBody SysDrugInDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setUserId(this.commonRequest.getUserId());
        this.sysDrugService.drugInventory(dto);
        return ResponseData.success((Object)"\u836f\u623f\u5165\u5e93\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5206\u9875", httpMethod="GET", notes="\u5206\u9875")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData pageList(Page page, SysDrugDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.sysDrugService.pageList(page, dto));
    }

    @ApiOperation(value="\u5206\u9875", httpMethod="GET", notes="\u5206\u9875")
    @GetMapping(value={"/pageListByDual"})
    @AntiRefresh
    public ResponseData pageListByDual(Page page, SysDrugDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.sysDrugService.pageListByDual(page, dto));
    }

    @ApiOperation(value="\u5305\u542b\u6d41\u8f6c\u836f\u54c1\u7684\u5206\u9875", httpMethod="GET", notes="\u5206\u9875")
    @GetMapping(value={"/queryDrugPageContainLZ"})
    @AntiRefresh
    public ResponseData queryDrugPageContainLZ(Page page, SysDrugDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.sysDrugService.queryDrugPageContainLZ(page, dto));
    }

    @ApiOperation(value="\u91c7\u8d2d\u5355\u836f\u54c1\u5206\u9875", httpMethod="GET", notes="\u91c7\u8d2d\u5355\u836f\u54c1\u5206\u9875")
    @GetMapping(value={"/pageListByPurchase"})
    @AntiRefresh
    public ResponseData pageListByPurchase(Page page, SysDrugDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.sysDrugService.pageListByPurchase(page, dto));
    }

    @ApiOperation(value="\u836f\u54c1\u6a21\u5757 \u5bfc\u51fa", httpMethod="GET", notes="\u836f\u54c1\u6a21\u5757 \u5bfc\u51fa")
    @GetMapping(value={"/exportDrug"})
    @AntiRefresh
    public void exportDrug(HttpServletResponse response, SysDrugDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        String excelName = "\u836f\u54c1\u76ee\u5f55";
        String sheetName = "";
        if ("1".equals(dto.getDrugsType())) {
            sheetName = "\u4e2d\u6210\u836f\u76ee\u5f55";
        } else if ("2".equals(dto.getDrugsType())) {
            sheetName = "\u897f\u836f\u76ee\u5f55";
        } else if ("3".equals(dto.getDrugsType())) {
            sheetName = "\u4e2d\u836f\u76ee\u5f55";
        }
        SysParamEntity sysParamEntity = new SysParamEntity();
        sysParamEntity.setName("exportDrug");
        sysParamEntity.setTenantId(tenantId);
        SysParamVo sysParamVo = this.paramService.sysParamSelectByName(sysParamEntity);
        if (sysParamVo != null && "on".equals(sysParamVo.getValue())) {
            List records = this.sysDrugService.queryDrugByExport(dto);
            List exportList = BeanUtil.copyList((List)records, ExportDrugNew.class);
            EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)excelName, (String)sheetName, (Object)new ExportDrugNew(), (List)exportList, null);
        } else {
            dto.setTenantId(tenantId);
            Page page = new Page();
            page.setCurrent(1L);
            page.setSize(-1L);
            IPage sysDrugEntityIPage = this.sysDrugService.pageList(page, dto);
            List records = sysDrugEntityIPage.getRecords();
            List exportList = BeanUtil.copyList((List)records, ExportDrug.class);
            EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)excelName, (String)sheetName, (Object)new ExportDrug(), (List)exportList, null);
        }
    }

    @UserOptLogger(operation="\u836f\u54c1\u7ba1\u7406")
    @PostMapping(value={"/saveUpdate"})
    @Transactional(rollbackFor={BusinessException.class})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdates(@RequestBody SysDrugEntity entity) {
        Integer classificationId;
        List drugList;
        if (StringUtils.isBlank((String)entity.getId()) && !StringUtils.isBlank((String)entity.getThirdCode()) && !CollectionUtils.isEmpty((Collection)(drugList = this.sysDrugMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugEntity::getThirdCode, (Object)entity.getThirdCode())).eq(SysDrugEntity::getDelFlag, (Object)"0"))))) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)("\u4e09\u65b9id\uff1a" + entity.getThirdCode() + "\u5df2\u88ab" + ((SysDrugEntity)drugList.get(0)).getDrugsName() + "\u4f7f\u7528\uff0c\u8bf7\u66f4\u6362\u5176\u4ed6\u4e09\u65b9id"));
        }
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        entity.setSignNo(this.commonRequest.getSignNo());
        entity.setUserId(this.commonRequest.getUserId());
        entity.setUserName(this.commonRequest.getUserName());
        this.sysDrugService.saveUpdates(entity);
        if (entity.getClassificationId() != null && 0 != (classificationId = entity.getClassificationId())) {
            SysDrugClassificationMiddleEntity drugClassMiddleEntity = new SysDrugClassificationMiddleEntity();
            drugClassMiddleEntity.setClassificationId(classificationId);
            drugClassMiddleEntity.setDrugId(entity.getId());
            drugClassMiddleEntity.setTenantId(tenantId);
            SysDrugClassificationMiddleEntity one = (SysDrugClassificationMiddleEntity)this.drugClassificationMiddleService.getOne((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugClassificationMiddleEntity::getDrugId, (Object)entity.getId())).eq(SysDrugClassificationMiddleEntity::getTenantId, (Object)tenantId));
            if (StrUtil.isEmptyIfStr((Object)one)) {
                this.drugClassificationMiddleService.save((Object)drugClassMiddleEntity);
            } else {
                this.drugClassificationMiddleService.update((Object)drugClassMiddleEntity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugClassificationMiddleEntity::getDrugId, (Object)entity.getId())).eq(SysDrugClassificationMiddleEntity::getTenantId, (Object)tenantId));
            }
        }
        return ResponseData.success();
    }

    @ApiOperation(value="\u5206\u9875", httpMethod="GET", notes="\u5206\u9875")
    @AntiRefresh
    @GetMapping(value={"/pageListByCustom"})
    public ResponseData pageListByCustom(SysDrugDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        if (ObjectUtil.isNull((Object)dto.getCurrent()) || ObjectUtil.isNull((Object)dto.getSize())) {
            dto.setCurrent(Integer.valueOf(1));
            dto.setSize(Integer.valueOf(30));
        }
        return ResponseData.success((Object)this.sysDrugService.pageListByCustom(new Page((long)dto.getCurrent().intValue(), (long)dto.getSize().intValue()), dto));
    }

    @UserOptLogger(operation="\u836f\u54c1\u7ba1\u7406")
    @PostMapping(value={"/saveUpdateByCustom"})
    @Transactional(rollbackFor={BusinessException.class})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdateByCustom(@RequestBody SysDrugEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        entity.setSignNo(this.commonRequest.getSignNo());
        entity.setUserId(this.commonRequest.getUserId());
        entity.setUserName(this.commonRequest.getUserName());
        return this.sysDrugService.addOrEditDrugCustom(entity);
    }

    @PostMapping(value={"/delDrugCustom"})
    @Transactional(rollbackFor={BusinessException.class})
    @ApiOperation(value="\u5220\u9664", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData delDrugCustom(@RequestBody SysDrugEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        entity.setSignNo(this.commonRequest.getSignNo());
        entity.setUserId(this.commonRequest.getUserId());
        entity.setUserName(this.commonRequest.getUserName());
        return this.sysDrugService.delDrugCustom(entity);
    }

    @UserOptLogger(operation="\u836f\u54c1\u7ba1\u7406")
    @PostMapping(value={"/saveUpdatesByDual"})
    @Transactional(rollbackFor={BusinessException.class})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdatesByDual(@RequestBody SysDrugDualEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        entity.setSignNo(this.commonRequest.getSignNo());
        entity.setUserId(this.commonRequest.getUserId());
        entity.setUserName(this.commonRequest.getUserName());
        this.sysDrugService.saveUpdatesDual(entity);
        return ResponseData.success();
    }

    @GetMapping(value={"/details"})
    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET", notes="\u8be6\u60c5")
    public ResponseData details(SysDrugEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        return ResponseData.success((Object)this.sysDrugService.details(entity));
    }

    @PostMapping(value={"/drugIdDetails"})
    @ApiOperation(value="\u901a\u8fc7\u836f\u54c1id \u8be6\u60c5", httpMethod="POST", notes="\u901a\u8fc7\u836f\u54c1id \u8be6\u60c5")
    public ResponseData<SysDrugEntity> drugIdDetails(@RequestBody SysDrugEntity entity) {
        SysDrugEntity one = (SysDrugEntity)this.sysDrugService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugEntity::getId, (Object)entity.getId())).eq(SysDrugEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(SysDrugEntity::getStatus, (Object)"0")).eq(SysDrugEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        return ResponseData.success((Object)one);
    }

    @PostMapping(value={"/newDrugIdDetails"})
    @ApiOperation(value="\u901a\u8fc7\u836f\u54c1id \u8be6\u60c5", httpMethod="POST", notes="\u9632\u6b62null\u503c\u5e8f\u5217\u5316\u9519\u8bef")
    public ResponseData<SysDrugEntity> newDrugIdDetails(@RequestBody SysDrugEntity entity) {
        SysDrugEntity one = (SysDrugEntity)this.sysDrugService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugEntity::getId, (Object)entity.getId())).eq(SysDrugEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(SysDrugEntity::getStatus, (Object)"0")).eq(SysDrugEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        if (one == null) {
            return ResponseData.error((String)"\u5f53\u524d\u836f\u54c1\u5df2\u88ab\u836f\u623f\u7981\u7528\uff01");
        }
        return ResponseData.success((Object)one);
    }

    @PostMapping(value={"/newDrugIdDetailsByDual"})
    @ApiOperation(value="\u901a\u8fc7\u836f\u54c1id \u8be6\u60c5", httpMethod="POST", notes="\u9632\u6b62null\u503c\u5e8f\u5217\u5316\u9519\u8bef")
    public ResponseData<SysDrugEntity> newDrugIdDetailsByDual(@RequestBody SysDrugEntity entity) {
        SysDrugDualEntity one = (SysDrugDualEntity)this.sysDrugDualService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugDualEntity::getId, (Object)entity.getId())).eq(SysDrugDualEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(SysDrugDualEntity::getStatus, (Object)"0")).eq(SysDrugDualEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        if (one == null) {
            return ResponseData.error((String)"\u5f53\u524d\u836f\u54c1\u5df2\u88ab\u836f\u623f\u7981\u7528\uff01");
        }
        SysDrugEntity copy = (SysDrugEntity)BeanUtil.copy((Object)one, SysDrugEntity.class);
        return ResponseData.success((Object)copy);
    }

    @PostMapping(value={"/newDrugIdDetailsByCustom"})
    @ApiOperation(value="\u901a\u8fc7\u836f\u54c1id \u8be6\u60c5", httpMethod="POST", notes="\u9632\u6b62null\u503c\u5e8f\u5217\u5316\u9519\u8bef")
    public ResponseData<SysDrugEntity> newDrugIdDetailsByCustom(@RequestBody SysDrugEntity entity) {
        SysDrugCustomEntity one = (SysDrugCustomEntity)this.sysDrugCustomService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugCustomEntity::getId, (Object)entity.getId())).eq(SysDrugCustomEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(SysDrugCustomEntity::getStatus, (Object)"0")).eq(SysDrugCustomEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        if (one == null) {
            return ResponseData.error((String)"\u5f53\u524d\u836f\u54c1\u5df2\u88ab\u836f\u623f\u7981\u7528\uff01");
        }
        SysDrugEntity copy = (SysDrugEntity)BeanUtil.copy((Object)one, SysDrugEntity.class);
        return ResponseData.success((Object)copy);
    }

    @PostMapping(value={"drugIds"})
    @ApiOperation(value="\u6279\u91cf\u836f\u54c1id \u96c6\u5408", httpMethod="POST", notes="\u6279\u91cf\u836f\u54c1id \u96c6\u5408")
    public ResponseData<SysDrugEntity> drugIds(@RequestBody List<String> ids) {
        List list = this.sysDrugService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugEntity::getId, ids)).eq(SysDrugEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(SysDrugEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        if (!StrUtil.isEmptyIfStr((Object)list)) {
            list.forEach(a -> {
                a.setDrugsId(a.getId());
                a.setDrugType(a.getDrugsType());
            });
        }
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"drugIdsByDual"})
    @ApiOperation(value="\u6279\u91cf\u836f\u54c1id \u96c6\u5408", httpMethod="POST", notes="\u6279\u91cf\u836f\u54c1id \u96c6\u5408")
    public ResponseData<SysDrugEntity> drugIdsByDual(@RequestBody List<String> ids) {
        SysDrugDto drugDto = new SysDrugDto();
        drugDto.setDrugIds(ids);
        List list = this.sysDrugService.queryDrugByDual(drugDto);
        if (!StrUtil.isEmptyIfStr((Object)list)) {
            list.forEach(a -> {
                a.setDrugsId(a.getId());
                a.setDrugType(a.getDrugsType());
            });
        }
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"drugIdsByDevice"})
    @ApiOperation(value="\u6279\u91cf\u836f\u54c1id \u96c6\u5408", httpMethod="POST", notes="\u6279\u91cf\u836f\u54c1id \u96c6\u5408")
    public ResponseData<SysDrugEntity> drugIdsByDevice(@RequestBody List<String> ids) {
        SysDrugDto drugDto = new SysDrugDto();
        drugDto.setDrugIds(ids);
        List list = this.sysDrugService.queryDrugByDevice(drugDto);
        if (!StrUtil.isEmptyIfStr((Object)list)) {
            list.forEach(a -> {
                a.setDrugsId(a.getId());
                a.setDrugType(a.getDrugsType());
            });
        }
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"drugInternalCodes"})
    @ApiOperation(value="\u6279\u91cf\u836f\u54c1\u5185\u90e8\u7f16\u7801id \u96c6\u5408", httpMethod="POST", notes="\u6279\u91cf\u836f\u54c1\u5185\u90e8\u7f16\u7801id \u96c6\u5408")
    public ResponseData<SysDrugEntity> drugInternalCodes(@RequestBody List<String> internalCodes) {
        List list = this.sysDrugService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugEntity::getInternalCode, internalCodes)).eq(SysDrugEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(SysDrugEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        return ResponseData.success((Object)list);
    }

    @UserOptLogger(operation="\u836f\u54c1\u6a21\u5757")
    @PostMapping(value={"/removeSysDrug"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public ResponseData removeSysDrug(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody String[] ids) {
        return ResponseData.success((Object)this.sysDrugService.removeSysDrug(ids));
    }

    @UserOptLogger(operation="\u836f\u54c1\u6a21\u5757")
    @PostMapping(value={"/drugStatus"})
    @ApiOperation(value="\u542f\u52a8/\u6682\u505c", httpMethod="POST", notes="\u542f\u52a8/\u6682\u505c")
    public ResponseData drugStatus(@RequestBody SysDrugEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysDrugService.drugStatus(entity));
    }

    @UserOptLogger(operation="\u836f\u54c1\u6a21\u5757")
    @PostMapping(value={"/drugStatusByDual"})
    @ApiOperation(value="\u542f\u52a8/\u6682\u505c", httpMethod="POST", notes="\u542f\u52a8/\u6682\u505c")
    public ResponseData drugStatusByDual(@RequestBody SysDrugDualEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysDrugService.drugStatus(entity));
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="[\u4e2d\u836f]\u666e\u901a\u5bfc\u5165 Excel", httpMethod="POST", notes="[\u4e2d\u836f]\u666e\u901a\u5bfc\u5165 Excel")
    public ResponseData importX(@RequestPart(value="file") MultipartFile file) throws IOException {
        List userList = EasyExcelUtil.importExcel((MultipartFile)file, (Object)new DrugVo(), (Object)new DrugListener());
        List sysDrugEntities = BeanUtil.copyList((List)userList, SysDrugEntity.class);
        this.sysDrugService.saveBatch((Collection)sysDrugEntities, 1000);
        return ResponseData.success((Object)userList);
    }

    public SysDrugController(SysDrugService sysDrugService, SysDrugDualService sysDrugDualService, SysDrugCustomService sysDrugCustomService, CommonRequest commonRequest, SysDrugClassificationMiddleService drugClassificationMiddleService, SysDictService sysDictService) {
        this.sysDrugService = sysDrugService;
        this.sysDrugDualService = sysDrugDualService;
        this.sysDrugCustomService = sysDrugCustomService;
        this.commonRequest = commonRequest;
        this.drugClassificationMiddleService = drugClassificationMiddleService;
        this.sysDictService = sysDictService;
    }
}

