/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.drug.SysDrugInventoryCheckDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.drug.inventory.SysDrugAccessEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugBatchEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryCheckEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryCheckPrescriptionEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugAccessService;
import com.byh.sys.web.service.SysDrugBatchService;
import com.byh.sys.web.service.SysDrugInventoryCheckPrescriptionService;
import com.byh.sys.web.service.SysDrugInventoryCheckService;
import com.byh.sys.web.service.SysDrugInventoryService;
import com.byh.sys.web.service.SysDrugQcQmService;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inventoryCheck"})
public class SysDrugInventoryCheckController {
    private static final Logger log = LoggerFactory.getLogger(SysDrugInventoryCheckController.class);
    private static Logger logger = LoggerFactory.getLogger(SysDrugInventoryCheckController.class);
    private final CommonRequest commonRequest;
    private final SysDrugInventoryCheckService checkService;
    private final SysDrugInventoryCheckPrescriptionService checkPrescriptionService;
    private final SysDrugInventoryService drugInventoryService;
    private final SysDrugQcQmService sysDrugQcQmService;
    private final SysDrugBatchService sysDrugBatchService;
    private final SysDrugAccessService sysDrugAccessService;

    @ApiOperation(value="\u5206\u9875", httpMethod="GET", notes="\u5206\u9875")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData pageList(Page page, SysDrugInventoryCheckDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.checkService.pageList(page, dto));
    }

    @UserOptLogger(operation="\u836f\u5e93\u5e93\u5b58\u76d8\u70b9\u65b0\u589e/\u7f16\u8f91")
    @PostMapping(value={"/saveUpdate"})
    @Transactional(rollbackFor={Exception.class})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdate(@RequestBody SysDrugInventoryCheckDto dto) {
        List list = this.checkService.list((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryCheckEntity::getAuditStatus, (Object)"1"));
        if (list.size() > 0) {
            throw new BusinessException("\u836f\u5e93\u76d8\u70b9\u6709\u672a\u5b8c\u6210\u76d8\u70b9\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u5efa\uff01{list}");
        }
        SysDrugInventoryCheckEntity entity = (SysDrugInventoryCheckEntity)BeanUtil.copy((Object)dto, SysDrugInventoryCheckEntity.class);
        Integer tenantId = this.commonRequest.getTenant();
        if (StrUtil.isEmpty((CharSequence)entity.getId())) {
            String guiID = UUIDUtils.getRandom((int)5, (boolean)true);
            entity.setId(guiID);
            entity.setAuditStatus("1");
            entity.setCheckTime(new Date());
            entity.setTenantId(tenantId);
            this.checkService.save((Object)entity);
        } else {
            entity.setUpdateTime(new Date());
            this.checkService.updateById((Object)entity);
            this.checkPrescriptionService.remove((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryCheckPrescriptionEntity::getDrugInventoryCheckId, (Object)dto.getId()));
        }
        List checkPreList = dto.getCheckPreList();
        if (ObjectUtil.isNull((Object)checkPreList)) {
            throw new BusinessException("\u836f\u5e93\u5e93\u5b58\u76d8\u70b9-\u9644\u8868\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01{checkPreList}");
        }
        checkPreList.forEach(a -> {
            String uuid = UUIDUtils.getRandom((int)5, (boolean)true);
            a.setId(uuid);
            a.setDrugInventoryCheckId(entity.getId());
            a.setCreateTime(new Date());
        });
        List checkPresList = BeanUtil.copyList((List)checkPreList, SysDrugInventoryCheckPrescriptionEntity.class);
        this.checkPrescriptionService.saveBatch((Collection)checkPresList, 2000);
        return ResponseData.success((Object)entity).saveUpdate();
    }

    @GetMapping(value={"/details"})
    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET", notes="\u8be6\u60c5")
    public ResponseData details(Page page, SysDrugInventoryCheckPrescriptionEntity entity) {
        return ResponseData.success((Object)this.checkPrescriptionService.page((IPage)page, (Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryCheckPrescriptionEntity::getDrugInventoryCheckId, (Object)entity.getId())));
    }

    @UserOptLogger(operation="\u836f\u5e93\u5e93\u5b58\u76d8\u70b9\u5ba1\u6838\u72b6\u6001")
    @PostMapping(value={"/auditStatus"})
    @Transactional(rollbackFor={Exception.class})
    @ApiOperation(value="\u836f\u5e93\u76d8\u70b9\u5ba1\u6838\u72b6\u6001", httpMethod="POST", notes="\u836f\u5e93\u76d8\u70b9\u5ba1\u6838\u72b6\u6001")
    public ResponseData auditStatus(@RequestBody SysDrugInventoryCheckDto dto) {
        SysDrugInventoryCheckEntity entity = (SysDrugInventoryCheckEntity)BeanUtil.copy((Object)dto, SysDrugInventoryCheckEntity.class);
        String auditStatus = entity.getAuditStatus();
        String userName = this.commonRequest.getUserName();
        if ("5".equals(auditStatus)) {
            this.checkService.removeById((Serializable)entity);
            this.checkPrescriptionService.remove((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryCheckPrescriptionEntity::getDrugInventoryCheckId, (Object)entity.getId()));
            return ResponseData.success();
        }
        if ("2".equals(auditStatus)) {
            entity.setCheckUse(userName);
            this.checkService.updateById((Object)entity);
            this.checkPrescriptionService.remove((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryCheckPrescriptionEntity::getDrugInventoryCheckId, (Object)dto.getId()));
            List checkPreList = dto.getCheckPreList();
            if (ObjectUtil.isNull((Object)checkPreList)) {
                throw new BusinessException("\u836f\u5e93\u5e93\u5b58\u76d8\u70b9-\u9644\u8868\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01{checkPreList}");
            }
            checkPreList.forEach(a -> {
                String uuid = UUIDUtils.getRandom((int)5, (boolean)true);
                a.setId(uuid);
                a.setDrugInventoryCheckId(entity.getId());
                a.setCreateTime(new Date());
            });
            List checkPresList = BeanUtil.copyList((List)checkPreList, SysDrugInventoryCheckPrescriptionEntity.class);
            this.checkPrescriptionService.saveBatch((Collection)checkPresList, 2000);
        }
        if ("3".equals(auditStatus)) {
            entity.setAuditUse(userName);
            int size = dto.getCheckPreList().size();
            entity.setCheckNumber(Integer.valueOf(size));
            this.checkService.updateById((Object)entity);
            List checkPreList = dto.getCheckPreList();
            if (ObjectUtil.isNull((Object)checkPreList)) {
                throw new BusinessException("\u836f\u5e93\u5e93\u5b58\u76d8\u70b9-\u9644\u8868\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01{checkPreList}");
            }
            BigDecimal retailPricePl = entity.getRetailPricePl();
            if (StrUtil.isBlankIfStr((Object)retailPricePl)) {
                throw new BusinessException("\u96f6\u552e\u76c8\u4e8f\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a\uff01{retailPricePl}");
            }
            BigDecimal purchasePricePl = entity.getPurchasePricePl();
            if (StrUtil.isBlankIfStr((Object)purchasePricePl)) {
                throw new BusinessException("\u8fdb\u4ef7\u76c8\u4e8f\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a\uff01{purchasePricePl}");
            }
            BigDecimal actualPricePl = entity.getActualPricePl();
            if (StrUtil.isBlankIfStr((Object)actualPricePl)) {
                throw new BusinessException("\u5b9e\u9645\u96f6\u552e\u603b\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01{actualPricePl}");
            }
            this.checkPrescriptionService.remove((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryCheckPrescriptionEntity::getDrugInventoryCheckId, (Object)entity.getId()));
            this.checkPrescriptionService.saveBatch((Collection)checkPreList, 2000);
            return ResponseData.success();
        }
        if ("4".equals(auditStatus)) {
            this.checkService.updateById((Object)entity);
            List list = this.checkPrescriptionService.list((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryCheckPrescriptionEntity::getDrugInventoryCheckId, (Object)entity.getId()));
            if (ObjectUtil.isNotNull((Object)list)) {
                list.forEach(a -> {
                    this.updateDrugInventory(a);
                    this.saveDruAccess(a, entity);
                    this.updateDrugBatch(a);
                });
            }
        }
        return ResponseData.success();
    }

    private void updateDrugBatch(SysDrugInventoryCheckPrescriptionEntity a) {
        Integer drugNum = a.getPhysicalInventory();
        SysDrugBatchEntity one = (SysDrugBatchEntity)this.sysDrugBatchService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugBatchEntity::getDrugId, (Object)a.getDrugId())).eq(SysDrugBatchEntity::getPurchasePrice, (Object)a.getPurchasePrice())).eq(SysDrugBatchEntity::getEffectiveTime, (Object)a.getEffectiveTime())).eq(SysDrugBatchEntity::getBatchNumber, (Object)a.getBatchNumber())).last("limit 1"));
        Integer residue = one.getBookInventory();
        Integer i2 = residue - drugNum;
        BigDecimal purchasePrice = one.getPurchasePrice();
        BigDecimal retailPrice = one.getRetailPrice();
        BigDecimal purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(i2.intValue()));
        BigDecimal retailAmount = retailPrice.multiply(BigDecimal.valueOf(i2.intValue()));
        one.setBookInventory(i2);
        one.setPurchaseAmount(purchaseAmount);
        one.setRetailAmount(retailAmount);
        this.sysDrugBatchService.update((Object)one, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugBatchEntity::getDrugId, (Object)a.getDrugId())).eq(SysDrugBatchEntity::getBatchNumber, (Object)a.getBatchNumber()));
    }

    private void saveDruAccess(SysDrugInventoryCheckPrescriptionEntity a, SysDrugInventoryCheckEntity entity) {
        Integer bookInventory = a.getBookInventory();
        Integer physicalInventory = a.getPhysicalInventory();
        String uuid = UUIDUtils.getRandom((int)5, (boolean)true);
        Integer tenantId = this.commonRequest.getTenant();
        SysDrugAccessEntity drugAccessEntity = new SysDrugAccessEntity();
        drugAccessEntity.setId(uuid);
        if (bookInventory > physicalInventory) {
            drugAccessEntity.setWayType("Y");
        }
        if (bookInventory < physicalInventory) {
            drugAccessEntity.setWayType("N");
        }
        drugAccessEntity.setWayTime(new Date());
        drugAccessEntity.setWayNom(entity.getId());
        drugAccessEntity.setNumber(a.getPhysicalInventory());
        drugAccessEntity.setUnit(a.getUnit());
        drugAccessEntity.setBatchNumber(a.getBatchNumber());
        drugAccessEntity.setEffectiveTime(a.getEffectiveTime());
        drugAccessEntity.setTenantId(tenantId);
        drugAccessEntity.setDrugId(a.getDrugId());
        drugAccessEntity.setDrugName(a.getDrugName());
        this.sysDrugAccessService.save((Object)drugAccessEntity);
    }

    private void updateDrugInventory(SysDrugInventoryCheckPrescriptionEntity a) {
        SysDrugInventoryEntity copy = (SysDrugInventoryEntity)this.drugInventoryService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryEntity::getDrugId, (Object)a.getDrugId()));
        Integer actualInventory = copy.getActualInventory();
        Integer drugNum = a.getPhysicalInventory();
        Integer realityNum = actualInventory - drugNum;
        copy.setActualInventory(realityNum);
        BigDecimal purchasePrice = copy.getPurchasePrice();
        BigDecimal purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(realityNum.intValue()));
        copy.setPurchaseAmount(purchaseAmount);
        BigDecimal retailPrice = copy.getRetailPrice();
        BigDecimal retailAmount = retailPrice.multiply(BigDecimal.valueOf(realityNum.intValue()));
        copy.setRetailAmount(retailAmount);
        this.drugInventoryService.update((Object)copy, (Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryEntity::getDrugId, (Object)a.getDrugId()));
    }

    public SysDrugInventoryCheckController(CommonRequest commonRequest, SysDrugInventoryCheckService checkService, SysDrugInventoryCheckPrescriptionService checkPrescriptionService, SysDrugInventoryService drugInventoryService, SysDrugQcQmService sysDrugQcQmService, SysDrugBatchService sysDrugBatchService, SysDrugAccessService sysDrugAccessService) {
        this.commonRequest = commonRequest;
        this.checkService = checkService;
        this.checkPrescriptionService = checkPrescriptionService;
        this.drugInventoryService = drugInventoryService;
        this.sysDrugQcQmService = sysDrugQcQmService;
        this.sysDrugBatchService = sysDrugBatchService;
        this.sysDrugAccessService = sysDrugAccessService;
    }
}

