/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.utils.aes;

import com.alibaba.fastjson.JSONObject;
import com.byh.sys.web.mvc.utils.aes.AESOperator;
import com.byh.sys.web.mvc.utils.aes.AESUtil;
import com.byh.sys.web.mvc.utils.aes.NeedCrypto;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class EncryptResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(EncryptResponseBodyAdvice.class);

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return new NeedCrypto().needEncrypt(returnType);
    }

    public Object beforeBodyWrite(Object obj, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        ServletServerHttpRequest sshr = (ServletServerHttpRequest)serverHttpRequest;
        HttpServletRequest request = sshr.getServletRequest();
        String realData = "";
        JSONObject data = new JSONObject();
        try {
            data = (JSONObject)JSONObject.toJSON((Object)obj);
            if (!data.get((Object)"data").toString().isEmpty()) {
                realData = data.get((Object)"data").toString();
            }
            serverHttpResponse.getHeaders().add("encrypt", "true");
            String returnData = AESOperator.replace((String)AESUtil.encrypt((String)realData));
            log.debug("\u63a5\u53e3={},\u539f\u59cb\u6570\u636e={},\u52a0\u5bc6\u540e\u6570\u636e={}", new Object[]{request.getRequestURI(), realData, returnData});
            data.put("data", (Object)returnData);
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38\uff01", (Throwable)e);
        }
        return data;
    }
}

