/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.chargeItem.Medical;
import com.byh.sys.api.dto.chargeItem.SysChargeItemDto;
import com.byh.sys.api.enums.ApplyGenderEnum;
import com.byh.sys.api.enums.ChargeItemSourceEnum;
import com.byh.sys.api.enums.MedicalInsuranceCheckStatusEnum;
import com.byh.sys.api.enums.StatusEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysChargeItemHsInfoEntity;
import com.byh.sys.api.model.chargeItem.SysChargeItemEntity;
import com.byh.sys.api.model.treatmentItem.SysTreatmentChargeEntity;
import com.byh.sys.api.model.treatmentItem.SysTreatmentItemEntity;
import com.byh.sys.api.request.HsBaseRequest;
import com.byh.sys.api.request.UploadCatalogRequest;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.StringPinYinUtil;
import com.byh.sys.api.util.StringWubiUtil;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.chargeItem.ExportChargeItem;
import com.byh.sys.api.vo.chargeItem.SysChargeItemVo;
import com.byh.sys.data.repository.SysChargeItemHsInfoMapper;
import com.byh.sys.data.repository.SysChargeItemMapper;
import com.byh.sys.data.repository.SysTreatmentChargeMapper;
import com.byh.sys.data.repository.SysTreatmentItemMapper;
import com.byh.sys.web.fegin.HsServiceFeign;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysChargeItemService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysChargeItemServiceImpl
extends ServiceImpl<SysChargeItemMapper, SysChargeItemEntity>
implements SysChargeItemService {
    @Resource
    private SysChargeItemMapper sysChargeItemMapper;
    @Resource
    private SysTreatmentChargeMapper sysTreatmentChargeMapper;
    @Resource
    private SysTreatmentItemMapper sysTreatmentItemMapper;
    @Autowired
    private HsServiceFeign hsServiceFeign;
    @Autowired
    private CommonRequest commonRequest;
    private Logger logger = LoggerFactory.getLogger(SysChargeItemServiceImpl.class);
    @Autowired
    private SysChargeItemHsInfoMapper sysChargeItemHsInfoMapper;

    @Transactional(rollbackFor={BusinessException.class})
    public void deleteMedicalInfo(Integer id) {
        SysChargeItemEntity chargeItem;
        if (id == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u79fb\u9664\u533b\u4fdd\u5bf9\u7167\u4fe1\u606f\u65f6\uff0cID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if ((chargeItem = (SysChargeItemEntity)this.sysChargeItemMapper.selectOne((Wrapper)Wrappers.lambdaQuery(SysChargeItemEntity.class).eq(SysChargeItemEntity::getId, (Object)id))) == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u79fb\u9664\u533b\u4fdd\u5bf9\u7167\u4fe1\u606f\u65f6\uff0c\u6839\u636eID\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6536\u8d39\u4fe1\u606f\uff01");
        }
        if (Stream.of(chargeItem.getMedicalInsuranceCode(), chargeItem.getMedicalInsuranceName(), chargeItem.getPlaceMedicalInsuranceCode(), chargeItem.getPlaceMedicalInsuranceName(), chargeItem.getChargeItemLevel(), chargeItem.getDrugSpec(), chargeItem.getConversionRate(), chargeItem.getManufacturer(), chargeItem.getProductCode(), chargeItem.getProductName(), chargeItem.getPayStandard(), chargeItem.getApprovalNum(), chargeItem.getDrugType()).allMatch(StrUtil::isEmpty)) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u533b\u4fdd\u5bf9\u7167\u4fe1\u606f\u5df2\u79fb\u9664\uff01");
        }
        chargeItem.setMedicalInsuranceCode(null);
        chargeItem.setMedicalInsuranceName(null);
        chargeItem.setPlaceMedicalInsuranceCode(null);
        chargeItem.setPlaceMedicalInsuranceName(null);
        chargeItem.setChargeItemLevel(null);
        chargeItem.setDrugSpec(null);
        chargeItem.setConversionRate(null);
        chargeItem.setManufacturer(null);
        chargeItem.setProductCode(null);
        chargeItem.setProductName(null);
        chargeItem.setPayStandard(null);
        chargeItem.setApprovalNum(null);
        chargeItem.setDrugType(null);
        this.sysChargeItemMapper.updateById((Object)chargeItem);
    }

    public void exportChargeItemList(HttpServletResponse response, Integer tenantId) {
        List exportChargeItemList = this.sysChargeItemMapper.selectExportList(tenantId);
        EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)"\u6536\u8d39\u9879\u76ee", (String)"\u6536\u8d39\u9879\u76ee", (Object)new ExportChargeItem(), (List)exportChargeItemList, null);
    }

    public void uploadMedicalInsurance(HsBaseRequest hsBaseRequest) {
        if (ArrayUtil.isEmpty((Object[])hsBaseRequest.getIds())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u4e0a\u4f20\u533b\u4fdd\u65f6\uff0c\u4f20\u9012\u7684\u6536\u8d39\u9879\u76eeID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        List chargeItemList = this.sysChargeItemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysChargeItemEntity.class).isNotNull(SysChargeItemEntity::getMedicalInsuranceCode)).in(SysChargeItemEntity::getId, (Object[])hsBaseRequest.getIds())).eq(SysChargeItemEntity::getMedicalInsuranceCheckStatusCode, (Object)MedicalInsuranceCheckStatusEnum.NO_UPLOAD.getValue()));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (SysChargeItemEntity entity : chargeItemList) {
            entity.setSignNo(hsBaseRequest.getSign_no());
            entity.setTenantId(hsBaseRequest.getTenantId());
            entity.setUpdateId(hsBaseRequest.getUserId());
            entity.setUpdateName(hsBaseRequest.getOpter_name());
            entity = this.upload(entity, Integer.valueOf(2));
            this.sysChargeItemMapper.updateById((Object)entity);
        }
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void insert(SysChargeItemDto dto) {
        SysChargeItemEntity dbEntity;
        if (StrUtil.isEmpty((CharSequence)dto.getChargeItemName())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u65b0\u589e\u6536\u8d39\u9879\u76ee\u65f6\uff0c\u9879\u76ee\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if ((dbEntity = (SysChargeItemEntity)this.sysChargeItemMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysChargeItemEntity.class).eq(SysChargeItemEntity::getChargeItemName, (Object)dto.getChargeItemName())).eq(dto.getTenantId() != null, SysChargeItemEntity::getTenantId, (Object)dto.getTenantId()))) != null) {
            throw new BusinessException("10000", "\u6536\u8d39\u9879\u76ee\u5df2\u5b58\u5728\uff0c\u65b0\u589e\u5931\u8d25\uff01");
        }
        SysChargeItemEntity entity = new SysChargeItemEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        entity.setPyCode(StringPinYinUtil.toFirstChar((String)entity.getChargeItemName()));
        entity.setWbCode(StringWubiUtil.getWbCode((String)entity.getChargeItemName()));
        entity.setChargeItemCode(UUIDUtils.getNumberRandom((int)9));
        entity.setInHosptialCode(Integer.valueOf(entity.getChargeItemCode()));
        entity.setItemPrice(entity.getItemPrice() == null ? new BigDecimal(0) : entity.getItemPrice());
        String statusCode = entity.getStatusCode();
        String statusName = Optional.ofNullable(StatusEnum.getEnumLabel((String)statusCode)).map(StatusEnum::getLabel).orElse(null);
        entity.setStatusCode(StrUtil.isEmpty((CharSequence)statusName) ? StatusEnum.ENABLED.getValue() : statusCode);
        entity.setStatusName(StrUtil.isEmpty((CharSequence)statusName) ? StatusEnum.ENABLED.getLabel() : statusName);
        entity.setIsMergeChargeItem(StrUtil.isEmpty((CharSequence)entity.getIsMergeChargeItem()) ? "0" : entity.getIsMergeChargeItem());
        entity.setIsUserMedicalInsuranceIdPay(StrUtil.isEmpty((CharSequence)entity.getIsUserMedicalInsuranceIdPay()) ? "0" : entity.getIsUserMedicalInsuranceIdPay());
        String sourceCode = entity.getSourceCode();
        String sourceName = Optional.ofNullable(ChargeItemSourceEnum.getEnumLabel((String)sourceCode)).map(ChargeItemSourceEnum::getLabel).orElse(null);
        entity.setSourceCode(StrUtil.isEmpty((CharSequence)sourceName) ? ChargeItemSourceEnum.CUSTOM.getValue() : sourceCode);
        entity.setSourceName(StrUtil.isEmpty((CharSequence)sourceName) ? ChargeItemSourceEnum.CUSTOM.getLabel() : sourceName);
        String applyGenderCode = entity.getApplyGenderCode();
        String applyGenderName = Optional.ofNullable(ApplyGenderEnum.getEnumLabel((String)applyGenderCode)).map(ApplyGenderEnum::getLabel).orElse(null);
        entity.setApplyGenderCode(StrUtil.isEmpty((CharSequence)applyGenderName) ? ApplyGenderEnum.NO_LIMITATION.getValue() : applyGenderCode);
        entity.setApplyGenderName(StrUtil.isEmpty((CharSequence)applyGenderName) ? ApplyGenderEnum.NO_LIMITATION.getLabel() : applyGenderName);
        String medicalInsuranceCheckStatusCode = entity.getMedicalInsuranceCheckStatusCode();
        String medicalInsuranceCheckStatusName = Optional.ofNullable(MedicalInsuranceCheckStatusEnum.getEnumLabel((String)medicalInsuranceCheckStatusCode)).map(MedicalInsuranceCheckStatusEnum::getLabel).orElse(null);
        entity.setMedicalInsuranceCheckStatusCode(StrUtil.isEmpty((CharSequence)medicalInsuranceCheckStatusName) ? MedicalInsuranceCheckStatusEnum.NO_UPLOAD.getValue() : medicalInsuranceCheckStatusCode);
        entity.setMedicalInsuranceCheckStatusName(StrUtil.isEmpty((CharSequence)medicalInsuranceCheckStatusName) ? MedicalInsuranceCheckStatusEnum.NO_UPLOAD.getLabel() : medicalInsuranceCheckStatusName);
        if (dto.getMedical() != null) {
            entity = this.setEntity(entity, dto.getMedical());
        }
        if (StrUtil.isNotEmpty((CharSequence)entity.getMedicalInsuranceCode())) {
            entity = this.upload(entity, Integer.valueOf(1));
        }
        int insertCount = this.sysChargeItemMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)insertCount, (String)"10001", (String)"\u6536\u8d39\u9879\u76ee\u65b0\u589e\u5931\u8d25\uff01");
    }

    private SysChargeItemEntity upload(SysChargeItemEntity entity, Integer operaFlag) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<UploadCatalogRequest> list = new ArrayList<UploadCatalogRequest>(1);
        UploadCatalogRequest request = new UploadCatalogRequest();
        request.setFixmedins_hilist_id(entity.getChargeItemCode());
        request.setFixmedins_hilist_name(entity.getChargeItemName());
        request.setList_type("201");
        request.setMed_list_codg(entity.getMedicalInsuranceCode());
        request.setSpec(entity.getDrugSpec());
        request.setPrdr_name(entity.getManufacturer());
        Date beginDate = entity.getCreateTime() == null ? new Date() : entity.getCreateTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(beginDate);
        calendar.add(1, 1);
        Date endDate = calendar.getTime();
        String beginDateStr = sdf.format(beginDate);
        String endDateStr = sdf.format(endDate);
        request.setBegndate(beginDateStr);
        request.setEnddate(endDateStr);
        request.setTenantId(entity.getTenantId());
        request.setSign_no(entity.getSignNo());
        request.setOpter_type("1");
        if (operaFlag == 1) {
            request.setOpter(entity.getCreateId().toString());
            request.setOpter_name(entity.getCreateName());
        } else {
            request.setOpter(entity.getUpdateId().toString());
            request.setOpter_name(entity.getUpdateName());
        }
        list.add(request);
        ResponseData responseData = this.hsServiceFeign.uploadCatalogList(list);
        if ("200".equals(responseData.getCode())) {
            entity.setMedicalInsuranceCheckStatusCode(MedicalInsuranceCheckStatusEnum.ALREADY_UPLOAD.getValue());
            entity.setMedicalInsuranceCheckStatusName(MedicalInsuranceCheckStatusEnum.ALREADY_UPLOAD.getLabel());
        } else {
            entity.setMedicalInsuranceCheckStatusCode(MedicalInsuranceCheckStatusEnum.FAIL_UPLOAD.getValue());
            entity.setMedicalInsuranceCheckStatusName(MedicalInsuranceCheckStatusEnum.FAIL_UPLOAD.getLabel());
            entity.setFailReason(responseData.getMsg());
        }
        return entity;
    }

    public Page<SysChargeItemVo> selectPageList(SysChargeItemDto dto) {
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.sysChargeItemMapper.selectPageList(page, dto);
        list.forEach(vo -> {
            if (Stream.of(vo.getMedicalInsuranceCode(), vo.getMedicalInsuranceName(), vo.getPlaceMedicalInsuranceCode(), vo.getPlaceMedicalInsuranceName(), vo.getChargeItemLevel(), vo.getDrugSpec(), vo.getConversionRate(), vo.getManufacturer(), vo.getProductCode(), vo.getProductName(), vo.getPayStandard(), vo.getApprovalNum(), vo.getDrugType()).allMatch(StrUtil::isEmpty)) {
                vo.setMedical(null);
            } else {
                SysChargeItemHsInfoEntity sysChargeItemHsInfoEntity = (SysChargeItemHsInfoEntity)this.sysChargeItemHsInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysChargeItemHsInfoEntity::getHsDrugCode, (Object)vo.getMedicalInsuranceCode()));
                Medical medical = new Medical();
                medical.setHsDrugCode(vo.getMedicalInsuranceCode());
                medical.setHsDrugName(vo.getMedicalInsuranceName());
                medical.setLocDrugCode(vo.getPlaceMedicalInsuranceCode());
                medical.setLocDrugName(vo.getPlaceMedicalInsuranceName());
                medical.setFeeLevel(vo.getChargeItemLevel());
                medical.setDrugSpec(vo.getDrugSpec());
                medical.setConversionRate(vo.getConversionRate());
                medical.setManufacturer(vo.getManufacturer());
                medical.setProductCode(vo.getProductCode());
                medical.setProductName(vo.getProductName());
                medical.setPayStandard(vo.getPayStandard());
                medical.setApprovalNum(vo.getApprovalNum());
                medical.setDrugType(vo.getDrugType());
                if (sysChargeItemHsInfoEntity != null) {
                    medical.setItemDetail(sysChargeItemHsInfoEntity.getItemDetail());
                    medical.setChsDrugCode(sysChargeItemHsInfoEntity.getCHsDrugCode());
                }
                vo.setMedical(medical);
            }
        });
        page.setRecords(list);
        return page;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void update(SysChargeItemDto dto) {
        if (dto.getId() == null || StrUtil.isEmpty((CharSequence)dto.getId().toString())) {
            throw new BusinessException("500", "\u7f16\u8f91\u6536\u8d39\u9879\u76ee\u65f6\uff0c\u6536\u8d39\u9879\u76ee\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)dto.getChargeItemName())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u6536\u8d39\u9879\u76ee\u65f6\uff0c\u9879\u76ee\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        SysChargeItemEntity entity = new SysChargeItemEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        SysChargeItemEntity dbEntity = (SysChargeItemEntity)this.sysChargeItemMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysChargeItemEntity.class).eq(SysChargeItemEntity::getChargeItemName, (Object)entity.getChargeItemName())).eq(entity.getTenantId() != null, SysChargeItemEntity::getTenantId, (Object)entity.getTenantId()));
        if (dbEntity != null && !dbEntity.getId().equals(entity.getId())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u6536\u8d39\u9879\u76ee\u65f6\uff0c\u9879\u76ee\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        entity.setPyCode(StringPinYinUtil.toFirstChar((String)entity.getChargeItemName()));
        entity.setWbCode(StringWubiUtil.getWbCode((String)entity.getChargeItemName()));
        String applyGenderName = Optional.ofNullable(ApplyGenderEnum.getEnumLabel((String)entity.getApplyGenderCode())).map(ApplyGenderEnum::getLabel).orElse(null);
        entity.setApplyGenderName(applyGenderName);
        String sourceName = Optional.ofNullable(ChargeItemSourceEnum.getEnumLabel((String)entity.getSourceCode())).map(ChargeItemSourceEnum::getLabel).orElse(null);
        entity.setSourceName(sourceName);
        String statusName = Optional.ofNullable(StatusEnum.getEnumLabel((String)entity.getStatusCode())).map(StatusEnum::getLabel).orElse(null);
        entity.setStatusName(statusName);
        if (StrUtil.isNotEmpty((CharSequence)statusName) && StatusEnum.UN_ENABLED.getValue().equals(entity.getStatusCode())) {
            Integer[] ids = new Integer[]{entity.getId()};
            this.checkStatus(ids, Integer.valueOf(1));
        }
        String medicalInsuranceCheckStatusName = Optional.ofNullable(MedicalInsuranceCheckStatusEnum.getEnumLabel((String)entity.getMedicalInsuranceCheckStatusCode())).map(MedicalInsuranceCheckStatusEnum::getLabel).orElse(null);
        entity.setMedicalInsuranceCheckStatusName(medicalInsuranceCheckStatusName);
        if (dto.getMedical() != null) {
            this.setEntity(entity, dto.getMedical());
        }
        if (StrUtil.isNotEmpty((CharSequence)entity.getMedicalInsuranceCode()) && MedicalInsuranceCheckStatusEnum.NO_UPLOAD.getValue().equals(entity.getMedicalInsuranceCheckStatusCode())) {
            entity = this.upload(entity, Integer.valueOf(2));
        }
        int updateCount = this.sysChargeItemMapper.updateById((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)updateCount, (String)"10001", (String)"\u7f16\u8f91\u6536\u8d39\u9879\u76ee\u5931\u8d25\uff01");
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void deleteList(Integer[] ids) {
        if (ArrayUtil.isEmpty((Object[])ids)) {
            throw new BusinessException("10000", "\u5220\u9664\u6536\u8d39\u9879\u76ee\u65f6\uff0c\u6536\u8d39\u9879\u76ee\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        this.checkStatus(ids, Integer.valueOf(2));
        int deleteCount = this.sysChargeItemMapper.deleteListByIds(ids);
        ExceptionUtils.createException((Logger)this.logger, (int)deleteCount, (String)"10001", (String)"\u5220\u9664\u6536\u8d39\u9879\u76ee\u5931\u8d25\uff01");
    }

    private void checkStatus(Integer[] ids, Integer typeFlag) {
        List treatmentChargeEntityList = this.sysTreatmentChargeMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysTreatmentChargeEntity.class).in(SysTreatmentChargeEntity::getChargeId, (Object[])ids));
        if (!treatmentChargeEntityList.isEmpty()) {
            List treatmentIds = treatmentChargeEntityList.stream().map(SysTreatmentChargeEntity::getTreatmentId).collect(Collectors.toList());
            List treatmentItemEntityList = this.sysTreatmentItemMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysTreatmentItemEntity.class).in(SysTreatmentItemEntity::getId, treatmentIds));
            boolean flag = false;
            StringJoiner joiner = new StringJoiner("\uff0c", "", "\u3002");
            for (SysTreatmentItemEntity sysTreatmentItemEntity : treatmentItemEntityList) {
                if (!StatusEnum.ENABLED.getValue().equals(sysTreatmentItemEntity.getStatusCode())) continue;
                flag = true;
                joiner.add(sysTreatmentItemEntity.getItemName());
            }
            if (flag) {
                String itemName = joiner.toString();
                if (typeFlag == 1) {
                    ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)("\u8be5\u6536\u8d39\u9879\u76ee\u5df2\u88ab\u8bca\u7597\u9879\u76ee\u4f7f\u7528\uff0c\u9879\u76ee\u65e0\u6cd5\u88ab\u505c\u7528\uff01\u5bf9\u5e94\u8bca\u7597\u9879\u76ee\uff1a" + itemName));
                } else if (typeFlag == 2) {
                    ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)("\u8be5\u6536\u8d39\u9879\u76ee\u5df2\u88ab\u8bca\u7597\u9879\u76ee\u4f7f\u7528\uff0c\u9879\u76ee\u65e0\u6cd5\u88ab\u5220\u9664\uff01\u5bf9\u5e94\u8bca\u7597\u9879\u76ee\uff1a" + itemName));
                }
            }
        }
    }

    private SysChargeItemEntity setEntity(SysChargeItemEntity entity, Medical medical) {
        entity.setMedicalInsuranceCode(medical.getHsDrugCode());
        entity.setMedicalInsuranceName(medical.getHsDrugName());
        entity.setPlaceMedicalInsuranceCode(medical.getLocDrugCode());
        entity.setPlaceMedicalInsuranceName(medical.getLocDrugName());
        entity.setChargeItemLevel(medical.getFeeLevel());
        entity.setDrugSpec(medical.getDrugSpec());
        entity.setConversionRate(medical.getConversionRate());
        entity.setManufacturer(medical.getManufacturer());
        entity.setProductCode(medical.getProductCode());
        entity.setProductName(medical.getProductName());
        entity.setPayStandard(medical.getPayStandard());
        entity.setApprovalNum(medical.getApprovalNum());
        entity.setDrugType(medical.getDrugType());
        return entity;
    }
}

