/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.call_function;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sys.api.dto.OutPrescription;
import com.byh.sys.api.dto.OutPrescriptionDto;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacySaveDto;
import com.byh.sys.api.dto.hsUploadApi.MedicalSaleReturnRequest;
import com.byh.sys.api.dto.hsUploadApi.MedicationInventoryRequest;
import com.byh.sys.api.dto.hsUploadApi.MedicationInventoryUploadRequest;
import com.byh.sys.api.dto.hsUploadApi.PharmaceuticalRequest;
import com.byh.sys.api.dto.hsUploadApi.PurchaseReturnRequest;
import com.byh.sys.api.dto.hsUploadApi.UploadDeptRequest;
import com.byh.sys.api.model.base.BaseEntity;
import com.byh.sys.api.model.department.SysDepartmentEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryInPrescriptionEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryOutEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryOutPrescriptionEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacySimpleEntity;
import com.byh.sys.api.model.hsUpload.HsUploadLogEntity;
import com.byh.sys.api.util.DateUtils;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.StringUtils;
import com.byh.sys.api.vo.drug.SysDrugPharmacyVo;
import com.byh.sys.data.repository.HsMapper;
import com.byh.sys.data.repository.HsUploadLogMapper;
import com.byh.sys.data.repository.SysDepartmentMapper;
import com.byh.sys.data.repository.SysDrugInventoryInPrescriptionMapper;
import com.byh.sys.data.repository.SysDrugInventoryOutPrescriptionMapper;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.data.repository.SysDrugPharmacyMapper;
import com.byh.sys.data.repository.SysDrugPharmacySimpleMapper;
import com.byh.sys.data.repository.SysParamMapper;
import com.byh.sys.web.call_function.HsUploadExtend;
import com.byh.sys.web.fegin.HsServiceFeign;
import com.byh.sys.web.fegin.OutServiceFeign;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.mvc.utils.JsonUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class HsUploadExtend {
    private Logger log = LoggerFactory.getLogger(HsUploadExtend.class);
    @Autowired
    private SysDrugPharmacyMapper sysDrugPharmacyMapper;
    @Autowired
    private HsServiceFeign hsServiceFeign;
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private OutServiceFeign outServiceFeign;
    @Autowired
    private SysDrugPharmacySimpleMapper sysDrugPharmacySimpleMapper;
    @Autowired
    private SysDrugMapper sysDrugMapper;
    @Autowired
    private SysDrugInventoryOutPrescriptionMapper sysDrugInventoryOutPrescriptionMapper;
    @Autowired
    private SysDrugInventoryInPrescriptionMapper sysDrugInventoryInPrescriptionMapper;
    @Autowired
    private SysParamMapper sysParamMapper;
    @Autowired
    private SysDepartmentMapper sysDepartmentMapper;
    @Autowired
    private HsUploadLogMapper hsUploadLogMapper;
    @Autowired
    private HsMapper hsMapper;
    private static final String signNo = "99999";

    public ResponseData context(List<SysDrugPharmacySaveDto> saveDtoList, JSONObject drugTracCodg) {
        if (CollectionUtils.isEmpty(saveDtoList)) {
            return ResponseData.success();
        }
        CompletableFuture.supplyAsync(() -> {
            this.goodsSale(saveDtoList, drugTracCodg);
            return 1;
        });
        return ResponseData.success();
    }

    @Transactional
    public ResponseData goodsReturnContext(List<SysDrugPharmacySaveDto> drugPharmacyList, JSONObject drugTracCodg) {
        if (CollectionUtils.isEmpty(drugPharmacyList)) {
            return ResponseData.success();
        }
        String userName = this.commonRequest.getUserInfo().getUserName();
        Integer userId = this.commonRequest.getUserId();
        CompletableFuture.supplyAsync(() -> {
            this.goodsReturn(drugPharmacyList, drugTracCodg, userName, userId);
            return 1;
        });
        return ResponseData.success();
    }

    public ResponseData medicationInventoryUploadContext(List<SysDrugPharmacySaveDto> saveDtoList, Integer tenantId) {
        if (CollectionUtils.isEmpty(saveDtoList)) {
            return ResponseData.success();
        }
        String userName = this.commonRequest.getUserInfo().getUserName();
        CompletableFuture.supplyAsync(() -> {
            this.medicationInventoryUpload(saveDtoList, tenantId, userName);
            return 1;
        });
        return ResponseData.success();
    }

    @Transactional
    public ResponseData medicationPurchaseContext(String id) {
        String value = this.sysParamMapper.selectByNameReturnValue("hs_run_async", this.commonRequest.getTenant());
        if ("0".equals(value)) {
            this.medicationPurchase(id);
        } else if ("1".equals(value)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
        }
        return ResponseData.success();
    }

    @Transactional
    public ResponseData purchaseReturnContext(SysDrugInventoryOutEntity entity) {
        String value = this.sysParamMapper.selectByNameReturnValue("hs_run_async", this.commonRequest.getTenant());
        if ("0".equals(value)) {
            this.purchaseReturn(entity);
        } else if ("1".equals(value)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
        }
        return ResponseData.success();
    }

    public void goodsSale(List<SysDrugPharmacySaveDto> saveDtoList, JSONObject drugTracCodg) {
        ArrayList medicalSaleReturnRequests = new ArrayList(10);
        List drugsIds = saveDtoList.stream().map(SysDrugPharmacySaveDto::getDrugsId).collect(Collectors.toList());
        List sysDrugPharmacyVos = this.sysDrugPharmacyMapper.sysDrugPharmacySelectByDrugsId(drugsIds, saveDtoList.get(0).getWarehouse(), saveDtoList.get(0).getTenantId());
        Map<String, List<SysDrugPharmacyVo>> vosMap = sysDrugPharmacyVos.stream().collect(Collectors.groupingBy(SysDrugPharmacyVo::getBatchNumber));
        Object type = drugTracCodg.get((Object)"type");
        HashMap codgsMap = new HashMap();
        for (String id : drugsIds) {
            List<String> codgs = Arrays.asList(String.valueOf(drugTracCodg.get((Object)id)).split(","));
            ArrayList<String> arrList = new ArrayList<String>(codgs);
            codgsMap.put(id, arrList.iterator());
        }
        OutPrescriptionDto dto = new OutPrescriptionDto();
        dto.setPrescriptionNo(saveDtoList.get(0).getPrescriptionId());
        ResponseData responseData = this.outServiceFeign.selectByNo(dto);
        ExceptionUtils.createException((Logger)this.log, (!"200".equals(responseData.getCode()) ? 1 : 0) != 0, (String)"500", (String)("\u901a\u8fc7\u5904\u65b9\u53f7\uff1a" + saveDtoList.get(0).getPrescriptionId() + "\u83b7\u53d6\u5904\u65b9\u5931\u8d25\uff1b"));
        OutPrescription prescription = (OutPrescription)ResponseData.formateResult((Object)responseData.getData(), OutPrescription.class);
        List drugList = this.sysDrugMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(SysDrugEntity::getId, drugsIds));
        Map<String, List<SysDrugEntity>> drugMedicalCodeMap = drugList.stream().collect(Collectors.groupingBy(SysDrugEntity::getId));
        for (SysDrugPharmacySaveDto saveDto : saveDtoList) {
            List<SysDrugPharmacyVo> batchEntitys = vosMap.get(saveDto.getBatchNumber());
            if (CollectionUtils.isEmpty(batchEntitys)) continue;
            Iterator iterator = (Iterator)codgsMap.get(saveDto.getDrugsId());
            for (SysDrugPharmacyVo batchEntity : batchEntitys) {
                if (!saveDto.getDrugsId().equals(batchEntity.getDrugsId()) || saveDto.getPurchasePrice().compareTo(batchEntity.getPurchasePrice()) != 0) continue;
                this.goodsSaleSetValue(batchEntity, saveDto, prescription, medicalSaleReturnRequests, iterator, drugMedicalCodeMap, type);
            }
        }
        for (MedicalSaleReturnRequest medicationInventoryRequest : medicalSaleReturnRequests) {
            ResponseData response = this.hsServiceFeign.goodsSale(medicationInventoryRequest);
            this.saveHsUploadLog("\u3010goodsSale:3505\u3011", JSONObject.parseObject((String)JSONObject.toJSONString((Object)medicationInventoryRequest)), JSONObject.parseObject((String)JSONObject.toJSONString((Object)response)), drugTracCodg);
            this.log.info("-------------{}", (Object)responseData);
        }
    }

    public void medicationInventoryUploadChange(List<SysDrugPharmacySaveDto> saveDtoList, List<SysDrugPharmacyVo> sysDrugPharmacyVos, JSONObject drugTracCodg) {
        ArrayList medicationInventoryRequests = new ArrayList(10);
        saveDtoList.forEach(saveDto -> {
            for (SysDrugPharmacyVo n : sysDrugPharmacyVos) {
                if (!saveDto.getDrugsId().equals(n.getDrugsId()) || !saveDto.getBatchNumber().equals(n.getBatchNumber()) || saveDto.getPurchasePrice().compareTo(n.getPurchasePrice()) != 0) continue;
                this.medicationInventoryUploadChangeSetValue(n, saveDto, medicationInventoryRequests);
                break;
            }
        });
        for (MedicationInventoryRequest medicationInventoryRequest : medicationInventoryRequests) {
            ResponseData responseData = this.hsServiceFeign.medicationInventoryUploadChange(medicationInventoryRequest);
            this.saveHsUploadLog("\u3010medicationInventoryUploadChange:3502\u3011", JSONObject.parseObject((String)JSONObject.toJSONString((Object)medicationInventoryRequest)), JSONObject.parseObject((String)JSONObject.toJSONString((Object)responseData)), drugTracCodg);
            this.log.info("-------------{}", (Object)responseData);
        }
    }

    public void goodsReturn(List<SysDrugPharmacySaveDto> saveDtoList, JSONObject drugTracCodg, String userName, Integer userId) {
        ArrayList medicalSaleReturnRequests = new ArrayList(10);
        List drugsIds = saveDtoList.stream().map(SysDrugPharmacySaveDto::getDrugsId).collect(Collectors.toList());
        List sysDrugPharmacyVos = this.sysDrugPharmacyMapper.sysDrugPharmacySelectByDrugsId(drugsIds, saveDtoList.get(0).getWarehouse(), saveDtoList.get(0).getTenantId());
        Map<String, List<SysDrugPharmacyVo>> vosMap = sysDrugPharmacyVos.stream().collect(Collectors.groupingBy(SysDrugPharmacyVo::getBatchNumber));
        HashMap codgsMap = new HashMap();
        for (String id : drugsIds) {
            List<String> codgs = Arrays.asList(String.valueOf(drugTracCodg.get((Object)id)).split(","));
            ArrayList<String> arrList = new ArrayList<String>(codgs);
            codgsMap.put(id, arrList.iterator());
        }
        OutPrescriptionDto dto = new OutPrescriptionDto();
        dto.setPrescriptionNo(saveDtoList.get(0).getPrescriptionId());
        ResponseData responseData = this.outServiceFeign.selectByNo(dto);
        ExceptionUtils.createException((Logger)this.log, (!"200".equals(responseData.getCode()) ? 1 : 0) != 0, (String)"500", (String)("\u901a\u8fc7\u5904\u65b9\u53f7\uff1a" + saveDtoList.get(0).getPrescriptionId() + "\u83b7\u53d6\u5904\u65b9\u5931\u8d25\uff1b"));
        OutPrescription prescription = (OutPrescription)ResponseData.formateResult((Object)responseData.getData(), OutPrescription.class);
        List drugList = this.sysDrugMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(SysDrugEntity::getId, drugsIds));
        Map<String, List<SysDrugEntity>> drugMedicalCodeMap = drugList.stream().collect(Collectors.groupingBy(SysDrugEntity::getId));
        for (SysDrugPharmacySaveDto saveDto : saveDtoList) {
            List<SysDrugPharmacyVo> batchEntitys = vosMap.get(saveDto.getBatchNumber());
            if (CollectionUtils.isEmpty(batchEntitys)) continue;
            Iterator iterator = (Iterator)codgsMap.get(saveDto.getDrugsId());
            for (SysDrugPharmacyVo batchEntity : batchEntitys) {
                if (!saveDto.getDrugsId().equals(batchEntity.getDrugsId()) || saveDto.getPurchasePrice().compareTo(batchEntity.getPurchasePrice()) != 0) continue;
                this.goodsReturnSetValue(batchEntity, saveDto, prescription, medicalSaleReturnRequests, iterator, drugMedicalCodeMap, userName);
            }
        }
        for (MedicalSaleReturnRequest n : medicalSaleReturnRequests) {
            ResponseData response = this.hsServiceFeign.goodsReturn(n);
            this.saveHsUploadLog("\u3010goodsReturn:3506\u3011", JSONObject.parseObject((String)JSONObject.toJSONString((Object)n)), JSONObject.parseObject((String)JSONObject.toJSONString((Object)response)), drugTracCodg);
            this.log.info("-------------{}", (Object)response);
        }
    }

    public void medicationInventoryUpload(List<SysDrugPharmacySaveDto> saveDtoList, Integer tenantId, String userName) {
        List drugsId = saveDtoList.stream().map(SysDrugPharmacySaveDto::getDrugsId).distinct().collect(Collectors.toList());
        List simpleList = this.sysDrugPharmacySimpleMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugPharmacySimpleEntity::getDrugsId, drugsId)).eq(SysDrugPharmacySimpleEntity::getTenantId, (Object)tenantId));
        List drugList = this.sysDrugMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugEntity::getId, drugsId)).eq(SysDrugEntity::getTenantId, (Object)tenantId));
        Map<String, List<SysDrugPharmacySimpleEntity>> simpleMap = simpleList.stream().collect(Collectors.groupingBy(SysDrugPharmacySimpleEntity::getDrugsId));
        Map<String, List<SysDrugEntity>> drugMap = drugList.stream().collect(Collectors.groupingBy(SysDrugEntity::getId));
        ArrayList medicationInventoryUploadRequests = new ArrayList();
        for (SysDrugPharmacySaveDto n : saveDtoList) {
            this.medicationInventoryUploadSetValue(n, medicationInventoryUploadRequests, simpleMap, drugMap);
            System.out.println(n);
        }
        for (SysDrugPharmacySaveDto n : medicationInventoryUploadRequests) {
            ResponseData responseData = this.hsServiceFeign.medicationInventoryUpload((MedicationInventoryUploadRequest)n);
            this.hsUploadLogMapper.insert((Object)new HsUploadLogEntity("\u3010medicationInventoryUpload:3501\u3011", JSONObject.toJSONString((Object)n), JSONObject.toJSONString((Object)responseData), userName));
            this.log.info("-------------{}", (Object)responseData);
        }
    }

    public void medicationPurchase(String id) {
        List pList = this.sysDrugInventoryInPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryInPrescriptionEntity::getDrugInventoryInId, (Object)id)).eq(SysDrugInventoryInPrescriptionEntity::getTenantId, (Object)this.commonRequest.getTenant()));
        ArrayList pharmaceuticalRequests = new ArrayList(5);
        for (SysDrugInventoryInPrescriptionEntity n : pList) {
            this.medicationPurchaseSetValue(n, pharmaceuticalRequests);
        }
        for (SysDrugInventoryInPrescriptionEntity n : pharmaceuticalRequests) {
            ResponseData responseData = this.hsServiceFeign.medicationPurchase((PharmaceuticalRequest)n);
            this.hsUploadLogMapper.insert((Object)new HsUploadLogEntity("\u3010medicationPurchase:3503\u3011", JSONObject.toJSONString((Object)n), JSONObject.toJSONString((Object)responseData)));
            this.log.info("---------{}", (Object)responseData);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    @Async
    public ResponseData medicationInContext(String id, String userNames) {
        System.out.println(Thread.currentThread().getThreadGroup() + "---------\u67e5\u770b\u7ebf\u7a0b-----------" + Thread.currentThread().getName());
        try {
            String value = this.sysParamMapper.selectByNameReturnValue("hs_run_async", this.commonRequest.getTenant());
            if ("0".equals(value)) {
                this.medicationIn(id, userNames);
            } else if ("1".equals(value)) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (Exception e) {
            this.log.info("\u5165\u5e93\u4e4b\u540e\u5411\u533b\u4fdd\u63a8\u9001\u6570\u636e\u8fd4\u56de\u7ed3\u679c\u96c6=======================================" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        return ResponseData.success();
    }

    private void medicationIn(String id, String userNames) {
        List pList = this.sysDrugInventoryInPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryInPrescriptionEntity::getDrugInventoryInId, (Object)id)).eq(SysDrugInventoryInPrescriptionEntity::getTenantId, (Object)this.commonRequest.getTenant()));
        for (SysDrugInventoryInPrescriptionEntity n : pList) {
            Integer drugNum = n.getDrugNum();
            String str = n.getDrugTracCodg();
            List<String> strList = Arrays.asList(str.split(","));
            int size = strList.size();
            if (StrUtil.isEmptyIfStr(strList)) continue;
            strList.forEach(a -> {
                PharmaceuticalRequest medica = new PharmaceuticalRequest();
                medica.setInsuplc_admdvs("");
                medica.setSign_no("99999");
                medica.setTenantId(n.getTenantId());
                medica.setAprvno(n.getApprovalNumber());
                medica.setExpy_end(DateUtils.dateFormatYMD((Date)n.getEffectiveTime()));
                medica.setFixmedins_bchno(n.getBatchNumber());
                medica.setFixmedins_hilist_id(n.getInternalCode().toString());
                medica.setFixmedins_hilist_name(n.getDrugName());
                medica.setManu_date(DateUtils.dateFormatYMD((Date)new Date()));
                medica.setManu_lotnum(n.getBatchNumber());
                medica.setMed_list_codg(n.getMedicalInsuranceCode());
                medica.setProdentp_name(n.getManufacturer());
                medica.setPurc_retn_cnt(new BigDecimal(1));
                this.log.info("---------------\u5f00\u59cb\u7ed3\u675f----------------" + userNames);
                medica.setPurc_retn_opter_name(userNames);
                medica.setPurc_retn_stoin_time(DateUtils.dateFormatYMD((Date)new Date()));
                medica.setSpler_name(n.getSupplierName());
                medica.setRx_flag("1");
                medica.setDrug_trac_codg(a);
                ResponseData responseData = this.hsServiceFeign.medicationPurchase(medica);
                this.hsUploadLogMapper.insert((Object)new HsUploadLogEntity("\u3010medicationInContext:3503\u3011", JSONObject.toJSONString((Object)medica), JSONObject.toJSONString((Object)responseData), userNames));
                this.log.info("-----\u836f\u5e93\u5165\u5e93\u8ffd\u6eaf\u7801\u4e0a\u4f20\u8fd4\u56de\u7ed3\u679c\u96c6----{}", (Object)responseData);
            });
        }
    }

    private void purchaseReturn(SysDrugInventoryOutEntity entity) {
        List preEntity = this.sysDrugInventoryOutPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryOutPrescriptionEntity::getDrugInventoryOutId, (Object)entity.getId())).eq(SysDrugInventoryOutPrescriptionEntity::getTenantId, (Object)entity.getTenantId()));
        ArrayList pharmaceuticalRequests = new ArrayList(5);
        for (SysDrugInventoryOutPrescriptionEntity n : preEntity) {
            this.purchaseReturnSetValue(n, pharmaceuticalRequests);
        }
        for (SysDrugInventoryOutPrescriptionEntity n : pharmaceuticalRequests) {
            ResponseData responseData = this.hsServiceFeign.purchaseReturn((PurchaseReturnRequest)n);
            this.hsUploadLogMapper.insert((Object)new HsUploadLogEntity("\u3010purchaseReturn:3504\u3011", JSONObject.toJSONString((Object)n), JSONObject.toJSONString((Object)responseData)));
            this.log.info("---------{}", (Object)responseData);
        }
    }

    @Transactional
    public ResponseData uploadDeptContrastNewContext(Integer id) {
        String value = this.sysParamMapper.selectByNameReturnValue("hs_run_async", this.commonRequest.getTenant());
        this.uploadDeptContrastNew(id);
        return ResponseData.success();
    }

    public void uploadDeptContrastNew(Integer id) {
        SysDepartmentEntity entity = (SysDepartmentEntity)this.sysDepartmentMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getId, (Object)id));
        List deptContrastList = this.uploadDeptContrastNewSetValue(entity);
        ResponseData responseData = this.hsServiceFeign.updateDeptContrastNew(deptContrastList);
        this.hsUploadLogMapper.insert((Object)new HsUploadLogEntity("\u3010uploadDeptContrastNew:3401A\u3011", JSONObject.toJSONString((Object)deptContrastList), JSONObject.toJSONString((Object)responseData)));
        this.log.info("----------{}", (Object)responseData);
    }

    @Transactional
    public ResponseData updateDeptContrastNewContext(Integer id) {
        String value = this.sysParamMapper.selectByNameReturnValue("hs_run_async", this.commonRequest.getTenant());
        this.updateDeptContrastNew(id);
        return ResponseData.success();
    }

    public void updateDeptContrastNew(Integer id) {
        SysDepartmentEntity entity = (SysDepartmentEntity)this.sysDepartmentMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getId, (Object)id));
        List deptContrastList = this.updateDeptContrastNewSetValue(entity);
        ResponseData responseData = this.hsServiceFeign.updateDeptContrastNew(deptContrastList);
        this.hsUploadLogMapper.insert((Object)new HsUploadLogEntity("\u3010updateDeptContrastNew:3402A\u3011", JSONObject.toJSONString((Object)deptContrastList), JSONObject.toJSONString((Object)responseData)));
        this.log.info("----------{}", (Object)responseData);
    }

    private void medicationInventoryUploadChangeSetValue(SysDrugPharmacyVo n, SysDrugPharmacySaveDto saveDto, List<MedicationInventoryRequest> medicationInventoryRequests) {
        MedicationInventoryRequest medica = new MedicationInventoryRequest();
        medica.setCnt(n.getActualInventory());
        medica.setFixmedins_bchno(n.getBatchNumber());
        medica.setFixmedins_hilist_id(n.getInternalCode());
        medica.setFixmedins_hilist_name(n.getDrugsName());
        medica.setMed_list_codg(saveDto.getMedicalInsuranceCode());
        medica.setRx_flag("1");
        medica.setTenantId(saveDto.getTenantId());
        medica.setInv_chg_time(DateUtils.dateFormatYMD((Date)saveDto.getInOutTime()));
        medica.setPric(saveDto.getRetailPrice().toString());
        String method = inOutEnum.getValueByKey((String)saveDto.getInOutMethod());
        medica.setInv_chg_type(method);
        medica.setSign_no("99999");
        medica.setInsuplc_admdvs("");
        medicationInventoryRequests.add(medica);
    }

    private void goodsSaleSetValue(SysDrugPharmacyVo n, SysDrugPharmacySaveDto saveDto, OutPrescription prescription, List<MedicalSaleReturnRequest> medicalSaleReturnRequests, Iterator<String> iterator, Map<String, List<SysDrugEntity>> drugMap, Object type) {
        MedicalSaleReturnRequest medica = new MedicalSaleReturnRequest();
        medica.setFixmedins_bchno(saveDto.getInventoryId());
        medica.setFixmedins_hilist_id(n.getInternalCode());
        medica.setFixmedins_hilist_name(n.getDrugsName());
        medica.setMed_list_codg(saveDto.getMedicalInsuranceCode());
        medica.setRx_flag("1");
        medica.setTenantId(saveDto.getTenantId());
        medica.setSign_no("99999");
        medica.setInsuplc_admdvs("");
        medica.setManu_lotnum(n.getBatchNumber());
        medica.setSel_retn_cnt(Double.valueOf(Math.abs(Double.parseDouble(String.valueOf(saveDto.getActualInventory())))));
        medica.setRtal_docno(saveDto.getInventoryId());
        medica.setSel_retn_opter_name(prescription.getPrescribingDoctorName());
        medica.setTrdn_flag("0");
        medica.setPrsc_dr_name(prescription.getPrescribingDoctorName());
        medica.setPhar_name(prescription.getPrescribingDoctorName());
        medica.setPhar_prac_cert_no(String.valueOf(prescription.getPrescribingDoctorId()));
        medica.setManu_date(DateUtils.dateFormatYMD((Date)new Date()));
        medica.setSel_retn_time(DateUtils.dateFormatYMD((Date)saveDto.getInOutTime()));
        medica.setPsn_name(prescription.getPatientName());
        medica.setPsn_no(String.valueOf(prescription.getPatientId()));
        List<SysDrugEntity> a = drugMap.get(saveDto.getDrugsId());
        if (null != a && !CollectionUtils.isEmpty(a)) {
            if ("2".equals(type)) {
                medica.setTrdn_flag("1");
            } else if (Integer.parseInt(a.get(0).getPackSpecification()) > 1) {
                medica.setSel_retn_cnt(Double.valueOf(medica.getSel_retn_cnt() * Double.valueOf(a.get(0).getPackSpecification())));
                medica.setTrdn_flag("1");
            } else if (Integer.parseInt(a.get(0).getTrdnSpecification()) > 1 && Integer.parseInt(a.get(0).getPackSpecification()) == 1) {
                medica.setTrdn_flag("1");
            }
        }
        ArrayList<JSONObject> drugtracinfos = new ArrayList<JSONObject>();
        int i = 0;
        while ((double)i < medica.getSel_retn_cnt()) {
            if (iterator.hasNext()) {
                String codg = iterator.next();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("drug_trac_codg", (Object)codg);
                jsonObject.put("trdn_flag", (Object)medica.getTrdn_flag());
                drugtracinfos.add(jsonObject);
                iterator.remove();
            }
            ++i;
        }
        medica.setDrugtracinfo(drugtracinfos);
        String mdtrtId = this.hsMapper.selectMdtrtSetlType(prescription.getPrescriptionNo());
        medica.setMdtrt_sn(mdtrtId == null ? prescription.getOutpatientNo() : mdtrtId);
        String setlId = this.hsMapper.selectSetlId(prescription.getPrescriptionNo());
        medica.setSetl_id(setlId);
        if (StringUtils.isBlank((String)mdtrtId)) {
            medica.setMdtrt_setl_type("2");
        } else {
            medica.setMdtrt_setl_type("1");
        }
        medicalSaleReturnRequests.add(medica);
    }

    private void goodsReturnSetValue(SysDrugPharmacyVo n, SysDrugPharmacySaveDto saveDto, OutPrescription prescription, List<MedicalSaleReturnRequest> medicalSaleReturnRequests, Iterator<String> iterator, Map<String, List<SysDrugEntity>> drugMap, String userName) {
        MedicalSaleReturnRequest medica = new MedicalSaleReturnRequest();
        medica.setMed_list_codg(n.getMedicalInsuranceCode());
        medica.setFixmedins_bchno(saveDto.getInventoryId());
        medica.setFixmedins_hilist_id(n.getInternalCode());
        medica.setFixmedins_hilist_name(n.getDrugsName());
        medica.setManu_lotnum(n.getBatchNumber());
        medica.setPhar_name(prescription.getPrescribingDoctorName());
        medica.setPhar_prac_cert_no(prescription.getPrescribingDoctorId().toString());
        medica.setPsn_cert_type("1");
        medica.setRtal_docno(n.getInventoryId());
        medica.setRx_flag("1");
        medica.setSel_retn_cnt(Double.valueOf(Math.abs(Double.parseDouble(String.valueOf(saveDto.getActualInventory())))));
        medica.setSel_retn_time(DateUtils.dateFormatYMD((Date)new Date()));
        medica.setTrdn_flag("0");
        medica.setTenantId(n.getTenantId());
        medica.setSel_retn_opter_name(userName);
        medica.setManu_date(DateUtils.dateFormatYMD((Date)new Date()));
        medica.setSign_no("99999");
        medica.setInsuplc_admdvs("");
        medica.setMedins_prod_sel_no(prescription.getOutpatientNo());
        List<SysDrugEntity> a = drugMap.get(saveDto.getDrugsId());
        if (null != a && !CollectionUtils.isEmpty(a) && Integer.parseInt(a.get(0).getPackSpecification()) > 1) {
            medica.setSel_retn_cnt(Double.valueOf(medica.getSel_retn_cnt() * Double.valueOf(a.get(0).getPackSpecification())));
            medica.setTrdn_flag("1");
        }
        ArrayList<JSONObject> drugtracinfos = new ArrayList<JSONObject>();
        int i = 0;
        while ((double)i < medica.getSel_retn_cnt()) {
            if (iterator.hasNext()) {
                String codg = iterator.next();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("drug_trac_codg", (Object)codg);
                drugtracinfos.add(jsonObject);
                iterator.remove();
            }
            ++i;
        }
        medica.setDrugtracinfo(drugtracinfos);
        String mdtrtId = this.hsMapper.selectMdtrtSetlType(prescription.getPrescriptionNo());
        medica.setMdtrt_sn(mdtrtId == null ? prescription.getOutpatientNo() : mdtrtId);
        if (StringUtils.isBlank((String)mdtrtId)) {
            medica.setMdtrt_setl_type("2");
        } else {
            medica.setMdtrt_setl_type("1");
        }
        medicalSaleReturnRequests.add(medica);
    }

    private void medicationInventoryUploadSetValue(SysDrugPharmacySaveDto n, List<MedicationInventoryUploadRequest> medicationInventoryUploadRequests, Map<String, List<SysDrugPharmacySimpleEntity>> simpleMap, Map<String, List<SysDrugEntity>> drugMap) {
        MedicationInventoryUploadRequest medica = new MedicationInventoryUploadRequest();
        SysDrugPharmacySimpleEntity simple = simpleMap.get(n.getDrugsId()).get(0);
        SysDrugEntity drug = drugMap.get(n.getDrugsId()).get(0);
        medica.setRx_flag("1");
        medica.setManu_date(DateUtils.dateFormatYMD((Date)new Date()));
        medica.setSign_no("99999");
        medica.setTenantId(n.getTenantId());
        medica.setFixmedins_bchno(n.getBatchNumber());
        medica.setFixmedins_hilist_id(drug.getInternalCode().toString());
        medica.setFixmedins_hilist_name(drug.getDrugsName());
        medica.setMed_list_codg(drug.getMedicalInsuranceCode());
        medica.setExpy_end(DateUtils.dateFormatYMD((Date)n.getEffectiveTime()));
        medica.setInv_cnt(new BigDecimal(simple.getActualInventory()));
        medica.setInvdate(DateUtils.dateFormatYMD((Date)n.getInOutTime()));
        medica.setInsuplc_admdvs("");
        medicationInventoryUploadRequests.add(medica);
    }

    private void medicationPurchaseSetValue(SysDrugInventoryInPrescriptionEntity n, List<PharmaceuticalRequest> pharmaceuticalRequests) {
        PharmaceuticalRequest medica = new PharmaceuticalRequest();
        medica.setInsuplc_admdvs("");
        medica.setSign_no("99999");
        medica.setTenantId(n.getTenantId());
        medica.setAprvno(n.getApprovalNumber());
        medica.setExpy_end(DateUtils.dateFormatYMD((Date)n.getEffectiveTime()));
        medica.setFixmedins_bchno(n.getBatchNumber());
        medica.setFixmedins_hilist_id(n.getInternalCode().toString());
        medica.setFixmedins_hilist_name(n.getDrugName());
        medica.setManu_date(DateUtils.dateFormatYMD((Date)new Date()));
        medica.setManu_lotnum(n.getBatchNumber());
        medica.setMed_list_codg(n.getMedicalInsuranceCode());
        medica.setProdentp_name(n.getManufacturer());
        medica.setPurc_retn_cnt(new BigDecimal(n.getDrugNum()));
        medica.setPurc_retn_opter_name(this.commonRequest.getUserInfo().getUserName());
        medica.setPurc_retn_stoin_time(DateUtils.dateFormatYMD((Date)new Date()));
        medica.setSpler_name(n.getSupplierName());
        medica.setRx_flag("1");
        medica.setDrug_trac_codg(n.getDrugTracCodg());
        pharmaceuticalRequests.add(medica);
    }

    private void purchaseReturnSetValue(SysDrugInventoryOutPrescriptionEntity n, List<PurchaseReturnRequest> pharmaceuticalRequests) {
        PurchaseReturnRequest medica = new PurchaseReturnRequest();
        medica.setInsuplc_admdvs("");
        medica.setRx_flag("1");
        medica.setSign_no(this.commonRequest.getSignNo());
        medica.setTenantId(n.getTenantId());
        medica.setExpy_end(DateUtils.dateFormatYMD((Date)n.getEffectiveTime()));
        medica.setFixmedins_bchno(n.getBatchNumber());
        medica.setFixmedins_hilist_id(n.getInternalCode().toString());
        medica.setFixmedins_hilist_name(n.getDrugName());
        medica.setManu_date(DateUtils.dateFormatYMD((Date)new Date()));
        medica.setFinl_trns_pric(n.getRetailPrice());
        medica.setManu_date(DateUtils.dateFormatYMD((Date)new Date()));
        medica.setMed_list_codg(n.getMedicalInsuranceCode());
        medica.setPurc_invo_no(n.getDrugInventoryInId());
        medica.setPurc_retn_cnt(new BigDecimal(n.getDrugNum()));
        medica.setPurc_retn_opter_name(this.commonRequest.getUserInfo().getUserName());
        medica.setPurc_retn_stoin_time(DateUtils.dateFormatYMD((Date)new Date()));
        medica.setRx_flag("1");
        medica.setSpler_name(n.getSupplierName());
        pharmaceuticalRequests.add(medica);
    }

    public List<UploadDeptRequest> uploadDeptContrastNewSetValue(SysDepartmentEntity entity) {
        ArrayList<UploadDeptRequest> deptContrastList = new ArrayList<UploadDeptRequest>();
        UploadDeptRequest uploadDeptRequest = new UploadDeptRequest();
        uploadDeptRequest.setHosp_dept_codg(entity.getId().toString());
        uploadDeptRequest.setHosp_dept_name(entity.getDepartmentName());
        uploadDeptRequest.setCaty(entity.getCaty());
        uploadDeptRequest.setItro("");
        uploadDeptRequest.setDept_resper_name("");
        uploadDeptRequest.setDept_resper_tel("");
        uploadDeptRequest.setBegntime(DateUtils.dateFormatYMD((Date)entity.getCreateTime()));
        uploadDeptRequest.setDept_estbdat(DateUtils.dateFormatYMD((Date)entity.getCreateTime()));
        uploadDeptRequest.setPoolarea_no("360103");
        uploadDeptRequest.setDr_psncnt("0");
        uploadDeptRequest.setPhar_psncnt("0");
        uploadDeptRequest.setNurs_psncnt("0");
        uploadDeptRequest.setTecn_psncnt("0");
        uploadDeptRequest.setTenantId(this.commonRequest.getTenant());
        uploadDeptRequest.setSign_no(this.commonRequest.getSignNo());
        deptContrastList.add(uploadDeptRequest);
        return deptContrastList;
    }

    public List<UploadDeptRequest> updateDeptContrastNewSetValue(SysDepartmentEntity entity) {
        ArrayList<UploadDeptRequest> deptContrastList = new ArrayList<UploadDeptRequest>();
        UploadDeptRequest uploadDeptRequest = new UploadDeptRequest();
        uploadDeptRequest.setHosp_dept_codg(entity.getId().toString());
        uploadDeptRequest.setHosp_dept_name(entity.getDepartmentName());
        uploadDeptRequest.setCaty(entity.getCaty());
        uploadDeptRequest.setItro("");
        uploadDeptRequest.setDept_resper_name("");
        uploadDeptRequest.setDept_resper_tel("");
        uploadDeptRequest.setBegntime(DateUtils.dateFormatYMD((Date)entity.getCreateTime()));
        uploadDeptRequest.setDept_estbdat(DateUtils.dateFormatYMD((Date)entity.getCreateTime()));
        uploadDeptRequest.setPoolarea_no("360103");
        uploadDeptRequest.setAprv_bed_cnt("0");
        uploadDeptRequest.setDr_psncnt("0");
        uploadDeptRequest.setPhar_psncnt("0");
        uploadDeptRequest.setNurs_psncnt("0");
        uploadDeptRequest.setTecn_psncnt("0");
        uploadDeptRequest.setTenantId(this.commonRequest.getTenant());
        uploadDeptRequest.setSign_no(this.commonRequest.getSignNo());
        deptContrastList.add(uploadDeptRequest);
        return deptContrastList;
    }

    private void saveHsUploadLog(String code, JSONObject param, JSONObject response, JSONObject drugTracCodg) {
        HsUploadLogEntity hsUploadLogEntity = new HsUploadLogEntity(code, JSONObject.toJSONString((Object)param), JSONObject.toJSONString((Object)response), String.valueOf(drugTracCodg.get((Object)"createId")), String.valueOf(drugTracCodg.get((Object)"createName")));
        hsUploadLogEntity.setDrugsId(Objects.isNull(param.get((Object)"fixmedins_hilist_id")) ? null : String.valueOf(param.get((Object)"fixmedins_hilist_id")));
        hsUploadLogEntity.setDrugsName(Objects.isNull(param.get((Object)"fixmedins_hilist_name")) ? null : String.valueOf(param.get((Object)"fixmedins_hilist_name")));
        hsUploadLogEntity.setPatientName(Objects.isNull(param.get((Object)"psn_name")) ? null : String.valueOf(param.get((Object)"psn_name")));
        hsUploadLogEntity.setDrugTracCodg(Objects.isNull(param.get((Object)"drugtracinfo")) ? null : String.valueOf(JsonUtils.create((Object)param.get((Object)"drugtracinfo")).getArrayValue().getList()));
        Object o = drugTracCodg.get((Object)"type");
        if (Objects.nonNull(o)) {
            hsUploadLogEntity.setType(Objects.isNull(drugTracCodg.get((Object)"type")) ? null : String.valueOf(drugTracCodg.get((Object)"type")));
        }
        this.hsUploadLogMapper.insert((Object)hsUploadLogEntity);
    }

    static /* synthetic */ void access$000(HsUploadExtend x0, SysDrugInventoryOutEntity x1) {
        x0.purchaseReturn(x1);
    }

    static /* synthetic */ void access$100(HsUploadExtend x0, String x1, String x2) {
        x0.medicationIn(x1, x2);
    }
}

