/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.call_function;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sys.api.dto.purchaseOrder.PurchaseOrderUpdateStatusDto;
import com.byh.sys.api.model.PurchaseOrderEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryInEntity;
import com.byh.sys.api.model.purchaseOrder.FlDataCallBackEntity;
import com.byh.sys.api.model.purchaseOrder.PushDownloadLocalbillEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.data.repository.FlDataCallBackMapper;
import com.byh.sys.data.repository.PurchaseOrderMapper;
import com.byh.sys.data.repository.SysDrugInventoryInMapper;
import com.byh.sys.data.repository.SysDrugInventoryInPrescriptionMapper;
import com.byh.sys.data.repository.SysDrugPharmacyInMapper;
import com.byh.sys.web.call_function.HsUploadExtend;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.PurchaseOrderService;
import com.byh.sys.web.service.SysDrugInventoryInService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysDrugInventoryExtend {
    private static final Logger log = LoggerFactory.getLogger(SysDrugInventoryExtend.class);
    @Autowired
    private PurchaseOrderService purchaseOrderService;
    @Autowired
    private SysDrugInventoryInService sysDrugInventoryInService;
    @Autowired
    private PurchaseOrderMapper purchaseOrderMapper;
    @Autowired
    private HsUploadExtend hsUploadExtend;
    @Autowired
    private SysDrugPharmacyInMapper sysDrugPharmacyInMapper;
    @Autowired
    private SysDrugInventoryInMapper sysDrugInventoryInMapper;
    @Autowired
    private SysDrugInventoryInPrescriptionMapper sysDrugInventoryInPrescriptionMapper;
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private FlDataCallBackMapper flDataCallBackMapper;

    public void checkDrugInventorySave(String orderid) {
        SysDrugInventoryInEntity inEntity = (SysDrugInventoryInEntity)this.sysDrugInventoryInService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryInEntity::getOrderid, (Object)orderid)).and(Wrappers2 -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers2.eq(SysDrugInventoryInEntity::getAuditStatus, (Object)"2")).or()).eq(SysDrugInventoryInEntity::getAuditStatus, (Object)"1");
        }));
        ExceptionUtils.createException((Logger)log, (!Objects.isNull(inEntity) ? 1 : 0) != 0, (String)"500", (String)("\u3010orderid\uff1a" + orderid + "\u3011\u5df2\u5904\u4e8e\u5f85\u5165\u5e93\u72b6\u6001\u6216\u5df2\u786e\u8ba4\u5165\u5e93"));
    }

    public boolean confirmPurchaseOrderIn(String orderid) {
        if (!"0".equals(orderid)) {
            FlDataCallBackEntity flDataCallBackEntity = (FlDataCallBackEntity)this.flDataCallBackMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(PushDownloadLocalbillEntity::getBill_code, (Object)orderid));
            if (Objects.nonNull(flDataCallBackEntity)) {
                ExceptionUtils.createException((Logger)log, (boolean)"1".equals(flDataCallBackEntity.getStatus()), (String)"500", (String)("\u3010\u91c7\u8d2d\u5355\u53f7\uff1a" + orderid + "\u3011\u5df2\u5165\u5e93\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c"));
                FlDataCallBackEntity entity = new FlDataCallBackEntity();
                entity.setStatus("1");
                int a = this.flDataCallBackMapper.update((Object)entity, (Wrapper)Wrappers.lambdaQuery().eq(PushDownloadLocalbillEntity::getBill_code, (Object)orderid));
                ExceptionUtils.createException((Logger)log, (int)a, (String)"500", (String)("\u3010\u91c7\u8d2d\u5355\u53f7\uff1a" + orderid + "\u3011\u901a\u8fc7PDA\u5165\u5e93\uff0c\u786e\u8ba4\u8fc7\u7a0b\u4e2d\u66f4\u6539\u5165\u5e93\u8ba2\u5355\u5165\u5e93\u72b6\u6001\u51fa\u73b0\u5f02\u5e38\u8bf7\u68c0\u67e5"));
                return Boolean.TRUE;
            }
            PurchaseOrderEntity purchaseOrderEntity = (PurchaseOrderEntity)this.purchaseOrderMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(PurchaseOrderEntity::getOrderid, (Object)orderid));
            if (Objects.nonNull(purchaseOrderEntity)) {
                ExceptionUtils.createException((Logger)log, (boolean)"1".equals(purchaseOrderEntity.getInFlag()), (String)"500", (String)("\u3010\u91c7\u8d2d\u5355\u53f7\uff1a" + orderid + "\u3011\u5df2\u5165\u5e93\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c"));
                PurchaseOrderUpdateStatusDto purchaseOrderUpdateStatusDto = new PurchaseOrderUpdateStatusDto();
                purchaseOrderUpdateStatusDto.setOrderid(Integer.valueOf(Integer.parseInt(orderid)));
                purchaseOrderUpdateStatusDto.setInFlag("1");
                this.purchaseOrderService.purchaseOrderUpdateStatus(purchaseOrderUpdateStatusDto);
            }
        }
        return Boolean.TRUE;
    }
}

