/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.material;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.material.inventory.SysMaterialInventoryDto;
import com.byh.sys.api.dto.material.inventory.SysMaterialInventorySaveDto;
import com.byh.sys.api.dto.material.inventory.SysMaterialInventoryUpdateDto;
import com.byh.sys.api.model.material.SysMaterialInventoryEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.material.SysMaterialInventoryVo;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysMaterialInventoryService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysMaterial/inventory"})
public class SysMaterialInventoryController {
    @Autowired
    private SysMaterialInventoryService sysMaterialInventoryService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/save"})
    @UserOptLogger(operation="\u6750\u6599\u5e93\u5b58\u6a21\u5757")
    @ApiOperation(value="\u65b0\u589e\u6750\u6599\u5e93\u5b58")
    public ResponseData sysMaterialInventorySave(@RequestBody @Valid SysMaterialInventorySaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysMaterialInventoryService.sysMaterialInventorySave(dto);
        return ResponseData.success().msg("\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/select"})
    @ApiOperation(value="\u67e5\u8be2\u6750\u6599\u5e93\u5b58")
    @AntiRefresh
    public ResponseData sysMaterialInventorySelect(Page page, SysMaterialInventoryDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.sysMaterialInventoryService.sysMaterialInventorySelect(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/selectByInventoryId"})
    @ApiOperation(value="\u6839\u636eInventoryId\u67e5\u8be2\u6750\u6599\u5e93\u5b58")
    @AntiRefresh
    public ResponseData<List<SysMaterialInventoryVo>> sysMaterialInventorySelectByInventoryId(SysMaterialInventoryDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        List list = this.sysMaterialInventoryService.sysMaterialInventorySelectByInventoryId(dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/update"})
    @UserOptLogger(operation="\u6750\u6599\u5e93\u5b58\u6a21\u5757")
    @ApiOperation(value="\u66f4\u65b0\u6750\u6599\u5e93\u5b58")
    public ResponseData sysMaterialInventoryUpdate(@RequestBody @Valid SysMaterialInventoryUpdateDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysMaterialInventoryService.sysMaterialInventoryUpdate(dto);
        return ResponseData.success().msg("\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u6750\u6599\u5e93\u5b58")
    public ResponseData sysMaterialInventoryDelete(@RequestBody @Valid SysMaterialInventoryEntity entity) {
        this.sysMaterialInventoryService.sysMaterialInventoryDelete(entity);
        return ResponseData.success();
    }

    @RequestMapping(value={"/inOut/detail"})
    @ApiOperation(value="\u4ed3\u5e93\u8fdb\u9500\u5b58\u8be6\u60c5")
    @AntiRefresh
    public ResponseData sysMaterialInventoryInOutDetail(@RequestBody Integer id) {
        this.sysMaterialInventoryService.sysMaterialInventoryInOutDetail(id, this.commonRequest.getTenant());
        return ResponseData.success();
    }

    @RequestMapping(value={"/batch/detail"})
    @ApiOperation(value="\u4ed3\u5e93\u6279\u6b21\u8be6\u60c5")
    @AntiRefresh
    public ResponseData sysMaterialInventoryBatchDetail(@RequestBody Integer id) {
        this.sysMaterialInventoryService.sysMaterialInventoryBatchDetail(id, this.commonRequest.getTenant());
        return ResponseData.success().msg("\u5220\u9664\u6210\u529f");
    }
}

