/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.drug.SysDrugInventoryInDto;
import com.byh.sys.api.enums.DictEnums;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.dict.SysDictValueEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryCheckEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryInEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryInPrescriptionEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugTogetherEntity;
import com.byh.sys.api.model.excel.SysDrugInventoryImportExcel;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.drug.SysDrugVo;
import com.byh.sys.data.repository.SysDictValueMapper;
import com.byh.sys.data.repository.SysDrugInventoryCheckMapper;
import com.byh.sys.data.repository.SysDrugInventoryInMapper;
import com.byh.sys.data.repository.SysDrugInventoryInPrescriptionMapper;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.data.repository.SysDrugTogetherMapper;
import com.byh.sys.web.service.SysDrugInventoryInService;
import com.byh.sys.web.service.impl.SysTreatmentItemServiceImpl;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysDrugInventoryInServiceImpl
extends ServiceImpl<SysDrugInventoryInMapper, SysDrugInventoryInEntity>
implements SysDrugInventoryInService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugInventoryInServiceImpl.class);
    @Resource
    private SysDrugMapper sysDrugMapper;
    @Resource
    private SysDrugInventoryCheckMapper sysDrugInventoryCheckMapper;
    @Resource
    private SysDrugTogetherMapper sysDrugTogetherMapper;
    @Resource
    private SysDrugInventoryInPrescriptionMapper sysDrugInventoryInPrescriptionMapper;
    @Resource
    private SysDictValueMapper sysDictValueMapper;
    private Logger logger = LoggerFactory.getLogger(SysTreatmentItemServiceImpl.class);

    @Transactional(rollbackFor={BusinessException.class})
    public void importDrugInventoryExcel(MultipartFile file, Integer tenantId, Integer userId, String userName) {
        try {
            List checkList = this.sysDrugInventoryCheckMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysDrugInventoryCheckEntity.class).eq(SysDrugInventoryCheckEntity::getAuditStatus, (Object)DictEnums.CHECK_ING.getCode()));
            if (!checkList.isEmpty()) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5f53\u524d\u836f\u5e93\u6b63\u5728\u76d8\u70b9\u4e2d\uff0c\u4e0d\u80fd\u6267\u884c\u836f\u54c1\u5165\u5e93\u5bfc\u5165\u64cd\u4f5c\uff01");
            }
            InputStream inputStream = file.getInputStream();
            XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
            XSSFSheet sheet = workbook.getSheetAt(0);
            List drugList = this.sysDrugMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysDrugEntity.class).eq(SysDrugEntity::getTenantId, (Object)tenantId));
            Map drugMap = drugList.stream().collect(Collectors.toMap(SysDrugEntity::getInternalCode, Function.identity()));
            BigDecimal purchaseAmount = new BigDecimal(0);
            BigDecimal retailAmount = new BigDecimal(0);
            List dictValueList = this.sysDictValueMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysDictValueEntity.class).eq(SysDictValueEntity::getType, (Object)"we_pack_units"));
            Map<String, String> dictValueMap = dictValueList.stream().collect(Collectors.toMap(SysDictValueEntity::getLabel, SysDictValueEntity::getValue));
            ArrayList<SysDrugInventoryInPrescriptionEntity> drugInventoryInPrescriptionList = new ArrayList<SysDrugInventoryInPrescriptionEntity>();
            String drugType = "";
            int readCount = 0;
            for (Row row : sheet) {
                if (readCount <= 0) {
                    ++readCount;
                    continue;
                }
                SysDrugEntity drugEntity = (SysDrugEntity)drugMap.get(Integer.valueOf(row.getCell(2).getStringCellValue()));
                if (drugEntity == null) continue;
                drugType = row.getCell(25).getStringCellValue();
                SysDrugInventoryInPrescriptionEntity drugInPrescEntity = new SysDrugInventoryInPrescriptionEntity();
                drugInPrescEntity.setMedicalInsuranceCode(drugEntity.getMedicalInsuranceCode());
                drugInPrescEntity.setMedicalInsuranceName(drugEntity.getMedicalInsuranceName());
                drugInPrescEntity.setLevel(drugEntity.getLevel());
                drugInPrescEntity.setDrugId(drugEntity.getId());
                drugInPrescEntity.setDrugName(row.getCell(3).getStringCellValue());
                drugInPrescEntity.setSpecifications(row.getCell(6).getStringCellValue());
                BigDecimal retailPrice = BigDecimal.valueOf(row.getCell(7).getNumericCellValue());
                drugInPrescEntity.setRetailPrice(retailPrice);
                BigDecimal purchasePrice = BigDecimal.valueOf(row.getCell(16).getNumericCellValue());
                drugInPrescEntity.setPurchasePrice(purchasePrice);
                Integer stockNum = (int)row.getCell(8).getNumericCellValue();
                drugInPrescEntity.setDrugNum(stockNum);
                String unit = dictValueMap.getOrDefault(row.getCell(9).getStringCellValue(), null);
                drugInPrescEntity.setUnit(unit);
                BigDecimal purchaseOneAmount = retailPrice.multiply(BigDecimal.valueOf(stockNum.intValue()));
                purchaseAmount = purchaseAmount.add(purchaseOneAmount);
                BigDecimal retailOneAmount = purchasePrice.multiply(BigDecimal.valueOf(stockNum.intValue()));
                retailAmount = retailAmount.add(retailOneAmount);
                drugInPrescEntity.setEffectiveTime(row.getCell(14).getDateCellValue());
                drugInPrescEntity.setManufacturer(row.getCell(19).getStringCellValue());
                drugInPrescEntity.setApprovalNumber(drugEntity.getApprovalNumber());
                drugInPrescEntity.setBatchNumber(row.getCell(13).getStringCellValue());
                drugInPrescEntity.setDrugsType(drugEntity.getDrugsType());
                drugInPrescEntity.setDrugProperties(drugEntity.getDrugProperties());
                drugInPrescEntity.setTenantId(tenantId);
                drugInventoryInPrescriptionList.add(drugInPrescEntity);
            }
            SysDrugInventoryInEntity drugInventoryInEntity = new SysDrugInventoryInEntity();
            drugInventoryInEntity.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            drugInventoryInEntity.setWarehousingUse(userName);
            LocalDate today = LocalDate.now();
            Date warehousingTime = Date.from(today.atStartOfDay(ZoneId.systemDefault()).toInstant());
            drugInventoryInEntity.setWarehousingTime(warehousingTime);
            drugInventoryInEntity.setWarehousingMethod("2");
            if ("\u897f\u836f".equals(drugType)) {
                drugInventoryInEntity.setWarehousingWarehouse("0");
            } else if ("\u8349\u836f".equals(drugType)) {
                drugInventoryInEntity.setWarehousingWarehouse("1");
            }
            drugInventoryInEntity.setSupplierId("20012");
            drugInventoryInEntity.setSupplierName("\u5176\u4ed6");
            drugInventoryInEntity.setAuditStatus("1");
            drugInventoryInEntity.setTenantId(tenantId);
            LocalDateTime now = LocalDateTime.now();
            Date createTime = Date.from(now.atZone(ZoneId.systemDefault()).toInstant());
            drugInventoryInEntity.setCreateTime(createTime);
            drugInventoryInEntity.setPurchaseAmount(purchaseAmount);
            drugInventoryInEntity.setRetailAmount(retailAmount);
            drugInventoryInEntity.setCreateId(userId);
            ((SysDrugInventoryInMapper)this.baseMapper).insert((Object)drugInventoryInEntity);
            drugInventoryInPrescriptionList.forEach(entity -> {
                entity.setId(UUIDUtils.getRandom((int)5, (boolean)true));
                entity.setDrugInventoryInId(drugInventoryInEntity.getId());
                this.sysDrugInventoryInPrescriptionMapper.insert(entity);
            });
            SysDrugTogetherEntity drugTogetherEntity = new SysDrugTogetherEntity();
            drugTogetherEntity.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            drugTogetherEntity.setDrugInventoryInId(drugInventoryInEntity.getId());
            drugTogetherEntity.setPurchaseAmount(purchaseAmount);
            drugTogetherEntity.setRetailAmount(retailAmount);
            drugTogetherEntity.setTenantId(tenantId);
            drugTogetherEntity.setStatus("0");
            this.sysDrugTogetherMapper.insert((Object)drugTogetherEntity);
        }
        catch (Exception e) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
            this.logger.info(e.getMessage());
        }
    }

    public IPage<SysDrugInventoryInEntity> pageList(Page<SysDrugInventoryInEntity> page, SysDrugInventoryInDto dto) {
        LambdaQueryWrapper qw = Wrappers.lambdaQuery();
        if (StrUtil.isNotEmpty((CharSequence)dto.getSearch())) {
            qw.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(SysDrugInventoryInEntity::getId, (Object)dto.getSearch())).or()).like(SysDrugInventoryInEntity::getInvoiceNumber, (Object)dto.getSearch());
            });
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getWarehousingWarehouse())) {
            qw.eq(SysDrugInventoryInEntity::getWarehousingWarehouse, (Object)dto.getWarehousingWarehouse());
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getWarehousingMethod())) {
            qw.eq(SysDrugInventoryInEntity::getWarehousingMethod, (Object)dto.getWarehousingMethod());
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getStartTime()) && StrUtil.isNotEmpty((CharSequence)dto.getEndTime())) {
            dto.setStartTime(dto.getStartTime() + " 00:00:00");
            dto.setEndTime(dto.getEndTime() + " 23:59:59");
            qw.between(SysDrugInventoryInEntity::getWarehousingTime, (Object)dto.getStartTime(), (Object)dto.getEndTime());
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getAuditStatus())) {
            qw.eq(SysDrugInventoryInEntity::getAuditStatus, (Object)dto.getAuditStatus());
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getSupplierId())) {
            qw.eq(SysDrugInventoryInEntity::getSupplierId, (Object)dto.getSupplierId());
        }
        qw.eq(SysDrugInventoryInEntity::getTenantId, (Object)dto.getTenantId());
        qw.orderByDesc(SysDrugInventoryInEntity::getCreateTime);
        return ((SysDrugInventoryInMapper)this.baseMapper).selectPage(page, (Wrapper)qw);
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean removeDrugInventoryIn(String[] ids) {
        if (ObjectUtils.isEmpty((Object[])ids)) {
            throw new BusinessException("\u836f\u5e93\u5165\u5e93id\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ((SysDrugInventoryInMapper)this.baseMapper).removeDrugInventoryIn(ids);
        ((SysDrugInventoryInMapper)this.baseMapper).removeDrugInventoryInPre(ids);
        return true;
    }

    public List<SysDrugVo> sysDrugInventoryInImport(MultipartFile file) throws Exception {
        StringBuilder builder = new StringBuilder();
        ArrayList<SysDrugVo> resultList = new ArrayList<SysDrugVo>();
        String st = EasyExcelUtil.importExcelMerge((MultipartFile)file, (Object)new SysDrugInventoryImportExcel());
        List list = JSON.parseArray((String)st, SysDrugInventoryImportExcel.class);
        for (SysDrugInventoryImportExcel n : list) {
            List sysDrugEntities = this.sysDrugMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugEntity::getDrugsName, (Object)n.getDrugName())).eq(SysDrugEntity::getSpecifications, (Object)n.getSpecifications())).eq(SysDrugEntity::getRetailPrice, (Object)n.getRetailPrice()));
            List voList = BeanUtil.copyList((List)sysDrugEntities, SysDrugVo.class);
            for (SysDrugVo m : voList) {
                m.setDrugNum(n.getQuantity());
            }
            if (!CollectionUtils.isEmpty((Collection)sysDrugEntities)) {
                resultList.addAll(voList);
                continue;
            }
            builder.append("\u3010").append(n.getDrugName()).append("\u3011").append(";");
        }
        ExceptionUtils.createException((Logger)log, (!builder.toString().isEmpty() ? 1 : 0) != 0, (String)"500", (String)builder.append("\u836f\u54c1\u672a\u627e\u5230--\u8bf7\u53bb\u9664Excel\u4e2d\u7684\u6570\u636e\u5373\u53ef\u5bfc\u5165").toString());
        return resultList;
    }
}

