/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.drug.drugPharmacyStorage.SysDrugPharmacyStorageDto;
import com.byh.sys.api.dto.drug.drugPharmacyStorage.SysDrugPharmacyStorageSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyStorage.SysDrugPharmacyStorageUpdateDto;
import com.byh.sys.api.enums.SysDrugStorageEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.base.NoIdBaseEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyStorageEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.drug.SysDrugPharmacyStorageVo;
import com.byh.sys.data.repository.SysDrugPharmacyStorageMapper;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugPharmacyStorageService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDrugPharmacyStorageServiceImpl
implements SysDrugPharmacyStorageService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugPharmacyStorageServiceImpl.class);
    @Resource
    private SysDrugPharmacyStorageMapper sysDrugPharmacyStorageMapper;
    @Autowired
    private CommonRequest commonRequest;

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyStorageSave(SysDrugPharmacyStorageSaveDto dto) {
        this.checkDrugPharmacyStorageName(dto.getName(), dto.getTenantId());
        SysDrugPharmacyStorageEntity entity = (SysDrugPharmacyStorageEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyStorageEntity.class);
        entity.setId(UUIDUtils.getRandom((int)5, (boolean)true));
        int a = this.sysDrugPharmacyStorageMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugStorageEnum.SYS_DRUG_PHARMACY_STORAGE_INSERT_ERROR.getCode(), (String)SysDrugStorageEnum.SYS_DRUG_PHARMACY_STORAGE_INSERT_ERROR.getName());
    }

    public IPage<SysDrugPharmacyStorageVo> sysDrugPharmacyStorageSelect(Page page, SysDrugPharmacyStorageDto dto) {
        if ("1".equals(this.commonRequest.getUserId().toString())) {
            return this.sysDrugPharmacyStorageMapper.sysDrugPharmacyStorageSelectNormal(page, dto);
        }
        IPage list = this.sysDrugPharmacyStorageMapper.sysDrugPharmacyStorageSelect(page, dto);
        if (CollectionUtils.isEmpty((Collection)list.getRecords())) {
            return this.sysDrugPharmacyStorageMapper.sysDrugPharmacyStorageSelectNormal(page, dto);
        }
        return list;
    }

    public void sysDrugPharmacyStorageUpdate(SysDrugPharmacyStorageUpdateDto dto) {
        SysDrugPharmacyStorageEntity entity = (SysDrugPharmacyStorageEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyStorageEntity.class);
        int a = this.sysDrugPharmacyStorageMapper.updateById((Object)entity);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugStorageEnum.SYS_DRUG_PHARMACY_STORAGE_INSERT_ERROR.getCode(), (String)SysDrugStorageEnum.SYS_DRUG_PHARMACY_STORAGE_INSERT_ERROR.getName());
    }

    public void sysDrugPharmacyStorageDelete(String[] ids) {
        int a = this.sysDrugPharmacyStorageMapper.sysDrugPharmacyStorageDelete(ids);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugStorageEnum.SYS_DRUG_PHARMACY_STORAGE_INSERT_ERROR.getCode(), (String)SysDrugStorageEnum.SYS_DRUG_PHARMACY_STORAGE_INSERT_ERROR.getName());
    }

    public List<SysDrugPharmacyStorageVo> sysDrugPharmacyStorageList(Integer tenant) {
        List list = this.sysDrugPharmacyStorageMapper.selectByTenantId(tenant);
        return list;
    }

    public void lockAndUnLock(SysDrugPharmacyStorageUpdateDto dto) {
        SysDrugPharmacyStorageEntity entity = (SysDrugPharmacyStorageEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyStorageEntity.class);
        this.sysDrugPharmacyStorageMapper.updateById((Object)entity);
    }

    private void checkDrugPharmacyStorageName(String name, Integer tenantId) {
        SysDrugPharmacyStorageEntity entity = (SysDrugPharmacyStorageEntity)this.sysDrugPharmacyStorageMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyStorageEntity::getName, (Object)name)).eq(NoIdBaseEntity::getDelFlag, (Object)"0")).eq(SysDrugPharmacyStorageEntity::getTenantId, (Object)tenantId));
        ExceptionUtils.createException((Logger)log, (entity != null ? 1 : 0) != 0, (String)SysDrugStorageEnum.SYS_DRUG_PHARMACY_STORAGE_NAME_ALREADY_EXISTS.getCode(), (String)SysDrugStorageEnum.SYS_DRUG_PHARMACY_STORAGE_NAME_ALREADY_EXISTS.getName());
    }
}

