/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.SysUserDto;
import com.byh.sys.api.enums.AccountEnums;
import com.byh.sys.api.enums.ErrorEnum;
import com.byh.sys.api.enums.LoginDeviceType;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysUserEntity;
import com.byh.sys.api.util.Base64Util;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.VerifyCodeUtil;
import com.byh.sys.api.vo.user.LoginRespVo;
import com.byh.sys.api.vo.user.UserLoginReqVO;
import com.byh.sys.api.vo.user.VercodeRespVo;
import com.byh.sys.data.repository.SysUserMapper;
import com.byh.sys.web.mvc.config.ProjProperties;
import com.byh.sys.web.mvc.utils.RedisUtil;
import com.byh.sys.web.service.SysUserService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import sun.misc.BASE64Encoder;

@Service
public class SysUserServiceImpl
extends ServiceImpl<SysUserMapper, SysUserEntity>
implements SysUserService {
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    protected ProjProperties projProperties;
    @Resource
    private SysUserMapper sysUserMapper;
    public static final String JWT_SECRET = "hxgy-ehospital";

    public ResponseData getVerCode(int width, int height) {
        if (width == 0 || height == 0) {
            width = 100;
            height = 40;
        }
        VerifyCodeUtil vc = new VerifyCodeUtil();
        if (height != 0 && width != 0) {
            vc.setHeight(height);
            vc.setWidth(width);
        }
        BufferedImage image = vc.getImage();
        String text = vc.getText();
        String random = String.valueOf(RandomUtil.getRandom());
        this.redisUtil.set("vercode_" + random, (Object)text, 600L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", baos);
        }
        catch (IOException e) {
            log.info("\u83b7\u53d6\u56fe\u6587\u9a8c\u8bc1\u7801 \u5f02\u5e38", (Object)e.getMessage());
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        byte[] bytes = baos.toByteArray();
        BASE64Encoder encoder = new BASE64Encoder();
        String png_base64 = encoder.encodeBuffer(bytes).trim();
        png_base64 = png_base64.replaceAll("\n", "").replaceAll("\r", "");
        VercodeRespVo vercodeRespVo = new VercodeRespVo();
        vercodeRespVo.setVercodeKey("vercode_" + random);
        vercodeRespVo.setVercodeValue(text);
        vercodeRespVo.setPng_base64("data:image/jpeg;base64," + png_base64);
        log.info("\u83b7\u53d6\u56fe\u6587\u9a8c\u8bc1\u7801 \u9a8c\u8bc1\u7801:" + text);
        return ResponseData.success((Object)vercodeRespVo);
    }

    public Page<SysUserEntity> pageList(SysUserDto sysUserDto) {
        Page page = new Page((long)sysUserDto.getCurrent().intValue(), (long)sysUserDto.getSize().intValue());
        List list = ((SysUserMapper)this.baseMapper).pageList(page, sysUserDto);
        page.setRecords(list);
        return page;
    }

    public Boolean removeSysUser(Long[] ids) {
        if (ObjectUtils.isEmpty((Object[])ids)) {
            throw new BusinessException("\u83dc\u5355\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u4e3a\u7a7a\uff01{ids}\uff01" + ids);
        }
        return ((SysUserMapper)this.baseMapper).removeSysUser(ids);
    }

    public ResponseData<LoginRespVo> loginV2(UserLoginReqVO reqVO, String source) {
        log.info("====loginV2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqVO));
        this.verifyVercode_web_manager(reqVO.getVercodeKey(), reqVO.getVercodeValue(), reqVO.getLoginDeviceType());
        return this.managerLoginHandler(reqVO, source);
    }

    protected void verifyVercode_web_manager(String vercodeKey, String vercodeValue, LoginDeviceType loginDeviceType) {
        if (this.projProperties.getVercodeEnabled() != null && !this.projProperties.getVercodeEnabled().booleanValue()) {
            log.info("web\u7aef\u7ba1\u7406\u5458\u6821\u9a8c\u56fe\u6587\u9a8c\u8bc1\u7801\u662f\u5426\u6b63\u786e--\u8df3\u8fc7");
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)vercodeKey) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)vercodeValue)) {
            log.info("PC\u7aef\u767b\u5f55 \u9700\u8981\u8fdb\u884c\u56fe\u6587\u9a8c\u8bc1");
            throw new BusinessException(ErrorEnum.VERCODE_NEED_YES.getErrCode(), ErrorEnum.VERCODE_NEED_YES.getMsg());
        }
        if (!(org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)vercodeKey) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)vercodeValue) || this.verifyVercode(vercodeKey, vercodeValue))) {
            throw new BusinessException(ErrorEnum.VERCODE_ERROR);
        }
    }

    private boolean verifyVercode(String vercodeKey, String vercodeValue) {
        Object vercode = "";
        if (!StringUtils.isEmpty((Object)vercodeKey) && !StringUtils.isEmpty((Object)vercodeValue) && (vercode = this.redisUtil.get(vercodeKey)) != null && vercodeValue.equalsIgnoreCase((String)vercode)) {
            log.info("\u56fe\u6587\u9a8c\u8bc1\u901a\u8fc7  \u5165\u53c2\uff1a{},\u5b9e\u9645\u9a8c\u8bc1\u7801\uff1a{}", (Object)vercodeValue, vercode);
            this.redisUtil.del(new String[]{vercodeKey});
            return true;
        }
        log.info("\u56fe\u6587\u9a8c\u8bc1\u4e0d\u6b63\u786e\u5165\u53c2\uff1a{},\u5b9e\u9645\u9a8c\u8bc1\u7801\uff1a{}", (Object)vercodeValue, vercode);
        this.redisUtil.del(new String[]{vercodeKey});
        return false;
    }

    private ResponseData<LoginRespVo> managerLoginHandler(UserLoginReqVO reqVO, String source) {
        List sysUserEntityList = this.sysUserMapper.queryByAccountNo(reqVO.getAccountNo());
        log.info("\u67e5\u8be2\u8d26\u6237\u4fe1\u606f=={}", (Object)JSON.toJSONString((Object)sysUserEntityList));
        int action = 0;
        if (sysUserEntityList == null || sysUserEntityList.isEmpty()) {
            action = 0;
        } else {
            for (SysUserEntity sysUser : sysUserEntityList) {
                if (AccountEnums.AccountStatusEnum.NORMAL.getValue().equals(sysUser.getLockFlag())) {
                    action = 1;
                    break;
                }
                if (!AccountEnums.AccountStatusEnum.PROHIBIT.getValue().equals(sysUser.getLockFlag())) continue;
                action = 2;
            }
        }
        if (0 == action) {
            return ResponseData.tp().msg(ErrorEnum.NO_EXISTS_ACCOUNT.getMsg());
        }
        if (2 == action) {
            return ResponseData.tp().msg(ErrorEnum.DISABLED_ACCOUNT.getMsg());
        }
        if (!sysUserEntityList.isEmpty()) {
            log.info("====loginV2====\u6b63\u5e38\u767b\u5f55");
            return this.loginV2Posthandler((SysUserEntity)sysUserEntityList.get(0), reqVO, source);
        }
        return ResponseData.tp().msg("\u767b\u9646\u5f02\u5e38\uff01");
    }

    private ResponseData<LoginRespVo> loginV2Posthandler(SysUserEntity sysUser, UserLoginReqVO reqVO, String source) {
        byte[] bytes = reqVO.getPassword().getBytes();
        String encode = Base64Util.encode((byte[])bytes);
        if (!encode.equals(sysUser.getPassword())) {
            return ResponseData.tp().msg(ErrorEnum.NO_EXISTS_ACCOUNT_2.getMsg());
        }
        String loginToken = this.genLoginToken(sysUser, source);
        LoginRespVo accountLoginResp = new LoginRespVo();
        BeanUtils.copyProperties((Object)sysUser, (Object)accountLoginResp);
        accountLoginResp.setLoginToken(loginToken);
        return ResponseData.success((Object)accountLoginResp);
    }

    public String genLoginToken(SysUserEntity sysUser, String source) {
        return null;
    }
}

