/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/blacklist"})
public class BlacklistController {
    private static final Logger log = LoggerFactory.getLogger(BlacklistController.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private static final String BLACKLIST_KEY = "user:blacklist";

    @PostMapping(value={"/add"})
    public BaseResponse<?> addToBlacklist(@RequestParam String userId) {
        try {
            this.redisTemplate.opsForSet().add((Object)BLACKLIST_KEY, (Object[])new String[]{userId});
            log.info("User [{}] added to blacklist", (Object)userId);
            return BaseResponse.success((Object)"User added to blacklist");
        }
        catch (Exception e) {
            log.error("Error adding user to blacklist: {}", (Object)e.getMessage());
            return BaseResponse.error((String)"500", (String)"Failed to add user to blacklist");
        }
    }

    @PostMapping(value={"/remove"})
    public BaseResponse<?> removeFromBlacklist(@RequestParam String userId) {
        try {
            this.redisTemplate.opsForSet().remove((Object)BLACKLIST_KEY, new Object[]{userId});
            log.info("User [{}] removed from blacklist", (Object)userId);
            return BaseResponse.success((Object)"User removed from blacklist");
        }
        catch (Exception e) {
            log.error("Error removing user from blacklist: {}", (Object)e.getMessage());
            return BaseResponse.error((String)"500", (String)"Failed to remove user from blacklist");
        }
    }

    @GetMapping(value={"/check"})
    public BaseResponse<?> isUserBlacklisted(@RequestParam String userId) {
        try {
            Boolean isBlacklisted = this.redisTemplate.opsForSet().isMember((Object)BLACKLIST_KEY, (Object)userId);
            return BaseResponse.success((Object)isBlacklisted);
        }
        catch (Exception e) {
            log.error("Error checking blacklist: {}", (Object)e.getMessage());
            return BaseResponse.error((String)"500", (String)"Failed to check blacklist");
        }
    }

    @GetMapping(value={"/list"})
    public BaseResponse<?> getBlacklist() {
        try {
            Set blacklistedUsers = this.redisTemplate.opsForSet().members((Object)BLACKLIST_KEY);
            return BaseResponse.success((Object)blacklistedUsers);
        }
        catch (Exception e) {
            log.error("Error retrieving blacklist: {}", (Object)e.getMessage());
            return BaseResponse.error((String)"500", (String)"Failed to retrieve blacklist");
        }
    }
}

