/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.controller.ChatController;
import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.ChatMessage;
import com.chdu.ai.model.ChatRecordsRequest;
import com.chdu.ai.model.Conversion;
import com.chdu.ai.model.LoginRequest;
import com.chdu.ai.model.User;
import com.chdu.ai.model.UserDetailsRequest;
import com.chdu.ai.model.UserDetailsResponse;
import com.chdu.ai.model.UserLoginRecord;
import com.chdu.ai.service.ChatService;
import com.chdu.ai.service.ConversionService;
import com.chdu.ai.service.UserLoginRecordService;
import com.chdu.ai.service.UserService;
import com.chdu.ai.util.NumericIdGenerator;
import com.chdu.ai.util.RateLimiterUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/im"})
public class ChatController {
    private static final Logger log = LoggerFactory.getLogger(ChatController.class);
    private final UserService userService;
    private final ChatService chatService;
    private final UserLoginRecordService userLoginRecordService;
    private ConversionService conversionService;
    private final RabbitTemplate rabbitTemplate;

    public ChatController(UserService userService, ChatService chatService, UserLoginRecordService userLoginRecordService, ConversionService conversionService, RabbitTemplate rabbitTemplate) {
        this.userService = userService;
        this.chatService = chatService;
        this.userLoginRecordService = userLoginRecordService;
        this.conversionService = conversionService;
        this.rabbitTemplate = rabbitTemplate;
    }

    @PostMapping(value={"/login"})
    public BaseResponse<?> login(@RequestBody LoginRequest loginRequest) {
        try {
            String userId;
            String userName = loginRequest.getUserName() != null && !loginRequest.getUserName().trim().isEmpty() ? loginRequest.getUserName().trim() : "DefaultUser";
            String tenantId = loginRequest.getTenantId();
            if (tenantId == null || tenantId.trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"tenantId is required");
            }
            User existingUser = this.userService.getUserByName(userName);
            if (existingUser != null) {
                userId = existingUser.getId();
            } else {
                userId = NumericIdGenerator.generate4NumericId();
                User newUser = new User(userId, userName, tenantId);
                this.userService.registerUser(newUser);
            }
            this.userLoginRecordService.recordLogin(new UserLoginRecord(userId, Long.valueOf(System.currentTimeMillis())));
            return BaseResponse.success((Object)new LoginResponse(userId, userName));
        }
        catch (Exception e) {
            return BaseResponse.error((String)"500", (String)("Login failed: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/userDetails"})
    public BaseResponse<UserDetailsResponse> getUserDetails(@RequestBody UserDetailsRequest request) {
        String userId = request.getUserId();
        if (userId == null || userId.trim().isEmpty()) {
            return BaseResponse.error((String)"400", (String)"userId is required");
        }
        User user = this.userService.getUserById(userId);
        if (user == null) {
            return BaseResponse.error((String)"404", (String)"User not found");
        }
        List conversions = this.conversionService.getConversionsByUserId(userId);
        Conversion latestConversion = conversions.size() > 0 ? (Conversion)conversions.get(0) : null;
        List recentMessages = null;
        if (latestConversion != null) {
            recentMessages = this.chatService.getMessagesByConversionId(latestConversion.getId());
        }
        UserDetailsResponse response = new UserDetailsResponse(user.getUsername(), conversions, recentMessages);
        return BaseResponse.success((Object)response);
    }

    @PostMapping(value={"/sendMessage"})
    public BaseResponse<?> sendMessage(@RequestBody ChatMessage chatMessage, HttpServletRequest request) {
        try {
            if (chatMessage.getFromUser() == null || chatMessage.getFromUser().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"Sender user ID is required");
            }
            String fromUserId = chatMessage.getFromUser();
            if (!RateLimiterUtil.tryAcquire((String)fromUserId)) {
                return BaseResponse.error((String)"429", (String)"Too many requests. Please slow down.");
            }
            if (chatMessage.getConversionId() == null || chatMessage.getConversionId().trim().isEmpty()) {
                chatMessage.setConversionId(NumericIdGenerator.generate4NumericId());
            }
            this.rabbitTemplate.convertAndSend("chat_exchange", "chat.send", (Object)chatMessage);
            log.info("Message queued for sending: messageId={}, fromUser={}", (Object)chatMessage.getId(), (Object)chatMessage.getFromUser());
            return BaseResponse.success((Object)"Message queued for sending");
        }
        catch (Exception e) {
            return BaseResponse.error((String)"500", (String)("Error sending message: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/chatRecords"})
    public BaseResponse<List<ChatMessage>> getChatRecords(@RequestBody ChatRecordsRequest request, HttpServletRequest httpRequest) {
        try {
            if (request.getConversionId() == null || request.getConversionId().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"Conversation ID is required");
            }
            List records = this.chatService.getChatRecords(request.getConversionId());
            return BaseResponse.success((Object)records);
        }
        catch (Exception e) {
            return BaseResponse.error((String)"500", (String)("Error retrieving chat records: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/revokeMessage"})
    public BaseResponse<?> revokeMessage(@RequestParam String messageId, HttpServletRequest httpRequest) {
        try {
            if (messageId == null || messageId.trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"Message ID is required");
            }
            ChatMessage msg = this.chatService.getMessageById(messageId);
            if (msg == null) {
                return BaseResponse.error((String)"404", (String)"Message not found");
            }
            boolean success = this.chatService.revokeMessage(messageId);
            if (success) {
                return BaseResponse.success((Object)"Message revoked successfully");
            }
            return BaseResponse.error((String)"400", (String)"Message cannot be revoked");
        }
        catch (Exception e) {
            return BaseResponse.error((String)"500", (String)("Error revoking message: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/deleteMessage"})
    public BaseResponse<?> deleteMessage(@RequestParam String messageId, HttpServletRequest httpRequest) {
        try {
            if (messageId == null || messageId.trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"Message ID is required");
            }
            ChatMessage msg = this.chatService.getMessageById(messageId);
            if (msg == null) {
                return BaseResponse.error((String)"404", (String)"Message not found");
            }
            boolean success = this.chatService.deleteMessage(messageId);
            if (success) {
                return BaseResponse.success((Object)"Message deleted successfully");
            }
            return BaseResponse.error((String)"400", (String)"Message cannot be deleted");
        }
        catch (Exception e) {
            return BaseResponse.error((String)"500", (String)("Error deleting message: " + e.getMessage()));
        }
    }
}

