/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.service.OSSService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/upload"})
public class UploadController {
    @Autowired
    private OSSService ossService;

    @PostMapping(value={"/uploadFile"})
    public BaseResponse<String> uploadFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="msgType") String msgType, @RequestParam(value="conversationId") String conversationId) {
        try {
            if (!"image".equalsIgnoreCase(msgType) && !"voice".equalsIgnoreCase(msgType)) {
                return BaseResponse.error((String)"400", (String)"Unsupported msgType. Only 'image' and 'voice' are supported.");
            }
            String url = this.ossService.uploadFile(file.getInputStream(), conversationId, file.getOriginalFilename());
            return BaseResponse.success((Object)url);
        }
        catch (IOException e) {
            return BaseResponse.error((String)"500", (String)("File upload failed: " + e.getMessage()));
        }
    }
}

