/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.indices.CreateIndexResponse;
import com.chdu.ai.service.ElasticSearchService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElasticSearchServiceImpl
implements ElasticSearchService {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchServiceImpl.class);
    private static final String INDEX_NAME = "medical_docs";
    private final ElasticsearchClient esClient;

    @Autowired
    public ElasticSearchServiceImpl(ElasticsearchClient esClient) {
        this.esClient = esClient;
    }

    private void ensureIndexExists() throws IOException {
        boolean exists = this.esClient.indices().exists(e -> e.index(INDEX_NAME, new String[0])).value();
        if (!exists) {
            log.info("\u7d22\u5f15 {} \u4e0d\u5b58\u5728\uff0c\u5f00\u59cb\u521b\u5efa\u7d22\u5f15", (Object)INDEX_NAME);
            CreateIndexResponse createIndexResponse = this.esClient.indices().create(c -> c.index(INDEX_NAME).mappings(m -> m.properties("title", p -> p.text(t -> t)).properties("content", p -> p.text(t -> t)).properties("embedding", p -> p.keyword(k -> k))));
            if (!createIndexResponse.acknowledged()) {
                throw new IOException("\u521b\u5efa\u7d22\u5f15 medical_docs \u5931\u8d25");
            }
            log.info("\u7d22\u5f15 {} \u521b\u5efa\u6210\u529f", (Object)INDEX_NAME);
        }
    }

    public List<String> searchMedicalDocs(String query) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            this.ensureIndexExists();
            if (query == null || query.trim().isEmpty()) {
                throw new IllegalArgumentException("\u67e5\u8be2\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
            }
            SearchResponse searchResponse = this.esClient.search(s -> s.index(INDEX_NAME, new String[0]).query(q -> q.match(m -> m.field("content").query(FieldValue.of((String)query)))).size(Integer.valueOf(5)), Object.class);
            for (Hit hit : searchResponse.hits().hits()) {
                results.add(hit.source().toString());
            }
        }
        catch (IOException e) {
            log.error("\u641c\u7d22\u65f6\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return results;
    }
}

