/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.Conversion;
import com.chdu.ai.service.ConversionService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/conversion"})
public class ConversionController {
    private static final Logger log = LoggerFactory.getLogger(ConversionController.class);
    @Autowired
    private ConversionService conversionService;

    @PostMapping(value={"/getById"})
    public BaseResponse<Conversion> getConversionById(@RequestBody Conversion conversion) {
        Conversion result = this.conversionService.getConversionById(conversion.getId());
        return result != null ? BaseResponse.success((Object)result) : BaseResponse.error((String)"404", (String)"Conversion not found");
    }

    @PostMapping(value={"/getAll"})
    public BaseResponse<List<Conversion>> getAllConversions() {
        List conversions = this.conversionService.getAllConversions();
        return BaseResponse.success((Object)conversions);
    }

    @PostMapping(value={"/getByUserId"})
    public BaseResponse<List<Conversion>> getConversionsByUserId(@RequestBody Conversion conversion) {
        List conversions = this.conversionService.getConversionsByUserId(conversion.getUserId());
        return BaseResponse.success((Object)conversions);
    }

    @PostMapping(value={"/create"})
    public BaseResponse<Conversion> createConversion(@RequestBody Conversion conversion) {
        if (conversion.getConversionName() == null || conversion.getUserId() == null) {
            return BaseResponse.error((String)"400", (String)"conversionName and userId are required");
        }
        try {
            Conversion createdConversion = this.conversionService.createConversion(conversion);
            return BaseResponse.success((Object)createdConversion);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u4f1a\u8bdd\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)"Failed to create conversion");
        }
    }

    @PostMapping(value={"/update"})
    public BaseResponse<String> updateConversion(@RequestBody Conversion conversion) {
        this.conversionService.updateConversion(conversion);
        return BaseResponse.success((Object)"Conversion updated successfully");
    }

    @PostMapping(value={"/delete"})
    public BaseResponse<String> deleteConversion(@RequestBody Conversion conversion) {
        this.conversionService.deleteConversion(conversion.getId());
        return BaseResponse.success((Object)"Conversion logically deleted");
    }
}

