/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.mapper.KnowledgeBaseMapper;
import com.chdu.ai.service.BaichuanApiService;
import com.chdu.ai.service.MilvusVectorSearchService;
import io.milvus.client.MilvusServiceClient;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.grpc.SearchResults;
import io.milvus.param.MetricType;
import io.milvus.param.R;
import io.milvus.param.dml.SearchParam;
import io.milvus.response.SearchResultsWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MilvusVectorSearchServiceImpl
implements MilvusVectorSearchService {
    @Autowired
    private MilvusServiceClient milvusClient;
    @Autowired
    private KnowledgeBaseMapper knowledgeBaseMapper;
    @Autowired
    private BaichuanApiService baichuanApiService;
    private static final String COLLECTION_NAME = "medical_knowledge";
    private static final String VECTOR_FIELD_NAME = "field1";

    public Optional<String> search(String query) {
        float[] queryVector = this.textToVector(query);
        List<List> targetVectors = Collections.singletonList(this.toFloatList(queryVector));
        SearchParam searchParam = SearchParam.newBuilder().withCollectionName(COLLECTION_NAME).withMetricType(MetricType.L2).withTopK(Integer.valueOf(10)).withVectors(targetVectors).withVectorFieldName(VECTOR_FIELD_NAME).withConsistencyLevel(ConsistencyLevelEnum.EVENTUALLY).withParams("{\"nprobe\":10,\"offset\":2, \"limit\":3}").build();
        R response = this.milvusClient.search(searchParam);
        if (!response.getStatus().equals(R.Status.Success)) {
            System.out.println("Milvus \u641c\u7d22\u5931\u8d25: " + response.getException().getMessage());
            return Optional.empty();
        }
        SearchResultsWrapper wrapper = new SearchResultsWrapper(((SearchResults)response.getData()).getResults());
        System.out.println("Milvus \u641c\u7d22\u7ed3\u679c:");
        for (int i = 0; i < targetVectors.size(); ++i) {
            List scores = wrapper.getIDScore(i);
            for (SearchResultsWrapper.IDScore score : scores) {
                System.out.println("ID: " + score.getLongID() + ", \u76f8\u4f3c\u5ea6: " + score.getScore());
                if (!((double)score.getScore() > 0.8)) continue;
                return Optional.of(this.knowledgeBaseMapper.findById(score.getLongID()).getAnswer());
            }
        }
        return Optional.empty();
    }

    private float[] textToVector(String text) {
        return this.baichuanApiService.vectorizeText(text);
    }

    private List<Float> toFloatList(float[] array) {
        ArrayList<Float> floatList = new ArrayList<Float>();
        for (float v : array) {
            floatList.add(Float.valueOf(v));
        }
        return floatList;
    }
}

