/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.mapper.MedicalDocMapper;
import com.chdu.ai.model.MedicalDoc;
import com.chdu.ai.service.BaichuanApiService;
import com.chdu.ai.service.DashScopeService;
import com.chdu.ai.service.ElasticSearchService;
import com.chdu.ai.service.MedicalDocSearchService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MedicalDocSearchServiceImpl
implements MedicalDocSearchService {
    @Autowired
    private MedicalDocMapper medicalDocMapper;
    @Autowired
    private ElasticSearchService elasticSearchService;
    @Autowired
    private BaichuanApiService baichuanApiService;
    @Autowired
    private DashScopeService dashScopeService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public List<MedicalDoc> searchMedicalDocs(String query) {
        HashSet<MedicalDoc> results = new HashSet<MedicalDoc>();
        results.addAll(this.medicalDocMapper.searchByKeyword(query));
        List esResults = this.elasticSearchService.searchMedicalDocs(query);
        for (String esResult : esResults) {
            try {
                MedicalDoc doc = this.medicalDocMapper.findById(Long.parseLong(esResult));
                if (doc == null) continue;
                results.add(doc);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (results.isEmpty()) {
            String answer = this.dashScopeService.generateResponse(query);
            MedicalDoc doc = new MedicalDoc();
            doc.setTitle(query);
            doc.setContent(answer);
            results.add(doc);
        }
        ArrayList<MedicalDoc> resultList = new ArrayList<MedicalDoc>(results);
        return resultList;
    }

    public void saveMedicalDoc(String title, String content) {
        MedicalDoc doc = new MedicalDoc();
        doc.setTitle(title);
        doc.setContent(content);
        float[] vector = this.baichuanApiService.vectorizeText(content);
        try {
            String jsonVector = this.objectMapper.writeValueAsString((Object)vector);
            doc.setEmbedding(jsonVector);
            this.medicalDocMapper.insertMedicalDoc(doc);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }
}

