/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.chdu.ai.service.OSSService;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OSSServiceImpl
implements OSSService {
    @Value(value="${aliyun.oss.endpoint}")
    private String endpoint;
    @Value(value="${aliyun.accessKeyId}")
    private String accessKeyId;
    @Value(value="${aliyun.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${aliyun.oss.bucketName}")
    private String bucketName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(InputStream inputStream, String conversationId, String originalFileName) {
        OSS ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        try {
            String newFileName = conversationId + "/" + System.currentTimeMillis() + "_" + originalFileName;
            ossClient.putObject(this.bucketName, newFileName, inputStream);
            String string = "https://" + this.bucketName + "." + this.endpoint + "/" + newFileName;
            return string;
        }
        finally {
            ossClient.shutdown();
        }
    }
}

