/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.handler;

import com.alibaba.nls.client.AccessToken;
import com.alibaba.nls.client.protocol.NlsClient;
import com.alibaba.nls.client.protocol.tts.SpeechSynthesizer;
import com.alibaba.nls.client.protocol.tts.SpeechSynthesizerListener;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

@Component
public class TTSWebSocketHandler
implements WebSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(TTSWebSocketHandler.class);
    @Value(value="${aliyun.tts.app-key}")
    private String appKey;
    @Value(value="${aliyun.accessKeyId}")
    private String accessKeyId;
    @Value(value="${aliyun.accessKeySecret}")
    private String accessKeySecret;
    private NlsClient client;
    private AccessToken accessToken;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final AtomicLong sessionCounter = new AtomicLong(0L);
    private final Map<String, WebSocketSession> activeSessions = new ConcurrentHashMap();
    private final Map<String, SpeechSynthesizer> activeSynthesizers = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        try {
            this.accessToken = new AccessToken(this.accessKeyId, this.accessKeySecret);
            this.accessToken.apply();
            this.client = new NlsClient(this.accessToken.getToken());
            logger.info("TTS WebSocket\u670d\u52a1\u521d\u59cb\u5316\u6210\u529f\uff0cToken\u8fc7\u671f\u65f6\u95f4: {}", (Object)this.accessToken.getExpireTime());
        }
        catch (Exception e) {
            logger.error("TTS WebSocket\u670d\u52a1\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("TTS WebSocket\u670d\u52a1\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    @PreDestroy
    public void destroy() {
        this.activeSynthesizers.values().forEach(synthesizer -> {
            try {
                synthesizer.close();
            }
            catch (Exception e) {
                logger.warn("\u5173\u95ed\u8bed\u97f3\u5408\u6210\u5668\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
        });
        this.activeSynthesizers.clear();
        this.activeSessions.values().forEach(session -> {
            try {
                if (session.isOpen()) {
                    session.close();
                }
            }
            catch (Exception e) {
                logger.warn("\u5173\u95edWebSocket\u4f1a\u8bdd\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
        });
        this.activeSessions.clear();
        if (this.client != null) {
            try {
                this.client.shutdown();
                logger.info("TTS WebSocket\u5ba2\u6237\u7aef\u5df2\u5173\u95ed");
            }
            catch (Exception e) {
                logger.error("\u5173\u95edTTS WebSocket\u5ba2\u6237\u7aef\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
        }
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        String sessionId = this.generateSessionId();
        session.getAttributes().put("sessionId", sessionId);
        this.activeSessions.put(sessionId, session);
        logger.info("TTS WebSocket\u8fde\u63a5\u5efa\u7acb\uff0c\u4f1a\u8bddID: {}, \u8fdc\u7a0b\u5730\u5740: {}", (Object)sessionId, (Object)session.getRemoteAddress());
        this.sendMessage(session, this.createResponseMessage("connected", "TTS WebSocket\u8fde\u63a5\u6210\u529f", (Object)sessionId));
    }

    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
        String sessionId = (String)session.getAttributes().get("sessionId");
        if (message instanceof TextMessage) {
            this.handleTextMessage(session, sessionId, (TextMessage)message);
        } else {
            logger.warn("\u6536\u5230\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b: {}, \u4f1a\u8bddID: {}", (Object)message.getClass().getSimpleName(), (Object)sessionId);
            this.sendErrorMessage(session, "\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b");
        }
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        String sessionId = (String)session.getAttributes().get("sessionId");
        logger.error("TTS WebSocket\u4f20\u8f93\u9519\u8bef\uff0c\u4f1a\u8bddID: {}", (Object)sessionId, (Object)exception);
        this.cleanupSession(sessionId);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        String sessionId = (String)session.getAttributes().get("sessionId");
        logger.info("TTS WebSocket\u8fde\u63a5\u5173\u95ed\uff0c\u4f1a\u8bddID: {}, \u5173\u95ed\u72b6\u6001: {}", (Object)sessionId, (Object)closeStatus);
        this.cleanupSession(sessionId);
    }

    public boolean supportsPartialMessages() {
        return false;
    }

    private void handleTextMessage(WebSocketSession session, String sessionId, TextMessage message) {
        try {
            String action;
            JsonNode jsonNode = this.objectMapper.readTree((String)message.getPayload());
            switch (action = jsonNode.get("action").asText()) {
                case "synthesize": {
                    this.handleSynthesizeRequest(session, sessionId, jsonNode);
                    break;
                }
                case "stop": {
                    this.handleStopRequest(session, sessionId);
                    break;
                }
                case "ping": {
                    this.handlePingRequest(session, sessionId);
                    break;
                }
                default: {
                    this.sendErrorMessage(session, "\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b: " + action);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u6587\u672c\u6d88\u606f\u5931\u8d25\uff0c\u4f1a\u8bddID: {}", (Object)sessionId, (Object)e);
            this.sendErrorMessage(session, "\u6d88\u606f\u5904\u7406\u5931\u8d25: " + e.getMessage());
        }
    }

    private void handleSynthesizeRequest(WebSocketSession session, String sessionId, JsonNode request) {
        try {
            this.refreshTokenIfNeeded();
            String text = request.get("text").asText();
            if (text == null || text.trim().isEmpty()) {
                this.sendErrorMessage(session, "\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            this.stopCurrentSynthesis(sessionId);
            SpeechSynthesizerListener listener = this.createSynthesizerListener(session, sessionId);
            SpeechSynthesizer synthesizer = new SpeechSynthesizer(this.client, listener);
            synthesizer.setAppKey(this.appKey);
            synthesizer.setText(text);
            this.activeSynthesizers.put(sessionId, synthesizer);
            logger.info("\u5f00\u59cbWebSocket\u8bed\u97f3\u5408\u6210\uff0c\u4f1a\u8bddID: {}, \u6587\u672c: {}, \u58f0\u97f3: {}, \u91c7\u6837\u7387: {}, \u683c\u5f0f: {}", (Object)sessionId, (Object)text);
            this.sendMessage(session, this.createResponseMessage("synthesis_started", "\u5f00\u59cb\u8bed\u97f3\u5408\u6210", null));
            synthesizer.start();
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u8bed\u97f3\u5408\u6210\u8bf7\u6c42\u5931\u8d25\uff0c\u4f1a\u8bddID: {}", (Object)sessionId, (Object)e);
            this.sendErrorMessage(session, "\u8bed\u97f3\u5408\u6210\u5931\u8d25: " + e.getMessage());
        }
    }

    private void handleStopRequest(WebSocketSession session, String sessionId) {
        try {
            this.stopCurrentSynthesis(sessionId);
            this.sendMessage(session, this.createResponseMessage("synthesis_stopped", "\u8bed\u97f3\u5408\u6210\u5df2\u505c\u6b62", null));
        }
        catch (Exception e) {
            logger.error("\u505c\u6b62\u8bed\u97f3\u5408\u6210\u5931\u8d25\uff0c\u4f1a\u8bddID: {}", (Object)sessionId, (Object)e);
            this.sendErrorMessage(session, "\u505c\u6b62\u5408\u6210\u5931\u8d25: " + e.getMessage());
        }
    }

    private void handlePingRequest(WebSocketSession session, String sessionId) {
        try {
            this.sendMessage(session, this.createResponseMessage("pong", "pong", (Object)System.currentTimeMillis()));
        }
        catch (Exception e) {
            logger.error("\u5904\u7406ping\u8bf7\u6c42\u5931\u8d25\uff0c\u4f1a\u8bddID: {}", (Object)sessionId, (Object)e);
        }
    }

    private SpeechSynthesizerListener createSynthesizerListener(WebSocketSession session, String sessionId) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void stopCurrentSynthesis(String sessionId) {
        block5: {
            SpeechSynthesizer synthesizer = (SpeechSynthesizer)this.activeSynthesizers.remove(sessionId);
            if (synthesizer != null) {
                try {
                    synthesizer.close();
                    logger.info("\u505c\u6b62\u8bed\u97f3\u5408\u6210\uff0c\u4f1a\u8bddID: {}", (Object)sessionId);
                }
                catch (Exception e) {
                    if (e.getMessage() != null && (e.getMessage().contains("closed") || e.getMessage().contains("shutdown") || e.getMessage().contains("disconnected"))) {
                        logger.debug("\u5408\u6210\u5668\u5df2\u5173\u95ed\uff0c\u4f1a\u8bddID: {}", (Object)sessionId);
                        break block5;
                    }
                    logger.warn("\u5173\u95ed\u8bed\u97f3\u5408\u6210\u5668\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u4f1a\u8bddID: {}", (Object)sessionId, (Object)e);
                }
            } else {
                logger.debug("\u672a\u627e\u5230\u6d3b\u52a8\u7684\u8bed\u97f3\u5408\u6210\u5668\uff0c\u4f1a\u8bddID: {}", (Object)sessionId);
            }
        }
    }

    private void cleanupSession(String sessionId) {
        if (sessionId != null) {
            this.activeSessions.remove(sessionId);
            this.stopCurrentSynthesis(sessionId);
        }
    }

    private void sendMessage(WebSocketSession session, String message) {
        try {
            if (session.isOpen()) {
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001WebSocket\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private void sendErrorMessage(WebSocketSession session, String error) {
        try {
            String errorMessage = this.createErrorMessage(error);
            this.sendMessage(session, errorMessage);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u9519\u8bef\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private String createResponseMessage(String type, String message, Object data) {
        try {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("type", type);
            response.put("message", message);
            response.put("data", data);
            response.put("timestamp", System.currentTimeMillis());
            return this.objectMapper.writeValueAsString(response);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u54cd\u5e94\u6d88\u606f\u5931\u8d25", (Throwable)e);
            return "{\"type\":\"error\",\"message\":\"\u521b\u5efa\u54cd\u5e94\u6d88\u606f\u5931\u8d25\"}";
        }
    }

    private String createErrorMessage(String error) {
        try {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("type", "error");
            response.put("message", error);
            response.put("timestamp", System.currentTimeMillis());
            return this.objectMapper.writeValueAsString(response);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u9519\u8bef\u6d88\u606f\u5931\u8d25", (Throwable)e);
            return "{\"type\":\"error\",\"message\":\"\u672a\u77e5\u9519\u8bef\"}";
        }
    }

    private String generateSessionId() {
        return "tts_" + System.currentTimeMillis() + "_" + this.sessionCounter.incrementAndGet();
    }

    private void refreshTokenIfNeeded() throws Exception {
        if (this.accessToken == null || System.currentTimeMillis() >= this.accessToken.getExpireTime() - 60000L) {
            logger.info("Token\u5373\u5c06\u8fc7\u671f\uff0c\u5f00\u59cb\u5237\u65b0Token");
            this.accessToken = new AccessToken(this.accessKeyId, this.accessKeySecret);
            this.accessToken.apply();
            if (this.client != null) {
                this.client.shutdown();
            }
            this.client = new NlsClient(this.accessToken.getToken());
            logger.info("Token\u5237\u65b0\u6210\u529f\uff0c\u65b0\u7684\u8fc7\u671f\u65f6\u95f4: {}", (Object)this.accessToken.getExpireTime());
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ String access$100(TTSWebSocketHandler x0, String x1, String x2, Object x3) {
        return x0.createResponseMessage(x1, x2, x3);
    }

    static /* synthetic */ void access$200(TTSWebSocketHandler x0, WebSocketSession x1, String x2) {
        x0.sendMessage(x1, x2);
    }

    static /* synthetic */ Map access$300(TTSWebSocketHandler x0) {
        return x0.activeSynthesizers;
    }

    static /* synthetic */ void access$400(TTSWebSocketHandler x0, WebSocketSession x1, String x2) {
        x0.sendErrorMessage(x1, x2);
    }
}

