/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.mapper.ChatMessageMapper;
import com.chdu.ai.model.ChatMessage;
import com.chdu.ai.service.ChatService;
import com.chdu.ai.util.NumericIdGenerator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChatServiceImpl
implements ChatService {
    private final ChatMessageMapper chatMessageMapper;

    @Autowired
    public ChatServiceImpl(ChatMessageMapper chatMessageMapper) {
        this.chatMessageMapper = chatMessageMapper;
    }

    @Transactional
    public ChatMessage saveMessage(ChatMessage chatMessage) {
        chatMessage.setId(NumericIdGenerator.generate9NumericId());
        this.chatMessageMapper.insertChatMessage(chatMessage);
        return this.chatMessageMapper.getMessageById(chatMessage.getId());
    }

    public List<ChatMessage> getChatRecords(String conversionId) {
        return this.chatMessageMapper.getChatMessagesByConversationId(conversionId);
    }

    public ChatMessage getMessageById(String messageId) {
        return this.chatMessageMapper.getMessageById(messageId);
    }

    public boolean revokeMessage(String messageId) {
        return this.chatMessageMapper.revokeMessage(messageId) > 0;
    }

    public boolean deleteMessage(String messageId) {
        return this.chatMessageMapper.deleteMessage(messageId) > 0;
    }

    public List<ChatMessage> getOfflineMessages(String userId) {
        return this.chatMessageMapper.getOfflineMessagesByUserId(userId);
    }

    @Transactional
    public void markMessagesAsDelivered(List<String> messageIds) {
        if (messageIds == null || messageIds.isEmpty()) {
            return;
        }
        this.chatMessageMapper.markMessagesAsDelivered(messageIds);
    }

    public List<ChatMessage> getMessagesByConversionId(String conversionId) {
        return this.chatMessageMapper.getMessagesByConversionId(conversionId);
    }
}

