/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.service.DifyUserMappingService;
import java.security.MessageDigest;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class DifyUserMappingServiceImpl
implements DifyUserMappingService {
    private static final Logger logger = LoggerFactory.getLogger(DifyUserMappingServiceImpl.class);
    private static final String DIFY_USER_MAPPING_KEY = "dify:user:mapping:";
    private static final String REVERSE_MAPPING_KEY = "dify:reverse:mapping:";
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public String getDifyUserId(String systemUserId, String hospitalId) {
        try {
            String cacheKey = DIFY_USER_MAPPING_KEY + systemUserId + ":" + hospitalId;
            String difyUserId = (String)this.redisTemplate.opsForValue().get((Object)cacheKey);
            if (difyUserId != null) {
                logger.debug("\u4ece\u7f13\u5b58\u83b7\u53d6Dify\u7528\u6237ID: systemUserId={}, hospitalId={}, difyUserId={}", new Object[]{systemUserId, hospitalId, difyUserId});
                return difyUserId;
            }
            difyUserId = this.generateDifyUserId(systemUserId, hospitalId);
            this.redisTemplate.opsForValue().set((Object)cacheKey, (Object)difyUserId, 30L, TimeUnit.DAYS);
            String reverseCacheKey = REVERSE_MAPPING_KEY + difyUserId;
            String systemUserInfo = systemUserId + ":" + hospitalId;
            this.redisTemplate.opsForValue().set((Object)reverseCacheKey, (Object)systemUserInfo, 30L, TimeUnit.DAYS);
            logger.info("\u751f\u6210\u65b0\u7684Dify\u7528\u6237ID: systemUserId={}, hospitalId={}, difyUserId={}", new Object[]{systemUserId, hospitalId, difyUserId});
            return difyUserId;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6Dify\u7528\u6237ID\u5931\u8d25: systemUserId={}, hospitalId={}", new Object[]{systemUserId, hospitalId, e});
            return this.generateDifyUserId(systemUserId, hospitalId);
        }
    }

    public String[] getSystemUserInfo(String difyUserId) {
        try {
            String reverseCacheKey = REVERSE_MAPPING_KEY + difyUserId;
            String systemUserInfo = (String)this.redisTemplate.opsForValue().get((Object)reverseCacheKey);
            if (systemUserInfo != null && systemUserInfo.contains(":")) {
                String[] parts = systemUserInfo.split(":", 2);
                logger.debug("\u53cd\u5411\u67e5\u627e\u7cfb\u7edf\u7528\u6237\u4fe1\u606f\u6210\u529f: difyUserId={}, systemUserId={}, hospitalId={}", new Object[]{difyUserId, parts[0], parts[1]});
                return parts;
            }
            logger.warn("\u672a\u627e\u5230Dify\u7528\u6237ID\u5bf9\u5e94\u7684\u7cfb\u7edf\u7528\u6237\u4fe1\u606f: difyUserId={}", (Object)difyUserId);
            return null;
        }
        catch (Exception e) {
            logger.error("\u53cd\u5411\u67e5\u627e\u7cfb\u7edf\u7528\u6237\u4fe1\u606f\u5931\u8d25: difyUserId={}", (Object)difyUserId, (Object)e);
            return null;
        }
    }

    public String generateSessionTitle(String firstMessage) {
        if (firstMessage == null || firstMessage.trim().isEmpty()) {
            return "\u65b0\u5bf9\u8bdd";
        }
        String cleanMessage = firstMessage.trim().replaceAll("\\s+", " ");
        if (cleanMessage.length() <= 30) {
            return cleanMessage;
        }
        return cleanMessage.substring(0, 30) + "...";
    }

    private String generateDifyUserId(String systemUserId, String hospitalId) {
        try {
            String input = hospitalId + "_" + systemUserId + "_dify_user";
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hashBytes = md.digest(input.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (byte b : hashBytes) {
                sb.append(String.format("%02x", b));
            }
            return "user_" + sb.toString().substring(0, 16);
        }
        catch (Exception e) {
            logger.error("\u751f\u6210Dify\u7528\u6237ID\u5f02\u5e38", (Throwable)e);
            return "user_" + hospitalId + "_" + systemUserId.hashCode();
        }
    }
}

