/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.util;

import com.chdu.ai.util.ContentProcessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;

public class ContentProcessor {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static ProcessedContent process(List<Map<String, Object>> messageParts) throws JsonProcessingException {
        boolean onlyText = messageParts.stream().allMatch(part -> "text".equalsIgnoreCase((String)part.get("type")));
        if (onlyText) {
            String textContent = (String)messageParts.get(0).get("text");
            return new ProcessedContent("text", textContent);
        }
        String serializedContent = objectMapper.writeValueAsString(messageParts);
        return new ProcessedContent("object_string", serializedContent);
    }
}

